/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.Static;

public class Clip
extends UGen
implements DataBeadReceiver {
    private float min;
    private float max;
    private UGen minUGen;
    private UGen maxUGen;
    private boolean isMinStatic;
    private boolean isMaxStatic;

    public Clip(AudioContext context) {
        this(context, 1);
    }

    public Clip(AudioContext context, int channels) {
        super(context, channels, channels);
        this.setRange(-1.0f, 1.0f);
    }

    @Override
    public void calculateBuffer() {
        if (this.isMinStatic && this.isMaxStatic) {
            for (int j = 0; j < this.ins; ++j) {
                float[] bi = this.bufIn[j];
                float[] bo = this.bufOut[j];
                for (int i = 0; i < this.bufferSize; ++i) {
                    float y = bi[i];
                    bo[i] = y < this.min ? this.min : (y > this.max ? this.max : y);
                }
            }
        } else {
            this.minUGen.update();
            this.maxUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.min = this.minUGen.getValue(0, i);
                this.max = this.maxUGen.getValue(0, i);
                for (int j = 0; j < this.ins; ++j) {
                    float y = this.bufIn[j][i];
                    this.bufOut[j][i] = y < this.min ? this.min : (y > this.max ? this.max : y);
                }
            }
        }
    }

    public Clip setRange(float minimum, float maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        return this;
    }

    public float getMinimum() {
        return this.min;
    }

    public Clip setMinimum(float minimum) {
        this.min = minimum;
        if (this.isMinStatic) {
            ((Static)this.minUGen).setValue(minimum);
        } else {
            this.minUGen = new Static(this.context, minimum);
            this.isMinStatic = true;
        }
        return this;
    }

    public Clip setMinimum(UGen minimumUGen) {
        if (minimumUGen == null) {
            this.setMinimum(this.min);
        } else {
            this.minUGen = minimumUGen;
            this.minUGen.update();
            this.min = this.minUGen.getValue();
            this.isMinStatic = false;
        }
        return this;
    }

    public UGen getMinimumUGen() {
        if (this.isMinStatic) {
            return null;
        }
        return this.minUGen;
    }

    public float getMaximum() {
        return this.max;
    }

    public Clip setMaximum(float maximum) {
        this.max = maximum;
        if (this.isMaxStatic) {
            ((Static)this.maxUGen).setValue(maximum);
        } else {
            this.maxUGen = new Static(this.context, maximum);
            this.isMaxStatic = true;
        }
        return this;
    }

    public Clip setMaximum(UGen maximumUGen) {
        if (maximumUGen == null) {
            this.setMaximum(this.max);
        } else {
            this.maxUGen = maximumUGen;
            this.maxUGen.update();
            this.max = this.maxUGen.getValue();
            this.isMaxStatic = false;
        }
        return this;
    }

    public UGen getMaximumUGen() {
        if (this.isMaxStatic) {
            return null;
        }
        return this.maxUGen;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            UGen u = db.getUGen("maximum");
            if (u == null) {
                this.setMaximum(db.getFloat("maximum", this.max));
            } else {
                this.setMaximum(u);
            }
            u = db.getUGen("minimum");
            if (u == null) {
                this.setMinimum(db.getFloat("minimum", this.min));
            } else {
                this.setMinimum(u);
            }
        }
        return this;
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isMinStatic) {
            db.put("minimum", (Object)Float.valueOf(this.min));
        } else {
            db.put("minimum", (Object)this.minUGen);
        }
        if (this.isMaxStatic) {
            db.put("maximum", (Object)Float.valueOf(this.max));
        } else {
            db.put("maximum", (Object)this.maxUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("minimum", (Object)Float.valueOf(this.min));
        db.put("maximum", (Object)Float.valueOf(this.max));
        return db;
    }
}

