/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.Arrays;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class CombFilter
extends IIRFilter {
    private float a = 1.0f;
    private float g = 0.2f;
    private float h = 0.2f;
    private int maxDelay = 1;
    private int delay = 1;
    private int ind = 0;
    private UGen aUGen;
    private UGen gUGen;
    private UGen hUGen;
    private UGen delayUGen;
    private boolean isAStatic;
    private boolean isGStatic;
    private boolean isHStatic;
    private boolean isDelayStatic;
    private boolean areAllStatic;
    private float[] xn;
    private float[] yn;
    private int bufLen = 1;

    public CombFilter(AudioContext con, int maxdel) {
        super(con, 1, 1);
        this.maxDelay = Math.max(maxdel, 1);
        this.bufLen = this.maxDelay + 1;
        this.yn = new float[this.bufLen];
        this.xn = new float[this.bufLen];
        this.setA(this.a).setG(this.g).setH(this.h).setDelay(1);
    }

    private void checkStaticStatus() {
        this.areAllStatic = this.isAStatic && this.isGStatic && this.isGStatic && this.isDelayStatic;
    }

    @Override
    public void calculateBuffer() {
        float[] bi = this.bufIn[0];
        float[] bo = this.bufOut[0];
        if (this.areAllStatic) {
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                int ind2 = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = bi[currsample];
                bo[currsample] = this.yn[this.ind] = this.a * this.xn[this.ind] + this.g * this.xn[ind2] - this.h * this.yn[ind2];
                this.ind = (this.ind + 1) % this.bufLen;
            }
        } else {
            this.aUGen.update();
            this.gUGen.update();
            this.hUGen.update();
            this.delayUGen.update();
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                this.a = this.aUGen.getValue(0, currsample);
                this.g = this.gUGen.getValue(0, currsample);
                this.h = this.hUGen.getValue(0, currsample);
                this.delay = (int)this.delayUGen.getValue(0, currsample);
                if (this.delay < 1) {
                    this.delay = 1;
                } else if (this.delay >= this.maxDelay) {
                    this.delay = this.maxDelay;
                }
                int ind2 = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = bi[currsample];
                bo[currsample] = this.yn[this.ind] = this.a * this.xn[this.ind] + this.g * this.xn[ind2] - this.h * this.yn[ind2];
                this.ind = (this.ind + 1) % this.bufLen;
            }
        }
    }

    public void reset() {
        Arrays.fill(this.yn, 0.0f);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public CombFilter setDelay(int delay) {
        this.delay = delay < 1 ? 1 : (delay >= this.maxDelay ? this.maxDelay : delay);
        if (this.isDelayStatic) {
            this.delayUGen.setValue(delay);
        } else {
            this.delayUGen = new Static(this.context, (float)delay);
            this.isDelayStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setDelay(UGen delay) {
        if (delay == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = delay;
            delay.update();
            this.delay = (int)delay.getValue();
            this.isDelayStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getDelayUGen() {
        if (this.isDelayStatic) {
            return null;
        }
        return this.delayUGen;
    }

    public float getG() {
        return this.g;
    }

    public CombFilter setG(float g) {
        this.g = g;
        if (this.isGStatic) {
            this.gUGen.setValue(g);
        } else {
            this.gUGen = new Static(this.context, g);
            this.isGStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setG(UGen g) {
        if (g == null) {
            this.setG(this.g);
        } else {
            this.gUGen = g;
            g.update();
            this.g = g.getValue();
            this.isGStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getGUGen() {
        if (this.isGStatic) {
            return null;
        }
        return this.gUGen;
    }

    public float getH() {
        return this.h;
    }

    public CombFilter setH(float h) {
        this.h = h;
        if (this.isHStatic) {
            this.hUGen.setValue(h);
        } else {
            this.hUGen = new Static(this.context, h);
            this.isHStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setH(UGen h) {
        if (h == null) {
            this.setH(this.h);
        } else {
            this.aUGen = h;
            h.update();
            this.h = h.getValue();
            this.isHStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getHUGen() {
        if (this.isHStatic) {
            return null;
        }
        return this.hUGen;
    }

    public float getA() {
        return this.a;
    }

    public CombFilter setA(float a) {
        this.a = a;
        if (this.isAStatic) {
            this.aUGen.setValue(a);
        } else {
            this.aUGen = new Static(this.context, a);
            this.isAStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setA(UGen a) {
        if (a == null) {
            this.setA(this.a);
        } else {
            this.aUGen = a;
            a.update();
            this.a = a.getValue();
            this.isAStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getAUGen() {
        if (this.isAStatic) {
            return null;
        }
        return this.aUGen;
    }

    public CombFilter setParams(int delay, float a, float g, float h) {
        this.setA(a);
        this.setG(g);
        this.setH(h);
        this.setDelay(delay);
        return this;
    }

    public CombFilter setParams(UGen delUGen, UGen aUGen, UGen gUGen, UGen hUGen) {
        this.setDelay(delUGen);
        this.setA(aUGen);
        this.setG(gUGen);
        this.setH(hUGen);
        return this;
    }

    public CombFilter setParams(DataBead paramBead) {
        if (paramBead != null) {
            Object o = paramBead.get("a");
            if (o != null) {
                if (o instanceof UGen) {
                    this.setA((UGen)o);
                } else {
                    this.setA(paramBead.getFloat("a", this.a));
                }
            }
            if ((o = paramBead.get("g")) != null) {
                if (o instanceof UGen) {
                    this.setG((UGen)o);
                } else {
                    this.setG(paramBead.getFloat("g", this.g));
                }
            }
            if ((o = paramBead.get("h")) != null) {
                if (o instanceof UGen) {
                    this.setH((UGen)o);
                } else {
                    this.setH(paramBead.getFloat("h", this.h));
                }
            }
            if ((o = paramBead.get("delay")) != null) {
                if (o instanceof UGen) {
                    this.setDelay((UGen)o);
                } else {
                    this.setDelay((int)paramBead.getFloat("delay", this.delay));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isAStatic) {
            db.put("a", (Object)Float.valueOf(this.a));
        } else {
            db.put("a", (Object)this.aUGen);
        }
        if (this.isGStatic) {
            db.put("g", (Object)Float.valueOf(this.g));
        } else {
            db.put("g", (Object)this.gUGen);
        }
        if (this.isHStatic) {
            db.put("h", (Object)Float.valueOf(this.h));
        } else {
            db.put("h", (Object)this.hUGen);
        }
        if (this.isDelayStatic) {
            db.put("delay", (Object)this.delay);
        } else {
            db.put("delay", (Object)this.delayUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("a", (Object)Float.valueOf(this.a));
        db.put("g", (Object)Float.valueOf(this.g));
        db.put("h", (Object)Float.valueOf(this.h));
        db.put("delay", (Object)this.delay);
        return db;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float freq) {
        float[] bs = new float[this.delay + 1];
        float[] as = new float[this.delay + 1];
        bs[0] = this.a;
        bs[this.delay] = this.g;
        as[0] = 1.0f;
        as[this.delay] = this.h;
        return CombFilter.calculateFilterResponse(bs, as, freq, this.context.getSampleRate());
    }
}

