/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.Static;

public class CrossFade
extends UGen {
    private UGen incoming;
    private UGen outgoing;
    private double crossfadeTimeSamps;
    private long currentTimeSamps;
    private float incomingLevel;
    private float outgoingLevel;
    private boolean pauseAfterComplete;

    public CrossFade(AudioContext context, int channels) {
        super(context, channels);
        this.incoming = new Static(context, 0.0f);
        this.pauseAfterComplete = false;
    }

    public CrossFade(AudioContext context, UGen start) {
        super(context, start.getOuts());
        this.incoming = start;
        this.pauseAfterComplete = false;
    }

    public void fadeTo(UGen target, float crossfadeTimeMS) {
        if (this.incoming != target) {
            this.outgoing = this.incoming;
            this.incoming = target;
            if (this.incoming == null) {
                this.incoming = new Static(this.context, 0.0f);
            }
            this.crossfadeTimeSamps = this.context.msToSamples(crossfadeTimeMS);
            this.currentTimeSamps = 0L;
        }
    }

    public boolean doesPauseAfterComplete() {
        return this.pauseAfterComplete;
    }

    public void setPauseAfterComplete(boolean pauseAfterComplete) {
        this.pauseAfterComplete = pauseAfterComplete;
    }

    @Override
    public void calculateBuffer() {
        this.incoming.update();
        if (this.outgoing != null) {
            this.outgoing.update();
        }
        for (int j = 0; j < this.bufferSize; ++j) {
            int i;
            if ((double)this.currentTimeSamps >= this.crossfadeTimeSamps) {
                for (i = 0; i < this.outs; ++i) {
                    this.bufOut[i][j] = this.incoming.getValue(i, j);
                }
                continue;
            }
            this.incomingLevel = (float)((double)this.currentTimeSamps / this.crossfadeTimeSamps);
            this.outgoingLevel = 1.0f - this.incomingLevel;
            for (i = 0; i < this.outs; ++i) {
                this.bufOut[i][j] = this.incomingLevel * this.incoming.getValue(i, j) + this.outgoingLevel * this.outgoing.getValue(i, j);
            }
            ++this.currentTimeSamps;
        }
        if ((double)this.currentTimeSamps >= this.crossfadeTimeSamps && this.pauseAfterComplete && this.outgoing != null) {
            this.outgoing.pause(true);
            this.outgoing = null;
        }
    }
}

