/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public abstract class DelayEvent
extends UGen {
    private long sampleDelay;
    private long count;
    private boolean triggerAfter = false;
    private long threshold;

    public DelayEvent(AudioContext context, double delay) {
        this(context, delay, false);
    }

    public DelayEvent(AudioContext context, double delay, boolean triggerAfter) {
        super(context, 0, 0);
        this.sampleDelay = (long)context.msToSamples(delay);
        this.reset();
        this.triggeredAfter(triggerAfter);
    }

    public void reset() {
        this.count = 0L;
    }

    @Override
    public void calculateBuffer() {
        if (this.sampleDelay - this.count > this.threshold) {
            this.count += (long)this.bufferSize;
        } else {
            this.trigger();
        }
    }

    public abstract void trigger();

    public double getSampleDelay() {
        return this.context.samplesToMs(this.sampleDelay);
    }

    public DelayEvent setSampleDelay(float sampleDelay) {
        this.sampleDelay = (long)this.context.msToSamples(sampleDelay);
        return this;
    }

    public double getCount() {
        return this.context.samplesToMs(this.count);
    }

    public boolean isTriggeredAfter() {
        return this.triggerAfter;
    }

    public DelayEvent triggeredAfter(boolean f) {
        this.triggerAfter = f;
        this.threshold = f ? 0L : (long)this.bufferSize;
        return this;
    }
}

