/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.ArrayList;
import java.util.List;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;

public class Envelope
extends UGen {
    private ArrayList<Segment> segments = new ArrayList();
    private float currentStartValue = 0.0f;
    private float currentValue = 0.0f;
    private int currentTime;
    private Segment currentSegment = null;
    private boolean lock = false;
    private boolean unchanged = false;
    protected float[] myBufOut;

    public Envelope(AudioContext context) {
        super(context, 1);
        this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
        this.outputPauseRegime = UGen.OutputPauseRegime.RETAIN;
        this.myBufOut = new float[this.bufferSize];
        this.bufOut[0] = this.myBufOut;
    }

    public Envelope(AudioContext context, float value) {
        this(context);
        this.setValue(value);
    }

    public Envelope lock(boolean lock) {
        this.lock = lock;
        return this;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public synchronized Envelope addSegment(float endValue, float duration, float curvature) {
        if (!(this.lock || Float.isNaN(endValue) || Float.isInfinite(endValue))) {
            this.segments.add(new Segment(endValue, duration, curvature, null));
            this.unchanged = false;
        }
        return this;
    }

    public synchronized Envelope addSegment(float endValue, float duration, float curvature, Bead trigger) {
        if (!(this.lock || Float.isNaN(endValue) || Float.isInfinite(endValue))) {
            this.segments.add(new Segment(endValue, duration, curvature, trigger));
            this.unchanged = false;
        }
        return this;
    }

    public Envelope addSegment(float endValue, float duration) {
        return this.addSegment(endValue, duration, 1.0f, null);
    }

    public Envelope addSegment(float endValue, float duration, Bead trigger) {
        return this.addSegment(endValue, duration, 1.0f, trigger);
    }

    public Envelope addSegments(List<Segment> segments) {
        if (!this.lock) {
            for (Segment s : segments) {
                if (Float.isNaN(s.endValue) || Float.isInfinite(s.endValue)) continue;
                segments.add(s);
                this.unchanged = false;
            }
        }
        return this;
    }

    @Override
    public void setValue(float value) {
        if (!this.lock) {
            this.clear();
            this.addSegment(value, 0.0f);
            this.currentValue = value;
        }
    }

    public synchronized Envelope clear() {
        if (!this.lock) {
            this.segments = new ArrayList();
            this.currentSegment = null;
        }
        return this;
    }

    private synchronized void getNextSegment() {
        if (this.currentSegment != null) {
            this.currentValue = this.currentStartValue = this.currentSegment.endValue;
            this.segments.remove(this.currentSegment);
            if (this.currentSegment.trigger != null) {
                this.currentSegment.trigger.message(this);
            }
        } else {
            this.currentStartValue = this.currentValue;
        }
        this.currentSegment = this.segments.size() > 0 ? this.segments.get(0) : null;
        this.currentTime = 0;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public synchronized void calculateBuffer() {
        if (!this.unchanged) {
            boolean iChanged = false;
            for (int i = 0; i < this.bufferSize; ++i) {
                if (this.currentSegment == null) {
                    this.getNextSegment();
                } else if (this.currentSegment.duration == 0L) {
                    this.getNextSegment();
                    iChanged = true;
                } else {
                    iChanged = true;
                    float ratio = this.currentSegment.curvature != 1.0f ? (float)Math.pow((double)this.currentTime / (double)this.currentSegment.duration, this.currentSegment.curvature) : (float)this.currentTime / (float)this.currentSegment.duration;
                    this.currentValue = (1.0f - ratio) * this.currentStartValue + ratio * this.currentSegment.endValue;
                    ++this.currentTime;
                    if ((long)this.currentTime > this.currentSegment.duration) {
                        this.getNextSegment();
                    }
                }
                this.myBufOut[i] = this.currentValue;
            }
            if (!iChanged) {
                this.unchanged = true;
            }
        }
    }

    @Override
    public float getValue(int i, int j) {
        if (this.unchanged) {
            return this.currentValue;
        }
        return this.myBufOut[j];
    }

    public class Segment {
        float endValue;
        long duration;
        float curvature;
        Bead trigger;

        public Segment(float endValue, float duration, float curvature, Bead trigger) {
            this.endValue = endValue;
            this.duration = (int)Envelope.this.context.msToSamples(duration);
            this.curvature = Math.abs(curvature);
            this.trigger = trigger;
        }
    }
}

