/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class Gain
extends UGen
implements DataBeadReceiver {
    private UGen gainUGen;
    private float gain = 1.0f;

    public Gain(AudioContext context, int inouts, UGen gainEnvelope) {
        super(context, inouts, inouts);
        this.setGain(gainEnvelope);
    }

    public Gain(AudioContext context, int inouts, float gain) {
        super(context, inouts, inouts);
        this.setGain(gain);
    }

    public Gain(AudioContext context, int inouts) {
        this(context, inouts, 1.0f);
    }

    @Deprecated
    public UGen getGainEnvelope() {
        return this.gainUGen;
    }

    @Deprecated
    public void setGainEnvelope(UGen gainEnvelope) {
        this.gainUGen = gainEnvelope;
    }

    public float getGain() {
        return this.gain;
    }

    public Gain setGain(float gain) {
        this.gainUGen = null;
        this.gain = gain;
        return this;
    }

    public Gain setGain(UGen gainUGen) {
        if (gainUGen == null) {
            this.setGain(this.gain);
        } else {
            this.gainUGen = gainUGen;
            gainUGen.update();
            this.gain = gainUGen.getValue();
        }
        return this;
    }

    public UGen getGainUGen() {
        return this.gainUGen;
    }

    @Override
    public void calculateBuffer() {
        if (this.gainUGen == null) {
            for (int channel = 0; channel < this.ins; ++channel) {
                float[] bi = this.bufIn[channel];
                float[] bo = this.bufOut[channel];
                for (int i = 0; i < this.bufferSize; ++i) {
                    bo[i] = this.gain * bi[i];
                }
            }
        } else {
            this.gainUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.gain = this.gainUGen.getValue(0, i);
                for (int channel = 0; channel < this.ins; ++channel) {
                    this.bufOut[channel][i] = this.gain * this.bufIn[channel][i];
                }
            }
        }
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            UGen u = db.getUGen("gain");
            if (u == null) {
                this.setGain(db.getFloat("gain", this.gain));
            } else {
                this.setGain(u);
            }
        }
        return this;
    }
}

