/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Glide
extends UGen {
    private float currentValue;
    private float previousValue;
    private float targetValue;
    private int glideTime;
    private int countSinceGlide;
    private boolean gliding;
    private boolean nothingChanged;

    public Glide(AudioContext context, float currentValue, float glideTimeMS) {
        super(context, 1);
        this.currentValue = currentValue;
        this.countSinceGlide = 0;
        this.gliding = false;
        this.nothingChanged = false;
        this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
        this.outputPauseRegime = UGen.OutputPauseRegime.RETAIN;
        this.bufOut[0] = new float[this.bufferSize];
        this.setGlideTime(glideTimeMS);
    }

    public Glide(AudioContext context, float currentValue) {
        this(context, currentValue, 100.0f);
    }

    public Glide(AudioContext context) {
        this(context, 0.0f);
    }

    @Override
    public void setValue(float targetValue) {
        this.targetValue = targetValue;
        this.gliding = true;
        this.nothingChanged = false;
        this.countSinceGlide = 0;
        this.previousValue = this.currentValue;
    }

    public void setValueImmediately(float targetValue) {
        this.currentValue = targetValue;
        this.gliding = false;
        this.nothingChanged = false;
        this.countSinceGlide = 0;
    }

    public void setGlideTime(float msTime) {
        this.glideTime = (int)this.context.msToSamples(msTime);
    }

    public float getGlideTime() {
        return (float)this.context.samplesToMs(this.glideTime);
    }

    @Override
    public void calculateBuffer() {
        if (!this.nothingChanged) {
            this.nothingChanged = true;
            for (int i = 0; i < this.bufferSize; ++i) {
                if (this.gliding) {
                    if ((float)this.glideTime <= 0.0f) {
                        this.gliding = false;
                        this.previousValue = this.currentValue = this.targetValue;
                        this.bufOut[0][i] = this.currentValue;
                        this.nothingChanged = false;
                    } else if (this.countSinceGlide > this.glideTime) {
                        this.gliding = false;
                        this.bufOut[0][i] = this.previousValue = this.targetValue;
                    } else {
                        float offset = (float)this.countSinceGlide / (float)this.glideTime;
                        this.bufOut[0][i] = this.currentValue = offset * this.targetValue + (1.0f - offset) * this.previousValue;
                        this.nothingChanged = false;
                    }
                    ++this.countSinceGlide;
                    continue;
                }
                this.bufOut[0][i] = this.currentValue;
            }
        }
    }
}

