/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.ArrayList;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.buffers.CosineWindow;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.Static;

public class GranularSamplePlayer
extends SamplePlayer {
    private UGen pitchEnvelope;
    private UGen grainIntervalEnvelope;
    private UGen grainSizeEnvelope;
    private UGen randomnessEnvelope;
    private UGen randomPanEnvelope;
    private float timeSinceLastGrain;
    private double msPerSample;
    protected float pitch;
    private ArrayList<Grain> grains = new ArrayList();
    private ArrayList<Grain> freeGrains = new ArrayList();
    private ArrayList<Grain> deadGrains = new ArrayList();
    private Buffer window;
    private boolean loopInsideGrains;
    private boolean firstGrain = true;

    public GranularSamplePlayer(AudioContext context, int outs) {
        super(context, outs);
        this.pitchEnvelope = new Static(context, 1.0f);
        this.setGrainInterval(new Static(context, 70.0f));
        this.setGrainSize(new Static(context, 100.0f));
        this.setRandomness(new Static(context, 0.0f));
        this.setRandomPan(new Static(context, 0.0f));
        this.setWindow(new CosineWindow().getDefault());
        this.msPerSample = context.samplesToMs(1.0);
        this.loopInsideGrains = false;
    }

    public GranularSamplePlayer(AudioContext context, Sample buffer) {
        this(context, buffer.getNumChannels());
        this.setSample(buffer);
        this.loopStartEnvelope = new Static(context, 0.0f);
        this.loopEndEnvelope = new Static(context, (float)buffer.getLength());
    }

    @Override
    @Deprecated
    public UGen getPitchEnvelope() {
        return this.pitchEnvelope;
    }

    @Override
    public UGen getPitchUGen() {
        return this.pitchEnvelope;
    }

    @Override
    @Deprecated
    public void setPitchEnvelope(UGen pitchEnvelope) {
        this.pitchEnvelope = pitchEnvelope;
    }

    @Override
    public void setPitch(UGen pitchUGen) {
        this.pitchEnvelope = pitchUGen;
    }

    @Deprecated
    public UGen getGrainIntervalEnvelope() {
        return this.grainIntervalEnvelope;
    }

    public UGen getGrainIntervalUGen() {
        return this.grainIntervalEnvelope;
    }

    @Deprecated
    public void setGrainIntervalEnvelope(UGen grainIntervalEnvelope) {
        this.grainIntervalEnvelope = grainIntervalEnvelope;
    }

    public void setGrainInterval(UGen grainIntervalUGen) {
        this.grainIntervalEnvelope = grainIntervalUGen;
    }

    @Deprecated
    public UGen getGrainSizeEnvelope() {
        return this.grainSizeEnvelope;
    }

    public UGen getGrainSizeUGen() {
        return this.grainSizeEnvelope;
    }

    @Deprecated
    public void setGrainSizeEnvelope(UGen grainSizeEnvelope) {
        this.grainSizeEnvelope = grainSizeEnvelope;
    }

    public void setGrainSize(UGen grainSizeUGen) {
        this.grainSizeEnvelope = grainSizeUGen;
    }

    public Buffer getWindow() {
        return this.window;
    }

    public void setWindow(Buffer window) {
        this.window = window;
    }

    @Deprecated
    public UGen getRandomnessEnvelope() {
        return this.randomnessEnvelope;
    }

    public UGen getRandomnessUGen() {
        return this.randomnessEnvelope;
    }

    @Deprecated
    public void setRandomnessEnvelope(UGen randomnessEnvelope) {
        this.randomnessEnvelope = randomnessEnvelope;
    }

    public void setRandomness(UGen randomnessUGen) {
        this.randomnessEnvelope = randomnessUGen;
    }

    @Deprecated
    public UGen getRandomPanEnvelope() {
        return this.randomPanEnvelope;
    }

    public UGen getRandomPanUGen() {
        return this.randomPanEnvelope;
    }

    @Deprecated
    public void setRandomPanEnvelope(UGen randomPanEnvelope) {
        this.randomPanEnvelope = randomPanEnvelope;
    }

    public void setRandomPan(UGen randomPanEnvelope) {
        this.randomPanEnvelope = randomPanEnvelope;
    }

    @Override
    @Deprecated
    public synchronized void setBuffer(Sample buffer) {
        super.setSample(buffer);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public synchronized void setSample(Sample buffer) {
        super.setSample(buffer);
        this.grains.clear();
        this.timeSinceLastGrain = 0.0f;
    }

    @Override
    public void start() {
        super.start();
        this.timeSinceLastGrain = 0.0f;
    }

    private void resetGrain(Grain g, int time) {
        g.position = this.position + (double)(this.grainSizeEnvelope.getValue(0, time) * this.randomnessEnvelope.getValue(0, time)) * (Math.random() * 2.0 - 1.0);
        g.age = 0.0;
        g.grainSize = this.grainSizeEnvelope.getValue(0, time);
    }

    private void setGrainPan(Grain g, float panRandomness) {
        g.pan = new float[this.outs];
        if (this.outs == 2) {
            float pan = (float)Math.random() * Math.min(1.0f, Math.max(0.0f, panRandomness)) * 0.5f;
            pan = Math.random() < 0.5 ? 0.5f + pan : 0.5f - pan;
            g.pan[0] = pan > 0.5f ? 1.0f : 2.0f * pan;
            g.pan[1] = pan < 0.5f ? 1.0f : 2.0f * (1.0f - pan);
        } else {
            for (int i = 0; i < this.outs; ++i) {
                g.pan[i] = 1.0f;
            }
        }
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain g = new Grain();
            g.position = this.position;
            g.age = this.grainSizeEnvelope.getValue() / 4.0f;
            this.grains.add(g);
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainIntervalEnvelope.getValue() / 2.0f;
            this.setGrainPan(g, this.randomPanEnvelope.getValue(0, 0));
        }
    }

    @Override
    public synchronized void calculateBuffer() {
        if (this.sample != null) {
            this.rateEnvelope.update();
            if (this.positionEnvelope != null) {
                this.positionEnvelope.update();
            }
            this.loopStartEnvelope.update();
            this.loopEndEnvelope.update();
            this.pitchEnvelope.update();
            this.grainIntervalEnvelope.update();
            this.grainSizeEnvelope.update();
            this.randomnessEnvelope.update();
            this.randomPanEnvelope.update();
            this.firstGrain();
            for (int i = 0; i < this.bufferSize; ++i) {
                Grain g;
                int gi;
                if (this.timeSinceLastGrain > this.grainIntervalEnvelope.getValue(0, i)) {
                    Grain g2 = null;
                    if (this.freeGrains.size() > 0) {
                        g2 = this.freeGrains.get(0);
                        this.freeGrains.remove(0);
                    } else {
                        g2 = new Grain();
                    }
                    this.resetGrain(g2, i);
                    this.setGrainPan(g2, this.randomPanEnvelope.getValue(0, i));
                    this.grains.add(g2);
                    this.timeSinceLastGrain = 0.0f;
                }
                for (int j = 0; j < this.outs; ++j) {
                    this.bufOut[j][i] = 0.0f;
                }
                for (gi = 0; gi < this.grains.size(); ++gi) {
                    g = this.grains.get(gi);
                    float windowScale = this.window.getValueFraction((float)(g.age / g.grainSize));
                    switch (this.interpolationType) {
                        case ADAPTIVE: {
                            if (this.pitch > 2.5f) {
                                this.sample.getFrameNoInterp(g.position, this.frame);
                                break;
                            }
                            if (this.pitch > 0.5f) {
                                this.sample.getFrameLinear(g.position, this.frame);
                                break;
                            }
                            this.sample.getFrameCubic(g.position, this.frame);
                            break;
                        }
                        case LINEAR: {
                            this.sample.getFrameLinear(g.position, this.frame);
                            break;
                        }
                        case CUBIC: {
                            this.sample.getFrameCubic(g.position, this.frame);
                            break;
                        }
                        case NONE: {
                            this.sample.getFrameNoInterp(g.position, this.frame);
                        }
                    }
                    for (int j = 0; j < this.outs; ++j) {
                        float[] fArray = this.bufOut[j];
                        int n = i;
                        fArray[n] = fArray[n] + g.pan[j] * windowScale * this.frame[j % this.sample.getNumChannels()];
                    }
                }
                this.calculateNextPosition(i);
                this.pitch = Math.abs(this.pitchEnvelope.getValue(0, i));
                for (gi = 0; gi < this.grains.size(); ++gi) {
                    g = this.grains.get(gi);
                    this.calculateNextGrainPosition(g);
                }
                this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.msPerSample);
                for (gi = 0; gi < this.grains.size(); ++gi) {
                    g = this.grains.get(gi);
                    if (!(g.age > g.grainSize)) continue;
                    this.freeGrains.add(g);
                    this.deadGrains.add(g);
                }
                for (gi = 0; gi < this.deadGrains.size(); ++gi) {
                    g = this.deadGrains.get(gi);
                    this.grains.remove(g);
                }
                this.deadGrains.clear();
            }
        }
    }

    private void calculateNextGrainPosition(Grain g) {
        int direction = this.rate >= 0.0f ? 1 : -1;
        g.age += this.msPerSample;
        if (this.loopInsideGrains) {
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    g.position += (double)direction * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    g.position -= (double)direction * this.positionIncrement * (double)this.pitch;
                    break;
                }
                case LOOP_FORWARDS: {
                    g.position += (double)direction * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && g.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        g.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(g.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    g.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    g.position -= (double)direction * this.positionIncrement * (double)this.pitch;
                    if (this.rate > 0.0f && g.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        g.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(g.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    g.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    g.position = g.position + (double)direction * (this.forwards ? this.positionIncrement * (double)this.pitch : -this.positionIncrement * (double)this.pitch);
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(g.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        g.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - g.position;
                        break;
                    }
                    if (!(g.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    g.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - g.position;
                }
            }
        } else {
            g.position += (double)direction * this.positionIncrement * (double)this.pitch;
        }
    }

    public float getAverageNumberOfGrains() {
        return this.grainSizeEnvelope.getValue() / this.grainIntervalEnvelope.getValue();
    }

    private static class Grain {
        double position;
        double age;
        double grainSize;
        float[] pan;

        private Grain() {
        }
    }
}

