/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public abstract class IIRFilter
extends UGen {
    public IIRFilter(AudioContext context, int ins, int outs) {
        super(context, ins, outs);
    }

    public abstract IIRFilterAnalysis getFilterResponse(float var1);

    public float getAmplitudeResponse(float freq) {
        return (float)this.getFilterResponse((float)freq).amplitudeResponse;
    }

    public float getPhaseResponse(float freq) {
        return (float)this.getFilterResponse((float)freq).phaseResponse;
    }

    public float getPhaseDelay(float freq) {
        return (float)this.getFilterResponse((float)freq).phaseDelay;
    }

    public float getGroupDelay(float freq) {
        return (float)this.getFilterResponse((float)freq).groupDelay;
    }

    public static IIRFilterAnalysis calculateFilterResponse(float[] bs, float[] as, float freq, float samplingFreq) {
        IIRFilterAnalysis ret = IIRFilter.analyzeFilter(bs, as, freq, samplingFreq);
        ret.groupDelay = IIRFilter.calculateGroupDelay(bs, as, freq, samplingFreq);
        return ret;
    }

    protected static double calculateGroupDelay(float[] bs, float[] as, float freq, float samplingFreq) {
        IIRFilterAnalysis a = IIRFilter.analyzeFilter(bs, as, freq - 0.01f, samplingFreq);
        IIRFilterAnalysis b = IIRFilter.analyzeFilter(bs, as, freq + 0.01f, samplingFreq);
        return (b.phaseResponse - a.phaseResponse) / (a.w - b.w);
    }

    protected static IIRFilterAnalysis analyzeFilter(float[] bs, float[] as, float freq, float samplingFreq) {
        int i;
        double w = (double)(-2.0f * freq) * Math.PI / (double)samplingFreq;
        double nr = 0.0;
        double ni = 0.0;
        double dr = 1.0;
        double di = 0.0;
        if (bs.length > 0) {
            nr = bs[0];
            for (i = 1; i < bs.length; ++i) {
                nr += (double)bs[i] * Math.cos(w * (double)i);
                ni += (double)bs[i] * Math.sin(w * (double)i);
            }
        }
        if (as.length > 0) {
            dr = as[0];
            for (i = 1; i < as.length; ++i) {
                dr += (double)as[i] * Math.cos(w * (double)i);
                di += (double)as[i] * Math.sin(w * (double)i);
            }
        }
        double md2 = dr * dr + di * di;
        IIRFilterAnalysis ret = new IIRFilterAnalysis();
        ret.amplitudeResponse = Math.sqrt((nr * nr + ni * ni) / md2);
        ret.phaseResponse = Math.atan2(ni, nr) - Math.atan2(di, dr);
        ret.phaseDelay = ret.phaseResponse / Math.PI / -2.0 / (double)freq;
        ret.frReal = (nr * dr + ni * di) / md2;
        ret.frImag = (ni * dr - nr * di) / md2;
        ret.w = w;
        return ret;
    }

    public static class IIRFilterAnalysis {
        public double frReal = 0.0;
        public double frImag = 0.0;
        public double amplitudeResponse = 0.0;
        public double phaseResponse = 0.0;
        public double phaseDelay = 0.0;
        public double groupDelay = 0.0;
        public double w = 0.0;
    }
}

