/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;

public class OnePoleFilter
extends IIRFilter
implements DataBeadReceiver {
    private float freq;
    private float b0;
    private float a1;
    private float y1 = 0.0f;
    private UGen freqUGen;
    protected float samplingfreq;
    protected float two_pi_over_sf;
    protected boolean isFreqStatic;

    public OnePoleFilter(AudioContext con, float freq) {
        super(con, 1, 1);
        this.samplingfreq = con.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.setFrequency(freq);
    }

    public OnePoleFilter(AudioContext con, UGen freq) {
        super(con, 1, 1);
        this.samplingfreq = con.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.setFrequency(freq);
    }

    protected void calcVals() {
        this.b0 = (float)Math.sin(this.two_pi_over_sf * this.freq);
        this.a1 = this.b0 - 1.0f;
    }

    @Override
    public void calculateBuffer() {
        float[] bi = this.bufIn[0];
        float[] bo = this.bufOut[0];
        if (this.isFreqStatic) {
            for (int currsamp = 0; currsamp < this.bufferSize; ++currsamp) {
                bo[currsamp] = this.y1 = this.b0 * bi[currsamp] - this.a1 * this.y1;
            }
        } else {
            this.freqUGen.update();
            for (int currsamp = 0; currsamp < this.bufferSize; ++currsamp) {
                this.b0 = (float)Math.sin(this.two_pi_over_sf * this.freqUGen.getValue(0, currsamp));
                this.a1 = this.b0 - 1.0f;
                bo[currsamp] = this.y1 = this.b0 * bi[currsamp] - this.a1 * this.y1;
            }
            this.freq = this.freqUGen.getValue(0, this.bufferSize - 1);
        }
        if (Float.isNaN(this.y1)) {
            this.y1 = 0.0f;
        }
    }

    public float getFrequency() {
        return this.freq;
    }

    public OnePoleFilter setFrequency(float freq) {
        this.freq = freq;
        this.b0 = (float)Math.sin(this.two_pi_over_sf * freq);
        this.a1 = this.b0 - 1.0f;
        this.isFreqStatic = true;
        return this;
    }

    public OnePoleFilter setFrequency(UGen freqUGen) {
        if (freqUGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = freqUGen;
            freqUGen.update();
            this.freq = freqUGen.getValue();
            this.isFreqStatic = false;
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public OnePoleFilter setFreq(float freq) {
        return this.setFrequency(freq);
    }

    @Deprecated
    public OnePoleFilter setFreq(UGen freqUGen) {
        return this.setFrequency(freqUGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public OnePoleFilter setParams(DataBead paramBead) {
        Object o;
        if (paramBead != null && (o = paramBead.get("frequency")) != null) {
            if (o instanceof UGen) {
                this.setFrequency((UGen)o);
            } else {
                this.setFrequency(paramBead.getFloat("frequency", this.freq));
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isFreqStatic) {
            db.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            db.put("frequency", (Object)this.freqUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("frequency", (Object)Float.valueOf(this.freq));
        return db;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        this.setParams(db);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float freq) {
        return OnePoleFilter.calculateFilterResponse(new float[]{this.b0}, new float[]{1.0f, this.a1}, freq, this.context.getSampleRate());
    }
}

