/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;

public class OscillatorBank
extends UGen {
    private float[] frequency;
    private float[] gains;
    private float[] point;
    private double[] increment;
    private Buffer buffer;
    private int numOscillators;
    private float gain;

    public OscillatorBank(AudioContext context, Buffer buffer, int numOscillators) {
        super(context, 1);
        this.buffer = buffer;
        this.setNumOscillators(numOscillators);
        this.gain = 1.0f / (float)numOscillators;
    }

    public void setNumOscillators(int numOscillators) {
        int i;
        this.numOscillators = numOscillators;
        float[] old = this.frequency;
        this.frequency = new float[numOscillators];
        this.increment = new double[numOscillators];
        int min = 0;
        if (old != null) {
            min = Math.min(this.frequency.length, old.length);
        }
        for (i = 0; i < min; ++i) {
            this.frequency[i] = old[i];
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
        for (i = min; i < this.frequency.length; ++i) {
            this.frequency[i] = 0.0f;
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
        old = this.gains;
        this.gains = new float[numOscillators];
        for (i = 0; i < min; ++i) {
            this.gains[i] = old[i];
        }
        for (i = min; i < this.gains.length; ++i) {
            this.gains[i] = 1.0f;
        }
        old = this.point;
        this.point = new float[numOscillators];
        for (i = 0; i < min; ++i) {
            this.point[i] = old[i];
        }
        for (i = min; i < this.point.length; ++i) {
            this.point[i] = 0.0f;
        }
    }

    public void setFrequenciesAndGains(float[][] freqsGains) {
        for (int i = 0; i < this.numOscillators; ++i) {
            if (i < freqsGains.length) {
                this.frequency[i] = Math.abs(freqsGains[i][0]);
                this.gains[i] = freqsGains[i][1];
            } else {
                this.frequency[i] = 0.0f;
            }
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
    }

    public void setFrequencies(float[] frequencies) {
        for (int i = 0; i < this.numOscillators; ++i) {
            this.frequency[i] = i < frequencies.length ? Math.abs(frequencies[i]) : 0.0f;
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
    }

    public float[] getFrequencies() {
        return this.frequency;
    }

    public void setGains(float[] gains) {
        for (int i = 0; i < this.numOscillators; ++i) {
            this.gains[i] = i < gains.length ? gains[i] : 0.0f;
        }
    }

    public float[] getGains() {
        return this.gains;
    }

    @Override
    public void calculateBuffer() {
        this.zeroOuts();
        int i = 0;
        while (i < this.bufferSize) {
            for (int j = 0; j < this.numOscillators; ++j) {
                this.point[j] = (float)((double)this.point[j] + this.increment[j]) % 1.0f;
                float[] fArray = this.bufOut[0];
                int n = i;
                fArray[n] = fArray[n] + this.gains[j] * this.buffer.getValueFraction(this.point[j]);
            }
            float[] fArray = this.bufOut[0];
            int n = i++;
            fArray[n] = fArray[n] * this.gain;
        }
    }
}

