/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class Panner
extends UGen
implements DataBeadReceiver {
    protected static int rootSize = 1024;
    public static float[] ROOTS = Panner.buildRoots(rootSize);
    protected float pos = 0.0f;
    protected float p1;
    protected float p2;
    protected UGen posUGen;
    protected boolean isPosStatic;

    public Panner(AudioContext con) {
        this(con, 0.0f);
    }

    public Panner(AudioContext con, float ipos) {
        super(con, 1, 2);
        this.setPos(ipos);
    }

    public Panner(AudioContext con, UGen posUGen) {
        super(con, 1, 2);
        this.setPos(posUGen);
    }

    @Override
    public void calculateBuffer() {
        float[] bi = this.bufIn[0];
        float[] bo1 = this.bufOut[0];
        float[] bo2 = this.bufOut[1];
        if (this.isPosStatic) {
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                bo1[currsample] = this.p1 * bi[currsample];
                bo2[currsample] = this.p2 * bi[currsample];
            }
        } else {
            this.posUGen.update();
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                float f;
                this.pos = this.posUGen.getValue(0, currsample);
                if (f >= 1.0f) {
                    this.p1 = 0.0f;
                    this.p2 = 1.0f;
                } else if (this.pos <= -1.0f) {
                    this.p1 = 1.0f;
                    this.p2 = 0.0f;
                } else {
                    float f2 = (this.pos + 1.0f) * 0.5f * (float)rootSize;
                    int n1 = (int)Math.floor(f2);
                    this.p2 = ROOTS[n1] * (1.0f - (f2 -= (float)n1)) + ROOTS[n1 + 1] * f2;
                    this.p1 = ROOTS[rootSize - n1] * (1.0f - f2) + ROOTS[rootSize - (n1 + 1)] * f2;
                }
                bo1[currsample] = this.p1 * bi[currsample];
                bo2[currsample] = this.p2 * bi[currsample];
            }
        }
    }

    protected static float[] buildRoots(int rs) {
        float[] roots = new float[rs + 2];
        for (int i = 0; i < rs + 1; ++i) {
            roots[i] = (float)Math.sqrt((float)i / (float)rs);
        }
        roots[rs + 1] = 1.0f;
        return roots;
    }

    public float getPos() {
        return this.pos;
    }

    public Panner setPos(float pos) {
        float f;
        this.pos = pos;
        if (f >= 1.0f) {
            this.p1 = 0.0f;
            this.p2 = 1.0f;
        } else if (pos <= -1.0f) {
            this.p1 = 1.0f;
            this.p2 = 0.0f;
        } else {
            float f2 = (pos + 1.0f) * 0.5f * (float)rootSize;
            int n1 = (int)Math.floor(f2);
            this.p2 = ROOTS[n1] * (1.0f - (f2 -= (float)n1)) + ROOTS[n1 + 1] * f2;
            this.p1 = ROOTS[rootSize - n1] * (1.0f - f2) + ROOTS[rootSize - (n1 + 1)] * f2;
        }
        this.isPosStatic = true;
        this.posUGen = null;
        return this;
    }

    public Panner setPos(UGen posUGen) {
        if (posUGen == null) {
            this.setPos(this.pos);
        } else {
            this.posUGen = posUGen;
            posUGen.update();
            this.pos = posUGen.getValue();
            this.isPosStatic = false;
        }
        return this;
    }

    public UGen getPosUGen() {
        if (this.isPosStatic) {
            return null;
        }
        return this.posUGen;
    }

    public Panner setParams(DataBead paramBead) {
        Object o;
        if (paramBead != null && (o = paramBead.get("position")) != null) {
            if (o instanceof UGen) {
                this.setPos((UGen)o);
            } else {
                this.setPos(paramBead.getFloat("position", this.pos));
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isPosStatic) {
            db.put("position", (Object)Float.valueOf(this.pos));
        } else {
            db.put("position", (Object)this.posUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("position", (Object)Float.valueOf(this.pos));
        return db;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        this.setParams(db);
        return this;
    }
}

