/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Phasor
extends UGen {
    private UGen frequencyUGen;
    protected float frequency = 0.0f;
    protected double phase = 0.0;
    protected double one_over_sr;

    public Phasor(AudioContext con) {
        super(con, 0, 1);
        this.one_over_sr = 1.0 / (double)con.getSampleRate();
    }

    public Phasor(AudioContext con, float frequency) {
        this(con);
        this.setFrequency(frequency);
    }

    public Phasor(AudioContext con, UGen frequencyUGen) {
        this(con);
        this.setFrequency(frequencyUGen);
    }

    @Override
    public void calculateBuffer() {
        float[] bo = this.bufOut[0];
        if (this.frequencyUGen == null) {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.phase = ((this.phase + this.one_over_sr * (double)this.frequency) % 1.0 + 1.0) % 1.0;
                bo[i] = (float)this.phase;
            }
        } else {
            this.frequencyUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.frequency = this.frequencyUGen.getValue(0, i);
                this.phase = ((this.phase + this.one_over_sr * (double)this.frequency) % 1.0 + 1.0) % 1.0;
                bo[i] = (float)this.phase;
            }
        }
    }

    public UGen getFrequencyUGen() {
        return this.frequencyUGen;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public Phasor setFrequency(UGen frequencyUGen) {
        if (frequencyUGen == null) {
            this.setFrequency(this.frequency);
        } else {
            this.frequencyUGen = frequencyUGen;
            frequencyUGen.update();
            this.frequency = frequencyUGen.getValue();
        }
        return this;
    }

    public Phasor setFrequency(float frequency) {
        this.frequency = frequency;
        this.frequencyUGen = null;
        return this;
    }

    public float getPhase() {
        return (float)this.phase;
    }

    public Phasor setPhase(float phase) {
        this.phase = phase;
        return this;
    }
}

