/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.LinkedList;
import java.util.Queue;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class PolyLimit
extends UGen {
    private int maxInputs;
    private boolean steal = true;
    private Queue<UGen> existingInputs;

    public PolyLimit(AudioContext context, int inouts, int maxInputs) {
        super(context, inouts, inouts);
        this.setMaxInputs(maxInputs);
        this.existingInputs = new LinkedList<UGen>();
    }

    @Override
    public void addInput(UGen sourceUGen) {
        if (this.existingInputs.contains(sourceUGen)) {
            this.existingInputs.remove(sourceUGen);
            this.existingInputs.add(sourceUGen);
        } else if (this.steal) {
            if (this.existingInputs.size() >= this.maxInputs) {
                UGen deadUGen = this.existingInputs.poll();
                this.removeAllConnections(deadUGen);
            }
            this.existingInputs.add(sourceUGen);
            super.addInput(sourceUGen);
        } else {
            LinkedList<UGen> copy = new LinkedList<UGen>();
            copy.addAll(this.existingInputs);
            for (UGen ug : copy) {
                if (!ug.isDeleted()) continue;
                this.existingInputs.remove(ug);
            }
            if (this.existingInputs.size() < this.maxInputs) {
                this.existingInputs.add(sourceUGen);
                super.addInput(sourceUGen);
            }
        }
    }

    @Override
    public void removeAllConnections(UGen sourceUGen) {
        super.removeAllConnections(sourceUGen);
        this.existingInputs.remove(sourceUGen);
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }

    public void setMaxInputs(int maxInputs) {
        this.maxInputs = maxInputs;
    }

    public boolean isSteal() {
        return this.steal;
    }

    public void setSteal(boolean steal) {
        this.steal = steal;
    }

    @Override
    public void calculateBuffer() {
        for (int i = 0; i < this.ins; ++i) {
            this.bufOut[i] = this.bufIn[i];
        }
    }
}

