/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class RMS
extends UGen {
    private float[] rmsMem;
    private float sum = 0.0f;
    private float channelScale;
    private float memScale;
    private int channels;
    private int index = 0;
    private int memorySize;

    public RMS(AudioContext context, int channels, int memorySize) {
        super(context, channels, 1);
        this.channels = channels;
        this.channelScale = 1.0f / (float)channels;
        this.rmsMem = new float[memorySize];
        this.memorySize = memorySize;
        this.memScale = 1.0f / (float)memorySize;
    }

    @Override
    public void calculateBuffer() {
        float[] bo = this.bufOut[0];
        for (int i = 0; i < this.bufferSize; ++i) {
            float newMem = 0.0f;
            for (int j = 0; j < this.channels; ++j) {
                float x = this.bufIn[j][i];
                newMem += x * x;
            }
            this.sum -= this.rmsMem[this.index];
            this.rmsMem[this.index] = newMem * this.channelScale;
            this.sum += this.rmsMem[this.index];
            if (this.sum < 0.0f) {
                this.sum = 0.0f;
            }
            this.index = (this.index + 1) % this.memorySize;
            bo[i] = (float)Math.sqrt(this.sum * this.memScale);
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public int getMemorySize() {
        return this.memorySize;
    }
}

