/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGenChain;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.AllpassFilter;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.OnePoleFilter;
import net.beadsproject.beads.ugens.RandomPWM;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;

public class Reverb
extends UGenChain
implements DataBeadReceiver {
    private float size;
    private float damping;
    private float earlyLevel;
    private float lateLevel;
    private Gain earlyGain;
    private Gain lateGain;
    private AllpassFilter eAPF1;
    private AllpassFilter eAPF2;
    private AllpassFilter eAPF3;
    private AllpassFilter lAPF1;
    private AllpassFilter lAPF2;
    private AllpassFilter lAPF3;
    private AllpassFilter lAPF4;
    private AllpassFilter[] apfOuts;
    private float[] outDelayScale;
    private OnePoleFilter lpf;
    private OnePoleFilter src;
    private RandomPWM delayModulator;
    private float lateDelay1;
    private float lateDelay2;
    private float lateDelay3;
    private float lateDelay4;
    private float sampsPerMS;
    private TapIn earlyTapIn;
    private TapOut earlyTapOut;

    public Reverb(AudioContext context) {
        this(context, 1);
    }

    public Reverb(AudioContext context, int outChannels) {
        super(context, 1, outChannels);
        this.sampsPerMS = (float)context.msToSamples(1.0);
        this.src = new OnePoleFilter(context, 4000.0f);
        this.earlyTapIn = new TapIn(context, 125.0f);
        this.earlyTapOut = new TapOut(context, this.earlyTapIn, 10.0f);
        this.eAPF1 = new AllpassFilter(context, (int)(12.812 * (double)this.sampsPerMS), 113, 0.3f);
        this.eAPF2 = new AllpassFilter(context, (int)(12.812 * (double)this.sampsPerMS * 3.0), 337, 0.4f);
        this.eAPF3 = new AllpassFilter(context, (int)(12.812 * (double)this.sampsPerMS * 9.4), 1051, 0.5f);
        Gain earlyGainEcho = new Gain(context, 1, -0.3f);
        this.lAPF1 = new AllpassFilter(context, (int)(140.0f * this.sampsPerMS), 19, 0.72f);
        this.lAPF2 = new AllpassFilter(context, (int)(140.0f * this.sampsPerMS), 23, 0.7f);
        this.lAPF3 = new AllpassFilter(context, (int)(140.0f * this.sampsPerMS), 29, 0.65f);
        this.lAPF4 = new AllpassFilter(context, (int)(140.0f * this.sampsPerMS), 37, 0.6f);
        this.lpf = new OnePoleFilter(context, 1000.0f);
        TapIn lateTapIn = new TapIn(context, 1000.0f);
        TapOut lateTapOut1 = new TapOut(context, lateTapIn, 10.0f);
        TapOut lateTapOut2 = new TapOut(context, lateTapIn, 31.17f);
        Gain lateGainEcho = new Gain(context, 1, -0.25f);
        this.earlyGain = new Gain(context, 1, 1.0f);
        this.lateGain = new Gain(context, 1, 1.0f);
        Gain collectedGain = new Gain(context, 1, 1.0f);
        this.delayModulator = new RandomPWM(context, RandomPWM.RAMPED_NOISE, 4000.0f, 15000.0f, 1.0f);
        this.drawFromChainInput(this.src);
        this.earlyTapIn.addInput(this.src);
        this.earlyTapIn.addInput(this.earlyGain);
        this.eAPF1.addInput(this.earlyTapOut);
        this.eAPF2.addInput(this.eAPF1);
        this.eAPF3.addInput(this.eAPF2);
        earlyGainEcho.addInput(this.eAPF3);
        this.earlyGain.addInput(earlyGainEcho);
        this.lAPF1.addInput(earlyGainEcho);
        this.lAPF1.addInput(lateGainEcho);
        this.lAPF1.addInput(this.src);
        this.lAPF2.addInput(this.lAPF1);
        this.lAPF3.addInput(this.lAPF2);
        this.lAPF4.addInput(this.lAPF3);
        this.lpf.addInput(this.lAPF4);
        lateTapIn.addInput(this.lpf);
        lateGainEcho.addInput(lateTapOut1);
        lateGainEcho.addInput(lateTapOut2);
        this.lateGain.addInput(lateGainEcho);
        collectedGain.addInput(this.earlyGain);
        collectedGain.addInput(this.lateGain);
        this.apfOuts = new AllpassFilter[outChannels];
        this.outDelayScale = new float[outChannels];
        for (int i = 0; i < outChannels; ++i) {
            float g = 0.3f + (float)i / (float)(i + 1) * 0.1f + (float)Math.sin(i) * 0.05f;
            this.outDelayScale[i] = (3.0f * (float)i + 5.0f) / (5.0f * (float)i + 5.0f);
            this.apfOuts[i] = new AllpassFilter(context, (int)(60.0f * this.sampsPerMS), 20, g);
            this.apfOuts[i].addInput(collectedGain);
            this.addToChainOutput(i, this.apfOuts[i]);
        }
        this.setSize(0.5f).setDamping(0.7f).setEarlyReflectionsLevel(1.0f).setLateReverbLevel(1.0f);
    }

    @Override
    protected void preFrame() {
        this.delayModulator.update();
        int m = (int)(this.delayModulator.getValue() * 0.3f * this.sampsPerMS);
        this.lAPF1.setDelay((int)this.lateDelay1 - m);
        this.lAPF2.setDelay((int)this.lateDelay2 + m);
        this.lAPF3.setDelay((int)this.lateDelay3 - m);
        this.lAPF4.setDelay((int)this.lateDelay4 + m);
    }

    public float getSize() {
        return this.size;
    }

    public Reverb setSize(float size) {
        if (size > 1.0f) {
            size = 1.0f;
        } else if ((double)size < 0.01) {
            size = 0.01f;
        }
        this.size = size;
        this.lateDelay1 = 86.0f * size * this.sampsPerMS;
        this.lateDelay2 = this.lateDelay1 * 1.16f;
        this.lateDelay3 = this.lateDelay2 * 1.16f;
        this.lateDelay4 = this.lateDelay3 * 1.16f;
        this.earlyTapOut.setDelay(60.0f * size);
        float d = 12.812f * this.sampsPerMS * size;
        this.eAPF1.setDelay((int)d);
        this.eAPF2.setDelay((int)(d * 3.0f - 2.0f));
        this.eAPF3.setDelay((int)((double)d * 9.3 + 1.0));
        d = 60.0f * this.sampsPerMS * size;
        for (int i = 0; i < this.outs; ++i) {
            this.apfOuts[i].setDelay((int)(d * this.outDelayScale[i]));
        }
        return this;
    }

    public float getDamping() {
        return this.damping;
    }

    public Reverb setDamping(float damping) {
        if (damping < 0.0f) {
            damping = 0.0f;
        } else if (damping > 1.0f) {
            damping = 1.0f;
        }
        this.damping = damping;
        float f = 1.0f - (float)Math.sqrt(damping);
        this.src.setFrequency(f * 10000.0f + 250.0f);
        this.lpf.setFrequency(f * 8000.0f + 200.0f);
        return this;
    }

    public float getEarlyReflectionsLevel() {
        return this.earlyLevel;
    }

    public Reverb setEarlyReflectionsLevel(float earlyLevel) {
        this.earlyLevel = earlyLevel;
        this.earlyGain.setGain(earlyLevel);
        return this;
    }

    public float getLateReverbLevel() {
        return this.lateLevel;
    }

    public Reverb setLateReverbLevel(float lateLevel) {
        this.lateLevel = lateLevel;
        this.lateGain.setGain(lateLevel);
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            this.setDamping(db.getFloat("damping", this.damping));
            this.setSize(db.getFloat("roomSize", this.size));
            this.setEarlyReflectionsLevel(db.getFloat("earlyReflectionsLevel", this.earlyLevel));
            this.setLateReverbLevel(db.getFloat("lateReverbLevel", this.lateLevel));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        db.put("damping", (Object)Float.valueOf(this.damping));
        db.put("roomSize", (Object)Float.valueOf(this.size));
        db.put("earlyReflectionsLevel", (Object)Float.valueOf(this.earlyLevel));
        db.put("lateReverbLevel", (Object)Float.valueOf(this.lateLevel));
        return db;
    }
}

