/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.Glide;

public class Spatial
extends UGen {
    private int dimensions;
    private float[][] speakerPositions;
    private float sphereDiameter;
    private Map<UGen, Location> sources;
    private List<UGen> deadSources;
    private float curve;

    public Spatial(AudioContext context, int dimensions) {
        this(context, dimensions, (float)Math.sqrt(dimensions));
    }

    public Spatial(AudioContext context, int dimensions, float sphereDiameter) {
        super(context, (int)Math.pow(2.0, dimensions));
        this.dimensions = dimensions;
        switch (dimensions) {
            case 1: {
                this.setSpeakerPositions(new float[][]{{0.0f}, {1.0f}});
                break;
            }
            case 2: {
                this.setSpeakerPositions(new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}});
                break;
            }
            case 3: {
                this.setSpeakerPositions(new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}});
                break;
            }
            default: {
                new IllegalArgumentException("Error, that's a stupid number of dimensions: " + dimensions + "!").printStackTrace();
            }
        }
        this.setSphereDiameter(sphereDiameter);
        this.setup();
    }

    public Spatial(AudioContext context, int dimensions, float[][] locations) {
        this(context, dimensions, locations, (float)Math.sqrt(dimensions));
    }

    public Spatial(AudioContext context, int dimensions, float[][] locations, float sphereDiameter) {
        super(context, locations.length);
        this.dimensions = dimensions;
        this.setSpeakerPositions(locations);
        this.setSphereDiameter(sphereDiameter);
        this.setup();
    }

    private void setup() {
        this.outputInitializationRegime = UGen.OutputInitializationRegime.ZERO;
        this.sources = Collections.synchronizedMap(new Hashtable());
        this.deadSources = new ArrayList<UGen>();
        this.curve = 3.0f;
    }

    public void setSphereDiameter(float sd) {
        this.sphereDiameter = sd;
    }

    public static float[][] speakerPositionsFromFile(String file, int dimensions) {
        try {
            FileInputStream fis = new FileInputStream(new File(file));
            Scanner scanner = new Scanner(fis);
            LinkedList<Float> coords = new LinkedList<Float>();
            while (scanner.hasNext()) {
                coords.add(Float.valueOf(scanner.nextFloat()));
            }
            System.out.print("Spatial: Loaded speaker positions from " + file + " ");
            float[][] speakerPositions = new float[coords.size() / dimensions][dimensions];
            for (int i = 0; i < speakerPositions.length; ++i) {
                System.out.print("[");
                for (int j = 0; j < dimensions; ++j) {
                    speakerPositions[i][j] = ((Float)coords.poll()).floatValue();
                    System.out.print(speakerPositions[i][j] + " ");
                }
                System.out.print("]");
            }
            System.out.println();
            return speakerPositions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setSpeakerPositions(float[][] locations) {
        if (locations.length > 0 && locations[0].length != this.dimensions) {
            new IllegalArgumentException("Error, location data does not correspond to dimensions: " + this.dimensions + "!").printStackTrace();
            return;
        }
        this.speakerPositions = new float[locations.length][this.dimensions];
        for (int i = 0; i < this.speakerPositions.length; ++i) {
            for (int j = 0; j < this.dimensions; ++j) {
                this.speakerPositions[i][j] = locations[i][j];
            }
        }
    }

    public static float distance(float[] a, float[] b) {
        float distance = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            distance += (a[i] - b[i]) * (a[i] - b[i]);
        }
        distance = (float)Math.sqrt(distance);
        return distance;
    }

    @Override
    public void addInput(UGen source) {
        Location location = new Location(source);
        this.sources.put(source, location);
    }

    @Override
    public void addInput(int inputIndex, UGen source, int outputIndex) {
        this.addInput(source);
    }

    public void addInput(UGen source, UGen[][] controllers) {
        Location location = new Location(source, controllers);
        this.sources.put(source, location);
    }

    public void setLocation(UGen source, int channel, float[] newPos) {
        Location l = this.sources.get(source);
        if (l != null) {
            l.move(channel, newPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(UGen source) {
        Map<UGen, Location> map = this.sources;
        synchronized (map) {
            this.sources.remove(source);
        }
    }

    @Override
    public synchronized void clearInputConnections() {
        super.clearInputConnections();
        this.sources.clear();
    }

    @Override
    public synchronized void removeAllConnections(UGen sourceUGen) {
        super.removeAllConnections(sourceUGen);
        this.removeSource(sourceUGen);
    }

    public void setCurve(float curve) {
        this.curve = curve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateBuffer() {
        Map<UGen, Location> map = this.sources;
        synchronized (map) {
            for (UGen source : this.sources.keySet()) {
                Location location = this.sources.get(source);
                location.mixInAudio(this.bufOut);
                if (!source.isDeleted()) continue;
                this.deadSources.add(source);
            }
            for (UGen source : this.deadSources) {
                this.sources.remove(source);
            }
            this.deadSources.clear();
        }
    }

    @Override
    public synchronized int getNumberOfConnectedUGens(int index) {
        return this.sources.size();
    }

    public synchronized int getNumberOfSources() {
        return this.sources.size();
    }

    private class Location {
        UGen source;
        UGen[][] pos;
        boolean ownsPosition;

        Location(UGen source) {
            this.source = source;
            this.pos = new UGen[source.getOuts()][Spatial.this.dimensions];
            for (int i = 0; i < this.pos.length; ++i) {
                for (int j = 0; j < Spatial.this.dimensions; ++j) {
                    this.pos[i][j] = new Glide(Spatial.this.context, 100.0f, 5.0f);
                }
            }
            this.ownsPosition = true;
        }

        Location(UGen source, UGen[][] controllers) {
            this.source = source;
            this.pos = controllers;
            this.ownsPosition = false;
        }

        void move(int channel, float[] newPos) {
            if (!this.ownsPosition) {
                return;
            }
            for (int i = 0; i < this.pos[channel].length; ++i) {
                this.pos[channel][i].setValue(newPos[i]);
            }
        }

        void moveImmediately(int channel, float[] newPos) {
            if (!this.ownsPosition) {
                return;
            }
            for (int i = 0; i < this.pos[channel].length; ++i) {
                ((Glide)this.pos[channel][i]).setValueImmediately(newPos[i]);
            }
        }

        void mixInAudio(float[][] output) {
            this.source.update();
            for (int outputChannel = 0; outputChannel < this.pos.length; ++outputChannel) {
                for (int dim = 0; dim < Spatial.this.dimensions; ++dim) {
                    this.pos[outputChannel][dim].update();
                }
                for (int time = 0; time < Spatial.this.bufferSize; ++time) {
                    int speaker;
                    float[] currentPos = new float[Spatial.this.dimensions];
                    for (int dim = 0; dim < Spatial.this.dimensions; ++dim) {
                        currentPos[dim] = this.pos[outputChannel][dim].getValue(0, time);
                    }
                    float[] speakerGains = new float[Spatial.this.speakerPositions.length];
                    for (speaker = 0; speaker < Spatial.this.speakerPositions.length; ++speaker) {
                        float linearGain;
                        float distance = Spatial.distance(Spatial.this.speakerPositions[speaker], currentPos);
                        speakerGains[speaker] = linearGain = Math.max(0.0f, 1.0f - distance / Spatial.this.sphereDiameter);
                    }
                    for (speaker = 0; speaker < Spatial.this.speakerPositions.length; ++speaker) {
                        float[] fArray = output[speaker];
                        int n = time;
                        fArray[n] = fArray[n] + speakerGains[speaker] * this.source.getValue(outputChannel, time);
                    }
                }
            }
        }
    }
}

