/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.Arrays;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class TapIn
extends UGen {
    private float[] mem;
    private int memLength;
    private int maxDelay;
    private int counter;
    private float sampsPerMS;

    public TapIn(AudioContext ac, float maxDelayInMS) {
        super(ac, 1, 0);
        this.sampsPerMS = (float)ac.msToSamples(1.0);
        this.maxDelay = (int)ac.msToSamples(maxDelayInMS) + 1;
        if (this.maxDelay < this.bufferSize) {
            this.maxDelay = this.bufferSize;
        }
        this.memLength = this.maxDelay + 1;
        this.mem = new float[this.memLength];
        Arrays.fill(this.mem, 0.0f);
        this.counter = 0;
    }

    @Override
    public void calculateBuffer() {
        float[] bi = this.bufIn[0];
        for (int i = 0; i < this.bufferSize; ++i) {
            this.mem[this.counter] = bi[i];
            this.counter = (this.counter + 1) % this.memLength;
        }
    }

    public void fillBufferLinear(float[] buf, UGen env) {
        int base = (this.counter - this.bufferSize + this.memLength) % this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            float f;
            float numSamplesBack = env.getValue(0, i) * this.sampsPerMS;
            if (f < 0.0f) {
                numSamplesBack = 0.0f;
            } else if (numSamplesBack > (float)this.maxDelay) {
                numSamplesBack = this.maxDelay;
            }
            float frac = numSamplesBack % 1.0f;
            int d1 = (base + i - (int)numSamplesBack - 1 + this.memLength) % this.memLength;
            int d2 = (d1 + 1) % this.memLength;
            buf[i] = this.mem[d1] * frac + this.mem[d2] * (1.0f - frac);
        }
    }

    public void fillBufferLinear(float[] buf, float numSamplesBack) {
        if (numSamplesBack < 0.0f) {
            numSamplesBack = 0.0f;
        } else if (numSamplesBack > (float)this.maxDelay) {
            numSamplesBack = this.maxDelay;
        }
        float frac = numSamplesBack % 1.0f;
        int base = this.counter - this.bufferSize - (int)numSamplesBack - 1 + this.memLength + this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            int d1 = (base + i) % this.memLength;
            buf[i] = this.mem[d1] * frac + this.mem[(d1 + 1) % this.memLength] * (1.0f - frac);
        }
    }

    public void fillBufferNoInterp(float[] buf, UGen env) {
        int base = this.counter - this.bufferSize + this.memLength + this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            int numSamplesBack = (int)((double)(env.getValue(0, i) * this.sampsPerMS) + 0.5);
            if (numSamplesBack < 0) {
                numSamplesBack = 0;
            } else if (numSamplesBack > this.maxDelay) {
                numSamplesBack = this.maxDelay;
            }
            buf[i] = this.mem[(base + i - numSamplesBack) % this.memLength];
        }
    }

    public void fillBufferNoInterp(float[] buf, int numSamplesBack) {
        if (numSamplesBack < 0) {
            numSamplesBack = 0;
        } else if (numSamplesBack > this.maxDelay) {
            numSamplesBack = this.maxDelay;
        }
        int base = this.counter - this.bufferSize - numSamplesBack + this.memLength + this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.mem[(base + i) % this.memLength];
        }
    }

    public float fillBufferAllpass(float[] buf, UGen env, float lastY) {
        int base = this.counter - this.bufferSize + this.memLength + this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            float f;
            float numSamplesBack = env.getValue(0, i) * this.sampsPerMS;
            if (f < 0.0f) {
                numSamplesBack = 0.0f;
            } else if (numSamplesBack > (float)this.maxDelay) {
                numSamplesBack = this.maxDelay;
            }
            float frac = numSamplesBack % 1.0f;
            float g = (1.0f - frac) / (1.0f + frac);
            int d1 = (base + i - (int)numSamplesBack - 1 + this.memLength) % this.memLength;
            buf[i] = lastY = this.mem[d1] + g * (this.mem[(d1 + 1) % this.memLength] - lastY);
        }
        return lastY;
    }

    public float fillBufferAllpass(float[] buf, int sampDel, float g, float lastY) {
        if (sampDel < 0) {
            sampDel = 0;
        } else if (sampDel > this.maxDelay) {
            sampDel = this.maxDelay;
        }
        int base = this.counter - this.bufferSize - sampDel - 1 + this.memLength + this.memLength;
        for (int i = 0; i < buf.length; ++i) {
            int d1 = (base + i) % this.memLength;
            buf[i] = lastY = this.mem[d1] + g * (this.mem[(d1 + 1) % this.memLength] - lastY);
        }
        return lastY;
    }
}

