/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.TapIn;

public class TapOut
extends UGen {
    private TapIn ti;
    private UGen delayUGen;
    private float delay;
    private float sampsPerMS;
    private InterpolationType mode;
    private int sampDelayInt;
    private int sampDelayAPInt;
    private float lastY = 0.0f;
    private float sampDelayFloat;
    private float g;
    public static final InterpolationType NO_INTERP = InterpolationType.NO_INTERP;
    public static final InterpolationType LINEAR = InterpolationType.LINEAR;
    public static final InterpolationType ALLPASS = InterpolationType.ALLPASS;

    protected TapOut(AudioContext ac, TapIn ti) {
        super(ac, 0, 1);
        this.sampsPerMS = (float)ac.msToSamples(1.0);
        this.ti = ti;
        this.addDependent(ti);
        this.setMode(NO_INTERP);
    }

    public TapOut(AudioContext ac, TapIn ti, float delay) {
        this(ac, ti);
        this.setDelay(delay);
    }

    public TapOut(AudioContext ac, TapIn ti, UGen delayUGen) {
        this(ac, ti);
        this.setDelay(delayUGen);
    }

    public TapOut(AudioContext ac, TapIn ti, InterpolationType mode, float delay) {
        this(ac, ti);
        this.setDelay(delay).setMode(mode);
    }

    public TapOut(AudioContext ac, TapIn ti, InterpolationType mode, UGen delayUGen) {
        this(ac, ti);
        this.setDelay(this.delay).setMode(mode);
    }

    @Override
    public void calculateBuffer() {
        if (this.delayUGen == null) {
            switch (this.mode) {
                case NO_INTERP: {
                    this.ti.fillBufferNoInterp(this.bufOut[0], this.sampDelayInt);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case LINEAR: {
                    this.ti.fillBufferLinear(this.bufOut[0], this.sampDelayFloat);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case ALLPASS: {
                    this.lastY = this.ti.fillBufferAllpass(this.bufOut[0], this.sampDelayAPInt, this.g, this.lastY);
                }
            }
        } else {
            this.delayUGen.update();
            switch (this.mode) {
                case NO_INTERP: {
                    this.ti.fillBufferNoInterp(this.bufOut[0], this.delayUGen);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case LINEAR: {
                    this.ti.fillBufferLinear(this.bufOut[0], this.delayUGen);
                    this.lastY = this.bufOut[0][this.bufferSize - 1];
                    break;
                }
                case ALLPASS: {
                    this.lastY = this.ti.fillBufferAllpass(this.bufOut[0], this.delayUGen, this.lastY);
                }
            }
        }
    }

    public float getDelay() {
        return this.delay;
    }

    public TapOut setDelay(float delay) {
        this.delay = delay;
        this.sampDelayFloat = this.sampsPerMS * delay;
        this.sampDelayInt = (int)((double)this.sampDelayFloat + 0.5);
        this.sampDelayAPInt = (int)this.sampDelayFloat;
        float frac = this.sampDelayFloat % 1.0f;
        this.g = (1.0f - frac) / (1.0f + frac);
        this.delayUGen = null;
        return this;
    }

    public TapOut setDelay(UGen delayUGen) {
        if (delayUGen == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = delayUGen;
            delayUGen.update();
            this.delay = delayUGen.getValue();
        }
        return this;
    }

    public UGen getDelayUGen() {
        return this.delayUGen;
    }

    public TapOut setMode(InterpolationType mode) {
        switch (mode) {
            case NO_INTERP: {
                this.mode = mode;
                break;
            }
            case LINEAR: {
                this.mode = mode;
                break;
            }
            case ALLPASS: {
                this.mode = mode;
            }
        }
        return this;
    }

    public InterpolationType getMode() {
        return this.mode;
    }

    public static enum InterpolationType {
        NO_INTERP,
        LINEAR,
        ALLPASS;

    }
}

