/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class TrapezoidWave
extends UGen {
    protected float index;
    protected float a;
    protected float b;
    protected float c;
    protected float abSlope;
    protected float cdSlope;
    protected float freq;
    protected float dutyCycle = 0.5f;
    protected float attack = 0.0f;
    protected float decay = 0.0f;
    protected float delta;
    protected float iSampleRate;
    protected UGen freqUGen;
    protected UGen dutyCycleUGen;
    protected UGen attackUGen;
    protected UGen decayUGen;

    public TrapezoidWave(AudioContext con) {
        super(con, 0, 1);
        this.iSampleRate = 1.0f / con.getSampleRate();
        this.calcVals();
    }

    @Override
    public void calculateBuffer() {
        float[] bo = this.bufOut[0];
        if (this.freqUGen != null) {
            this.freqUGen.update();
        }
        if (this.dutyCycleUGen != null) {
            this.dutyCycleUGen.update();
        }
        if (this.attackUGen != null) {
            this.attackUGen.update();
        }
        if (this.decayUGen != null) {
            this.decayUGen.update();
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            boolean doCalc = false;
            if (this.dutyCycleUGen != null) {
                this.dutyCycle = this.dutyCycleUGen.getValue(0, i);
                if (this.dutyCycle < 0.0f) {
                    this.dutyCycle = 0.0f;
                } else if (this.dutyCycle > 1.0f) {
                    this.dutyCycle = 1.0f;
                }
                doCalc = true;
            }
            if (this.attackUGen != null) {
                this.attack = this.attackUGen.getValue(0, i);
                if (this.attack < 0.0f) {
                    this.attack = 0.0f;
                } else if (this.attack > 1.0f) {
                    this.attack = 1.0f;
                }
                doCalc = true;
            }
            if (this.decayUGen != null) {
                this.decay = this.decayUGen.getValue(0, i);
                if (this.decay < 0.0f) {
                    this.decay = 0.0f;
                } else if (this.decay > 1.0f) {
                    this.decay = 1.0f;
                }
                doCalc = true;
            }
            if (doCalc) {
                this.calcVals();
            }
            if (this.freqUGen != null) {
                this.freq = this.freqUGen.getValue(0, i);
                this.delta = this.freq * this.iSampleRate;
            }
            this.index = (this.index + this.delta) % 1.0f;
            if (this.index < 0.0f) {
                this.index = (this.index + 1.0f) % 1.0f;
            }
            bo[i] = this.index > this.c ? 1.0f - this.cdSlope * (this.index - this.c) : (this.index > this.b ? 1.0f : (this.index > this.a ? -1.0f + this.abSlope * (this.index - this.a) : -1.0f));
        }
    }

    protected void calcVals() {
        this.a = 1.0f - this.dutyCycle;
        if (this.a >= 1.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
            this.abSlope = 0.0f;
            this.cdSlope = 0.0f;
        } else {
            float dec;
            float att;
            float m = this.attack + this.decay;
            if (m > 0.0f) {
                m = (double)this.dutyCycle < 0.5 ? this.dutyCycle / m : (1.0f - this.dutyCycle) / m;
                if ((double)m >= 0.5) {
                    att = this.attack;
                    dec = this.decay;
                } else {
                    att = this.attack * 2.0f * m;
                    dec = this.decay * 2.0f * m;
                }
            } else {
                att = 0.0f;
                dec = 0.0f;
            }
            this.c = 1.0f - dec;
            this.b = this.c - this.dutyCycle + (att + dec) * 0.5f;
            this.a = this.b - att;
            this.abSlope = this.a == this.b ? 0.0f : 2.0f / (this.b - this.a);
            this.cdSlope = this.c == 1.0f ? 0.0f : 2.0f / (1.0f - this.c);
        }
    }

    public TrapezoidWave setFrequency(float freq) {
        this.freq = freq;
        this.freqUGen = null;
        this.delta = freq * this.iSampleRate;
        return this;
    }

    public TrapezoidWave setFrequency(UGen freqUGen) {
        if (freqUGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = freqUGen;
            freqUGen.update();
            this.freq = freqUGen.getValue();
        }
        return this;
    }

    public float getFrequency() {
        return this.freq;
    }

    public UGen getFrequencyUGen() {
        return this.freqUGen;
    }

    public TrapezoidWave setDutyCycle(UGen dutyCycleUGen) {
        if (dutyCycleUGen == null) {
            this.setDutyCycle(this.dutyCycle);
        } else {
            this.dutyCycleUGen = dutyCycleUGen;
            dutyCycleUGen.update();
            this.dutyCycle = dutyCycleUGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setDutyCycle(float dutyCycle) {
        this.dutyCycleUGen = null;
        this.dutyCycle = dutyCycle;
        if (this.dutyCycle < 0.0f) {
            this.dutyCycle = 0.0f;
        } else if (this.dutyCycle > 1.0f) {
            this.dutyCycle = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getDutyCycle() {
        return this.dutyCycle;
    }

    public UGen getDutyCycleUGen() {
        return this.dutyCycleUGen;
    }

    public TrapezoidWave setAttack(UGen attackUGen) {
        if (attackUGen == null) {
            this.setAttack(this.attack);
        } else {
            this.attackUGen = attackUGen;
            attackUGen.update();
            this.attack = attackUGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setAttack(float attack) {
        this.attackUGen = null;
        this.attack = attack;
        if (this.attack < 0.0f) {
            this.attack = 0.0f;
        } else if (this.attack > 1.0f) {
            this.attack = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getAttack() {
        return this.attack;
    }

    public UGen getAttackUGen() {
        return this.attackUGen;
    }

    public TrapezoidWave setDecay(UGen decayUGen) {
        if (decayUGen == null) {
            this.setDecay(this.decay);
        } else {
            this.decayUGen = decayUGen;
            decayUGen.update();
            this.decay = decayUGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setDecay(float decay) {
        this.decayUGen = null;
        this.decay = decay;
        if (decay < 0.0f) {
            this.decay = 0.0f;
        } else if (decay > 1.0f) {
            this.decay = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getDecay() {
        return this.decay;
    }

    public UGen getDecayUGen() {
        return this.decayUGen;
    }
}

