/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.Static;

public class WaveShaper
extends UGen
implements DataBeadReceiver {
    protected float preGain = 2.0f;
    protected float postGain = 1.0f;
    protected float limit = 1.0f;
    protected float wetMix = 1.0f;
    protected UGen preGainUGen;
    protected UGen postGainUGen;
    protected UGen limitUGen;
    protected UGen wetMixUGen;
    protected boolean isPreGainStatic = false;
    protected boolean isPostGainStatic = false;
    protected boolean isLimitStatic = false;
    protected boolean isWetMixStatic = false;
    protected float[] shape;
    protected int shapeLen;
    protected int channels = 1;

    public WaveShaper(AudioContext context) {
        this(context, 1);
    }

    public WaveShaper(AudioContext context, int channels) {
        super(context, channels, channels);
        this.channels = channels;
        this.setPreGain(2.0f).setPostGain(1.0f).setLimit(1.0f).setWetMix(1.0f);
        this.setShape(WaveShaper.generateCosineShape(1025));
    }

    public WaveShaper(AudioContext context, float[] shape) {
        this(context);
        this.setShape(shape);
    }

    public WaveShaper(AudioContext context, int channels, float[] shape) {
        this(context, channels);
        this.setShape(shape);
    }

    public WaveShaper(AudioContext context, Buffer shapeBuffer) {
        this(context);
        this.setShape(shapeBuffer.buf);
    }

    public WaveShaper(AudioContext context, int channels, Buffer shapeBuffer) {
        this(context, channels);
        this.setShape(shapeBuffer.buf);
    }

    public static float[] generateCosineShape(int length) {
        float[] ret = new float[length];
        int l = length - 1;
        for (int i = 1; i < length - 1; ++i) {
            ret[i] = 0.0f - (float)Math.cos((double)i * Math.PI / (double)l);
        }
        ret[0] = -1.0f;
        ret[length - 1] = 1.0f;
        if (length % 2 == 1) {
            ret[l / 2] = 0.0f;
        }
        return ret;
    }

    public static float[] generateExponentialShape(int length, float exponent) {
        float[] ret = new float[length];
        int l = length - 1;
        for (int i = 1; i < length - 1; ++i) {
            float x = i / l * 2 - 1;
            ret[i] = x < 0.0f ? (float)(-Math.pow(-x, exponent)) : (x == 0.0f ? 0.0f : (float)Math.pow(x, exponent));
        }
        ret[0] = -1.0f;
        ret[length - 1] = 1.0f;
        if (length % 2 == 1) {
            ret[l / 2] = 0.0f;
        }
        return ret;
    }

    @Override
    public void calculateBuffer() {
        this.preGainUGen.update();
        this.postGainUGen.update();
        this.limitUGen.update();
        this.wetMixUGen.update();
        if (this.channels == 1) {
            float[] bi = this.bufIn[0];
            float[] bo = this.bufOut[0];
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                float y2;
                this.preGain = this.preGainUGen.getValue(0, currsample);
                this.postGain = this.postGainUGen.getValue(0, currsample);
                this.limit = this.limitUGen.getValue(0, currsample);
                if (this.limit < 0.0f) {
                    this.limit = 0.0f;
                }
                this.wetMix = this.wetMixUGen.getValue(0, currsample);
                float y = bi[currsample];
                float y1 = (y * this.preGain * 0.5f + 0.5f) * (float)this.shapeLen;
                if (y1 <= 0.0f) {
                    y2 = this.shape[0] * this.postGain;
                } else if (y1 >= (float)this.shapeLen) {
                    y2 = this.shape[this.shapeLen] * this.postGain;
                } else {
                    int ind = (int)y1;
                    float frac = y1 - (float)ind;
                    y2 = (this.shape[ind] * (1.0f - frac) + this.shape[ind + 1] * frac) * this.postGain;
                }
                if (y2 > this.limit) {
                    y2 = this.limit;
                } else if (y2 < -this.limit) {
                    y2 = -this.limit;
                }
                bo[currsample] = y * (1.0f - this.wetMix) + y2 * this.wetMix;
            }
        } else {
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                this.preGain = this.preGainUGen.getValue(0, currsample);
                this.postGain = this.postGainUGen.getValue(0, currsample);
                this.limit = this.limitUGen.getValue(0, currsample);
                if (this.limit < 0.0f) {
                    this.limit = 0.0f;
                }
                this.wetMix = this.wetMixUGen.getValue(0, currsample);
                for (int currchannel = 0; currchannel < this.channels; ++currchannel) {
                    float y2;
                    float y = this.bufIn[currchannel][currsample];
                    float y1 = (y * this.preGain * 0.5f + 0.5f) * (float)this.shapeLen;
                    if (y1 <= 0.0f) {
                        y2 = this.shape[0] * this.postGain;
                    } else if (y1 >= (float)this.shapeLen) {
                        y2 = this.shape[this.shapeLen] * this.postGain;
                    } else {
                        int ind = (int)y1;
                        float frac = y1 - (float)ind;
                        y2 = (this.shape[ind] * (1.0f - frac) + this.shape[ind + 1] * frac) * this.postGain;
                    }
                    if (y2 > this.limit) {
                        y2 = this.limit;
                    } else if (y2 < -this.limit) {
                        y2 = -this.limit;
                    }
                    this.bufOut[currchannel][currsample] = y * (1.0f - this.wetMix) + y2 * this.wetMix;
                }
            }
        }
    }

    public float getPreGain() {
        return this.preGain;
    }

    public WaveShaper setPreGain(float preGain) {
        this.preGain = preGain;
        if (this.isPreGainStatic) {
            this.preGainUGen.setValue(preGain);
        } else {
            this.preGainUGen = new Static(this.context, preGain);
            this.isPreGainStatic = true;
        }
        return this;
    }

    public WaveShaper setPreGain(UGen preGainUGen) {
        if (preGainUGen == null) {
            this.setPreGain(this.preGain);
        } else {
            this.preGainUGen = preGainUGen;
            preGainUGen.update();
            this.preGain = preGainUGen.getValue();
            this.isPreGainStatic = false;
        }
        return this;
    }

    public UGen getPreGainUGen() {
        if (this.isPreGainStatic) {
            return null;
        }
        return this.preGainUGen;
    }

    public float getPostGain() {
        return this.postGain;
    }

    public WaveShaper setPostGain(float postGain) {
        this.postGain = postGain;
        if (this.isPostGainStatic) {
            this.postGainUGen.setValue(postGain);
        } else {
            this.postGainUGen = new Static(this.context, postGain);
            this.isPostGainStatic = true;
        }
        return this;
    }

    public WaveShaper setPostGain(UGen postGainUGen) {
        if (postGainUGen == null) {
            this.setPostGain(this.postGain);
        } else {
            this.postGainUGen = postGainUGen;
            postGainUGen.update();
            this.postGain = postGainUGen.getValue();
            this.isPostGainStatic = false;
        }
        return this;
    }

    public UGen getPostGainUGen() {
        if (this.isPostGainStatic) {
            return null;
        }
        return this.postGainUGen;
    }

    public float getLimit() {
        return this.limit;
    }

    public WaveShaper setLimit(float limit) {
        if (limit < 0.0f) {
            limit = 0.0f;
        }
        this.limit = limit;
        if (this.isLimitStatic) {
            this.limitUGen.setValue(limit);
        } else {
            this.limitUGen = new Static(this.context, limit);
            this.isLimitStatic = true;
        }
        return this;
    }

    public WaveShaper setLimit(UGen limitUGen) {
        if (limitUGen == null) {
            this.setLimit(this.limit);
        } else {
            this.limitUGen = limitUGen;
            limitUGen.update();
            this.limit = limitUGen.getValue();
            this.isLimitStatic = false;
        }
        return this;
    }

    public UGen getLimitUGen() {
        if (this.isLimitStatic) {
            return null;
        }
        return this.limitUGen;
    }

    public float getWetMix() {
        return this.wetMix;
    }

    public WaveShaper setWetMix(float wetMix) {
        this.wetMix = wetMix;
        if (this.isWetMixStatic) {
            this.wetMixUGen.setValue(wetMix);
        } else {
            this.wetMixUGen = new Static(this.context, wetMix);
            this.isWetMixStatic = true;
        }
        return this;
    }

    public WaveShaper setWetMix(UGen wetMixUGen) {
        if (wetMixUGen == null) {
            this.setWetMix(this.wetMix);
        } else {
            this.wetMixUGen = wetMixUGen;
            wetMixUGen.update();
            this.wetMix = wetMixUGen.getValue();
            this.isWetMixStatic = false;
        }
        return this;
    }

    public UGen getWetMixUGen() {
        if (this.isWetMixStatic) {
            return null;
        }
        return this.wetMixUGen;
    }

    public float[] getShape() {
        return this.shape;
    }

    public WaveShaper setShape(float[] shape) {
        if (shape != null && shape.length > 1) {
            this.shape = shape;
            this.shapeLen = shape.length - 1;
        }
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            UGen u = db.getUGen("preGain");
            if (u != null) {
                this.setPreGain(u);
            } else {
                this.setPreGain(db.getFloat("preGain", this.preGain));
            }
            u = db.getUGen("postGain");
            if (u != null) {
                this.setPostGain(u);
            } else {
                this.setPostGain(db.getFloat("postGain", this.postGain));
            }
            u = db.getUGen("limit");
            if (u != null) {
                this.setLimit(u);
            } else {
                this.setLimit(db.getFloat("limit", this.limit));
            }
            u = db.getUGen("wetMix");
            if (u != null) {
                this.setWetMix(u);
            } else {
                this.setWetMix(db.getFloat("wetMix", this.wetMix));
            }
            this.setShape(db.getFloatArray("shape"));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isPreGainStatic) {
            db.put("preGain", (Object)Float.valueOf(this.preGain));
        } else {
            db.put("preGain", (Object)this.preGainUGen);
        }
        if (this.isPostGainStatic) {
            db.put("postGain", (Object)Float.valueOf(this.postGain));
        } else {
            db.put("postGain", (Object)this.postGainUGen);
        }
        if (this.isLimitStatic) {
            db.put("limit", (Object)Float.valueOf(this.limit));
        } else {
            db.put("limit", (Object)this.limitUGen);
        }
        if (this.isWetMixStatic) {
            db.put("wetMix", (Object)Float.valueOf(this.wetMix));
        } else {
            db.put("wetMix", (Object)this.wetMixUGen);
        }
        db.put("shape", (Object)this.shape);
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("preGain", (Object)Float.valueOf(this.preGain));
        db.put("postGain", (Object)Float.valueOf(this.postGain));
        db.put("limit", (Object)Float.valueOf(this.limit));
        db.put("wetMix", (Object)Float.valueOf(this.wetMix));
        db.put("shape", (Object)this.shape);
        return db;
    }
}

