/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class ZMap
extends UGen
implements DataBeadReceiver {
    private int channels;
    private float a = 1.0f;
    private float b = 0.0f;
    private float o1 = 0.0f;
    private float o2 = 1.0f;
    private float n1 = 0.0f;
    private float n2 = 1.0f;
    private boolean clip = false;
    private boolean flipped = false;

    public ZMap(AudioContext context) {
        this(context, 1);
    }

    public ZMap(AudioContext context, int channels) {
        super(context, channels, channels);
        this.channels = channels;
        this.clear();
    }

    @Override
    public void calculateBuffer() {
        for (int j = 0; j < this.channels; ++j) {
            float[] bi = this.bufIn[j];
            float[] bo = this.bufOut[j];
            if (this.clip) {
                int i;
                if (this.flipped) {
                    for (i = 0; i < this.bufferSize; ++i) {
                        float y = bi[i];
                        if (y < this.o2) {
                            y = this.o2;
                        } else if (y > this.o1) {
                            y = this.o1;
                        }
                        bo[i] = this.a * y + this.b;
                    }
                    continue;
                }
                for (i = 0; i < this.bufferSize; ++i) {
                    float y = bi[i];
                    if (y > this.o2) {
                        y = this.o2;
                        continue;
                    }
                    if (!(y < this.o1)) continue;
                    y = this.o1;
                    bo[i] = this.a * y + this.b;
                }
                continue;
            }
            for (int i = 0; i < this.bufferSize; ++i) {
                bo[i] = this.a * bi[i] + this.b;
            }
        }
    }

    public float getSourceMinimum() {
        return this.o1;
    }

    public ZMap setSourceMinimum(float sourceMin) {
        if (sourceMin == this.o2) {
            this.o2 = sourceMin + 1.0E-10f;
        }
        return this.setRanges(sourceMin, this.o2, this.n1, this.n2);
    }

    public float getSourceMaximum() {
        return this.o2;
    }

    public ZMap setSourceMaximun(float sourceMax) {
        return this.setRanges(this.o1, sourceMax, this.n1, this.n2);
    }

    public float getTargetMinimum() {
        return this.n1;
    }

    public ZMap setTargetMinimum(float targetMin) {
        return this.setRanges(this.o1, this.o2, targetMin, this.n2);
    }

    public float getTargetMaximum() {
        return this.n2;
    }

    public ZMap setTargetMaximum(float targetMax) {
        return this.setRanges(this.o1, this.o2, this.n1, targetMax);
    }

    public ZMap setRanges(float sourceMin, float sourceMax, float targetMin, float targetMax) {
        if (sourceMin == sourceMax) {
            sourceMin = sourceMax - 1.0E-10f;
        }
        this.o1 = sourceMin;
        this.o2 = sourceMax;
        this.n1 = targetMin;
        this.n2 = targetMax;
        this.flipped = this.o1 > this.o2;
        this.a = (targetMax - targetMin) / (sourceMin - sourceMax);
        this.b = targetMin - this.a * sourceMin;
        return this;
    }

    public ZMap clear() {
        this.o1 = 0.0f;
        this.o2 = 1.0f;
        this.n1 = 0.0f;
        this.n2 = 1.0f;
        this.a = 1.0f;
        this.b = 0.0f;
        this.flipped = false;
        this.clip = false;
        return this;
    }

    public ZMap multiplyThenAdd(float multiplier, float shift) {
        this.a = multiplier;
        this.b = shift;
        this.n1 = this.a * this.o1 + this.b;
        this.n2 = this.a * this.o2 + this.b;
        return this;
    }

    public ZMap addThenMultiply(float preshift, float multiplier) {
        return this.multiplyThenAdd(multiplier, multiplier * preshift);
    }

    public float getMultiplier() {
        return this.a;
    }

    public ZMap setMultiplier(float multiplier) {
        return this.multiplyThenAdd(multiplier, this.b);
    }

    public float getShift() {
        return this.b;
    }

    public ZMap setShift(float shift) {
        return this.multiplyThenAdd(this.a, shift);
    }

    public boolean getClipping() {
        return this.clip;
    }

    public ZMap setClipping(boolean clip) {
        this.clip = clip;
        return this;
    }

    public int getChannels() {
        return this.channels;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            this.setRanges(db.getFloat("sourceMinimum", this.o1), db.getFloat("sourceMaximum", this.o2), db.getFloat("targetMinimum", this.n1), db.getFloat("targetMaximum", this.n2));
            this.multiplyThenAdd(db.getFloat("multiplier", this.a), db.getFloat("shift", this.b));
            Object o = db.get("clipping");
            if (o instanceof Boolean) {
                this.setClipping((Boolean)o);
            }
        }
        return this;
    }

    public DataBead getParams() {
        return this.getStaticParams();
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("sourceMinimum", (Object)Float.valueOf(this.o1));
        db.put("sourceMaximum", (Object)Float.valueOf(this.o2));
        db.put("targetMinimum", (Object)Float.valueOf(this.n1));
        db.put("targetMaximum", (Object)Float.valueOf(this.n2));
        db.put("multiplier", (Object)Float.valueOf(this.a));
        db.put("shift", (Object)Float.valueOf(this.b));
        db.put("clipping", (Object)this.clip);
        return db;
    }
}

