/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.beads;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioIO;
import net.beadsproject.beads.core.UGen;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.jack.JackAudioServer;
import org.jaudiolibs.audioservers.javasound.JavasoundAudioServer;

public abstract class AudioServerIO
extends AudioIO
implements AudioClient {
    protected AudioServer server;
    protected AudioConfiguration config;
    private List<FloatBuffer> inputs;

    @Override
    protected UGen getAudioInput(int[] channels) {
        return new RTInput(this.context, channels);
    }

    @Override
    public void configure(AudioConfiguration ac) throws Exception {
        if (this.config.getSampleRate() != ac.getSampleRate() || this.config.getInputChannelCount() != ac.getInputChannelCount() || this.config.getOutputChannelCount() != ac.getOutputChannelCount() || this.config.getMaxBufferSize() != ac.getMaxBufferSize() || !ac.isFixedBufferSize()) {
            System.out.println("Unexpected audio configuration");
            throw new IllegalArgumentException("Unexpected audio configuration");
        }
    }

    protected boolean runThread() {
        Thread audioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioServerIO.this.server.run();
                }
                catch (Exception ex) {
                    Logger.getLogger(AudioServerIO.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }, "audio");
        audioThread.setPriority(10);
        audioThread.start();
        return true;
    }

    @Override
    public boolean process(long time, List<FloatBuffer> inputs, List<FloatBuffer> outputs, int nFrames) {
        if (!this.context.isRunning()) {
            return false;
        }
        this.inputs = inputs;
        this.update();
        for (int i = 0; i < outputs.size(); ++i) {
            outputs.get(i).put(this.context.out.getOutBuffer(i));
        }
        this.inputs = null;
        return true;
    }

    @Override
    public void shutdown() {
    }

    public static class JavaSound
    extends AudioServerIO {
        String device = null;

        public JavaSound() {
        }

        public JavaSound(String device) {
            this.device = device;
        }

        @Override
        protected boolean start() {
            System.out.println("Starting JavaSound implementation of AudioServerIO");
            this.config = new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), true);
            try {
                this.server = JavasoundAudioServer.create(this.device, this.config, JavasoundAudioServer.TimingMode.FramePosition, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.runThread();
        }
    }

    public static class Jack
    extends AudioServerIO {
        private String name = "Beads";

        public Jack() {
        }

        public Jack(String name) {
            this.name = name;
        }

        @Override
        protected boolean start() {
            System.out.println("Starting Jack implementation of AudioServerIO");
            this.config = new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), true);
            this.server = JackAudioServer.create(this.name, this.config, true, this);
            return this.runThread();
        }
    }

    private class RTInput
    extends UGen {
        private int[] channels;

        RTInput(AudioContext context, int[] channels) {
            super(context, channels.length);
            this.channels = channels;
        }

        @Override
        public void calculateBuffer() {
            for (int i = 0; i < this.channels.length; ++i) {
                ((FloatBuffer)AudioServerIO.this.inputs.get(this.channels[i] - 1)).get(this.bufOut[i]);
            }
        }
    }
}

