/*
 * Decompiled with CFR 0.152.
 */
package org.musicalmetacreation.musebot.tools;

import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Scanner;

public class MusebotAssistant
implements OSCListener {
    OSCServer server;
    InetSocketAddress controllerAddress;
    String clientID;
    long lastHeartbeat = System.currentTimeMillis();
    boolean alive = true;
    boolean printMessage = false;
    Responder theResponder;

    public MusebotAssistant() {
        try {
            Scanner scanner = new Scanner(new File("config.txt"));
            String conductorHostname = "";
            int conductorListenPort = 0;
            int myListenPort = 0;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split("[ ]");
                if (parts[0].equals("mc_hostname")) {
                    conductorHostname = parts[1];
                    continue;
                }
                if (parts[0].equals("mc_listen_port")) {
                    conductorListenPort = Integer.parseInt(parts[1]);
                    continue;
                }
                if (parts[0].equals("my_listen_port")) {
                    myListenPort = Integer.parseInt(parts[1]);
                    continue;
                }
                if (!parts[0].equals("id")) continue;
                this.clientID = parts[1].trim();
            }
            scanner.close();
            if (this.clientID == null) {
                throw new IOException("No id parameter in config file.");
            }
            this.server = OSCServer.newUsing("udp", myListenPort);
            this.server.addOSCListener(this);
            this.server.start();
            this.controllerAddress = new InetSocketAddress(conductorHostname, conductorListenPort);
            System.out.println("Musebot config: conductor=" + conductorHostname + "," + conductorListenPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Since you don't have the config file you're not allowed to continue.");
            System.err.println("It's for your own good. Goodbye!");
            System.exit(0);
        }
        new Thread(){

            @Override
            public void run() {
                while (MusebotAssistant.this.alive) {
                    MusebotAssistant.this.send("/agent/alive", MusebotAssistant.this.clientID);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MusebotAssistant.this.alive) {
                    long currentTime = System.currentTimeMillis();
                    long diff = 0L;
                    MusebotAssistant musebotAssistant = MusebotAssistant.this;
                    synchronized (musebotAssistant) {
                        diff = currentTime - MusebotAssistant.this.lastHeartbeat;
                    }
                    if (diff > 30000L) {
                        System.out.println("Haven't heard from the MC so the kill message is being sent. (Time=" + currentTime + ", lastHeartbeat=" + MusebotAssistant.this.lastHeartbeat + ", diff=" + diff + ").");
                        MusebotAssistant.this.alive = false;
                        MusebotAssistant.this.theResponder.kill();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void send(String msgName, Object ... args) {
        try {
            this.server.send(new OSCMessage(msgName, args), this.controllerAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void respondWith(Responder responder) {
        this.theResponder = responder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(OSCMessage msg, SocketAddress source, long timetag) {
        if (this.printMessage && !msg.getName().equals("/mc/time")) {
            StringBuffer fullMessage = new StringBuffer(msg.getName() + ":");
            for (int i = 0; i < msg.getArgCount(); ++i) {
                fullMessage.append(" " + msg.getArg(i).toString());
            }
            System.out.println(fullMessage);
        }
        if (msg.getName().equals("/agent/off")) {
            if (this.theResponder != null) {
                this.theResponder.kill();
            }
        } else if (msg.getName().equals("/agent/gain")) {
            float gain = ((Float)msg.getArg(0)).floatValue();
            float time = 10.0f;
            if (msg.getArgCount() == 2) {
                time = ((Float)msg.getArg(1)).floatValue();
            }
            if (this.theResponder != null) {
                this.theResponder.gain(gain, time);
            }
        } else if (msg.getName().equals("/mc/time")) {
            float tempo = ((Float)msg.getArg(0)).floatValue();
            int tickCount = (Integer)msg.getArg(1);
            if (this.theResponder != null) {
                this.theResponder.time(tempo, tickCount);
            }
        } else {
            if (msg.getName().equals("/mc/agentList")) {
                MusebotAssistant musebotAssistant = this;
                synchronized (musebotAssistant) {
                    this.lastHeartbeat = System.currentTimeMillis();
                }
                System.out.println("Hearbeat received. Time = " + this.lastHeartbeat);
            }
            if (this.theResponder != null) {
                this.theResponder.incoming(msg);
            }
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setPrintMessage(boolean b) {
        this.printMessage = b;
    }

    public static interface Responder {
        public void incoming(OSCMessage var1);

        public void time(float var1, int var2);

        public void gain(float var1, float var2);

        public void kill();
    }
}

