/*
 * Decompiled with CFR 0.152.
 */
package org.musicalmetacreation.musebot.tools;

import de.sciss.net.OSCMessage;
import java.net.URISyntaxException;
import java.util.Random;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.stage.Stage;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;
import net.beadsproject.beads.ugens.WavePlayer;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public abstract class OBMusebotBaseClass
extends Application
implements MusebotAssistant.Responder {
    private static final Logger log = Logger.getLogger(OBMusebotBaseClass.class.getName());
    public final String workingDir = System.getProperty("user.dir");
    public final String resDir = this.workingDir + "/resources";
    public final String audioDir = this.resDir + "/audio";
    protected MusebotAssistant assistant;
    public final Random rng = new Random();
    public final AudioContext ac = new AudioContext(new AudioServerIO.Jack(), 512);
    UGen in;
    Envelope masterGainEnv;
    Glide tempoCtrl;
    Gain masterGain;

    public void start(Stage primaryStage) throws URISyntaxException {
        log.info("Creating musebot");
        this.assistant = new MusebotAssistant();
        this.in = this.ac.getAudioInput(new int[]{1, 2});
        this.masterGainEnv = new Envelope(this.ac, 1.0f);
        this.masterGain = new Gain(this.ac, 2, this.masterGainEnv);
        this.ac.out.addInput(this.masterGain);
        this.tempoCtrl = new Glide(this.ac, 2.0f, 120.0f);
        this.ac.start();
        this.assistant.respondWith(this);
        this.subclassStart();
    }

    protected abstract void subclassStart();

    public void sound(UGen sound) {
        this.masterGain.addInput(sound);
    }

    private void feedbackTest() {
        TapIn tin = new TapIn(this.ac, 5000.0f);
        TapOut tout = new TapOut(this.ac, tin, 1000.0f);
        this.ac.out.addInput(tout);
        tin.addInput(this.in);
    }

    private void bleep() {
        WavePlayer wp = new WavePlayer(this.ac, 500.0f, Buffer.SINE);
        Envelope e = new Envelope(this.ac, 1.0f);
        Gain g = new Gain(this.ac, 2, e);
        g.addInput(wp);
        this.sound(g);
        e.addSegment(0.0f, 100.0f, new KillTrigger(g));
    }

    @Override
    public void incoming(OSCMessage msg) {
        log.info(msg.getName());
    }

    @Override
    public void time(float tempo, int tickCount) {
        log.info("Time message: " + tickCount + " (" + tempo + " bpm)");
        this.tempoCtrl.setValue(tempo);
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnv.addSegment(level, time);
    }

    @Override
    public void kill() {
        this.masterGainEnv.lock(false);
        this.masterGainEnv.addSegment(0.0f, 4000.0f, new Bead(){

            @Override
            protected void messageReceived(Bead message) {
                super.messageReceived(message);
                System.exit(0);
            }
        });
        this.masterGainEnv.lock(true);
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        log.addHandler(handler);
        handler.setLevel(Level.SEVERE);
        log.setLevel(Level.SEVERE);
    }
}

