/*
 * Decompiled with CFR 0.152.
 */
package procjam2015;

import de.sciss.net.OSCMessage;
import java.util.Hashtable;
import org.musicalmetacreation.musebot.tools.OBMusebotBaseClass;
import procjam2015.Intent;
import procjam2015.IntentMessageHandler;
import procjam2015.sound_events.DrumKit;

public class ProcBot2015
extends OBMusebotBaseClass {
    public static final int[] repAtBeat = new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0};
    public static final int[] repAt2Beat = new int[]{1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0};
    Intent currentAction;
    Intent nextAction;
    IntentMessageHandler intentMessageHandler;
    DrumKit drums;
    int reg = 0;
    int eigthBeatFromTala = 0;

    public static void main(String[] args) {
        ProcBot2015.launch((String[])args);
    }

    @Override
    protected void subclassStart() {
        this.intentMessageHandler = new IntentMessageHandler(this.assistant);
        this.drums = new DrumKit(this);
        this.createInitialAction();
        this.assistant.setPrintMessage(true);
    }

    private void createInitialAction() {
        this.currentAction = new Intent();
        this.currentAction.activityMask = new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        this.currentAction.repetitionStructure = new char[]{'A', 'B', 'C', 'D'};
        this.currentAction.talaStructure = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
        this.currentAction.contourA = new char[]{'U', 'U', 'U', 'U', 'D', 'D', 'D', 'D'};
        this.currentAction.iFollow = null;
        this.currentAction.synchro = 0.5f;
        this.intentMessageHandler.currentIntent = this.currentAction.createCopy();
    }

    @Override
    public void time(float tempo, int tickCount) {
        super.time(tempo, tickCount);
        if (this.intentMessageHandler == null || this.currentAction == null) {
            return;
        }
        int tickModLoop = tickCount % 256;
        int beat = tickModLoop / 16;
        int quarterBeat = tickModLoop / 4;
        int halfBar = tickModLoop / 32;
        int bar = tickModLoop / 64;
        if (tickModLoop == 0 && this.nextAction != null) {
            this.currentAction = this.nextAction;
            System.out.println("Updated current action:");
            this.currentAction.print();
            this.reg = 0;
        } else if (tickModLoop == 64) {
            this.createIntent();
        } else if (tickModLoop == 192) {
            this.planAction();
        }
        if (tickModLoop % 32 == 0 && this.currentAction.contourA != null) {
            if (this.currentAction.contourA[halfBar] == 'U') {
                ++this.reg;
            }
            if (this.currentAction.contourA[halfBar] == 'D') {
                --this.reg;
            }
        }
        if (tickModLoop % 2 == 0 && this.currentAction.activityMask[beat] > 0) {
            int drumKitHeaviness = this.currentAction.activityMask[beat] / 3;
            boolean isKik = this.isTalaEvent(quarterBeat);
            this.eigthBeatFromTala = isKik ? 0 : ++this.eigthBeatFromTala;
            char pattern = 'A';
            if (this.currentAction.repetitionStructure != null) {
                pattern = this.currentAction.repetitionStructure[bar];
            }
            this.drums.play(drumKitHeaviness, isKik, pattern, this.eigthBeatFromTala);
        }
    }

    private boolean isTalaEvent(int quarterBeat) {
        if (this.nextAction == null || this.nextAction.talaStructure == null) {
            return false;
        }
        int now = 0;
        for (int i = 0; i < this.nextAction.talaStructure.length; ++i) {
            if (quarterBeat == now) {
                return true;
            }
            if (quarterBeat < now) {
                return false;
            }
            now += this.nextAction.talaStructure[i];
        }
        return false;
    }

    private void createIntent() {
        Intent newIntent = this.currentAction.createCopy();
        System.out.println("New intent to send:");
        newIntent.print();
        this.intentMessageHandler.broadcastIntent(newIntent);
    }

    private void modifyOwnAction() {
    }

    private void planAction() {
        if (this.intentMessageHandler.currentIntent == null) {
            return;
        }
        this.nextAction = this.intentMessageHandler.currentIntent.createCopy();
        int numAgents = this.intentMessageHandler.receivedIntents.size();
        if (numAgents <= 1) {
            this.modifyOwnAction();
        } else {
            int[] tala;
            int i;
            Hashtable<String, Integer> leaderCount = new Hashtable<String, Integer>();
            int highestLeaderCount = 0;
            String dominantLeader = null;
            float avgSynchro = 0.0f;
            int synchroCount = 0;
            for (Intent intent : this.intentMessageHandler.receivedIntents.values()) {
                if (intent.iFollow != null) {
                    int count = 0;
                    if (leaderCount.containsKey(intent.iFollow)) {
                        count = (Integer)leaderCount.get(intent.iFollow);
                    }
                    leaderCount.put(intent.iFollow, count++);
                    if (highestLeaderCount < count) {
                        highestLeaderCount = count;
                        dominantLeader = intent.iFollow;
                    }
                }
                if (intent.synchro == -1.0f) continue;
                avgSynchro += intent.synchro;
                ++synchroCount;
            }
            if (highestLeaderCount > 3) {
                this.nextAction.iFollow = dominantLeader;
            }
            if (this.rng.nextFloat() < 0.1f && numAgents > 0) {
                this.nextAction.iFollow = (String)this.intentMessageHandler.receivedIntents.keySet().toArray()[this.rng.nextInt(numAgents)];
            }
            avgSynchro /= (float)synchroCount;
            float stdDevSynchro = 0.0f;
            for (Intent intent : this.intentMessageHandler.receivedIntents.values()) {
                if (intent.synchro == -1.0f) continue;
                stdDevSynchro += (avgSynchro - intent.synchro) * (avgSynchro - intent.synchro);
            }
            stdDevSynchro /= (float)synchroCount;
            if ((stdDevSynchro = (float)Math.sqrt(stdDevSynchro)) < 2.0f) {
                this.nextAction.synchro = avgSynchro;
            }
            boolean bl = false;
            float occurrencesOfAAAB = 0.0f;
            float occurrencesOfAABB = 0.0f;
            float occurrencesOfABAB = 0.0f;
            int numActivitiyMasks = 0;
            float densityInLastBar = 0.0f;
            float densityInFirstBar = 0.0f;
            float repetitionAtBeat = 0.0f;
            float repetitionAt2Beat = 0.0f;
            float centroid = 0.0f;
            float[] beatCounts = new float[64];
            int numTalas = 0;
            for (Intent intent : this.intentMessageHandler.receivedIntents.values()) {
                if (intent.repetitionStructure != null) {
                    if (intent.repetitionStructure.equals(new char[]{'A', 'A', 'A', 'B'})) {
                        occurrencesOfAAAB += 1.0f;
                    }
                    if (intent.repetitionStructure.equals(new char[]{'A', 'A', 'B', 'B'})) {
                        occurrencesOfAABB += 1.0f;
                    }
                    if (intent.repetitionStructure.equals(new char[]{'A', 'B', 'A', 'B'})) {
                        occurrencesOfABAB += 1.0f;
                    }
                }
                if (intent.activityMask != null) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        densityInFirstBar += (float)intent.activityMask[i2 + 12] / 36.0f;
                        densityInLastBar += (float)intent.activityMask[i2 + 12] / 36.0f;
                    }
                    for (int i2 = 0; i2 < 16; ++i2) {
                        float activity = intent.activityMask[i2] > 5 ? 1.0f : 0.0f;
                        repetitionAtBeat += activity / 16.0f * (float)repAtBeat[i2];
                        repetitionAt2Beat += activity / 16.0f * (float)repAt2Beat[i2];
                        if (!(activity > 0.0f)) continue;
                        centroid += (float)i2 / 8.0f - 1.0f;
                    }
                    ++numActivitiyMasks;
                }
                if (intent.talaStructure == null) continue;
                ++numTalas;
                int[] times = new int[intent.talaStructure.length];
                int next = 0;
                for (int i3 = 0; i3 < intent.talaStructure.length; ++i3) {
                    times[i3] = next;
                    if ((next += intent.talaStructure[i3]) >= 64) continue;
                    int n = next;
                    beatCounts[n] = beatCounts[n] + 1.0f;
                }
            }
            occurrencesOfAAAB /= (float)bl;
            occurrencesOfAABB /= (float)bl;
            occurrencesOfABAB /= (float)bl;
            densityInFirstBar /= (float)numActivitiyMasks;
            densityInLastBar /= (float)numActivitiyMasks;
            repetitionAtBeat /= (float)numActivitiyMasks;
            repetitionAt2Beat /= (float)numActivitiyMasks;
            centroid /= (float)numActivitiyMasks;
            float beatStrength = 0.0f;
            for (i = 0; i < 64; ++i) {
                int n = i;
                beatCounts[n] = beatCounts[n] / (float)numTalas;
                beatStrength += beatCounts[i] / 64.0f;
            }
            if (occurrencesOfAAAB > 0.2f) {
                this.nextAction.repetitionStructure = new char[]{'A', 'A', 'A', 'B'};
            } else if (occurrencesOfAABB > 0.2f) {
                this.nextAction.repetitionStructure = new char[]{'A', 'A', 'B', 'B'};
            } else if (occurrencesOfABAB > 0.2f) {
                this.nextAction.repetitionStructure = new char[]{'A', 'B', 'A', 'B'};
            }
            if (repetitionAtBeat > 0.5f || repetitionAt2Beat > 0.5f) {
                if (this.rng.nextBoolean()) {
                    for (i = 0; i < 16; ++i) {
                        this.nextAction.activityMask[i] = i % 2 == 0 ? 9 : 0;
                    }
                } else {
                    for (i = 0; i < 16; ++i) {
                        this.nextAction.activityMask[i] = i / 2 % 2 == 0 ? 9 : 0;
                    }
                }
            }
            if (Math.abs(centroid) > 0.5f) {
                for (i = 0; i < 16; ++i) {
                    int n = i;
                    this.nextAction.activityMask[n] = this.nextAction.activityMask[n] * (int)((float)i / 15.0f);
                }
            }
            if (densityInFirstBar < 0.3f && this.rng.nextFloat() < 0.5f) {
                this.nextAction.activityMask[0] = 0;
                this.nextAction.activityMask[1] = 0;
                this.nextAction.activityMask[2] = 0;
                this.nextAction.activityMask[3] = 0;
            }
            if (densityInLastBar < 0.3f && this.rng.nextFloat() < 0.9f) {
                this.nextAction.activityMask[0] = 9;
                this.nextAction.activityMask[1] = 9;
                this.nextAction.activityMask[2] = 9;
                this.nextAction.activityMask[3] = 9;
            }
            if (beatStrength > 0.3f && (tala = this.intentMessageHandler.receivedIntents.get((Object)this.nextAction.iFollow).talaStructure) != null) {
                this.nextAction.talaStructure = tala;
            }
            char[] contour = null;
            try {
                contour = this.intentMessageHandler.receivedIntents.get((Object)this.nextAction.iFollow).contourA;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.nextAction.contourA = contour != null ? contour : this.currentAction.contourA;
            this.intentMessageHandler.receivedIntents.clear();
            System.out.println("Next action has been planned:");
            this.nextAction.print();
        }
    }

    @Override
    public void incoming(OSCMessage msg) {
        super.incoming(msg);
        if (msg.getName().equals("/broadcast/intent")) {
            this.intentMessageHandler.incoming(msg);
        }
    }
}

