/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.File;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jstat.AscendingMonitorComparator;
import sun.tools.jstat.DescendingMonitorComparator;
import sun.tools.jstat.OptionFinder;
import sun.tools.jstat.OptionFormat;

public class Arguments {
    private static final boolean debug = Boolean.getBoolean("jstat.debug");
    private static final boolean showUnsupported = Boolean.getBoolean("jstat.showUnsupported");
    private static final String JVMSTAT_USERDIR = ".jvmstat";
    private static final String OPTIONS_FILENAME = "jstat_options";
    private static final String ALL_NAMES = "\\w*";
    private Comparator comparator;
    private int headerRate;
    private boolean help;
    private boolean list;
    private boolean options;
    private boolean constants;
    private boolean constantsOnly;
    private boolean strings;
    private boolean timestamp;
    private boolean snap;
    private boolean verbose;
    private String specialOption;
    private String names;
    private OptionFormat optionFormat;
    private int count = -1;
    private int interval = -1;
    private String vmIdString;
    private VmIdentifier vmId;

    public static void printUsage(PrintStream printStream) {
        printStream.println("Usage: jstat -help|-options");
        printStream.println("       jstat -<option> [-t] [-h<lines>] <vmid> [<interval> [<count>]]");
        printStream.println();
        printStream.println("Definitions:");
        printStream.println("  <option>      An option reported by the -options option");
        printStream.println("  <vmid>        Virtual Machine Identifier. A vmid takes the following form:");
        printStream.println("                     <lvmid>[@<hostname>[:<port>]]");
        printStream.println("                Where <lvmid> is the local vm identifier for the target");
        printStream.println("                Java virtual machine, typically a process id; <hostname> is");
        printStream.println("                the name of the host running the target Java virtual machine;");
        printStream.println("                and <port> is the port number for the rmiregistry on the");
        printStream.println("                target host. See the jvmstat documentation for a more complete");
        printStream.println("                description of the Virtual Machine Identifier.");
        printStream.println("  <lines>       Number of samples between header lines.");
        printStream.println("  <interval>    Sampling interval. The following forms are allowed:");
        printStream.println("                    <n>[\"ms\"|\"s\"]");
        printStream.println("                Where <n> is an integer and the suffix specifies the units as ");
        printStream.println("                milliseconds(\"ms\") or seconds(\"s\"). The default units are \"ms\".");
        printStream.println("  <count>       Number of samples to take before terminating.");
        printStream.println("  -J<flag>      Pass <flag> directly to the runtime system.");
    }

    private static int toMillis(String string) throws IllegalArgumentException {
        int n;
        String[] stringArray = new String[]{"ms", "s"};
        String string2 = null;
        String string3 = string;
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = string.indexOf(stringArray[n]);
            if (n2 <= 0) continue;
            string2 = string.substring(n2);
            string3 = string.substring(0, n2);
            break;
        }
        try {
            n = Integer.parseInt(string3);
            if (string2 == null || string2.compareTo("ms") == 0) {
                return n;
            }
            if (string2.compareTo("s") == 0) {
                return n * 1000;
            }
            throw new IllegalArgumentException("Unknow time unit: " + string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not convert interval: " + string);
        }
    }

    public Arguments(String[] stringArray) throws IllegalArgumentException {
        Object object;
        Object object2;
        int n = 0;
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("invalid argument count");
        }
        if (stringArray[0].compareTo("-?") == 0 || stringArray[0].compareTo("-help") == 0) {
            this.help = true;
            return;
        }
        if (stringArray[0].compareTo("-options") == 0) {
            this.options = true;
            return;
        }
        if (stringArray[0].compareTo("-list") == 0) {
            this.list = true;
            if (stringArray.length > 2) {
                throw new IllegalArgumentException("invalid argument count");
            }
            ++n;
        }
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            object2 = stringArray[n];
            if (((String)object2).compareTo("-a") == 0) {
                this.comparator = new AscendingMonitorComparator();
            } else if (((String)object2).compareTo("-d") == 0) {
                this.comparator = new DescendingMonitorComparator();
            } else if (((String)object2).compareTo("-t") == 0) {
                this.timestamp = true;
            } else if (((String)object2).compareTo("-v") == 0) {
                this.verbose = true;
            } else if (((String)object2).compareTo("-constants") == 0 || ((String)object2).compareTo("-c") == 0) {
                this.constants = true;
            } else if (((String)object2).compareTo("-strings") == 0 || ((String)object2).compareTo("-s") == 0) {
                this.strings = true;
            } else if (((String)object2).startsWith("-h")) {
                if (((String)object2).compareTo("-h") != 0) {
                    object = ((String)object2).substring(2);
                } else {
                    if (++n >= stringArray.length) {
                        throw new IllegalArgumentException("-h requires an integer argument");
                    }
                    object = stringArray[n];
                }
                try {
                    this.headerRate = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.headerRate = -1;
                }
                if (this.headerRate < 0) {
                    throw new IllegalArgumentException("illegal -h argument: " + (String)object);
                }
            } else if (((String)object2).startsWith("-name")) {
                if (((String)object2).startsWith("-name=")) {
                    this.names = ((String)object2).substring(7);
                } else {
                    if (++n >= stringArray.length) {
                        throw new IllegalArgumentException("option argument expected");
                    }
                    this.names = stringArray[n];
                }
            } else {
                object = null;
                int n2 = stringArray[n].indexOf(64);
                object = n2 < 0 ? stringArray[n] : stringArray[n].substring(0, n2);
                try {
                    int n3 = Integer.parseInt((String)object);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (n == 0 && stringArray[n].compareTo("-snap") == 0) {
                        this.snap = true;
                    }
                    if (n == 0) {
                        this.specialOption = stringArray[n].substring(1);
                    }
                    throw new IllegalArgumentException("illegal argument: " + stringArray[n]);
                }
            }
            ++n;
        }
        if (this.specialOption == null && !this.list && !this.snap && this.names == null) {
            throw new IllegalArgumentException("-<option> required");
        }
        switch (stringArray.length - n) {
            case 3: {
                if (this.snap) {
                    throw new IllegalArgumentException("invalid argument count");
                }
                try {
                    this.count = Integer.parseInt(stringArray[stringArray.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("illegal count value: " + stringArray[stringArray.length - 1]);
                }
                this.interval = Arguments.toMillis(stringArray[stringArray.length - 2]);
                this.vmIdString = stringArray[stringArray.length - 3];
                break;
            }
            case 2: {
                if (this.snap) {
                    throw new IllegalArgumentException("invalid argument count");
                }
                this.interval = Arguments.toMillis(stringArray[stringArray.length - 1]);
                this.vmIdString = stringArray[stringArray.length - 2];
                break;
            }
            case 1: {
                this.vmIdString = stringArray[stringArray.length - 1];
                break;
            }
            case 0: {
                if (this.list) break;
                throw new IllegalArgumentException("invalid argument count");
            }
            default: {
                throw new IllegalArgumentException("invalid argument count");
            }
        }
        if (this.count == -1 && this.interval == -1) {
            this.count = 1;
            this.interval = 0;
        }
        if (this.comparator == null) {
            this.comparator = new AscendingMonitorComparator();
        }
        this.names = this.names == null ? ALL_NAMES : this.names.replace(',', '|');
        try {
            object2 = Pattern.compile(this.names);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Bad name pattern: " + patternSyntaxException.getMessage());
        }
        if (this.specialOption != null) {
            object2 = new OptionFinder(this.optionsSources());
            this.optionFormat = ((OptionFinder)object2).getOptionFormat(this.specialOption, this.timestamp);
            if (this.optionFormat == null) {
                throw new IllegalArgumentException("Unknown option: -" + this.specialOption);
            }
        }
        try {
            this.vmId = new VmIdentifier(this.vmIdString);
        }
        catch (URISyntaxException uRISyntaxException) {
            object = new IllegalArgumentException("Malformed VM Identifier: " + this.vmIdString);
            ((Throwable)object).initCause(uRISyntaxException);
            throw object;
        }
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isSnap() {
        return this.snap;
    }

    public boolean isOptions() {
        return this.options;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean printConstants() {
        return this.constants;
    }

    public boolean isConstantsOnly() {
        return this.constantsOnly;
    }

    public boolean printStrings() {
        return this.strings;
    }

    public boolean showUnsupported() {
        return showUnsupported;
    }

    public int headerRate() {
        return this.headerRate;
    }

    public String counterNames() {
        return this.names;
    }

    public VmIdentifier vmId() {
        return this.vmId;
    }

    public String vmIdString() {
        return this.vmIdString;
    }

    public int sampleInterval() {
        return this.interval;
    }

    public int sampleCount() {
        return this.count;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public boolean isSpecialOption() {
        return this.specialOption != null;
    }

    public String specialOption() {
        return this.specialOption;
    }

    public OptionFormat optionFormat() {
        return this.optionFormat;
    }

    public URL[] optionsSources() {
        URL[] uRLArray = new URL[2];
        int n = 0;
        String string = OPTIONS_FILENAME;
        try {
            String string2 = System.getProperty("user.home");
            String string3 = string2 + "/" + JVMSTAT_USERDIR;
            File file = new File(string3 + "/" + string);
            uRLArray[n++] = file.toURL();
        }
        catch (Exception exception) {
            if (debug) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
            throw new IllegalArgumentException("Internal Error: Bad URL: " + exception.getMessage());
        }
        uRLArray[n] = this.getClass().getResource("resources/" + string);
        assert (uRLArray[n] != null);
        return uRLArray;
    }
}

