/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import jode.AssertError;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.Handler;
import jode.bytecode.LineNumber;
import jode.bytecode.LocalVariableInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;

public final class Instruction
implements Opcodes {
    private static final String stackDelta = "\u0000\b\b\b\b\b\b\b\b\u0010\u0010\b\b\b\u0010\u0010\b\b\b\b\u0010\b\u0010\b\u0010\b\b\b\b\b\u0010\u0010\u0010\u0010\b\b\b\b\u0010\u0010\u0010\u0010\b\b\b\b\n\u0012\n\u0012\n\n\n\n\u0001\u0002\u0001\u0002\u0001\u0001\u0001\u0001\u0001\u0002\u0002\u0002\u0002\u0001\u0001\u0001\u0001\u0002\u0002\u0002\u0002\u0001\u0001\u0001\u0001\u0003\u0004\u0003\u0004\u0003\u0003\u0003\u0003\u0001\u0002\u0011\u001a#\"+4\u0012\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\n\u0014\t\u0012\t\u0012\n\u0013\n\u0013\n\u0013\n\u0014\n\u0014\n\u0014\u0000\u0011\t\u0011\n\n\u0012\t\u0011\u0011\n\u0012\n\t\t\t\f\n\n\f\f\u0001\u0001\u0001\u0001\u0001\u0001\u0002\u0002\u0002\u0002\u0002\u0002\u0002\u0002\u0000\b\u0000\u0001\u0001\u0001\u0002\u0001\u0002\u0001\u0000@@@@@@@@\u007f\b\t\t\t\u0001\t\t\u0001\u0001\u007f@\u0001\u0001\u0000\b";
    private int opcode;
    private int shortData;
    private int addr;
    private Object objData;
    private Object succs;
    private Instruction[] preds;
    Instruction nextByAddr;
    Instruction prevByAddr;
    private Object tmpInfo;

    public final int getOpcode() {
        return this.opcode;
    }

    public final int getAddr() {
        return this.addr;
    }

    public final int getNextAddr() {
        return this.nextByAddr.addr;
    }

    public final int getLength() {
        return this.getNextAddr() - this.addr;
    }

    final void setAddr(int n) {
        this.addr = n;
    }

    public final boolean hasLocalSlot() {
        return this.opcode == 132 || this.opcode == 169 || this.opcode >= 21 && this.opcode <= 25 || this.opcode >= 54 && this.opcode <= 58;
    }

    public final int getLocalSlot() {
        return this.shortData;
    }

    public final void setLocalSlot(int n) {
        this.shortData = n;
    }

    public final int getIncrement() {
        return ((Short)this.objData).shortValue();
    }

    public final void setIncrement(int n) {
        this.objData = new Short((short)n);
    }

    public final int getDimensions() {
        return this.shortData;
    }

    public final void setDimensions(int n) {
        this.shortData = n;
    }

    public final Object getConstant() {
        return this.objData;
    }

    public final void setConstant(Object object) {
        this.objData = object;
    }

    public final Reference getReference() {
        return (Reference)this.objData;
    }

    public final void setReference(Reference reference) {
        this.objData = reference;
    }

    public final String getClazzType() {
        return (String)this.objData;
    }

    public final void setClazzType(String string) {
        this.objData = string;
    }

    public final int[] getValues() {
        return (int[])this.objData;
    }

    public final void setValues(int[] nArray) {
        this.objData = nArray;
    }

    public final boolean doesAlwaysJump() {
        switch (this.opcode) {
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    public final Instruction[] getPreds() {
        return this.preds;
    }

    public boolean hasSuccs() {
        return this.succs != null;
    }

    public final Instruction[] getSuccs() {
        if (this.succs instanceof Instruction) {
            return new Instruction[]{(Instruction)this.succs};
        }
        return (Instruction[])this.succs;
    }

    public final Instruction getSingleSucc() {
        return (Instruction)this.succs;
    }

    public final Instruction getPrevByAddr() {
        if (this.prevByAddr.opcode == 254) {
            return null;
        }
        return this.prevByAddr;
    }

    public final Instruction getNextByAddr() {
        if (this.nextByAddr.opcode == 254) {
            return null;
        }
        return this.nextByAddr;
    }

    public final Object getTmpInfo() {
        return this.tmpInfo;
    }

    public final void setTmpInfo(Object object) {
        this.tmpInfo = object;
    }

    final void removeSuccs() {
        if (this.succs == null) {
            return;
        }
        if (this.succs instanceof Instruction[]) {
            Instruction[] instructionArray = (Instruction[])this.succs;
            int n = 0;
            while (n < instructionArray.length) {
                if (instructionArray[n] != null) {
                    instructionArray[n].removePredecessor(this);
                }
                ++n;
            }
        } else {
            ((Instruction)this.succs).removePredecessor(this);
        }
        this.succs = null;
    }

    private final void promoteSuccs(Instruction instruction, Instruction instruction2) {
        if (this.succs == instruction) {
            this.succs = instruction2;
        } else if (this.succs instanceof Instruction[]) {
            Instruction[] instructionArray = (Instruction[])this.succs;
            int n = 0;
            while (n < instructionArray.length) {
                if (instructionArray[n] == instruction) {
                    instructionArray[n] = instruction2;
                }
                ++n;
            }
        }
    }

    public final void setSuccs(Object object) {
        if (this.succs == object) {
            return;
        }
        this.removeSuccs();
        if (object == null) {
            return;
        }
        if (object instanceof Instruction[]) {
            Instruction[] instructionArray = (Instruction[])object;
            switch (instructionArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.succs = instructionArray[0];
                    instructionArray[0].addPredecessor(this);
                    break;
                }
                default: {
                    this.succs = instructionArray;
                    int n = 0;
                    while (n < instructionArray.length) {
                        instructionArray[n].addPredecessor(this);
                        ++n;
                    }
                    break block0;
                }
            }
        } else {
            this.succs = object;
            ((Instruction)object).addPredecessor(this);
        }
    }

    void addPredecessor(Instruction instruction) {
        if (this.preds == null) {
            this.preds = new Instruction[]{instruction};
            return;
        }
        int n = this.preds.length;
        Instruction[] instructionArray = new Instruction[n + 1];
        System.arraycopy(this.preds, 0, instructionArray, 0, n);
        instructionArray[n] = instruction;
        this.preds = instructionArray;
    }

    void removePredecessor(Instruction instruction) {
        int n = this.preds.length;
        if (n == 1) {
            if (this.preds[0] != instruction) {
                throw new AssertError("removing not existing predecessor");
            }
            this.preds = null;
        } else {
            Instruction[] instructionArray = new Instruction[n - 1];
            int n2 = 0;
            while (this.preds[n2] != instruction) {
                instructionArray[n2] = this.preds[n2];
                ++n2;
            }
            System.arraycopy(this.preds, n2 + 1, instructionArray, n2, n - n2 - 1);
            this.preds = instructionArray;
        }
    }

    public final void replaceInstruction(Instruction instruction, BytecodeInfo bytecodeInfo) {
        LineNumber[] lineNumberArray;
        this.removeSuccs();
        instruction.addr = this.addr;
        this.nextByAddr.prevByAddr = instruction;
        instruction.nextByAddr = this.nextByAddr;
        this.prevByAddr.nextByAddr = instruction;
        instruction.prevByAddr = this.prevByAddr;
        this.prevByAddr = null;
        this.nextByAddr = null;
        if (this.preds != null) {
            int n = 0;
            while (n < this.preds.length) {
                this.preds[n].promoteSuccs(this, instruction);
                ++n;
            }
            instruction.preds = this.preds;
            this.preds = null;
        }
        Handler[] handlerArray = bytecodeInfo.getExceptionHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            if (handlerArray[n].start == this) {
                handlerArray[n].start = instruction;
            }
            if (handlerArray[n].end == this) {
                handlerArray[n].end = instruction;
            }
            if (handlerArray[n].catcher == this) {
                handlerArray[n].catcher = instruction;
            }
            ++n;
        }
        LocalVariableInfo[] localVariableInfoArray = bytecodeInfo.getLocalVariableTable();
        if (localVariableInfoArray != null) {
            int n2 = 0;
            while (n2 < localVariableInfoArray.length) {
                if (localVariableInfoArray[n2].start == this) {
                    localVariableInfoArray[n2].start = instruction;
                }
                if (localVariableInfoArray[n2].end == this) {
                    localVariableInfoArray[n2].end = instruction;
                }
                ++n2;
            }
        }
        if ((lineNumberArray = bytecodeInfo.getLineNumberTable()) != null) {
            int n3 = 0;
            while (n3 < lineNumberArray.length) {
                if (lineNumberArray[n3].start == this) {
                    lineNumberArray[n3].start = instruction;
                }
                ++n3;
            }
        }
    }

    void appendInstruction(Instruction instruction, BytecodeInfo bytecodeInfo) {
        instruction.addr = this.nextByAddr.addr;
        instruction.nextByAddr = this.nextByAddr;
        this.nextByAddr.prevByAddr = instruction;
        instruction.prevByAddr = this;
        this.nextByAddr = instruction;
        Handler[] handlerArray = bytecodeInfo.getExceptionHandlers();
        if (handlerArray != null) {
            int n = 0;
            while (n < handlerArray.length) {
                if (handlerArray[n].end == this) {
                    handlerArray[n].end = instruction;
                }
                ++n;
            }
        }
    }

    void removeInstruction(BytecodeInfo bytecodeInfo) {
        Object[] objectArray;
        this.prevByAddr.nextByAddr = this.nextByAddr;
        this.nextByAddr.prevByAddr = this.prevByAddr;
        this.removeSuccs();
        if (this.preds != null) {
            int n = 0;
            while (n < this.preds.length) {
                this.preds[n].promoteSuccs(this, this.nextByAddr);
                ++n;
            }
            if (this.nextByAddr.preds == null) {
                this.nextByAddr.preds = this.preds;
            } else {
                Instruction[] instructionArray = new Instruction[this.nextByAddr.preds.length + this.preds.length];
                System.arraycopy(this.nextByAddr.preds, 0, instructionArray, 0, this.nextByAddr.preds.length);
                System.arraycopy(this.preds, 0, instructionArray, this.nextByAddr.preds.length, this.preds.length);
                this.nextByAddr.preds = instructionArray;
            }
            this.preds = null;
        }
        Object[] objectArray2 = bytecodeInfo.getExceptionHandlers();
        int n = 0;
        while (n < objectArray2.length) {
            if (objectArray2[n].start == this && objectArray2[n].end == this) {
                objectArray = new Handler[objectArray2.length - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n + 1, objectArray, n, objectArray2.length - (n + 1));
                objectArray2 = objectArray;
                bytecodeInfo.setExceptionHandlers((Handler[])objectArray);
                --n;
            } else {
                if (objectArray2[n].start == this) {
                    objectArray2[n].start = this.nextByAddr;
                }
                if (objectArray2[n].end == this) {
                    objectArray2[n].end = this.prevByAddr;
                }
                if (objectArray2[n].catcher == this) {
                    objectArray2[n].catcher = this.nextByAddr;
                }
            }
            ++n;
        }
        LocalVariableInfo[] localVariableInfoArray = bytecodeInfo.getLocalVariableTable();
        if (localVariableInfoArray != null) {
            int n2 = 0;
            while (n2 < localVariableInfoArray.length) {
                if (localVariableInfoArray[n2].start == this && localVariableInfoArray[n2].end == this) {
                    LocalVariableInfo[] localVariableInfoArray2 = new LocalVariableInfo[localVariableInfoArray.length - 1];
                    System.arraycopy(localVariableInfoArray, 0, localVariableInfoArray2, 0, n2);
                    System.arraycopy(localVariableInfoArray, n2 + 1, localVariableInfoArray2, n2, localVariableInfoArray2.length - n2);
                    localVariableInfoArray = localVariableInfoArray2;
                    bytecodeInfo.setLocalVariableTable(localVariableInfoArray2);
                    --n2;
                } else {
                    if (localVariableInfoArray[n2].start == this) {
                        localVariableInfoArray[n2].start = this.nextByAddr;
                    }
                    if (localVariableInfoArray[n2].end == this) {
                        localVariableInfoArray[n2].end = this.prevByAddr;
                    }
                }
                ++n2;
            }
        }
        if ((objectArray = bytecodeInfo.getLineNumberTable()) != null) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3].start == this) {
                    if (this.nextByAddr.opcode == 254 || n3 + 1 < objectArray.length && ((LineNumber)objectArray[n3 + 1]).start == this.nextByAddr) {
                        LineNumber[] lineNumberArray = new LineNumber[objectArray.length - 1];
                        System.arraycopy(objectArray, 0, lineNumberArray, 0, n3);
                        System.arraycopy(objectArray, n3 + 1, lineNumberArray, n3, lineNumberArray.length - n3);
                        objectArray = lineNumberArray;
                        bytecodeInfo.setLineNumberTable(lineNumberArray);
                        --n3;
                    } else {
                        ((LineNumber)objectArray[n3]).start = this.nextByAddr;
                    }
                }
                ++n3;
            }
        }
        this.prevByAddr = null;
        this.nextByAddr = null;
    }

    public int compareTo(Instruction instruction) {
        if (this.addr != instruction.addr) {
            return this.addr - instruction.addr;
        }
        if (this == instruction) {
            return 0;
        }
        do {
            instruction = instruction.nextByAddr;
            if (instruction.addr <= this.addr) continue;
            return -1;
        } while (instruction != this);
        return 1;
    }

    public void getStackPopPush(int[] nArray) {
        byte by = (byte)stackDelta.charAt(this.opcode);
        if (by < 64) {
            nArray[0] = by & 7;
            nArray[1] = by >> 3;
        } else {
            switch (this.opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Reference reference = this.getReference();
                    String string = reference.getType();
                    nArray[0] = this.opcode != 184 ? 1 : 0;
                    nArray[0] = nArray[0] + TypeSignature.getArgumentSize(string);
                    nArray[1] = TypeSignature.getReturnSize(string);
                    break;
                }
                case 179: 
                case 181: {
                    Reference reference = this.getReference();
                    nArray[1] = 0;
                    nArray[0] = TypeSignature.getTypeSize(reference.getType());
                    if (this.opcode != 181) break;
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                case 178: 
                case 180: {
                    Reference reference = this.getReference();
                    nArray[1] = TypeSignature.getTypeSize(reference.getType());
                    nArray[0] = this.opcode == 180 ? 1 : 0;
                    break;
                }
                case 197: {
                    nArray[1] = 1;
                    nArray[0] = this.getDimensions();
                    break;
                }
                default: {
                    throw new AssertError("Unknown Opcode: " + this.opcode);
                }
            }
        }
    }

    public Instruction findMatchingPop() {
        int[] nArray = new int[2];
        this.getStackPopPush(nArray);
        int n = nArray[1];
        Instruction instruction = this;
        while (instruction.succs == null && !instruction.doesAlwaysJump()) {
            instruction = instruction.nextByAddr;
            if (instruction.preds != null) {
                return null;
            }
            instruction.getStackPopPush(nArray);
            if (n == nArray[0]) {
                return instruction;
            }
            n += nArray[1] - nArray[0];
        }
        return null;
    }

    public Instruction findMatchingPush() {
        int n = 0;
        Instruction instruction = this;
        int[] nArray = new int[2];
        while (instruction.preds == null) {
            instruction = instruction.prevByAddr;
            if (instruction == null || instruction.succs != null || instruction.doesAlwaysJump()) {
                return null;
            }
            instruction.getStackPopPush(nArray);
            if (n < nArray[1]) {
                return n == 0 ? instruction : null;
            }
            n += nArray[0] - nArray[1];
        }
        return null;
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.addr)).append('_').append(Integer.toHexString(this.hashCode())).append(": ").append(Opcodes.opcodeString[this.opcode]);
        if (this.opcode != 171) {
            if (this.hasLocalSlot()) {
                stringBuffer.append(' ').append(this.getLocalSlot());
            }
            if (this.succs != null) {
                stringBuffer.append(' ').append(((Instruction)this.succs).addr);
            }
            if (this.objData != null) {
                stringBuffer.append(' ').append(this.objData);
            }
            if (this.opcode == 197) {
                stringBuffer.append(' ').append(this.getDimensions());
            }
        } else {
            int[] nArray = this.getValues();
            Instruction[] instructionArray = this.getSuccs();
            int n = 0;
            while (n < nArray.length) {
                stringBuffer.append(' ').append(nArray[n]).append("->").append(instructionArray[n].addr);
                ++n;
            }
            stringBuffer.append(' ').append("default: ").append(instructionArray[nArray.length].addr);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "" + this.addr + "_" + Integer.toHexString(this.hashCode());
    }

    public Instruction(int n) {
        this.opcode = n;
    }
}

