/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import jode.bytecode.BinaryInfo;
import jode.bytecode.ClassFormatException;
import jode.bytecode.ClassInfo;
import jode.bytecode.ConstantPool;
import jode.bytecode.GrowableConstantPool;

public class FieldInfo
extends BinaryInfo {
    ClassInfo clazzInfo;
    int modifier;
    String name;
    String typeSig;
    Object constant;
    boolean syntheticFlag;
    boolean deprecatedFlag;

    protected void readAttribute(String string, int n, ConstantPool constantPool, DataInputStream dataInputStream, int n2) throws IOException {
        if ((n2 & 0x10) != 0 && string.equals("ConstantValue")) {
            if (n != 2) {
                throw new ClassFormatException("ConstantValue attribute has wrong length");
            }
            int n3 = dataInputStream.readUnsignedShort();
            this.constant = constantPool.getConstant(n3);
        } else if (string.equals("Synthetic")) {
            this.syntheticFlag = true;
            if (n != 0) {
                throw new ClassFormatException("Synthetic attribute has wrong length");
            }
        } else if (string.equals("Deprecated")) {
            this.deprecatedFlag = true;
            if (n != 0) {
                throw new ClassFormatException("Deprecated attribute has wrong length");
            }
        } else {
            super.readAttribute(string, n, constantPool, dataInputStream, n2);
        }
    }

    public void read(ConstantPool constantPool, DataInputStream dataInputStream, int n) throws IOException {
        this.modifier = dataInputStream.readUnsignedShort();
        this.name = constantPool.getUTF8(dataInputStream.readUnsignedShort());
        this.typeSig = constantPool.getUTF8(dataInputStream.readUnsignedShort());
        this.readAttributes(constantPool, dataInputStream, n);
    }

    public void reserveSmallConstants(GrowableConstantPool growableConstantPool) {
    }

    public void prepareWriting(GrowableConstantPool growableConstantPool) {
        growableConstantPool.putUTF8(this.name);
        growableConstantPool.putUTF8(this.typeSig);
        if (this.constant != null) {
            growableConstantPool.putUTF8("ConstantValue");
            if (this.typeSig.charAt(0) == 'J' || this.typeSig.charAt(0) == 'D') {
                growableConstantPool.putLongConstant(this.constant);
            } else {
                growableConstantPool.putConstant(this.constant);
            }
        }
        if (this.syntheticFlag) {
            growableConstantPool.putUTF8("Synthetic");
        }
        if (this.deprecatedFlag) {
            growableConstantPool.putUTF8("Deprecated");
        }
        this.prepareAttributes(growableConstantPool);
    }

    protected int getKnownAttributeCount() {
        int n = 0;
        if (this.constant != null) {
            ++n;
        }
        if (this.syntheticFlag) {
            ++n;
        }
        if (this.deprecatedFlag) {
            ++n;
        }
        return n;
    }

    public void writeKnownAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        if (this.constant != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("ConstantValue"));
            dataOutputStream.writeInt(2);
            int n = this.typeSig.charAt(0) == 'J' || this.typeSig.charAt(0) == 'D' ? growableConstantPool.putLongConstant(this.constant) : growableConstantPool.putConstant(this.constant);
            dataOutputStream.writeShort(n);
        }
        if (this.syntheticFlag) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Synthetic"));
            dataOutputStream.writeInt(0);
        }
        if (this.deprecatedFlag) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("Deprecated"));
            dataOutputStream.writeInt(0);
        }
    }

    public void write(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.modifier);
        dataOutputStream.writeShort(growableConstantPool.putUTF8(this.name));
        dataOutputStream.writeShort(growableConstantPool.putUTF8(this.typeSig));
        this.writeAttributes(growableConstantPool, dataOutputStream);
    }

    public void dropInfo(int n) {
        if ((n & 0x10) != 0) {
            this.constant = null;
        }
        super.dropInfo(n);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.typeSig;
    }

    public int getModifiers() {
        return this.modifier;
    }

    public boolean isSynthetic() {
        return this.syntheticFlag;
    }

    public boolean isDeprecated() {
        return this.deprecatedFlag;
    }

    public Object getConstant() {
        this.clazzInfo.loadInfo(16);
        return this.constant;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        this.typeSig = string;
    }

    public void setModifiers(int n) {
        this.modifier = n;
    }

    public void setSynthetic(boolean bl) {
        this.syntheticFlag = bl;
    }

    public void setDeprecated(boolean bl) {
        this.deprecatedFlag = bl;
    }

    public void setConstant(Object object) {
        this.constant = object;
    }

    public String toString() {
        return "Field " + Modifier.toString(this.modifier) + " " + this.typeSig + " " + this.name;
    }

    public FieldInfo(ClassInfo classInfo) {
        this.clazzInfo = classInfo;
    }

    public FieldInfo(ClassInfo classInfo, String string, String string2, int n) {
        this.clazzInfo = classInfo;
        this.name = string;
        this.typeSig = string2;
        this.modifier = n;
    }
}

