/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.flow.FlowBlock;
import jode.flow.LoopBlock;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;

public class ContinueBlock
extends StructuredBlock {
    LoopBlock continuesBlock;
    String continueLabel;

    public void checkConsistent() {
        super.checkConsistent();
        StructuredBlock structuredBlock = this.outer;
        while (structuredBlock != this.continuesBlock) {
            if (structuredBlock == null) {
                throw new RuntimeException("Inconsistency");
            }
            structuredBlock = structuredBlock.outer;
        }
    }

    public boolean isEmpty() {
        return true;
    }

    public StructuredBlock getNextBlock() {
        return this.continuesBlock;
    }

    public FlowBlock getNextFlowBlock() {
        return null;
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        this.continuesBlock.mergeContinueStack(variableStack);
        return null;
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.println("continue" + (this.continueLabel == null ? "" : " " + this.continueLabel) + ";");
    }

    public boolean needsBraces() {
        return false;
    }

    public boolean jumpMayBeChanged() {
        return true;
    }

    public ContinueBlock(LoopBlock loopBlock, boolean bl) {
        this.continuesBlock = loopBlock;
        this.continueLabel = bl ? loopBlock.getLabel() : null;
    }
}

