/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score;

import com.softsynth.jmsl.Composable;
import com.softsynth.jmsl.DefaultDimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpaceEditable;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentPlayable;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.Limits;
import com.softsynth.jmsl.score.NoteFactory;
import com.softsynth.jmsl.score.NoteRenderer;
import com.softsynth.jmsl.score.NumberOutOfRangeException;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.util.JMSLMath;
import com.softsynth.jmsl.util.SimpleXMLSaver;
import com.softsynth.jmsl.util.XMLString;
import com.softsynth.jmsl.util.XMLWritable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Note
implements InstrumentPlayable,
Cloneable,
XMLWritable,
DimensionNameSpaceEditable {
    public static double GRACE_NOTE_SIZE_SCALER;
    private Vector a;
    private DimensionNameSpace b;
    private double[] c;
    private double[] d;
    private Track e;
    private Vector f;
    private Note g;
    private Vector h;
    private Note i;
    private Point2D j;
    public static boolean DBUG;
    private byte k;
    private byte l;
    private byte m;
    private byte n;
    private byte o;
    private Vector p;
    private byte q;
    private byte r;
    public static final int MARK_NONE = 0;
    public static final int MARK_ACCENT = 1;
    public static final int MARK_STACCATO = 2;
    public static final int MARK_TENUTO = 3;
    public static final int MARK_WEDGE = 4;
    public static final int MARK_ACCENT_STACCATO = 5;
    public static final int MARK_ACCENT_TENUTO = 6;
    public static final int MARK_WEDGE_STACCATO = 7;
    public static final int MARK_FERMATA = 8;
    public static final int MARK_HARMONIC = 9;
    public static final int MARK_TRILL = 10;
    public static final int MARK_TRILL_FLAT = 11;
    public static final int MARK_TRILL_SHARP = 12;
    public static final int MARK_TRILL_NATURAL = 13;
    public static final int MARK_MORDANT = 14;
    public static final int MARK_INVERTED_MORDANT = 15;
    public static final int MARK_BOWED_TREMOLO_1 = 16;
    public static final int MARK_BOWED_TREMOLO_2 = 17;
    public static final int MARK_BOWED_TREMOLO_3 = 18;
    public static final int MARK_ACCIACCATURA = 19;
    public static final int STEM_NONE = 0;
    public static final int STEM_UP = 1;
    public static final int STEM_DOWN = 2;
    public static final int ACC_FORCE_REDECLARATION = -1;
    public static final int ACC_NONE = 0;
    public static final int ACC_SHARP = 1;
    public static final int ACC_FLAT = 2;
    public static final int ACC_NATURAL = 3;
    public static final int ACC_DOUBLE_FLAT = 4;
    public static final int ACC_DOUBLE_SHARP = 5;
    public static final int ACC_QUARTERTONE_FLAT = 6;
    public static final int ACC_THREEQUARTERTONE_FLAT = 7;
    public static final int ACC_QUARTERTONE_SHARP = 8;
    public static final int ACC_THREEQUARTERTONE_SHARP = 9;
    public static final int ACC_PREFER_SHARP = 0;
    public static final int ACC_PREFER_FLAT = 1;
    public static final int ACC_NO_PREFERENCE = 2;
    public static final int WHOLE = 0;
    public static final int HALF = 1;
    public static final int QUARTER = 2;
    public static final int EIGHTH = 3;
    public static final int SIXTEENTH = 4;
    public static final int THIRTYSECOND = 5;
    public static final int SIXTYFOURTH = 6;
    public static final int ONEHUNDREDTWENTYEIGHTH = 7;
    public static final int TWOHUNDREDFIFTYSIXTH = 8;
    public static final double[] coreDurations;
    public static final String[] coreDurationNames;
    public static final int NOTEHEAD_BLACK = 0;
    public static final int NOTEHEAD_WHITE = 1;
    public static final int NOTEHEAD_X = 2;
    public static final int NOTEHEAD_X_OVAL = 3;
    public static final int NOTEHEAD_X_DIAMOND = 4;
    public static final int NOTEHEAD_WHITE_DIAMOND = 5;
    public static final int NOTEHEAD_BLACK_DIAMOND = 6;
    public static final int NOTEHEAD_WHITE_TRIANGLE = 7;
    public static final int NOTEHEAD_BLACK_TRIANGLE = 8;
    public static final int NOTEHEAD_WHITE_INVERTEDTRIANGLE = 9;
    public static final int NOTEHEAD_BLACK_INVERTEDTRIANGLE = 10;
    public static final int NOTEHEAD_BREVE = 11;
    public static final int NOTEHEAD_SLASH = 12;
    public static final int NOTEHEAD_RESERVED_1 = 13;
    public static final int NOTEHEAD_RESERVED_2 = 14;
    public static final String[] noteheadNames;
    public static final int DYNAMIC_NONE = 0;
    public static final int DYNAMIC_PPP = 1;
    public static final int DYNAMIC_PP = 2;
    public static final int DYNAMIC_P = 3;
    public static final int DYNAMIC_MP = 4;
    public static final int DYNAMIC_MF = 5;
    public static final int DYNAMIC_F = 6;
    public static final int DYNAMIC_FF = 7;
    public static final int DYNAMIC_FFF = 8;
    private String s;
    private int t;
    private int u;
    private static boolean v;
    private int w;
    private Color x;
    private int y;
    private int z;
    public static final String copyright;
    public static int A;
    private static String[] B;

    public Note(Track track, double d2, double d3, double d4, double d5) {
        this.a = new Vector();
        this.g = null;
        this.h = new Vector();
        this.p = new Vector();
        this.s = null;
        this.t = 0;
        this.u = 0;
        this.w = 0;
        this.x = null;
        this.y = 0;
        this.z = 0;
        this.setDimensionNameSpace((DimensionNameSpace)DefaultDimensionNameSpace.instance());
        this.e = track;
        this.c = new double[4];
        this.d = new double[this.c.length];
        this.c[0] = d2;
        this.c[1] = d3;
        this.c[2] = d4;
        this.c[3] = d5;
        this.j = new Point2D.Double();
        this.f = new Vector();
    }

    public Note(int n2, int n3, int n4, int n5) {
        int n6;
        block9: {
            block8: {
                n6 = A;
                this.a = new Vector();
                this.g = null;
                this.h = new Vector();
                this.p = new Vector();
                this.s = null;
                this.t = 0;
                this.u = 0;
                this.w = 0;
                this.x = null;
                this.y = 0;
                this.z = 0;
                this.setDimensionNameSpace((DimensionNameSpace)DefaultDimensionNameSpace.instance());
                this.setNoteDur(n2);
                if (n2 > 1) break block8;
                this.setNoteHeadType(1);
                if (n6 == 0) break block9;
            }
            this.setNoteHeadType(0);
        }
        this.setNumDots(n4);
        this.setAcc(n5);
        this.setTuplet(n3);
        double d2 = coreDurations[n2];
        if (n3 != 0) {
            d2 = Note.tupletDur(n3, d2);
        }
        switch (n4) {
            case 1: {
                d2 *= 1.5;
                if (n6 == 0) break;
            }
            case 2: {
                d2 = d2 + d2 * 0.5 + d2 * 0.25;
                break;
            }
        }
        d2 = NoteFactory.truncPrecision(d2);
        this.c = new double[4];
        this.d = new double[this.c.length];
        this.c[0] = d2;
        this.c[1] = 60.0;
        this.c[2] = 0.2;
        this.c[3] = d2 * 0.8;
        this.j = new Point2D.Double();
        this.f = new Vector();
    }

    public static Note cloneNote(Note note) {
        Note note2 = null;
        try {
            note2 = (Note)note.clone();
            note2.c(new Vector());
            note2.a(new Vector());
            note2.setGraceNotes(new Vector());
            note2.b(new Vector());
            Note.copyProperties(note, note2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(B[103] + cloneNotSupportedException);
        }
        return note2;
    }

    private void a(Vector vector) {
        this.a = vector;
    }

    private void b(Vector vector) {
        this.p = vector;
    }

    public static void copyProperties(Note note, Note note2) {
        Object object;
        double[] dArray = new double[note.getData().length];
        double[] dArray2 = new double[note.getData().length];
        System.arraycopy(note.getData(), 0, dArray, 0, note.getData().length);
        System.arraycopy(note.getData(), 0, dArray2, 0, note.getData().length);
        note2.setData(dArray);
        note2.d = dArray2;
        note2.setNumDots(note.getNumDots());
        note2.replaceDrawingAnchor(new Point2D.Double(note.getDrawingAnchor().getX(), note.getDrawingAnchor().getY()));
        note2.setTrack(note.getTrack());
        note2.setTuplet(note.getTuplet());
        note2.setDimensionNameSpace(note.getDimensionNameSpace());
        note2.setDynamic(note.getDynamic());
        note2.setSlurredOut(note.getSlurredOut());
        note2.setBeamedOut(note.getBeamedOut());
        note2.setGlissOut(note.getGlissOut());
        note2.setNoteDur(note.getNoteDur());
        note2.setAccPref(note.getAccPref());
        if (note.getCrescOut()) {
            note2.setCrescOut(true);
        } else if (note.getDecrescOut()) {
            note2.setDecrescOut(true);
        } else {
            note2.setCrescOut(false);
        }
        if (note.is8va()) {
            note2.set8va(true);
        } else if (note.is8vb()) {
            note2.set8vb(true);
        } else {
            note2.set8va(false);
        }
        note2.setNoteHeadType(note.getNoteHeadType());
        note2.setIsGraceNote(note.isGraceNote());
        NoteFactory.calcAndSetNoteHeadStemTailInfo(note2, note2.getNoteDur());
        NoteFactory.calcAndSetDurationData(note2, note2.getNoteDur(), note2.getTuplet(), note2.getNumDots());
        note2.a(new Vector());
        Enumeration enumeration = note.getUserBeans().elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            note2.addUserBean(object);
        }
        enumeration = note.getGraceNotes().elements();
        while (enumeration.hasMoreElements()) {
            object = (Note)enumeration.nextElement();
            object = Note.cloneNote(object);
            note2.addGraceNote((Note)object);
        }
        enumeration = note.getMarks().elements();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            note2.addMark((Integer)object);
        }
    }

    public static void setIntervalsToTrackOfHandle(Note note) {
        if (note.isChord()) {
            Enumeration enumeration = note.getIntervals().elements();
            while (enumeration.hasMoreElements()) {
                Note note2 = (Note)enumeration.nextElement();
                note2.setTrack(note.getTrack());
                if (A == 0) continue;
            }
        }
    }

    public boolean isChord() {
        return !this.f.isEmpty();
    }

    public boolean isInterval() {
        return this.g != null;
    }

    public boolean isMonoNote() {
        return !this.isChord() && !this.isInterval();
    }

    public void setGraceNotes(Vector vector) {
        this.h = vector;
    }

    public Note addGraceNote(Note note) {
        this.h.addElement(note);
        note.setGraceNoteHandle(this);
        return note;
    }

    public Note addGraceNote(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) {
        Note note = NoteFactory.makeNote(d2, d3, d4, d5);
        note.setIsGraceNote(true);
        note.setGraceNoteHandle(this);
        note.setAccPref(bl ? 0 : 1);
        note.setBeamedOut(bl2);
        note.setTiedOut(bl4);
        note.setSlurredOut(bl3);
        if (n2 != 0) {
            note.addMark(n2);
        }
        if (bl5) {
            note.addMark(19);
        }
        note.setTrack(this.getTrack());
        NoteFactory.setLevelPitch(note, note.getPitchData());
        this.h.addElement(note);
        return note;
    }

    public void removeGraceNote(Note note) {
        this.h.removeElement(note);
    }

    public Note getGraceNoteHandle() {
        return this.i;
    }

    public void setGraceNoteHandle(Note note) {
        this.i = note;
    }

    public void removeAllGraceNotes() {
        this.h.removeAllElements();
    }

    public Note addInterval(double d2) {
        Note note = Note.cloneNote(this);
        NoteFactory.setLevelPitch(note, d2);
        return this.addInterval(note);
    }

    public Note addInterval(Note note) {
        block21: {
            block20: {
                int n2;
                block19: {
                    block18: {
                        double d2;
                        Note note2;
                        n2 = A;
                        if (this.isRest() || note.isRest() || this.getHandle() != null && this.getHandle().isRest()) {
                            System.err.println(B[3]);
                            return null;
                        }
                        if (this.getDimensionNameSpace() != null) {
                            int n3;
                            double[] dArray = note.getData();
                            double[] dArray2 = new double[this.getDimensionNameSpace().dimension()];
                            if (dArray2.length != this.getData().length) {
                                // empty if block
                            }
                            for (n3 = 0; n3 < Math.min(dArray.length, dArray2.length); ++n3) {
                                dArray2[n3] = dArray[n3];
                                if (n2 == 0) continue;
                            }
                            note.setDimensionNameSpace(this.getDimensionNameSpace());
                            for (n3 = 4; n3 < dArray2.length; ++n3) {
                                if (dArray.length > n3) {
                                    dArray2[n3] = dArray[n3];
                                    if (n2 == 0) continue;
                                }
                                dArray2[n3] = this.getDimensionNameSpace().getDefault(n3);
                                if (n2 == 0) continue;
                            }
                            note.setData(dArray2);
                            double[] dArray3 = new double[dArray2.length];
                            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
                            note.d = dArray3;
                        }
                        double d3 = note.getPitchData();
                        boolean bl = false;
                        Enumeration enumeration = this.getIntervals().elements();
                        while (enumeration.hasMoreElements()) {
                            note2 = (Note)enumeration.nextElement();
                            d2 = note2.getPitchData();
                            boolean bl2 = bl = d2 == d3;
                            if ((!bl || n2 != 0) && n2 == 0) continue;
                        }
                        boolean bl3 = bl = bl || d3 == this.getPitchData();
                        if (bl) {
                            if (DBUG) {
                                System.err.println(B[1] + d3);
                                System.err.println(B[2] + note);
                                System.err.print(B[0] + this.getPitchData() + " ");
                                enumeration = this.getIntervals().elements();
                                while (enumeration.hasMoreElements()) {
                                    note2 = (Note)enumeration.nextElement();
                                    d2 = note2.getPitchData();
                                    System.err.print(d2 + " ");
                                    if (n2 == 0) continue;
                                }
                                System.err.println("");
                            }
                            return null;
                        }
                        this.f.addElement(note);
                        note.setHandle(this);
                        note.setDynamic(this.getDynamic());
                        note.setTrack(this.getTrack());
                        note.setSlurredOut(this.getSlurredOut());
                        note.setMark(this.getMark());
                        note.setBeamedOut(this.getBeamedOut());
                        if (!this.getCrescOut()) break block18;
                        note.setCrescOut(true);
                        if (n2 == 0) break block19;
                    }
                    if (this.getDecrescOut()) {
                        note.setDecrescOut(true);
                    }
                }
                if (!this.is8va()) break block20;
                note.set8va(true);
                if (n2 == 0) break block21;
            }
            if (this.is8vb()) {
                note.set8vb(true);
            }
        }
        return note;
    }

    public void removeInterval(Note note) {
        this.f.removeElement(note);
    }

    public void clearIntervals() {
        this.f.removeAllElements();
    }

    public void setHandle(Note note) {
        this.g = note;
    }

    public Note getHandle() {
        return this.g;
    }

    public Vector getIntervals() {
        return this.f;
    }

    private void c(Vector vector) {
        this.f = vector;
    }

    public int getNoteIndex() {
        if (this.isInterval()) {
            return this.getTrack().getChildren().indexOf(this.getHandle());
        }
        return this.getTrack().getChildren().indexOf(this);
    }

    public Note nextNote() {
        if (this.getNoteIndex() < this.getTrack().size() - 1) {
            return this.getTrack().getNote(this.getNoteIndex() + 1);
        }
        int n2 = this.getTrack().getTrackIndex();
        int n3 = this.getTrack().getStaff().getStaffIndex();
        int n4 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
        if (n4 == this.getScore().size() - 1) {
            return null;
        }
        Track track = this.getScore().getMeasure(n4 + 1).getStaff(n3).getTrack(n2);
        if (track.isEmpty()) {
            return null;
        }
        return track.getNote(0);
    }

    public Note prevNote() {
        if (this.getNoteIndex() > 0) {
            return this.getTrack().getNote(this.getNoteIndex() - 1);
        }
        int n2 = this.getTrack().getTrackIndex();
        int n3 = this.getTrack().getStaff().getStaffIndex();
        int n4 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
        if (n4 == 0) {
            return null;
        }
        Track track = this.getScore().getMeasure(n4 - 1).getStaff(n3).getTrack(n2);
        if (track.isEmpty()) {
            return null;
        }
        return track.getNote(track.size() - 1);
    }

    public boolean isRest() {
        return this.getPitchData() == 0.0;
    }

    public boolean isBeamable() {
        return !this.isRest();
    }

    public double getDurationData() {
        return this.c[0];
    }

    public double getPitchData() {
        return this.c[1];
    }

    public double getVelData() {
        return this.c[2];
    }

    public double getHoldData() {
        return this.c[3];
    }

    public void setDurationData(double d2) {
        this.c[0] = d2;
    }

    public void setPitchData(double d2) {
        this.c[1] = d2;
    }

    public void setVelData(double d2) {
        this.c[2] = d2;
    }

    public void setHoldData(double d2) {
        this.c[3] = d2;
    }

    public void setData(double d2, double d3, double d4, double d5) {
        this.c[0] = d2;
        this.c[1] = d3;
        this.c[2] = d4;
        this.c[3] = d5;
    }

    public boolean isNoteheadVisible() {
        return 0 == (this.l >> 6 & 1);
    }

    public void setNoteheadVisible(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.l = (byte)(this.l & 0xBF | n2 << 6);
    }

    public boolean isStemVisible() {
        return (this.l >> 4 & 1) == 0;
    }

    public void setStemVisible(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.l = (byte)(this.l & 0xEF | n2 << 4);
    }

    public void setSelected(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.l = (byte)(this.l & 0xFD | n2 << 1);
    }

    public boolean getSelected() {
        return 1 == (this.l >> 1 & 1);
    }

    public int getStemInfo() {
        return this.l >> 2 & 3;
    }

    public void setStemInfo(int n2) {
        this.l = (byte)(this.l & 0xF3 | n2 << 2);
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            ((Note)enumeration.nextElement()).setStemInfo(n2);
        }
    }

    public boolean getStemInfoOverride() {
        return 1 == (this.l >> 5 & 1);
    }

    public void setStemInfoOverride(int n2) {
        this.l = (byte)(this.l & 0xDF | 0x20);
        this.setStemInfo(n2);
    }

    public void clearStemInfoOverride() {
        this.l = (byte)(this.l & 0xDF | 0);
    }

    public void setOverflow(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.l = (byte)(this.l & 0xFE | n2);
    }

    public boolean getOverflow() {
        return 1 == (this.l & 1);
    }

    public static double getNoteDurationAsPerformanceTime(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new NumberOutOfRangeException(B[101] + n2 + B[102]);
        }
        return coreDurations[n2];
    }

    public double getNoteDurationAsPerformanceTime() {
        return coreDurations[this.getNoteDur()];
    }

    public static int getIndexOfCoreDuration(double d2) {
        int n2 = A;
        int n3 = -1;
        for (int i2 = 0; i2 < coreDurations.length; ++i2) {
            if (coreDurations[i2] != d2) continue;
            n3 = i2;
            if (n2 == 0) break;
            if (n2 == 0) continue;
        }
        return n3;
    }

    public int getNoteDur() {
        return this.m & 0xF;
    }

    public int getCoreDuration() {
        return this.getNoteDur();
    }

    public void setNoteDur(int n2) {
        this.m = (byte)(this.m & 0xF0 | n2);
    }

    public void setNoteHeadType(int n2) {
        this.m = (byte)(this.m & 0xF | n2 << 4);
    }

    public int getNoteHeadType() {
        return this.m >> 4 & 0xF;
    }

    public int getAcc() {
        return this.k & 0xF;
    }

    public void setAcc(int n2) {
        this.k = (byte)(this.k & 0xF0 | n2);
    }

    public int getAccPref() {
        return this.k >> 4 & 1;
    }

    public void setAccPref(int n2) {
        this.k = (byte)(this.k & 0xEF | n2 << 4);
    }

    public boolean getAccHidden() {
        return 1 == (this.k >> 5 & 1);
    }

    public void setAccHidden(boolean bl) {
        int n2;
        block3: {
            block2: {
                if (!bl) break block2;
                n2 = 1;
                if (A == 0) break block3;
            }
            n2 = 0;
        }
        this.k = (byte)(this.k & 0xDF | n2 << 5);
    }

    public boolean getAltEnharmonicSpelling() {
        return 1 == (this.k >> 6 & 1);
    }

    public void setAltEnharmonicSpelling(boolean bl) {
        int n2;
        block3: {
            block2: {
                if (!bl) break block2;
                n2 = 1;
                if (A == 0) break block3;
            }
            n2 = 0;
        }
        this.k = (byte)(this.k & 0xBF | n2 << 6);
    }

    public static String accToString(int n2) {
        int n3 = A;
        String string = B[105] + n2;
        switch (n2) {
            case 0: {
                string = B[110];
                if (n3 == 0) break;
            }
            case 1: {
                string = B[108];
                if (n3 == 0) break;
            }
            case 2: {
                string = B[109];
                if (n3 == 0) break;
            }
            case 3: {
                string = B[106];
                if (n3 == 0) break;
            }
            case 4: {
                string = B[104];
                if (n3 == 0) break;
            }
            case 5: {
                string = B[107];
            }
        }
        return string;
    }

    public int getNumDots() {
        return this.n & 3;
    }

    public void setNumDots(int n2) {
        this.n = (byte)(this.n & 0xFC | n2);
    }

    public boolean getBeamedOut() {
        return 0 != (this.n & 0x80);
    }

    public boolean getGlissOut() {
        return 0 != (this.o & 0x80);
    }

    public int getDynamic() {
        return this.n >> 3 & 0xF;
    }

    public void setDynamic(int n2) {
        n2 = Limits.clipTo((int)n2, (int)0, (int)8);
        this.n = (byte)(this.n & 0x87 | n2 << 3);
    }

    public void setMark(int n2) {
        this.addMark(n2);
    }

    public void addMark(int n2) {
        if (n2 == 0) {
            this.p.removeAllElements();
        } else {
            Integer n3 = new Integer(n2);
            if (!this.p.contains(n3)) {
                this.p.addElement(n3);
            }
        }
    }

    public int getMark() {
        if (this.p.size() == 0) {
            return 0;
        }
        return (Integer)this.p.elementAt(0);
    }

    public Vector getMarks() {
        return this.p;
    }

    public static String dynamicToString(int n2) {
        int n3 = A;
        String string = "";
        switch (n2) {
            case 0: {
                string = B[117];
                if (n3 == 0) break;
            }
            case 1: {
                string = B[112];
                if (n3 == 0) break;
            }
            case 2: {
                string = B[113];
                if (n3 == 0) break;
            }
            case 3: {
                string = "p";
                if (n3 == 0) break;
            }
            case 4: {
                string = B[115];
                if (n3 == 0) break;
            }
            case 5: {
                string = B[114];
                if (n3 == 0) break;
            }
            case 6: {
                string = "f";
                if (n3 == 0) break;
            }
            case 7: {
                string = B[111];
                if (n3 == 0) break;
            }
            case 8: {
                string = B[116];
            }
        }
        return string;
    }

    public static String markToString(int n2) {
        int n3 = A;
        String string = "";
        switch (n2) {
            case 0: {
                string = B[65];
                if (n3 == 0) break;
            }
            case 1: {
                string = B[59];
                if (n3 == 0) break;
            }
            case 2: {
                string = B[62];
                if (n3 == 0) break;
            }
            case 3: {
                string = B[61];
                if (n3 == 0) break;
            }
            case 4: {
                string = B[60];
                if (n3 == 0) break;
            }
            case 5: {
                string = B[58];
                if (n3 == 0) break;
            }
            case 6: {
                string = B[57];
                if (n3 == 0) break;
            }
            case 7: {
                string = B[66];
                if (n3 == 0) break;
            }
            case 8: {
                string = B[73];
                if (n3 == 0) break;
            }
            case 9: {
                string = B[63];
                if (n3 == 0) break;
            }
            case 10: {
                string = B[55];
                if (n3 == 0) break;
            }
            case 11: {
                string = B[69];
                if (n3 == 0) break;
            }
            case 12: {
                string = B[74];
                if (n3 == 0) break;
            }
            case 13: {
                string = B[70];
                if (n3 == 0) break;
            }
            case 14: {
                string = B[67];
                if (n3 == 0) break;
            }
            case 15: {
                string = B[72];
                if (n3 == 0) break;
            }
            case 16: {
                string = B[68];
                if (n3 == 0) break;
            }
            case 17: {
                string = B[64];
                if (n3 == 0) break;
            }
            case 18: {
                string = B[71];
                if (n3 == 0) break;
            }
            case 19: {
                string = B[56];
            }
        }
        return string;
    }

    public void setBeamedOut(boolean bl) {
        if (this.isInterval()) {
            this.getHandle().setBeamedOut(bl);
        } else {
            this.a(bl);
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                ((Note)enumeration.nextElement()).a(bl);
            }
        }
    }

    private void a(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 128;
        }
        this.n = (byte)(this.n & 0x7F | n2);
    }

    public void setGlissOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 128;
        }
        this.o = (byte)(this.o & 0x7F | n2);
    }

    public void setTiedOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.n = (byte)(this.n & 0xFB | n2 << 2);
    }

    public boolean getTiedOut() {
        return 1 == (this.n >> 2 & 1);
    }

    public void setSlurredOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.o = (byte)(this.o & 0xEF | n2 << 4);
    }

    public boolean getSlurredOut() {
        return 1 == (this.o >> 4 & 1);
    }

    public void setVisible(boolean bl) {
        int n2 = 1;
        if (bl) {
            n2 = 0;
        }
        this.o = (byte)(this.o & 0xDF | n2 << 5);
    }

    public boolean isVisible() {
        return 0 == (this.o >> 5 & 1);
    }

    public boolean isGraceNote() {
        return 1 == (this.o >> 6 & 1);
    }

    public void setIsGraceNote(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.o = (byte)(this.o & 0xBF | n2 << 6);
    }

    public Vector getGraceNotes() {
        return this.h;
    }

    public void setCrescOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.o = (byte)(this.o & 0xFC | n2);
    }

    public void setDecrescOut(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 3;
        }
        this.o = (byte)(this.o & 0xFC | n2);
    }

    public boolean getCrescOut() {
        return (this.o & 1) == 1 && (this.o & 2) == 0;
    }

    public boolean getDecrescOut() {
        return (this.o & 1) == 1 && (this.o & 2) == 2;
    }

    public void set8vaOut(boolean bl) {
        this.set8va(bl);
    }

    public void set8vbOut(boolean bl) {
        this.set8vb(bl);
    }

    public void set8va(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 4;
        }
        this.o = (byte)(this.o & 0xF3 | n2);
    }

    public void set8vb(boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 12;
        }
        this.o = (byte)(this.o & 0xF3 | n2);
    }

    public boolean get8vaOut() {
        return this.is8va();
    }

    public boolean get8vbOut() {
        return this.is8vb();
    }

    public boolean is8va() {
        return (this.o >> 2 & 3) == 1;
    }

    public boolean is8vb() {
        return (this.o >> 2 & 3) == 3;
    }

    public boolean startOf8va() {
        Note note = this.prevNote();
        return this.is8va() && (note == null || !note.is8va());
    }

    public boolean endOf8va() {
        Note note = this.nextNote();
        return this.is8va() && (note == null || !note.is8va());
    }

    public boolean startOf8vb() {
        Note note = this.prevNote();
        return this.is8vb() && (note == null || !note.is8vb());
    }

    public boolean endOf8vb() {
        Note note = this.nextNote();
        return this.is8vb() && (note == null || !note.is8vb());
    }

    Note a(double d2) {
        boolean bl;
        int n2 = A;
        Note note = this;
        boolean bl2 = bl = d2 == this.getPitchData();
        if (!bl && this.isChord()) {
            Enumeration enumeration = this.getIntervals().elements();
            while (enumeration.hasMoreElements()) {
                Note note2 = (Note)enumeration.nextElement();
                if (note2.getPitchData() == d2) {
                    bl = true;
                    note = note2;
                    if (n2 == 0) break;
                }
                if (n2 == 0) continue;
            }
        }
        if (bl) {
            return note;
        }
        return null;
    }

    public boolean getTiedIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        Note note2 = note.a(this.getPitchData());
        return note2 != null && note2.getTiedOut();
    }

    public boolean getCrescIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getCrescOut();
    }

    public boolean getDecrescIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getDecrescOut();
    }

    public boolean startOfCresc() {
        Note note = this.prevNote();
        return this.getCrescOut() && (note == null || !note.getCrescOut());
    }

    public boolean endOfCresc() {
        Note note = this.prevNote();
        return !this.getCrescOut() && note != null && note.getCrescOut();
    }

    public boolean startOfDecresc() {
        Note note = this.prevNote();
        return this.getDecrescOut() && (note == null || !note.getDecrescOut());
    }

    public boolean endOfDecresc() {
        Note note = this.prevNote();
        return !this.getDecrescOut() && note != null && note.getDecrescOut();
    }

    public boolean getSlurredIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.getSlurredOut();
    }

    public boolean get8vaIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.is8va();
    }

    public boolean get8vbIn() {
        Note note = this.prevNote();
        if (note == null) {
            return false;
        }
        return note.is8vb();
    }

    public void setLevel(int n2) {
        this.r = (byte)n2;
    }

    public int getLevel() {
        return this.r & 0xFF;
    }

    public void setDrawingAnchor(Point2D point2D) {
        this.j.setLocation(point2D);
    }

    public void replaceDrawingAnchor(Point2D point2D) {
        this.j = point2D;
    }

    public Point2D getDrawingAnchor() {
        return this.j;
    }

    public void setNumTails(int n2) {
    }

    public int getNumTails() {
        return Math.max(0, this.getNoteDur() - 2);
    }

    public void setStaffIndex(int n2) {
        this.y = n2;
    }

    public int getStaffIndex() {
        if (this.getTrack() != null && this.getTrack().getStaff() != null) {
            return this.getTrack().getStaff().getStaffIndex();
        }
        return this.y;
    }

    public void setMeasureIndex(int n2) {
        this.z = n2;
    }

    public int getMeasureIndex() {
        if (this.getTrack() != null && this.getTrack().getStaff() != null) {
            return this.getTrack().getStaff().getMeasure().getMeasureIndex();
        }
        return this.z;
    }

    public int getTuplet() {
        return this.q & 0xFF;
    }

    public void setTuplet(int n2) {
        this.q = (byte)(n2 & 0xFF);
    }

    public Track getTrack() {
        return this.e;
    }

    public Score getScore() {
        if (this.getTrack() == null) {
            return null;
        }
        return this.getTrack().getScore();
    }

    public void setTrack(Track track) {
        this.e = track;
    }

    public double[] getData() {
        return this.c;
    }

    public double[] getDataCopy() {
        double[] dArray = new double[this.getData().length];
        System.arraycopy(this.getData(), 0, dArray, 0, dArray.length);
        return dArray;
    }

    public void setData(double[] dArray) {
        this.c = dArray;
    }

    public void setData(int n2, double d2) {
        this.c[n2] = d2;
    }

    public double getData(int n2) {
        return this.c[n2];
    }

    double a() {
        double d2;
        int n2 = A;
        Note note = this;
        double d3 = note.getPitchData();
        double d4 = d2 = this.getDurationData();
        double d5 = this.getHoldData();
        double d6 = note.getTrack().getStaff().getMeasure().getTimeStretch();
        while (note != null && note.getTiedOut()) {
            Note note2;
            block6: {
                block5: {
                    note2 = note.nextNote();
                    if (note2 == null) break block5;
                    note = note2.a(d3);
                    if (n2 == 0) break block6;
                }
                note = null;
            }
            if (note != null) {
                double d7 = note2.getTrack().getStaff().getMeasure().getTimeStretch();
                double d8 = d7 / d6;
                d4 = note.getDurationData() * d8;
                d5 = note.getHoldData() * d8;
                d2 += d4;
            }
            if (n2 == 0) continue;
        }
        d2 -= d4;
        return d2 += d5;
    }

    private void b() {
        boolean bl;
        block9: {
            block8: {
                double d2;
                this.d = new double[this.c.length];
                System.arraycopy(this.c, 0, this.d, 0, this.c.length);
                if (Note.performExpressionMarks() && (this.getMark() == 2 || this.getMark() == 5)) {
                    d2 = 0.5;
                    this.d[3] = d2 * this.d[0];
                }
                if (Note.performExpressionMarks() && this.getMark() == 3) {
                    d2 = 0.95;
                    this.d[3] = d2 * this.d[0];
                }
                if (!this.is8va()) break block8;
                this.d[1] = this.d[1] + 12.0;
                if (A == 0) break block9;
            }
            if (this.is8vb()) {
                this.d[1] = this.d[1] - 12.0;
            }
        }
        if (!(bl = this.getTiedIn()) && this.getTiedOut()) {
            double d3;
            this.d[3] = d3 = this.a();
        }
        if (this.isInterval()) {
            this.d[0] = 0.0;
        }
    }

    public static boolean performExpressionMarks() {
        return v;
    }

    public static void setPerformExpressionMarks(boolean bl) {
        v = bl;
    }

    public double[] getPerformanceData() {
        this.b();
        return this.d;
    }

    public double[] getPerformanceDataCopy() {
        double[] dArray = new double[this.getData().length];
        System.arraycopy(this.getPerformanceData(), 0, dArray, 0, dArray.length);
        return dArray;
    }

    void c() {
        block5: {
            block4: {
                double[] dArray = this.getPerformanceData();
                if (this.isInterval()) {
                    JMSL.out.print(B[52]);
                }
                JMSL.out.print(B[50]);
                JMSL.printDoubleArray((double[])dArray);
                if (this.getTrack() == null) break block4;
                int n2 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
                int n3 = this.getTrack().getStaff().getStaffIndex();
                int n4 = this.getTrack().getTrackIndex();
                JMSL.out.println(B[54] + n2 + B[51] + n3 + B[49] + n4);
                JMSL.out.println(B[48] + this.getLevel());
                if (A == 0) break block5;
            }
            JMSL.out.println(B[53]);
        }
    }

    public double play(double d2, Composable composable, Instrument instrument) {
        double d3;
        double[] dArray;
        int n2;
        block6: {
            n2 = A;
            dArray = this.getPerformanceData();
            d3 = composable.timeStretch();
            if (instrument == null) break block6;
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                block8: {
                    Note note;
                    block7: {
                        note = (Note)enumeration.nextElement();
                        if (!note.getTiedIn() || note.getVelData() == 0.0) break block7;
                        instrument.update(d2, d3, note.getPerformanceData());
                        if (n2 == 0) break block8;
                    }
                    instrument.play(d2, d3, note.getPerformanceData());
                }
                if (n2 == 0) continue;
            }
            double d4 = this.getTiedIn() && this.getVelData() != 0.0 ? instrument.update(d2, d3, dArray) : instrument.play(d2, d3, dArray);
            return d4;
        }
        if (DBUG) {
            this.c();
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                ((Note)enumeration.nextElement()).c();
                if (n2 == 0) continue;
            }
        }
        return d2 + dArray[0] * d3;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block13: {
            block12: {
                int n2;
                int n3;
                block10: {
                    block11: {
                        block9: {
                            n3 = A;
                            stringBuffer = new StringBuffer();
                            stringBuffer.append(B[90]);
                            if (!this.isChord()) break block9;
                            stringBuffer.append(B[87] + this.getIntervals().size() + B[82]);
                            if (n3 == 0) break block10;
                        }
                        if (!this.isInterval()) break block11;
                        stringBuffer.append(B[100]);
                        if (n3 == 0) break block10;
                    }
                    stringBuffer.append(B[96]);
                }
                if (this.getTrack() != null) {
                    n2 = this.getTrack().getStaff().getMeasure().getMeasureIndex();
                    int n4 = this.getTrack().getStaff().getStaffIndex();
                    stringBuffer.append(B[86] + n2 + B[97] + n4 + "\n");
                }
                stringBuffer.append(B[89]);
                for (n2 = 0; n2 < this.c.length; ++n2) {
                    stringBuffer.append(this.c[n2]);
                    if (n2 >= this.c.length - 1) continue;
                    stringBuffer.append(B[91]);
                    if (n3 == 0) continue;
                }
                stringBuffer.append(B[92]);
                stringBuffer.append(B[77] + this.getNumDots() + B[91]);
                stringBuffer.append(B[84] + this.getNumTails() + B[91]);
                stringBuffer.append(B[88]);
                if (this.getNoteHeadType() != 0) break block12;
                stringBuffer.append(B[83]);
                if (n3 == 0) break block13;
            }
            stringBuffer.append(B[99]);
        }
        if (this.getTuplet() != 0) {
            stringBuffer.append(B[95] + this.getTuplet() + B[91]);
        }
        stringBuffer.append(B[98] + coreDurationNames[this.getNoteDur()] + B[91]);
        stringBuffer.append(B[81] + this.getLevel() + "\n");
        stringBuffer.append(B[76] + this.getTiedOut() + "\n");
        stringBuffer.append(B[79] + Note.dynamicToString(this.getDynamic()) + "\n");
        stringBuffer.append(B[78] + this.getSlurredOut() + "\n");
        stringBuffer.append(B[94] + this.getCrescOut() + "\n");
        stringBuffer.append(B[80] + this.getDecrescOut() + "\n");
        stringBuffer.append(B[75] + this.is8va() + "\n");
        stringBuffer.append(B[93] + this.is8vb() + "\n");
        stringBuffer.append(B[85] + Note.markToString(this.getMark()));
        return stringBuffer.toString();
    }

    public void render(Graphics graphics, double d2) {
        block4: {
            block3: {
                int n2 = A;
                for (int i2 = 0; i2 < this.getGraceNotes().size(); ++i2) {
                    Note note = (Note)this.getGraceNotes().elementAt(i2);
                    NoteRenderer.render(graphics, d2 * GRACE_NOTE_SIZE_SCALER, note);
                    if (n2 == 0) continue;
                }
                if (!this.isChord()) break block3;
                NoteRenderer.b(graphics, d2, this);
                if (n2 == 0) break block4;
            }
            NoteRenderer.render(graphics, d2, this);
        }
    }

    public static double tupletDur(int n2, double d2) {
        double d3 = Math.pow(2.0, JMSLMath.highestPowerOfTwoLessThan((int)n2)) * d2;
        return d3 / (double)n2;
    }

    public static void resortChord(Note note) {
        Note note2;
        Note note3;
        int n2;
        block6: {
            block5: {
                n2 = A;
                note3 = Note.getRoot(note);
                if (note.getHandle() == null) break block5;
                note2 = note.getHandle();
                if (n2 == 0) break block6;
            }
            note2 = note;
        }
        if (note3.getPitchData() == note2.getPitchData()) {
            Note.d(note3.getIntervals());
            return;
        }
        note3.setHandle(null);
        note3.addInterval(note2);
        note2.removeInterval(note3);
        Object object = note2.getIntervals().elements();
        while (object.hasMoreElements()) {
            note3.addInterval((Note)object.nextElement());
            if (n2 == 0) continue;
        }
        note2.clearIntervals();
        Note.d(note3.getIntervals());
        object = note3.getTrack();
        int n3 = object.getChildren().indexOf(note2);
        object.getChildren().removeElement(note2);
        ((Track)((Object)object)).insertNote(note3, n3);
    }

    public static Note[] getSortedChord(Note note) {
        int n2 = 1;
        if (note.isChord()) {
            n2 += note.getIntervals().size();
        }
        Note[] noteArray = new Note[n2];
        noteArray[0] = note;
        int n3 = 1;
        Enumeration enumeration = note.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            noteArray[n3++] = (Note)enumeration.nextElement();
            if (A == 0) continue;
        }
        Note.a(noteArray);
        return noteArray;
    }

    static void d(Vector vector) {
        int n2 = A;
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i2 = 0; i2 < vector.size() - 1; ++i2) {
                Note note = (Note)vector.elementAt(i2);
                Note note2 = (Note)vector.elementAt(i2 + 1);
                if (!(note.getPitchData() > note2.getPitchData())) continue;
                bl = false;
                Note note3 = note;
                vector.setElementAt((Note)vector.elementAt(i2 + 1), i2);
                vector.setElementAt(note3, i2 + 1);
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }

    static void a(Note[] noteArray) {
        int n2 = A;
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i2 = 0; i2 < noteArray.length - 1; ++i2) {
                Note note = noteArray[i2];
                Note note2 = noteArray[i2 + 1];
                if (!(note.getPitchData() > note2.getPitchData())) continue;
                bl = false;
                Note note3 = note;
                noteArray[i2] = noteArray[i2 + 1];
                noteArray[i2 + 1] = note3;
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }

    public static Note getRoot(Note note) {
        Note note2;
        int n2;
        block6: {
            block5: {
                n2 = A;
                if (note.getHandle() == null) break block5;
                note2 = note.getHandle();
                if (n2 == 0) break block6;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() < note2.getPitchData()) {
                note2 = note3;
            }
            if (n2 == 0) continue;
        }
        return note2;
    }

    public static Note getHighest(Note note) {
        Note note2;
        int n2;
        block7: {
            block6: {
                n2 = A;
                if (note.isMonoNote()) {
                    return note;
                }
                if (note.getHandle() == null) break block6;
                note2 = note.getHandle();
                if (n2 == 0) break block7;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() > note2.getPitchData()) {
                note2 = note3;
            }
            if (n2 == 0) continue;
        }
        return note2;
    }

    public static Note getLowest(Note note) {
        Note note2;
        int n2;
        block7: {
            block6: {
                n2 = A;
                if (note.isMonoNote()) {
                    return note;
                }
                if (note.getHandle() == null) break block6;
                note2 = note.getHandle();
                if (n2 == 0) break block7;
            }
            note2 = note;
        }
        Enumeration enumeration = note2.getIntervals().elements();
        while (enumeration.hasMoreElements()) {
            Note note3 = (Note)enumeration.nextElement();
            if (note3.getPitchData() < note2.getPitchData()) {
                note2 = note3;
            }
            if (n2 == 0) continue;
        }
        return note2;
    }

    public void writeXML(PrintWriter printWriter) throws IOException {
        this.writeXML(printWriter, true);
    }

    public void writeXML(PrintWriter printWriter, boolean bl) throws IOException {
        XMLString xMLString;
        block38: {
            block39: {
                int n2;
                block37: {
                    int n3;
                    CharSequence charSequence;
                    block36: {
                        block35: {
                            String string;
                            block34: {
                                block33: {
                                    String string2;
                                    block32: {
                                        block31: {
                                            block29: {
                                                block30: {
                                                    block28: {
                                                        n2 = A;
                                                        xMLString = new XMLString();
                                                        if (!this.isInterval()) break block28;
                                                        xMLString.startElement(B[5], false);
                                                        if (n2 == 0) break block29;
                                                    }
                                                    if (!this.isGraceNote()) break block30;
                                                    xMLString.startElement(B[14], false);
                                                    if (n2 == 0) break block29;
                                                }
                                                xMLString.startElement(B[42], false);
                                            }
                                            xMLString.addAttribute(B[38], this.getNoteDur() + "");
                                            xMLString.addAttribute(B[12], this.getTuplet() + "");
                                            xMLString.addAttribute(B[26], this.getNumDots() + "");
                                            xMLString.addAttribute(B[37], this.getAcc() + "");
                                            xMLString.addAttribute(B[24], this.getDurationData() + "");
                                            xMLString.addAttribute(B[7], this.getPitchData() + "");
                                            xMLString.addAttribute(B[15], this.getVelData() + "");
                                            xMLString.addAttribute(B[20], this.getHoldData() + "");
                                            xMLString.addAttribute(B[19], this.getBeamedOut() + "");
                                            xMLString.addAttribute(B[45], this.getGlissOut() + "");
                                            xMLString.addAttribute(B[28], this.getTiedOut() + "");
                                            xMLString.addAttribute(B[30], this.getAccPref() + "");
                                            xMLString.addAttribute(B[8], this.getAltEnharmonicSpelling() + "");
                                            xMLString.addAttribute(B[44], this.getDynamic() + "");
                                            xMLString.addAttribute(B[43], this.getSlurredOut() + "");
                                            xMLString.addAttribute(B[10], this.isGraceNote() + "");
                                            string2 = B[13];
                                            if (!this.getCrescOut()) break block31;
                                            string2 = B[33];
                                            if (n2 == 0) break block32;
                                        }
                                        if (this.getDecrescOut()) {
                                            string2 = B[11];
                                        }
                                    }
                                    xMLString.addAttribute(B[29], string2 + "");
                                    string = B[13];
                                    if (!this.is8va()) break block33;
                                    string = B[4];
                                    if (n2 == 0) break block34;
                                }
                                if (this.is8vb()) {
                                    string = B[16];
                                }
                            }
                            xMLString.addAttribute(B[35], string + "");
                            if (this.getMark() != 0) break block35;
                            xMLString.addAttribute(B[40], this.getMark() + "");
                            if (n2 == 0) break block36;
                        }
                        charSequence = new StringBuffer();
                        for (n3 = 0; n3 < this.getMarks().size(); ++n3) {
                            int n4 = (Integer)this.getMarks().elementAt(n3);
                            charSequence.append(n4 + "");
                            if (n3 >= this.getMarks().size() - 1) continue;
                            charSequence.append("_");
                            if (n2 == 0) continue;
                        }
                        xMLString.addAttribute(B[40], charSequence.toString());
                    }
                    xMLString.addAttribute(B[21], this.getTextOffsetX() + "");
                    xMLString.addAttribute(B[22], this.getTextOffsetY() + "");
                    xMLString.addAttribute(B[39], this.getNoteHeadType() + "");
                    xMLString.addAttribute(B[9], this.isVisible() + "");
                    xMLString.addAttribute(B[31], this.isNoteheadVisible() + "");
                    xMLString.addAttribute(B[25], this.isStemVisible() + "");
                    xMLString.addAttribute(B[18], this.getStemInfoOverride() + "");
                    xMLString.addAttribute(B[6], this.getStemInfo() + "");
                    if (this.x != null) {
                        xMLString.addAttribute(B[17], this.x.getRed() + "");
                        xMLString.addAttribute(B[27], this.x.getGreen() + "");
                        xMLString.addAttribute(B[23], this.x.getBlue() + "");
                    }
                    charSequence = "";
                    if (this.getText() != null) {
                        charSequence = XMLString.encodeQuotes((String)this.getText());
                    }
                    xMLString.addAttribute(B[41], (String)charSequence);
                    xMLString.endElement(null, true);
                    printWriter.println(xMLString);
                    if (this.b != null && this.b.dimension() > 4) {
                        for (n3 = 4; n3 < this.b.dimension(); ++n3) {
                            xMLString = new XMLString();
                            xMLString.startElement(B[46], false);
                            xMLString.addAttribute(B[34], n3 + "");
                            xMLString.addAttribute(B[32], this.getDoubleArray()[n3] + "");
                            xMLString.addAttribute(B[47], this.b.getDimensionName(n3));
                            xMLString.endElement(null, false);
                            printWriter.println(xMLString);
                            if (n2 == 0) continue;
                        }
                    }
                    if (this.isChord() && bl) {
                        Enumeration enumeration = this.f.elements();
                        while (enumeration.hasMoreElements()) {
                            Note note = (Note)enumeration.nextElement();
                            note.writeXML(printWriter);
                            if (n2 == 0) continue;
                        }
                    }
                    if (this.getGraceNotes().size() > 0) {
                        Enumeration enumeration = this.getGraceNotes().elements();
                        while (enumeration.hasMoreElements()) {
                            Note note = (Note)enumeration.nextElement();
                            note.writeXML(printWriter);
                            if (n2 == 0) continue;
                        }
                    }
                    if (this.a != null) {
                        Enumeration enumeration = this.a.elements();
                        while (enumeration.hasMoreElements()) {
                            Object e2 = enumeration.nextElement();
                            SimpleXMLSaver simpleXMLSaver = new SimpleXMLSaver(e2, B[36]);
                            simpleXMLSaver.writeXML(printWriter);
                            if (n2 == 0) continue;
                        }
                    }
                    xMLString = new XMLString();
                    if (this.isInterval() || this.isGraceNote()) break block37;
                    xMLString.endElement(B[42], true);
                    if (n2 == 0) break block38;
                }
                if (!this.isGraceNote()) break block39;
                xMLString.endElement(B[14], true);
                if (n2 == 0) break block38;
            }
            xMLString.endElement(B[5], true);
        }
        printWriter.println(xMLString);
    }

    public void setDimensionNameSpace(DimensionNameSpace dimensionNameSpace) {
        this.b = dimensionNameSpace;
    }

    public DimensionNameSpace getDimensionNameSpace() {
        return this.b;
    }

    public double[] getDoubleArray() {
        return this.getData();
    }

    public void setDoubleArray(double[] dArray) {
        this.c = new double[dArray.length];
        this.d = new double[dArray.length];
        System.arraycopy(dArray, 0, this.c, 0, this.c.length);
    }

    public static boolean firstNoteOfLine(Note note) {
        if (note == null || note.getTrack() == null || note.getTrack().getStaff() == null || note.getTrack().getStaff().getMeasure() == null) {
            return false;
        }
        return note.getTrack().getStaff().getMeasure().isBeginningOfLine() && note.getNoteIndex() == 0;
    }

    public static boolean lastNoteOfLine(Note note) {
        if (note == null || note.getTrack() == null || note.getTrack().getStaff() == null || note.getTrack().getStaff().getMeasure() == null) {
            return false;
        }
        boolean bl = note.getTrack().getStaff().getMeasure().f();
        boolean bl2 = note.getNoteIndex() == note.getTrack().size() - 1;
        return bl && bl2;
    }

    public void setText(String string) {
        this.s = string;
    }

    public String getText() {
        return this.s;
    }

    public void setTextOffsetX(int n2) {
        this.t = n2;
    }

    public int getTextOffsetX() {
        return this.t;
    }

    public void setTextOffsetY(int n2) {
        this.u = n2;
    }

    public int getTextOffsetY() {
        return this.u;
    }

    public static void main(String[] stringArray) {
    }

    public Vector getUserBeans() {
        return this.a;
    }

    public void addUserBean(Object object) {
        this.a.addElement(object);
    }

    public void removeUserBean(Object object) {
        this.a.removeElement(object);
    }

    public int getAccidentalOffset() {
        return this.w;
    }

    public void setAccidentalOffset(int n2) {
        this.w = n2;
    }

    public Color getNoteheadColor() {
        return this.x;
    }

    public void setNoteheadColor(Color color) {
        this.x = color;
    }

    static {
        String[] stringArray = new String[118];
        Object var0 = null;
        copyright = Note.z(Note.z("X1W+YR9O&\u000b\u0013\u001d\u000er\u0019\u000bn\u0017reR=LroR:L=]H5^~\u000bZ2KrYR9O&X\u001b,B!NI(B6"));
        var0 = null;
        stringArray[0] = Note.z(Note.z("u1S7X\u001b7Ir_S7TrHS1U6\u0011\u001b"));
        var0 = null;
        stringArray[1] = Note.z(Note.z("l\u001fu\u001cbu\u0019\u0006s\n\u001b\u001fS&NV.S7O\u001b*HrJ_:\u00076^K2N1JO;\u0007<DO;\u0007&D\u001b=O=Y_\u007f\u0006s\n\u001b.N&HSc"));
        var0 = null;
        stringArray[2] = Note.z(Note.z("t8A7E_7I5\u000bu1S7\u0011\u001b"));
        var0 = null;
        stringArray[3] = Note.z(Note.z("l\u001fu\u001cbu\u0019\u0006s\n\u001b\u001dF<ET*\u00073O_~U7XO-\u0007&D\u001b=O=Y_-\u0007=Y\u001b?C6\u000bR0S7YM?K!\u000bO1\u00073\u000bI;T&\n"));
        var0 = null;
        stringArray[4] = Note.z(Note.z("z\u0012s\u0013"));
        var0 = null;
        stringArray[5] = Note.z(Note.z("R0S7YM?K"));
        var0 = null;
        stringArray[6] = Note.z(Note.z("h\nb\u001fbu\u0018h"));
        var0 = null;
        stringArray[7] = Note.z(Note.z("k\u0017s\u0011c"));
        var0 = null;
        stringArray[8] = Note.z(Note.z("z\u0012s\u0017es\u001fu\u001fdu\u0017d"));
        var0 = null;
        stringArray[9] = Note.z(Note.z("m\u0017t\u001biw\u001b"));
        var0 = null;
        stringArray[10] = Note.z(Note.z("r\r`\u0000jx\u001bi\u001d\u007f~"));
        var0 = null;
        stringArray[11] = Note.z(Note.z("_;D NH="));
        var0 = null;
        stringArray[12] = Note.z(Note.z("o\u000bw\u001eno"));
        var0 = null;
        stringArray[13] = Note.z(Note.z("U1I7"));
        var0 = null;
        stringArray[14] = Note.z(Note.z("\\,F1NU1S7"));
        var0 = null;
        stringArray[15] = Note.z(Note.z("m\u001bk\u001dhr\n~"));
        var0 = null;
        stringArray[16] = Note.z(Note.z("y\u001ft\u0001j"));
        var0 = null;
        stringArray[17] = Note.z(Note.z("u\u0011s\u0017c~\u001fc\u0000n\u007f"));
        var0 = null;
        stringArray[18] = Note.z(Note.z("h\nb\u001fbu\u0018h\u001d}~\fu\u001bo~"));
        var0 = null;
        stringArray[19] = Note.z(Note.z("y\u001bf\u001fn\u007f\u0011r\u0006"));
        var0 = null;
        stringArray[20] = Note.z(Note.z("s\u0011k\u0016"));
        var0 = null;
        stringArray[21] = Note.z(Note.z("o\u001b\u007f\u0006d}\u0018t\u0017\u007fc"));
        var0 = null;
        stringArray[22] = Note.z(Note.z("o\u001b\u007f\u0006d}\u0018t\u0017\u007fb"));
        var0 = null;
        stringArray[23] = Note.z(Note.z("u\u0011s\u0017c~\u001fc\u0010gn\u001b"));
        var0 = null;
        stringArray[24] = Note.z(Note.z("\u007f\u000bu\u0013\u007fr\u0011i"));
        var0 = null;
        stringArray[25] = Note.z(Note.z("h\nb\u001f}r\rn\u0010g~"));
        var0 = null;
        stringArray[26] = Note.z(Note.z("\u007f\u0011s\u0001"));
        var0 = null;
        stringArray[27] = Note.z(Note.z("u\u0011s\u0017c~\u001fc\u0015y~\u001bi"));
        var0 = null;
        stringArray[28] = Note.z(Note.z("o\u0017b\u0016dn\n"));
        var0 = null;
        stringArray[29] = Note.z(Note.z("l\u001bc\u0015n"));
        var0 = null;
        stringArray[30] = Note.z(Note.z("z\u001dd\u0002y~\u0018"));
        var0 = null;
        stringArray[31] = Note.z(Note.z("u\u0011s\u0017c~\u001fc\u0004bh\u0017e\u001en"));
        var0 = null;
        stringArray[32] = Note.z(Note.z("M?K'N"));
        var0 = null;
        stringArray[33] = Note.z(Note.z("X,B!H"));
        var0 = null;
        stringArray[34] = Note.z(Note.z("R0C7S"));
        var0 = null;
        stringArray[35] = Note.z(Note.z("t\ns\u0013}z"));
        var0 = null;
        stringArray[36] = Note.z(Note.z("N-B i^?I"));
        var0 = null;
        stringArray[37] = Note.z(Note.z("z\u001dd\u001be}\u0011"));
        var0 = null;
        stringArray[38] = Note.z(Note.z("u\u0011s\u0017on\f"));
        var0 = null;
        stringArray[39] = Note.z(Note.z("u\u0011s\u0017c~\u001fc"));
        var0 = null;
        stringArray[40] = Note.z(Note.z("v\u001fu\u0019"));
        var0 = null;
        stringArray[41] = Note.z(Note.z("o\u001b\u007f\u0006"));
        var0 = null;
        stringArray[42] = Note.z(Note.z("U1S7"));
        var0 = null;
        stringArray[43] = Note.z(Note.z("h\u0012r\u0000dn\n"));
        var0 = null;
        stringArray[44] = Note.z(Note.z("\u007f\u0007i"));
        var0 = null;
        stringArray[45] = Note.z(Note.z("|\u0012n\u0001xt\u000bs"));
        var0 = null;
        stringArray[46] = Note.z(Note.z("_7J"));
        var0 = null;
        stringArray[47] = Note.z(Note.z("U?J7"));
        var0 = null;
        stringArray[48] = Note.z(Note.z("w\u001bq\u0017g\u0001~"));
        var0 = null;
        stringArray[49] = Note.z(Note.z("\u0017~s \b\u0001~"));
        var0 = null;
        stringArray[50] = Note.z(Note.z("u+K>\u000bR0T&^V;I&\u0007\u001b0H&N\u001b:F&J\u0001~"));
        var0 = null;
        stringArray[51] = Note.z(Note.z("\u0017~t&\b\u0001~"));
        var0 = null;
        stringArray[52] = Note.z(Note.z("r\u0010s\u0017ym\u001fk"));
        var0 = null;
        stringArray[53] = Note.z(Note.z("\u001b\u0010Hr_I?D9\u0004H*F4M\u00143B3XN,Br"));
        var0 = null;
        stringArray[54] = Note.z(Note.z("\u001b\u0013B3X\u0018d\u0007"));
        var0 = null;
        stringArray[55] = Note.z(Note.z("o,N>G"));
        var0 = null;
        stringArray[56] = Note.z(Note.z("z=D;JX=F&^I?"));
        var0 = null;
        stringArray[57] = Note.z(Note.z("z=D7EOss7EN*H"));
        var0 = null;
        stringArray[58] = Note.z(Note.z("z=D7EOst&JX=F&D"));
        var0 = null;
        stringArray[59] = Note.z(Note.z("z=D7EO"));
        var0 = null;
        stringArray[60] = Note.z(Note.z("l;C5N"));
        var0 = null;
        stringArray[61] = Note.z(Note.z("o;I'_T"));
        var0 = null;
        stringArray[62] = Note.z(Note.z("h*F1HZ*H"));
        var0 = null;
        stringArray[63] = Note.z(Note.z("s?U?DU7D"));
        var0 = null;
        stringArray[64] = Note.z(Note.z("y1P7O\u001b\nU7FT2Hr\u0003\nhS:\u0002"));
        var0 = null;
        stringArray[65] = Note.z(Note.z("V?U9tU1I7"));
        var0 = null;
        stringArray[66] = Note.z(Note.z("l;C5N\u0016\rS3HX?S="));
        var0 = null;
        stringArray[67] = Note.z(Note.z("V1U6NU*"));
        var0 = null;
        stringArray[68] = Note.z(Note.z("y1P7O\u001b\nU7FT2Hr\u0003\u0003*O{"));
        var0 = null;
        stringArray[69] = Note.z(Note.z("o,N>G\u0016\u0018K3_"));
        var0 = null;
        stringArray[70] = Note.z(Note.z("o,N>G\u0016\u0010F&^I?K"));
        var0 = null;
        stringArray[71] = Note.z(Note.z("y1P7O\u001b\nU7FT2Hr\u0003\blI6\u0002"));
        var0 = null;
        stringArray[72] = Note.z(Note.z("R0Q7YO;C\u007fFT,C7EO"));
        var0 = null;
        stringArray[73] = Note.z(Note.z("};U?JO?"));
        var0 = null;
        stringArray[74] = Note.z(Note.z("o,N>G\u0016\rO3YK"));
        var0 = null;
        stringArray[75] = Note.z(Note.z("2fQ3\u000bT+Sh\u000b"));
        var0 = null;
        stringArray[76] = Note.z(Note.z("2\nN7O\u001b\u0011R&\u0011\u001b"));
        var0 = null;
        stringArray[77] = Note.z(Note.z("2\u001aH&X\u0001~"));
        var0 = null;
        stringArray[78] = Note.z(Note.z("2\rK'Y\u001b1R&\u0011\u001b"));
        var0 = null;
        stringArray[79] = Note.z(Note.z("2\u001a^<JV7Dh\u000b"));
        var0 = null;
        stringArray[80] = Note.z(Note.z("2\u001aB1Y^-DrDN*\u001dr"));
        var0 = null;
        stringArray[81] = Note.z(Note.z("w;Q7G\u0001~"));
        var0 = null;
        stringArray[82] = Note.z(Note.z("\u001b7I&NI(F>X1"));
        var0 = null;
        stringArray[83] = Note.z(Note.z("y\u0012f\u0011`\u0017~"));
        var0 = null;
        stringArray[84] = Note.z(Note.z("o?N>X\u0001~"));
        var0 = null;
        stringArray[85] = Note.z(Note.z("2\u0013F @\u0001~"));
        var0 = null;
        stringArray[86] = Note.z(Note.z("2\u0013B3XN,Br"));
        var0 = null;
        stringArray[87] = Note.z(Note.z("x6H O\u001b6F<OW;\u0007%BO6\u0007"));
        var0 = null;
        stringArray[88] = Note.z(Note.z("u1S7C^?Ch\u000b"));
        var0 = null;
        stringArray[89] = Note.z(Note.z("2\u0010H&N\u001c-\u0007\"NI8H FZ<K7\u000b_?S3\u0011\u001bv\u0007"));
        var0 = null;
        stringArray[90] = Note.z(Note.z("u\u0011s\u0017\u000b"));
        var0 = null;
        stringArray[91] = Note.z(Note.z("\u0017~"));
        var0 = null;
        stringArray[92] = Note.z(Note.z("\u001bw-"));
        var0 = null;
        stringArray[93] = Note.z(Note.z("2fQ0\u000bT+Sh\u000b"));
        var0 = null;
        stringArray[94] = Note.z(Note.z("2\u001dU7XX~H'_\u0001~"));
        var0 = null;
        stringArray[95] = Note.z(Note.z("o+W>NOd\u0007"));
        var0 = null;
        stringArray[96] = Note.z(Note.z("V1I=[S1I;H1"));
        var0 = null;
        stringArray[97] = Note.z(Note.z("\u0017~t&J]8\u0007"));
        var0 = null;
        stringArray[98] = Note.z(Note.z("\u007f+Uh\u000b"));
        var0 = null;
        stringArray[99] = Note.z(Note.z("l\u0016n\u0006n\u0017~"));
        var0 = null;
        stringArray[100] = Note.z(Note.z("x6H O\u001b7I&NI(F>!"));
        var0 = null;
        stringArray[101] = Note.z(Note.z("\\;S\u001cDO;c'YZ*N=Ez-w7Y]1U?JU=B\u0006BV;\u000f{\u000bZ,@rFN-SrI^~D=EH*F<_\u001bn\t|\u001c\u0001~"));
        var0 = null;
        stringArray[102] = Note.z(Note.z("\u0004a\u0018"));
        var0 = null;
        stringArray[103] = Note.z(Note.z("u1S7\u0005X2H<Nu1S7\u0003\u0012~B YT,\u001dr"));
        var0 = null;
        stringArray[104] = Note.z(Note.z("z\u001dd\rot\u000be\u001end\u0018k\u0013\u007f"));
        var0 = null;
        stringArray[105] = Note.z(Note.z("r\u0010q\u0013gr\u001a\u0007\u0013hx\u0017c\u0017eo\u001fkr}z\u0012r\u0017\u000b"));
        var0 = null;
        stringArray[106] = Note.z(Note.z("z\u001dd\rez\nr\u0000jw"));
        var0 = null;
        stringArray[107] = Note.z(Note.z("z\u001dd\rot\u000be\u001end\ro\u0013yk"));
        var0 = null;
        stringArray[108] = Note.z(Note.z("z\u001dd\rxs\u001fu\u0002"));
        var0 = null;
        stringArray[109] = Note.z(Note.z("z\u001dd\rmw\u001fs"));
        var0 = null;
        stringArray[110] = Note.z(Note.z("z\u001dd\ret\u0010b"));
        var0 = null;
        stringArray[111] = Note.z(Note.z("]8"));
        var0 = null;
        stringArray[112] = Note.z(Note.z("K.W"));
        var0 = null;
        stringArray[113] = Note.z(Note.z("K."));
        var0 = null;
        stringArray[114] = Note.z(Note.z("V8"));
        var0 = null;
        stringArray[115] = Note.z(Note.z("V."));
        var0 = null;
        stringArray[116] = Note.z(Note.z("]8A"));
        var0 = null;
        stringArray[117] = Note.z(Note.z("_'I3FR=x<DU;"));
        B = stringArray;
        GRACE_NOTE_SIZE_SCALER = 0.5;
        DBUG = false;
        coreDurations = new double[]{4.0, 2.0, 1.0, 0.5, 0.25, 0.125, 0.0625, 0.03125, 0.015625};
        String[] stringArray2 = new String[9];
        stringArray2[0] = "w";
        stringArray2[1] = "h";
        stringArray2[2] = "q";
        stringArray2[3] = "e";
        stringArray2[4] = "s";
        var0 = null;
        stringArray2[5] = Note.z(Note.z("\bl"));
        var0 = null;
        stringArray2[6] = Note.z(Note.z("\rj"));
        var0 = null;
        stringArray2[7] = Note.z(Note.z("\nl\u001f"));
        var0 = null;
        stringArray2[8] = Note.z(Note.z("\tk\u0011"));
        coreDurationNames = stringArray2;
        String[] stringArray3 = new String[15];
        var0 = null;
        stringArray3[0] = Note.z(Note.z("Y2F1@"));
        var0 = null;
        stringArray3[1] = Note.z(Note.z("L6N&N"));
        stringArray3[2] = "X";
        var0 = null;
        stringArray3[3] = Note.z(Note.z("c~H$JW"));
        var0 = null;
        stringArray3[4] = Note.z(Note.z("c~C;JV1I6"));
        var0 = null;
        stringArray3[5] = Note.z(Note.z("L6N&N\u001b:N3FT0C"));
        var0 = null;
        stringArray3[6] = Note.z(Note.z("Y2F1@\u001b:N3FT0C"));
        var0 = null;
        stringArray3[7] = Note.z(Note.z("L6N&N\u001b*U;JU9K7"));
        var0 = null;
        stringArray3[8] = Note.z(Note.z("Y2F1@\u001b*U;JU9K7"));
        var0 = null;
        stringArray3[9] = Note.z(Note.z("L6N&N\u001b7I$NI*B6\u000bO,N3E\\2B"));
        var0 = null;
        stringArray3[10] = Note.z(Note.z("Y2F1@\u001b7I$NI*B6\u000bO,N3E\\2B"));
        var0 = null;
        stringArray3[11] = Note.z(Note.z("Y,B$N"));
        var0 = null;
        stringArray3[12] = Note.z(Note.z("H2F!C"));
        var0 = null;
        stringArray3[13] = Note.z(Note.z("I;T7YM;Cr\u001a"));
        var0 = null;
        stringArray3[14] = Note.z(Note.z("I;T7YM;Cr\u0019"));
        noteheadNames = stringArray3;
        v = true;
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x2B);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 59;
                            break;
                        }
                        case 1: {
                            n7 = 94;
                            break;
                        }
                        case 2: {
                            n7 = 39;
                            break;
                        }
                        case 3: {
                            n7 = 82;
                            break;
                        }
                        default: {
                            n7 = 43;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

