/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score;

import com.softsynth.jmsl.Composable;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.ParallelCollection;
import com.softsynth.jmsl.score.Clef;
import com.softsynth.jmsl.score.ClefRenderer;
import com.softsynth.jmsl.score.KeySignature;
import com.softsynth.jmsl.score.KeySignatureRenderer;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.MusicGlyphNumberRenderer;
import com.softsynth.jmsl.score.MusicGlyphRenderer;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Orchestra;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.TimeSigRenderer;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.score.util.RenderedMessageBean;
import com.softsynth.jmsl.util.SimpleXMLSaver;
import com.softsynth.jmsl.util.XMLString;
import com.softsynth.jmsl.util.XMLWritable;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Staff
extends ParallelCollection
implements XMLWritable {
    Measure y;
    public static final int SPACE_INTERVAL = 12;
    public static final int DEFAULT_STAFF_SPACE_ABOVE = 72;
    public static final int DEFAULT_STAFF_SPACE_BELOW = 72;
    public static final int LEVEL_OF_MIDDLE_LINE = 128;
    public static final int LEVEL_OF_TOP_LINE = 132;
    public static final int LEVEL_OF_BOTTOM_LINE = 124;
    Point2D z;
    Clef A;
    boolean B;
    boolean C;
    boolean D;
    boolean E;
    boolean F;
    int G;
    boolean H;
    private KeySignature I;
    private Vector J = new Vector();
    private boolean K;
    private int L;
    public static final String copyright;
    private static String[] M;

    public Staff(Measure measure) {
        this(measure, null);
        this.E = false;
        this.I = new KeySignature();
        this.I.setKeySignatureType(0);
        this.I.setNumAccidentals(0);
    }

    public Staff(Measure measure, Instrument instrument) {
        this.y = measure;
        int n2 = 2;
        if (measure.getScore() != null) {
            n2 = measure.getScore().getNumTracksPerStaff();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add((Composable)new Track(this, i2, instrument));
            if (Note.A == 0) continue;
        }
        this.z = new Point2D.Double();
        this.setClef(Clef.TREBLE_CLEF);
    }

    public int getStaffIndex() {
        return this.y.getChildren().indexOf((Object)this);
    }

    public void setInstrumentIndex(int n2) {
        this.G = n2;
        this.setInstrument();
    }

    public int getInstrumentIndex() {
        return this.G;
    }

    public void setInstrument() {
        Orchestra orchestra = this.getScore().getOrchestra();
        if (orchestra != null && orchestra.size() > this.G && this.G >= 0) {
            Instrument instrument = orchestra.getInstrument(this.G);
            this.setInstrument(instrument);
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Track track = (Track)((Object)enumeration.nextElement());
                track.setInstrument(instrument);
                if (Note.A == 0) continue;
            }
        }
    }

    public void setClefSetByHand(boolean bl) {
        this.E = bl;
    }

    public Track addTrack() {
        Track track = new Track(this, this.size());
        this.add((Composable)track);
        return track;
    }

    public Track addTrack(Instrument instrument) {
        Track track = new Track(this, this.size(), instrument);
        this.add((Composable)track);
        return track;
    }

    public boolean getClefSetByHand() {
        return this.E;
    }

    public void setKeySignatureSetByHand(boolean bl) {
        this.F = bl;
    }

    public boolean getKeySignatureSetByHand() {
        return this.F;
    }

    public boolean getInsIndexSetByHand() {
        return this.H;
    }

    public void setInsIndexSetByHand(boolean bl) {
        this.H = bl;
    }

    public KeySignature getKeySignature() {
        return this.I;
    }

    public void setKeySignature(KeySignature keySignature) {
        this.I = keySignature;
    }

    public void setDisplayClef(boolean bl) {
        this.B = bl;
    }

    public boolean getDisplayClef() {
        return this.B;
    }

    public void setDisplayTimeSig(boolean bl) {
        this.C = bl;
    }

    public boolean getDisplayTimeSig() {
        return this.C;
    }

    public void setDisplayKeySignature(boolean bl) {
        this.D = bl;
    }

    public boolean getDisplayKeySignature() {
        return this.D;
    }

    public boolean isMultiTrack() {
        return this.getNonEmptyTrackCount() > 1;
    }

    public int getNonEmptyTrackCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getTrack(i2).size() <= 0) continue;
            ++n2;
            if (Note.A == 0) continue;
        }
        return n2;
    }

    public Measure getMeasure() {
        return this.y;
    }

    public Track getTrack(int n2) {
        return (Track)this.get(n2);
    }

    public Score getScore() {
        if (this.getMeasure() == null) {
            return null;
        }
        return this.getMeasure().getScore();
    }

    public double getMaxDuration() {
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)((Object)enumeration.nextElement());
            d2 = Math.max(d2, track.getDuration());
            if (Note.A == 0) continue;
        }
        return d2;
    }

    public void setClef(Clef clef) {
        Clef clef2;
        this.A = clef2 = new Clef(clef);
        this.A.setStaff(this);
    }

    public Clef getClef() {
        return this.A;
    }

    public double getSpaceAbove() {
        return this.getScore().getStaffSpacing(this.getStaffIndex()).getSpaceAbove();
    }

    public double getSpaceBelow() {
        return this.getScore().getStaffSpacing(this.getStaffIndex()).getSpaceBelow();
    }

    public static double getStaffHeight() {
        return 48.0;
    }

    public double getTotalHeight() {
        return this.getSpaceAbove() + this.getSpaceBelow() + Staff.getStaffHeight();
    }

    public void setSpaceAbove(double d2) {
        this.getScore().getStaffSpacing(this.getStaffIndex()).setSpaceAbove(d2);
    }

    public void setSpaceBelow(double d2) {
        this.getScore().getStaffSpacing(this.getStaffIndex()).setSpaceBelow(d2);
    }

    public void addToSpaceAbove(double d2) {
        this.setSpaceAbove(Math.max(0.0, this.getSpaceAbove() + d2));
    }

    public void addToSpaceBelow(double d2) {
        this.setSpaceBelow(Math.max(0.0, this.getSpaceBelow() + d2));
    }

    public void setDrawingAnchor(Point2D point2D) {
        this.z.setLocation(point2D);
    }

    public Point2D getDrawingAnchor() {
        return this.z;
    }

    public void layoutChildren() {
        Point2D.Double double_ = new Point2D.Double(this.getDrawingAnchor().getX(), this.getDrawingAnchor().getY());
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)((Object)enumeration.nextElement());
            double_.y = this.levelOfTopLine();
            track.setDrawingAnchor(double_);
            track.layoutChildren();
            if (Note.A == 0) continue;
        }
    }

    public double levelOfTopLine() {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        return this.getDrawingAnchor().getY() + d2 * this.getSpaceAbove();
    }

    public boolean within(Point point) {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        return (double)point.x >= this.z.getX() && (double)point.x < this.z.getX() + (double)((int)(this.getMeasure().getWidth() * d2)) && (double)point.y >= this.z.getY() && (double)point.y < this.z.getY() + (double)((int)(this.getTotalHeight() * d2));
    }

    public int getInsertionIndex(Point2D point2D, int n2) {
        int n3 = Note.A;
        int n4 = 0;
        Enumeration enumeration = this.getTrack(n2).elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (point2D.getX() <= note.getDrawingAnchor().getX() && n3 == 0) break;
            ++n4;
            if (n3 == 0) continue;
        }
        return n4;
    }

    public int getNearestLevel(Point point) {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        int n2 = (int)(this.levelOfTopLine() + (Staff.getStaffHeight() + 12.0) * d2);
        return (int)(((double)(n2 - point.y) + d2 * 12.0 / 4.0) / (d2 * 12.0 / 2.0) + 122.0);
    }

    void a(Graphics graphics, double d2) {
        block4: {
            int n2;
            int n3;
            String string;
            block5: {
                if (!this.getScore().getStaffNumbersVisible()) {
                    return;
                }
                if (0 != this.getMeasure().getMeasureIndex() && !this.getMeasure().isBeginningOfLine()) break block4;
                string = this.getStaffIndex() + 1 + "";
                FontMetrics fontMetrics = graphics.getFontMetrics();
                double d3 = fontMetrics.stringWidth(string);
                double d4 = fontMetrics.stringWidth("0");
                double d5 = this.getDrawingAnchor().getX() - d4 * 2.0;
                double d6 = d3 - d4;
                double d7 = d5 - d6 / 2.0;
                n3 = (int)d7;
                n2 = (int)(this.levelOfTopLine() + d2 * 12.0 * 2.0);
                MusicGlyphRenderer musicGlyphRenderer = MusicGlyphNumberRenderer.a(M[12], graphics, string, d2, this.getScore());
                if (musicGlyphRenderer == null) break block5;
                MusicGlyphNumberRenderer.a(M[12], graphics, n3, n2, d2, musicGlyphRenderer, 0, string, 0, (Object)this);
                if (Note.A == 0) break block4;
            }
            graphics.drawString(string, n3, n2);
        }
    }

    void a(Graphics graphics, double d2, int n2, boolean bl) {
        block6: {
            FontMetrics fontMetrics;
            String string;
            block7: {
                block8: {
                    if (!this.getScore().getInstrumentNamesVisible()) {
                        return;
                    }
                    if (!this.getInsIndexSetByHand() && 0 != this.getMeasure().getMeasureIndex() && !this.getMeasure().isBeginningOfLine()) break block6;
                    Orchestra orchestra = this.getScore().getOrchestra();
                    string = M[13] + this.getInstrumentIndex();
                    if (orchestra == null) break block7;
                    if (this.getInstrumentIndex() >= orchestra.size()) break block8;
                    fontMetrics = orchestra.getInstrument(this.getInstrumentIndex());
                    if (fontMetrics != null) {
                        string = fontMetrics.getName();
                    }
                    if (Note.A == 0) break block7;
                }
                string = M[14];
            }
            fontMetrics = graphics.getFontMetrics();
            int n3 = 0;
            if (bl) {
                n3 = (int)(18.0 * d2);
            }
            ((Graphics2D)graphics).drawString(string, (float)(this.z.getX() + (double)n2 + 1.0), (float)(this.levelOfTopLine() - (double)n3 - (double)(fontMetrics.getHeight() / 4)));
        }
    }

    public void render(Graphics graphics, double d2) {
        graphics.setColor(Color.black);
        int n2 = 0;
        n2 = this.a(graphics, d2, n2);
        n2 = this.b(graphics, d2, n2);
        this.a(graphics, d2, n2, this.K);
        this.a(graphics, d2);
        n2 = this.c(graphics, d2, n2);
        this.c(graphics, d2);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Track)((Object)enumeration.nextElement())).render(graphics, d2);
            if (Note.A == 0) continue;
        }
        this.b(graphics, d2);
    }

    private void b(Graphics graphics, double d2) {
        Enumeration enumeration = this.getUserBeans().elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof RenderedMessageBean) {
                ((RenderedMessageBean)e2).execute(this.getScore(), (Object)this, graphics, this.getDrawingAnchor(), d2);
            }
            if (Note.A == 0) continue;
        }
    }

    private boolean a() {
        boolean bl;
        block3: {
            block2: {
                bl = false;
                int n2 = this.getMeasure().getMeasureIndex() - 1;
                if (n2 < 0) break block2;
                Measure measure = this.getScore().getMeasure(n2);
                Staff staff = measure.getStaff(this.getStaffIndex());
                Clef clef = staff.getClef();
                boolean bl2 = bl = clef.getClefType() != this.getClef().getClefType();
                if (Note.A == 0) break block3;
            }
            bl = true;
        }
        return bl;
    }

    private int a(Graphics graphics, double d2, int n2) {
        if (this.getDisplayClef()) {
            Measure measure = this.getMeasure();
            if (measure.isBeginningOfLine() || this.a() || this.getScore().isDrawCourtesyClefs()) {
                ClefRenderer.render(graphics, this.getClef(), this.z.getX(), this.levelOfTopLine(), d2, this);
            }
            n2 += (int)(ClefRenderer.CLEF_WIDTH * d2);
        }
        return n2;
    }

    private void c(Graphics graphics, double d2) {
        boolean bl;
        int n2 = Note.A;
        double d3 = this.getMeasure().getWidth() * d2;
        boolean bl2 = bl = this.getScore().getSelectedStaff() == this;
        if (!this.getScore().isHighlightSelectedStaff()) {
            bl = false;
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            Object object;
            Serializable serializable;
            if (!this.getScore().getStaffAndLedgerLineVisibilityManager().isStaffLineVisible(this.getStaffIndex(), i2)) continue;
            double d4 = ((double)(i2 * 12) + this.getSpaceAbove()) * d2 + this.z.getY();
            if (this.getScore().getMusicCurveRenderer() != null) {
                serializable = new Hashtable();
                ((Hashtable)serializable).put(M[9], new Double(d2));
                ((Hashtable)serializable).put(M[11], new Double(this.z.getX()));
                ((Hashtable)serializable).put(M[7], new Double(d4));
                ((Hashtable)serializable).put(M[6], new Double(this.z.getX() + d3));
                ((Hashtable)serializable).put(M[5], new Double(d4));
                ((Hashtable)serializable).put(M[8], new Double(i2));
                ((Hashtable)serializable).put(M[1], this);
                ((Hashtable)serializable).put(M[4], bl + "");
                object = M[10];
                this.getScore().getMusicCurveRenderer().draw(graphics, (String)object, (Hashtable)serializable);
                if (n2 == 0) continue;
            }
            serializable = graphics.getColor();
            object = bl ? Color.cyan : Color.black;
            graphics.setColor((Color)object);
            ((Graphics2D)graphics).draw(new Line2D.Double(this.z.getX(), d4, this.z.getX() + d3, d4));
            graphics.setColor((Color)serializable);
            if (n2 == 0) continue;
        }
    }

    private int b(Graphics graphics, double d2, int n2) {
        this.K = false;
        if (this.getDisplayKeySignature() && this.getScore().getKeySignaturesVisible()) {
            int n3 = (int)(24.0 * d2);
            KeySignature keySignature = this.getKeySignature();
            KeySignature keySignature2 = this.needsCancellingKeySig();
            if (keySignature2 != null) {
                keySignature = keySignature2;
            }
            KeySignatureRenderer.render(graphics, this, keySignature, this.z.getX() + (double)n2 + (double)n3, d2);
            this.K = keySignature.getKeySignatureType() == 0 && keySignature.getNumAccidentals() > 0 || keySignature.getKeySignatureType() == 1 && keySignature.getNumAccidentals() > 1;
        }
        return (int)((double)n2 + (double)this.L * d2);
    }

    protected KeySignature needsCancellingKeySig() {
        KeySignature keySignature = null;
        if (this.getMeasure().getMeasureIndex() > 0 && this.getKeySignature().getNumAccidentals() == 0) {
            int n2 = this.getMeasure().getMeasureIndex();
            Measure measure = this.getScore().getMeasure(n2 - 1);
            Staff staff = measure.getStaff(this.getStaffIndex());
            KeySignature keySignature2 = staff.getKeySignature();
            if (keySignature2.getNumAccidentals() > 0) {
                keySignature = KeySignature.getCancellingKeySignature(keySignature2);
            }
        }
        return keySignature;
    }

    private int c(Graphics graphics, double d2, int n2) {
        if (this.getDisplayTimeSig() && this.getScore().getTimeSignaturesVisible()) {
            TimeSigRenderer.render(graphics, this.getMeasure().getTimeSig(), this.z.getX() + (double)n2, this.levelOfTopLine(), d2, this.getScore().getScorePainter().getTimeSigFont(), this);
            n2 += (int)(40.0 * d2);
        }
        return n2;
    }

    public String getHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Score.indent() + M[2]);
        Score.printIndent += 5;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Track)((Object)enumeration.nextElement())).getHierarchy() + "\n");
            if (Note.A == 0) continue;
        }
        Score.printIndent -= 5;
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(M[3] + this.getStaffIndex());
        return stringBuffer.toString();
    }

    public void writeXML(PrintWriter printWriter) throws IOException {
        Track track;
        int n2 = Note.A;
        this.writeStaffPropertiesXML(printWriter);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            track = (Track)((Object)enumeration.nextElement());
            track.writeXML(printWriter);
            if (n2 == 0) continue;
        }
        if (this.J != null) {
            enumeration = this.J.elements();
            while (enumeration.hasMoreElements()) {
                track = enumeration.nextElement();
                SimpleXMLSaver simpleXMLSaver = new SimpleXMLSaver((Object)track, M[0]);
                simpleXMLSaver.writeXML(printWriter);
                if (n2 == 0) continue;
            }
        }
        this.closeStaffPropertiesXML(printWriter);
    }

    public void closeStaffPropertiesXML(PrintWriter printWriter) {
        XMLString xMLString = new XMLString();
        xMLString.endElement(M[1], true);
        printWriter.println(xMLString);
    }

    public void writeStaffPropertiesXML(PrintWriter printWriter) {
        XMLString xMLString = new XMLString();
        xMLString.startElement(M[1], false);
        xMLString.addAttribute(M[22], this.getStaffIndex() + "");
        xMLString.addAttribute(M[21], this.getClef().getClefType() + "");
        xMLString.addAttribute(M[16], this.getClefSetByHand() + "");
        xMLString.addAttribute(M[20], this.getInstrumentIndex() + "");
        xMLString.addAttribute(M[19], this.getInsIndexSetByHand() + "");
        xMLString.addAttribute(M[17], this.getKeySignature().getKeySignatureType() + "");
        xMLString.addAttribute(M[15], this.getKeySignature().getNumAccidentals() + "");
        xMLString.addAttribute(M[18], this.getKeySignatureSetByHand() + "");
        xMLString.endElement(null, true);
        printWriter.println(xMLString);
    }

    public Vector getUserBeans() {
        return this.J;
    }

    public void addUserBean(Object object) {
        this.J.addElement(object);
    }

    public void removeUserBean(Object object) {
        this.J.removeElement(object);
    }

    public void setMaxKeySignatureWidthInMeasure(int n2) {
        this.L = n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block263: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block262: {
                char[] cArray3;
                Object var0;
                block261: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block260: {
                        char[] cArray5;
                        block259: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block258: {
                                char[] cArray7;
                                block257: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block256: {
                                        char[] cArray9;
                                        block255: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block254: {
                                                char[] cArray11;
                                                block253: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block252: {
                                                        char[] cArray13;
                                                        block251: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block250: {
                                                                char[] cArray15;
                                                                block249: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block248: {
                                                                        char[] cArray17;
                                                                        block247: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block246: {
                                                                                char[] cArray19;
                                                                                block245: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block244: {
                                                                                        char[] cArray21;
                                                                                        block243: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block242: {
                                                                                                char[] cArray23;
                                                                                                block241: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block240: {
                                                                                                        char[] cArray25;
                                                                                                        block239: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block238: {
                                                                                                                char[] cArray27;
                                                                                                                block237: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block236: {
                                                                                                                        char[] cArray29;
                                                                                                                        block235: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block234: {
                                                                                                                                char[] cArray31;
                                                                                                                                block233: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block232: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block231: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block230: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block229: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block228: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block227: {
                                                                                                                                                            int n39;
                                                                                                                                                            int n40;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block226: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block225: {
                                                                                                                                                                    int n41;
                                                                                                                                                                    int n42;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block224: {
                                                                                                                                                                        char[] cArray41;
                                                                                                                                                                        block223: {
                                                                                                                                                                            int n43;
                                                                                                                                                                            int n44;
                                                                                                                                                                            char[] cArray42;
                                                                                                                                                                            block222: {
                                                                                                                                                                                char[] cArray43;
                                                                                                                                                                                block221: {
                                                                                                                                                                                    int n45;
                                                                                                                                                                                    int n46;
                                                                                                                                                                                    char[] cArray44;
                                                                                                                                                                                    block220: {
                                                                                                                                                                                        char[] cArray45;
                                                                                                                                                                                        block219: {
                                                                                                                                                                                            int n47;
                                                                                                                                                                                            int n48;
                                                                                                                                                                                            char[] cArray46;
                                                                                                                                                                                            block218: {
                                                                                                                                                                                                char[] cArray47;
                                                                                                                                                                                                block217: {
                                                                                                                                                                                                    int n49;
                                                                                                                                                                                                    int n50;
                                                                                                                                                                                                    char[] cArray48;
                                                                                                                                                                                                    block216: {
                                                                                                                                                                                                        stringArray = new String[23];
                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                        char[] cArray49 = "KE^F7AMFKe\u0000i\u0007\u001fw\u0018\u001a\u001e\u001f\u000bAIE\u001f\u0001ANEP3[AW\u0013eIFB\u001f7AMFK6\bXKL Z\\K[".toCharArray();
                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                        int n51 = cArray49.length;
                                                                                                                                                                                                        cArray48 = cArray49;
                                                                                                                                                                                                        n50 = n51;
                                                                                                                                                                                                        if (n51 <= 1) break block216;
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                        if (n50 <= n4) break block217;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    do {
                                                                                                                                                                                                        char[] cArray50 = cArray48;
                                                                                                                                                                                                        char[] cArray51 = cArray48;
                                                                                                                                                                                                        int n52 = n4;
                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                            int n53;
                                                                                                                                                                                                            char c2 = cArray50[n52];
                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                    n53 = 40;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                    n53 = 42;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                    n53 = 46;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                    n53 = 63;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                    n53 = 69;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                            cArray50[n52] = (char)(c2 ^ n53);
                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                            cArray48 = cArray51;
                                                                                                                                                                                                            n50 = n50;
                                                                                                                                                                                                            if (n50 != 0) break;
                                                                                                                                                                                                            cArray51 = cArray48;
                                                                                                                                                                                                            n49 = n50;
                                                                                                                                                                                                            n52 = n50;
                                                                                                                                                                                                            cArray50 = cArray48;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                    } while (n50 > n4);
                                                                                                                                                                                                }
                                                                                                                                                                                                copyright = new String(cArray47).intern();
                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                char[] cArray52 = "[^OY#}YKM\u0007MK@".toCharArray();
                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                int n54 = cArray52.length;
                                                                                                                                                                                                cArray46 = cArray52;
                                                                                                                                                                                                n48 = n54;
                                                                                                                                                                                                if (n54 <= 1) break block218;
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                                if (n48 <= n4) break block219;
                                                                                                                                                                                            }
                                                                                                                                                                                            do {
                                                                                                                                                                                                char[] cArray53 = cArray46;
                                                                                                                                                                                                char[] cArray54 = cArray46;
                                                                                                                                                                                                int n55 = n4;
                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                    int n56;
                                                                                                                                                                                                    char c3 = cArray53[n55];
                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                            n56 = 40;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                            n56 = 42;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                            n56 = 46;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                            n56 = 63;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        default: {
                                                                                                                                                                                                            n56 = 69;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    cArray53[n55] = (char)(c3 ^ n56);
                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                    cArray46 = cArray54;
                                                                                                                                                                                                    n48 = n48;
                                                                                                                                                                                                    if (n48 != 0) break;
                                                                                                                                                                                                    cArray54 = cArray46;
                                                                                                                                                                                                    n47 = n48;
                                                                                                                                                                                                    n55 = n48;
                                                                                                                                                                                                    cArray53 = cArray46;
                                                                                                                                                                                                }
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                            } while (n48 > n4);
                                                                                                                                                                                        }
                                                                                                                                                                                        stringArray[0] = new String(cArray45).intern();
                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                        char[] cArray55 = "[^OY#".toCharArray();
                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                        int n57 = cArray55.length;
                                                                                                                                                                                        cArray44 = cArray55;
                                                                                                                                                                                        n46 = n57;
                                                                                                                                                                                        if (n57 <= 1) break block220;
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                        if (n46 <= n4) break block221;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        char[] cArray56 = cArray44;
                                                                                                                                                                                        char[] cArray57 = cArray44;
                                                                                                                                                                                        int n58 = n4;
                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            int n59;
                                                                                                                                                                                            char c4 = cArray56[n58];
                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                    n59 = 40;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                    n59 = 42;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                    n59 = 46;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                    n59 = 63;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                default: {
                                                                                                                                                                                                    n59 = 69;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            cArray56[n58] = (char)(c4 ^ n59);
                                                                                                                                                                                            ++n4;
                                                                                                                                                                                            cArray44 = cArray57;
                                                                                                                                                                                            n46 = n46;
                                                                                                                                                                                            if (n46 != 0) break;
                                                                                                                                                                                            cArray57 = cArray44;
                                                                                                                                                                                            n45 = n46;
                                                                                                                                                                                            n58 = n46;
                                                                                                                                                                                            cArray56 = cArray44;
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                    } while (n46 > n4);
                                                                                                                                                                                }
                                                                                                                                                                                stringArray[1] = new String(cArray43).intern();
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray58 = "{^OY#\"".toCharArray();
                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                int n60 = cArray58.length;
                                                                                                                                                                                cArray42 = cArray58;
                                                                                                                                                                                n44 = n60;
                                                                                                                                                                                if (n60 <= 1) break block222;
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                                if (n44 <= n4) break block223;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                char[] cArray59 = cArray42;
                                                                                                                                                                                char[] cArray60 = cArray42;
                                                                                                                                                                                int n61 = n4;
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    int n62;
                                                                                                                                                                                    char c5 = cArray59[n61];
                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                        case 0: {
                                                                                                                                                                                            n62 = 40;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 1: {
                                                                                                                                                                                            n62 = 42;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 2: {
                                                                                                                                                                                            n62 = 46;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 3: {
                                                                                                                                                                                            n62 = 63;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        default: {
                                                                                                                                                                                            n62 = 69;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    cArray59[n61] = (char)(c5 ^ n62);
                                                                                                                                                                                    ++n4;
                                                                                                                                                                                    cArray42 = cArray60;
                                                                                                                                                                                    n44 = n44;
                                                                                                                                                                                    if (n44 != 0) break;
                                                                                                                                                                                    cArray60 = cArray42;
                                                                                                                                                                                    n43 = n44;
                                                                                                                                                                                    n61 = n44;
                                                                                                                                                                                    cArray59 = cArray42;
                                                                                                                                                                                }
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                            } while (n44 > n4);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[2] = new String(cArray41).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray61 = "{^OY#\b".toCharArray();
                                                                                                                                                                        n4 = 0;
                                                                                                                                                                        int n63 = cArray61.length;
                                                                                                                                                                        cArray40 = cArray61;
                                                                                                                                                                        n42 = n63;
                                                                                                                                                                        if (n63 <= 1) break block224;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                        if (n42 <= n4) break block225;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray62 = cArray40;
                                                                                                                                                                        char[] cArray63 = cArray40;
                                                                                                                                                                        int n64 = n4;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n65;
                                                                                                                                                                            char c6 = cArray62[n64];
                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n65 = 40;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n65 = 42;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n65 = 46;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n65 = 63;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n65 = 69;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray62[n64] = (char)(c6 ^ n65);
                                                                                                                                                                            ++n4;
                                                                                                                                                                            cArray40 = cArray63;
                                                                                                                                                                            n42 = n42;
                                                                                                                                                                            if (n42 != 0) break;
                                                                                                                                                                            cArray63 = cArray40;
                                                                                                                                                                            n41 = n42;
                                                                                                                                                                            n64 = n42;
                                                                                                                                                                            cArray62 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                    } while (n42 > n4);
                                                                                                                                                                }
                                                                                                                                                                stringArray[3] = new String(cArray39).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray64 = "[OBZ&\\OJ".toCharArray();
                                                                                                                                                                n4 = 0;
                                                                                                                                                                int n66 = cArray64.length;
                                                                                                                                                                cArray38 = cArray64;
                                                                                                                                                                n40 = n66;
                                                                                                                                                                if (n66 <= 1) break block226;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                                if (n40 <= n4) break block227;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray65 = cArray38;
                                                                                                                                                                char[] cArray66 = cArray38;
                                                                                                                                                                int n67 = n4;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n68;
                                                                                                                                                                    char c7 = cArray65[n67];
                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n68 = 40;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n68 = 42;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n68 = 46;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n68 = 63;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n68 = 69;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray65[n67] = (char)(c7 ^ n68);
                                                                                                                                                                    ++n4;
                                                                                                                                                                    cArray38 = cArray66;
                                                                                                                                                                    n40 = n40;
                                                                                                                                                                    if (n40 != 0) break;
                                                                                                                                                                    cArray66 = cArray38;
                                                                                                                                                                    n39 = n40;
                                                                                                                                                                    n67 = n40;
                                                                                                                                                                    cArray65 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                            } while (n40 > n4);
                                                                                                                                                        }
                                                                                                                                                        stringArray[4] = new String(cArray37).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray67 = "Q\u0018".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n69 = cArray67.length;
                                                                                                                                                        cArray36 = cArray67;
                                                                                                                                                        n38 = n69;
                                                                                                                                                        if (n69 <= 1) break block228;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block229;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray68 = cArray36;
                                                                                                                                                        char[] cArray69 = cArray36;
                                                                                                                                                        int n70 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n71;
                                                                                                                                                            char c8 = cArray68[n70];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n71 = 40;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n71 = 42;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n71 = 46;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n71 = 63;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n71 = 69;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray68[n70] = (char)(c8 ^ n71);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray69;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray69 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n70 = n38;
                                                                                                                                                            cArray68 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[5] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray70 = "P\u0018".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n72 = cArray70.length;
                                                                                                                                                cArray34 = cArray70;
                                                                                                                                                n36 = n72;
                                                                                                                                                if (n72 <= 1) break block230;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block231;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray71 = cArray34;
                                                                                                                                                char[] cArray72 = cArray34;
                                                                                                                                                int n73 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n74;
                                                                                                                                                    char c9 = cArray71[n73];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n74 = 40;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n74 = 42;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n74 = 46;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n74 = 63;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n74 = 69;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray71[n73] = (char)(c9 ^ n74);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray72;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray72 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n73 = n36;
                                                                                                                                                    cArray71 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[6] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray73 = "Q\u001b".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n75 = cArray73.length;
                                                                                                                                        cArray32 = cArray73;
                                                                                                                                        n34 = n75;
                                                                                                                                        if (n75 <= 1) break block232;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block233;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray74 = cArray32;
                                                                                                                                        char[] cArray75 = cArray32;
                                                                                                                                        int n76 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n77;
                                                                                                                                            char c10 = cArray74[n76];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n77 = 40;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n77 = 42;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n77 = 46;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n77 = 63;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n77 = 69;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray74[n76] = (char)(c10 ^ n77);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray75;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray75 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n76 = n34;
                                                                                                                                            cArray74 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[7] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray76 = "{^OY#dC@Z\fFNKG".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n78 = cArray76.length;
                                                                                                                                cArray30 = cArray76;
                                                                                                                                n32 = n78;
                                                                                                                                if (n78 <= 1) break block234;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block235;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray77 = cArray30;
                                                                                                                                char[] cArray78 = cArray30;
                                                                                                                                int n79 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n80;
                                                                                                                                    char c11 = cArray77[n79];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n80 = 40;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n80 = 42;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n80 = 46;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n80 = 63;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n80 = 69;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray77[n79] = (char)(c11 ^ n80);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray78;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray78 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n79 = n32;
                                                                                                                                    cArray77 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[8] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray79 = "REAR".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n81 = cArray79.length;
                                                                                                                        cArray28 = cArray79;
                                                                                                                        n30 = n81;
                                                                                                                        if (n81 <= 1) break block236;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block237;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray80 = cArray28;
                                                                                                                        char[] cArray81 = cArray28;
                                                                                                                        int n82 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n83;
                                                                                                                            char c12 = cArray80[n82];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n83 = 40;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n83 = 42;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n83 = 46;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n83 = 63;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n83 = 69;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray80[n82] = (char)(c12 ^ n83);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray81;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray81 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n82 = n30;
                                                                                                                            cArray80 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[9] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray82 = "{^OY#dC@Z".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n84 = cArray82.length;
                                                                                                                cArray26 = cArray82;
                                                                                                                n28 = n84;
                                                                                                                if (n84 <= 1) break block238;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block239;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray83 = cArray26;
                                                                                                                char[] cArray84 = cArray26;
                                                                                                                int n85 = n4;
                                                                                                                while (true) {
                                                                                                                    int n86;
                                                                                                                    char c13 = cArray83[n85];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n86 = 40;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n86 = 42;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n86 = 46;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n86 = 63;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n86 = 69;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray83[n85] = (char)(c13 ^ n86);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray84;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray84 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n85 = n28;
                                                                                                                    cArray83 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[10] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray85 = "P\u001b".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n87 = cArray85.length;
                                                                                                        cArray24 = cArray85;
                                                                                                        n26 = n87;
                                                                                                        if (n87 <= 1) break block240;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block241;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray86 = cArray24;
                                                                                                        char[] cArray87 = cArray24;
                                                                                                        int n88 = n4;
                                                                                                        while (true) {
                                                                                                            int n89;
                                                                                                            char c14 = cArray86[n88];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n89 = 40;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n89 = 42;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n89 = 46;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n89 = 63;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n89 = 69;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray86[n88] = (char)(c14 ^ n89);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray87;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray87 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n88 = n26;
                                                                                                            cArray86 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[11] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray88 = "[^OY#F_C] Z".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n90 = cArray88.length;
                                                                                                cArray22 = cArray88;
                                                                                                n24 = n90;
                                                                                                if (n90 <= 1) break block242;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block243;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray89 = cArray22;
                                                                                                char[] cArray90 = cArray22;
                                                                                                int n91 = n4;
                                                                                                while (true) {
                                                                                                    int n92;
                                                                                                    char c15 = cArray89[n91];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n92 = 40;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n92 = 42;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n92 = 46;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n92 = 63;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n92 = 69;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray89[n91] = (char)(c15 ^ n92);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray90;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray90 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n91 = n24;
                                                                                                    cArray89 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[12] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray91 = "f_BSeaD]\u001f".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n93 = cArray91.length;
                                                                                        cArray20 = cArray91;
                                                                                        n22 = n93;
                                                                                        if (n93 <= 1) break block244;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block245;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray92 = cArray20;
                                                                                        char[] cArray93 = cArray20;
                                                                                        int n94 = n4;
                                                                                        while (true) {
                                                                                            int n95;
                                                                                            char c16 = cArray92[n94];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n95 = 40;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n95 = 42;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n95 = 46;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n95 = 63;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n95 = 69;
                                                                                                }
                                                                                            }
                                                                                            cArray92[n94] = (char)(c16 ^ n95);
                                                                                            ++n4;
                                                                                            cArray20 = cArray93;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray93 = cArray20;
                                                                                            n21 = n22;
                                                                                            n94 = n22;
                                                                                            cArray92 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[13] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray94 = "aD]\u001f,FNKGeG_Z\u001f*N\n\\^+OO".toCharArray();
                                                                                n4 = 0;
                                                                                int n96 = cArray94.length;
                                                                                cArray18 = cArray94;
                                                                                n20 = n96;
                                                                                if (n96 <= 1) break block246;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block247;
                                                                            }
                                                                            do {
                                                                                char[] cArray95 = cArray18;
                                                                                char[] cArray96 = cArray18;
                                                                                int n97 = n4;
                                                                                while (true) {
                                                                                    int n98;
                                                                                    char c17 = cArray95[n97];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n98 = 40;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n98 = 42;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n98 = 46;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n98 = 63;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n98 = 69;
                                                                                        }
                                                                                    }
                                                                                    cArray95[n97] = (char)(c17 ^ n98);
                                                                                    ++n4;
                                                                                    cArray18 = cArray96;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray96 = cArray18;
                                                                                    n19 = n20;
                                                                                    n97 = n20;
                                                                                    cArray95 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[14] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray97 = "cowl\fod{r\u0004ki".toCharArray();
                                                                        n4 = 0;
                                                                        int n99 = cArray97.length;
                                                                        cArray16 = cArray97;
                                                                        n18 = n99;
                                                                        if (n99 <= 1) break block248;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block249;
                                                                    }
                                                                    do {
                                                                        char[] cArray98 = cArray16;
                                                                        char[] cArray99 = cArray16;
                                                                        int n100 = n4;
                                                                        while (true) {
                                                                            int n101;
                                                                            char c18 = cArray98[n100];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n101 = 40;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n101 = 42;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n101 = 46;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n101 = 63;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n101 = 69;
                                                                                }
                                                                            }
                                                                            cArray98[n100] = (char)(c18 ^ n101);
                                                                            ++n4;
                                                                            cArray16 = cArray99;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray99 = cArray16;
                                                                            n17 = n18;
                                                                            n100 = n18;
                                                                            cArray98 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[15] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray100 = "kfky\u0016m~lf\ridj".toCharArray();
                                                                n4 = 0;
                                                                int n102 = cArray100.length;
                                                                cArray14 = cArray100;
                                                                n16 = n102;
                                                                if (n102 <= 1) break block250;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block251;
                                                            }
                                                            do {
                                                                char[] cArray101 = cArray14;
                                                                char[] cArray102 = cArray14;
                                                                int n103 = n4;
                                                                while (true) {
                                                                    int n104;
                                                                    char c19 = cArray101[n103];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n104 = 40;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n104 = 42;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n104 = 46;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n104 = 63;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n104 = 69;
                                                                        }
                                                                    }
                                                                    cArray101[n103] = (char)(c19 ^ n104);
                                                                    ++n4;
                                                                    cArray14 = cArray102;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray102 = cArray14;
                                                                    n15 = n16;
                                                                    n103 = n16;
                                                                    cArray101 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[16] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray103 = "cowl\fo~wo\u0000".toCharArray();
                                                        n4 = 0;
                                                        int n105 = cArray103.length;
                                                        cArray12 = cArray103;
                                                        n14 = n105;
                                                        if (n105 <= 1) break block252;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block253;
                                                    }
                                                    do {
                                                        char[] cArray104 = cArray12;
                                                        char[] cArray105 = cArray12;
                                                        int n106 = n4;
                                                        while (true) {
                                                            int n107;
                                                            char c20 = cArray104[n106];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n107 = 40;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n107 = 42;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n107 = 46;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n107 = 63;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n107 = 69;
                                                                }
                                                            }
                                                            cArray104[n106] = (char)(c20 ^ n107);
                                                            ++n4;
                                                            cArray12 = cArray105;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray105 = cArray12;
                                                            n13 = n14;
                                                            n106 = n14;
                                                            cArray104 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[17] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray106 = "cowl\foykk\u0007qboq\u0001".toCharArray();
                                                n4 = 0;
                                                int n108 = cArray106.length;
                                                cArray10 = cArray106;
                                                n12 = n108;
                                                if (n108 <= 1) break block254;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block255;
                                            }
                                            do {
                                                char[] cArray107 = cArray10;
                                                char[] cArray108 = cArray10;
                                                int n109 = n4;
                                                while (true) {
                                                    int n110;
                                                    char c21 = cArray107[n109];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n110 = 40;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n110 = 42;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n110 = 46;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n110 = 63;
                                                            break;
                                                        }
                                                        default: {
                                                            n110 = 69;
                                                        }
                                                    }
                                                    cArray107[n109] = (char)(c21 ^ n110);
                                                    ++n4;
                                                    cArray10 = cArray108;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray108 = cArray10;
                                                    n11 = n12;
                                                    n109 = n12;
                                                    cArray107 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[18] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray109 = "ad}v\u000blovl\u0000|hww\u0004fn".toCharArray();
                                        n4 = 0;
                                        int n111 = cArray109.length;
                                        cArray8 = cArray109;
                                        n10 = n111;
                                        if (n111 <= 1) break block256;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block257;
                                    }
                                    do {
                                        char[] cArray110 = cArray8;
                                        char[] cArray111 = cArray8;
                                        int n112 = n4;
                                        while (true) {
                                            int n113;
                                            char c22 = cArray110[n112];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n113 = 40;
                                                    break;
                                                }
                                                case 1: {
                                                    n113 = 42;
                                                    break;
                                                }
                                                case 2: {
                                                    n113 = 46;
                                                    break;
                                                }
                                                case 3: {
                                                    n113 = 63;
                                                    break;
                                                }
                                                default: {
                                                    n113 = 69;
                                                }
                                            }
                                            cArray110[n112] = (char)(c22 ^ n113);
                                            ++n4;
                                            cArray8 = cArray111;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray111 = cArray8;
                                            n9 = n10;
                                            n112 = n10;
                                            cArray110 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[19] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray112 = "ad}k\u0017}gkq\u0011adjz\u001d".toCharArray();
                                n4 = 0;
                                int n114 = cArray112.length;
                                cArray6 = cArray112;
                                n8 = n114;
                                if (n114 <= 1) break block258;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block259;
                            }
                            do {
                                char[] cArray113 = cArray6;
                                char[] cArray114 = cArray6;
                                int n115 = n4;
                                while (true) {
                                    int n116;
                                    char c23 = cArray113[n115];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n116 = 40;
                                            break;
                                        }
                                        case 1: {
                                            n116 = 42;
                                            break;
                                        }
                                        case 2: {
                                            n116 = 46;
                                            break;
                                        }
                                        case 3: {
                                            n116 = 63;
                                            break;
                                        }
                                        default: {
                                            n116 = 69;
                                        }
                                    }
                                    cArray113[n115] = (char)(c23 ^ n116);
                                    ++n4;
                                    cArray6 = cArray114;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray114 = cArray6;
                                    n7 = n8;
                                    n115 = n8;
                                    cArray113 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[20] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray115 = "kfky".toCharArray();
                        n4 = 0;
                        int n117 = cArray115.length;
                        cArray4 = cArray115;
                        n6 = n117;
                        if (n117 <= 1) break block260;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block261;
                    }
                    do {
                        char[] cArray116 = cArray4;
                        char[] cArray117 = cArray4;
                        int n118 = n4;
                        while (true) {
                            int n119;
                            char c24 = cArray116[n118];
                            switch (n4 % 5) {
                                case 0: {
                                    n119 = 40;
                                    break;
                                }
                                case 1: {
                                    n119 = 42;
                                    break;
                                }
                                case 2: {
                                    n119 = 46;
                                    break;
                                }
                                case 3: {
                                    n119 = 63;
                                    break;
                                }
                                default: {
                                    n119 = 69;
                                }
                            }
                            cArray116[n118] = (char)(c24 ^ n119);
                            ++n4;
                            cArray4 = cArray117;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray117 = cArray4;
                            n5 = n6;
                            n118 = n6;
                            cArray116 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[21] = new String(cArray3).intern();
                var0 = null;
                char[] cArray118 = "adjz\u001d".toCharArray();
                n4 = 0;
                int n120 = cArray118.length;
                cArray2 = cArray118;
                n3 = n120;
                if (n120 <= 1) break block262;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block263;
            }
            do {
                char[] cArray119 = cArray2;
                char[] cArray120 = cArray2;
                int n121 = n4;
                while (true) {
                    int n122;
                    char c25 = cArray119[n121];
                    switch (n4 % 5) {
                        case 0: {
                            n122 = 40;
                            break;
                        }
                        case 1: {
                            n122 = 42;
                            break;
                        }
                        case 2: {
                            n122 = 46;
                            break;
                        }
                        case 3: {
                            n122 = 63;
                            break;
                        }
                        default: {
                            n122 = 69;
                        }
                    }
                    cArray119[n121] = (char)(c25 ^ n122);
                    ++n4;
                    cArray2 = cArray120;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray120 = cArray2;
                    n2 = n3;
                    n121 = n3;
                    cArray119 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[22] = new String(cArray).intern();
        M = stringArray;
    }
}

