/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score;

import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.DimensionNameSpaceComparison;
import com.softsynth.jmsl.DimensionNameSpaceTranslator;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.MusicList;
import com.softsynth.jmsl.score.AccidentalLevelManager;
import com.softsynth.jmsl.score.AccidentalPlacementCalculator;
import com.softsynth.jmsl.score.BeamRenderer;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.NoteFactory;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreLayoutManager;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.util.SimpleXMLSaver;
import com.softsynth.jmsl.util.XMLString;
import com.softsynth.jmsl.util.XMLWritable;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Track
extends MusicList
implements XMLWritable {
    private Vector y = new Vector();
    Staff z;
    Point2D A = new Point2D.Double();
    int B;
    public static final double TOLERABLE_ERROR;
    int C = 0;
    public static final String copyright;
    private static String[] D;

    public Track(Staff staff, int n2) {
        this.B = n2;
        this.z = staff;
        this.C = 0;
    }

    public Track(Staff staff, int n2, Instrument instrument) {
        this(staff, n2);
        this.setInstrument(instrument);
    }

    public void setInstrument(Instrument instrument) {
        DimensionNameSpace dimensionNameSpace;
        int n2 = Note.A;
        super.setInstrument(instrument);
        if (instrument != null && (dimensionNameSpace = instrument.getDimensionNameSpace()) != null) {
            DimensionNameSpaceTranslator dimensionNameSpaceTranslator = new DimensionNameSpaceTranslator();
            for (int i2 = 0; i2 < 4; ++i2) {
                dimensionNameSpaceTranslator.addInvariant(i2);
                if (n2 == 0) continue;
            }
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Note note = (Note)enumeration.nextElement();
                DimensionNameSpace dimensionNameSpace2 = note.getDimensionNameSpace();
                if (dimensionNameSpace2 != null && !DimensionNameSpaceComparison.equals((DimensionNameSpace)dimensionNameSpace, (DimensionNameSpace)dimensionNameSpace2)) {
                    dimensionNameSpaceTranslator.setDestinationDimensionNameSpace(dimensionNameSpace);
                    dimensionNameSpaceTranslator.setSourceDimensionNameSpace(dimensionNameSpace2);
                    double[] dArray = dimensionNameSpaceTranslator.translate(note.getData());
                    note.setDimensionNameSpace(dimensionNameSpace);
                    note.setDoubleArray(dArray);
                }
                if (n2 == 0) continue;
            }
        }
    }

    public int getTrackIndex() {
        return this.z.getChildren().indexOf((Object)this);
    }

    public Staff getStaff() {
        return this.z;
    }

    public Score getScore() {
        if (this.getStaff() == null) {
            return null;
        }
        return this.getStaff().getScore();
    }

    public Note getNote(int n2) {
        return (Note)this.getChildren().elementAt(n2);
    }

    public Vector getUserBeans() {
        return this.y;
    }

    public void addUserBean(Object object) {
        this.y.addElement(object);
    }

    public void removeUserBean(Object object) {
        this.y.removeElement(object);
    }

    public void setDrawingAnchor(Point2D point2D) {
        this.A.setLocation(point2D);
    }

    public Point2D getDrawingAnchor() {
        return this.A;
    }

    public boolean isEmpty() {
        return this.getChildren().size() == 0;
    }

    public int size() {
        return this.getChildren().size();
    }

    public boolean hasElementsLaterThan(double d2) {
        int n2 = Note.A;
        boolean bl = false;
        double d3 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (d3 >= d2) {
                bl = true;
                if (n2 == 0) break;
            }
            Note note = (Note)enumeration.nextElement();
            d3 += note.getDurationData();
            if (n2 == 0) continue;
        }
        return bl;
    }

    public double getDuration() {
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            d2 += note.getDurationData();
            if (Note.A == 0) continue;
        }
        return d2;
    }

    public double getStartTimeOfNote(Note note) {
        if (note.isInterval()) {
            note = note.getHandle();
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < note.getNoteIndex(); ++i2) {
            Note note2 = (Note)this.get(i2);
            d2 += note2.getDurationData();
            if (Note.A == 0) continue;
        }
        return d2;
    }

    public double getEndTimeOfNote(Note note) {
        if (note.isInterval()) {
            note = note.getHandle();
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 <= note.getNoteIndex(); ++i2) {
            Note note2 = (Note)this.get(i2);
            d2 += note2.getDurationData();
            if (Note.A == 0) continue;
        }
        return d2;
    }

    public Note getFirstNoteAfterTime(double d2) {
        Note note = null;
        double d3 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note2 = (Note)enumeration.nextElement();
            if (d3 >= d2) {
                note = note2;
                break;
            }
            d3 += note2.getDurationData();
        }
        return note;
    }

    public int getInsertionIndexForTime(double d2) {
        Note note = this.getFirstNoteAfterTime(d2);
        if (note == null) {
            return this.getChildren().size();
        }
        return this.getChildren().indexOf(note);
    }

    public Note getLastNoteBeforeTime(double d2) {
        Note note = null;
        double d3 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note2 = (Note)enumeration.nextElement();
            if (!(d3 <= d2)) break;
            note = note2;
            d3 += note2.getDurationData();
            if (Note.A == 0) continue;
        }
        if (note.isChord()) {
            return Note.getHighest(note);
        }
        return note;
    }

    void b() {
        Note note;
        if (!this.isEmpty() && (note = this.getNote(this.getChildren().size() - 1)) != null) {
            note.setBeamedOut(false);
            if (note.isChord()) {
                Enumeration enumeration = note.getIntervals().elements();
                while (enumeration.hasMoreElements()) {
                    ((Note)enumeration.nextElement()).setBeamedOut(false);
                    if (Note.A == 0) continue;
                }
            }
        }
    }

    void c() {
        int n2 = Note.A;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (note.getAcc() == 3) {
                note.setAcc(0);
            }
            if (note.isChord()) {
                Enumeration enumeration2 = note.getIntervals().elements();
                while (enumeration2.hasMoreElements()) {
                    Note note2 = (Note)enumeration2.nextElement();
                    if (note2.getAcc() == 3) {
                        note2.setAcc(0);
                    }
                    if (n2 == 0) continue;
                }
            }
            if (n2 == 0) continue;
        }
    }

    double d() {
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            d2 += note.getDurationData();
            if (Note.A == 0) continue;
        }
        return d2;
    }

    public String getDurationReport() {
        double d2;
        String string = "";
        double d3 = this.d();
        if (Math.abs(d3 - (d2 = this.getStaff().getMeasure().getTimeSig().getTotalTime())) > TOLERABLE_ERROR && d3 != 0.0) {
            int n2 = this.getStaff().getStaffIndex();
            int n3 = this.getStaff().getMeasure().getMeasureIndex();
            string = D[3] + (n3 + 1) + D[2] + (n2 + 1) + D[4] + d2 + D[0] + d3 + D[1] + (d2 - d3);
        }
        return string;
    }

    public void layoutChildren() {
        this.layoutChildren(true);
    }

    void e() {
        int n2 = Note.A;
        Vector<Note> vector = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            block8: {
                block7: {
                    Note note = (Note)enumeration.nextElement();
                    if (!note.getBeamedOut()) break block7;
                    if (vector == null) {
                        vector = new Vector<Note>();
                    }
                    vector.addElement(note);
                    if (n2 == 0) break block8;
                }
                if (vector != null) {
                    BeamRenderer.calcStemDirection(vector);
                    BeamRenderer.setStemDirection(vector);
                    vector = null;
                }
            }
            if (n2 == 0) continue;
        }
        if (vector != null) {
            BeamRenderer.setStemDirection(vector);
            vector = null;
        }
    }

    public void layoutChildren(boolean bl) {
        int n2 = Note.A;
        boolean bl2 = this.getStaff().size() > 1;
        int n3 = 1;
        if (this.getTrackIndex() < this.getStaff().size() / 2) {
            n3 = 2;
        }
        if (bl) {
            this.b();
        }
        this.c();
        AccidentalLevelManager accidentalLevelManager = this.resetAccidentalLevelManager();
        double d2 = 0.0;
        double d3 = this.getScore().getScoreLayoutManager().getZoom();
        Measure measure = this.getStaff().getMeasure();
        double d4 = this.A.getX() + measure.getLeftMargin() * d3;
        double d5 = measure.getTimeSig().getTotalTime();
        double d6 = Math.max(measure.getMaxDuration(), d5);
        double d7 = 0.0;
        double d8 = measure.getNoteAreaWidth();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Note note;
            int n4;
            Note note2 = (Note)enumeration.nextElement();
            if (bl2 && note2.getStemInfo() != 0 && !note2.getStemInfoOverride()) {
                note2.setStemInfo(n3);
            }
            d7 += note2.getDurationData();
            Note[] noteArray = Note.getSortedChord(note2);
            int n5 = note2.getStemInfo();
            for (n4 = 0; n4 < noteArray.length; ++n4) {
                double d9;
                Point2D.Double double_;
                block17: {
                    double d10;
                    block16: {
                        block15: {
                            block14: {
                                note = noteArray[n4];
                                NoteFactory.setLevelPitch(note, note.getPitchData());
                                if (n4 != 0) break block14;
                                n5 = note.getStemInfo();
                                if (n2 == 0) break block15;
                            }
                            note.setStemInfo(n5);
                        }
                        double_ = new Point2D.Double(d4, ScoreLayoutManager.calcNoteYPos(this.A.getY(), note.getLevel(), d3));
                        if (bl) {
                            note.setDrawingAnchor(double_);
                            note.setOverflow(d7 - d5 > TOLERABLE_ERROR);
                        }
                        if (!note.isRest()) {
                            this.manageAccidentals(accidentalLevelManager, note);
                            if (n2 == 0) continue;
                        }
                        if (!NoteFactory.isMultiTrack(note2)) continue;
                        d10 = 36.0 * d3;
                        int n6 = note2.getTrack().getTrackIndex();
                        d9 = ((Point2D)double_).getY();
                        if (n6 >= note2.getTrack().getStaff().size() / 2) break block16;
                        d9 += d10;
                        if (n2 == 0) break block17;
                    }
                    d9 -= d10;
                }
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), d9);
                if (!bl) continue;
                note.setDrawingAnchor(double_);
                if (n2 == 0) continue;
            }
            for (n4 = 0; n4 < note2.getGraceNotes().size(); ++n4) {
                note = (Note)note2.getGraceNotes().elementAt(n4);
                double d11 = note.getDrawingAnchor().getX();
                double d12 = ScoreLayoutManager.calcNoteYPos(this.A.getY(), note.getLevel(), d3);
                note.getDrawingAnchor().setLocation(d11, d12 += 12.0 * d3 / 3.0);
                note.setStemInfo(1);
                if (n2 == 0) continue;
            }
            new AccidentalPlacementCalculator().calculateAccidentalPlacement(note2);
            d4 += d3 * d8 * note2.getDurationData() / d6;
            if (n2 == 0) continue;
        }
    }

    public void manageAccidentals(AccidentalLevelManager accidentalLevelManager, Note note) {
        boolean bl;
        int n2;
        block8: {
            int n3;
            int n4;
            block7: {
                n4 = note.getAcc();
                note.setAccHidden(n4 == (n3 = accidentalLevelManager.getAccidentalForLevel(n2 = note.getLevel())));
                bl = this.a(note);
                if (bl) {
                    if (note.getAcc() == 0) {
                        note.setAcc(3);
                    }
                    note.setAccHidden(false);
                }
                if (n3 == 0 || n4 != 0) break block7;
                note.setAcc(3);
                accidentalLevelManager.setAccidentalForLevel(0, n2);
                if (Note.A == 0) break block8;
            }
            if (n4 != n3) {
                accidentalLevelManager.setAccidentalForLevel(n4, n2);
            }
        }
        if (bl) {
            accidentalLevelManager.setAccidentalForLevel(-1, n2);
        }
    }

    public AccidentalLevelManager resetAccidentalLevelManager() {
        AccidentalLevelManager accidentalLevelManager = this.getScore().getAccidentalLevelManager();
        accidentalLevelManager.clear();
        accidentalLevelManager.setAccidentalsFromKeySignature(this.getStaff());
        return accidentalLevelManager;
    }

    private boolean a(Note note) {
        boolean bl;
        block8: {
            Object object;
            int n2;
            int n3;
            block9: {
                Object object2;
                block7: {
                    n3 = Note.A;
                    bl = false;
                    if (!note.isChord()) break block7;
                    n2 = note.getLevel();
                    object2 = note.getIntervals().elements();
                    while (object2.hasMoreElements()) {
                        object = (Note)object2.nextElement();
                        if (((Note)object).getLevel() == n2) {
                            bl = true;
                            if (n3 == 0) break;
                        }
                        if (n3 == 0) continue;
                    }
                    if (n3 == 0) break block8;
                }
                if (!note.isInterval()) break block8;
                n2 = note.getLevel();
                object2 = note.getHandle();
                if (((Note)object2).getLevel() != n2) break block9;
                bl = true;
                if (n3 == 0) break block8;
            }
            object = note.getIntervals().elements();
            while (object.hasMoreElements()) {
                Note note2 = (Note)object.nextElement();
                if (note2 != note && note2.getLevel() == n2) {
                    bl = true;
                    if (n3 == 0) break;
                }
                if (n3 == 0) continue;
            }
        }
        return bl;
    }

    public void insertNote(Note note, int n2) {
        this.getChildren().insertElementAt(note, n2);
        note.setTrack(this);
        if (this.getStaff() != null && this.getStaff().getMeasure() != null) {
            this.getStaff().getMeasure().calcWidth();
        }
    }

    public void insertNote(Note note) {
        this.insertNote(note, this.C++);
    }

    public void setInsertionIndex(int n2) {
        this.C = n2;
    }

    public synchronized void deleteNote(Note note) {
        block7: {
            Vector vector;
            int n2;
            block8: {
                block6: {
                    n2 = Note.A;
                    vector = this.getChildren();
                    if (!note.isMonoNote()) break block6;
                    vector.removeElement(note);
                    if (n2 == 0) break block7;
                }
                if (!note.isInterval()) break block8;
                note.getHandle().removeInterval(note);
                if (n2 == 0) break block7;
            }
            if (note.isChord()) {
                int n3 = vector.indexOf(note);
                Note note2 = (Note)note.getIntervals().elementAt(0);
                note2.setHandle(null);
                note.removeInterval(note2);
                Enumeration enumeration = note.getIntervals().elements();
                while (enumeration.hasMoreElements()) {
                    note2.addInterval((Note)enumeration.nextElement());
                    if (n2 == 0) continue;
                }
                note.clearIntervals();
                vector.removeElement(note);
                this.insertNote(note2, n3);
                Note.resortChord(note2);
            }
        }
        if (this.getStaff() != null && this.getStaff().getMeasure() != null) {
            this.getStaff().getMeasure().calcWidth();
        }
    }

    public void render(Graphics graphics, double d2) {
        this.e();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Note)enumeration.nextElement()).render(graphics, d2);
            if (Note.A == 0) continue;
        }
    }

    public String getHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Score.indent() + D[8]);
        stringBuffer.append(Score.indent());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((Note)enumeration.nextElement() + " ");
            if (Note.A == 0) continue;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(D[8]);
        return stringBuffer.toString();
    }

    public void writeXML(PrintWriter printWriter) throws IOException {
        Note note;
        int n2 = Note.A;
        XMLString xMLString = new XMLString();
        xMLString.startElement(D[6], false);
        xMLString.addAttribute(D[7], this.getTrackIndex() + "");
        xMLString.endElement(null, true);
        printWriter.println(xMLString);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            note = (Note)enumeration.nextElement();
            note.writeXML(printWriter);
            if (n2 == 0) continue;
        }
        if (this.y != null) {
            enumeration = this.y.elements();
            while (enumeration.hasMoreElements()) {
                note = enumeration.nextElement();
                SimpleXMLSaver simpleXMLSaver = new SimpleXMLSaver((Object)note, D[5]);
                simpleXMLSaver.writeXML(printWriter);
                if (n2 == 0) continue;
            }
        }
        xMLString = new XMLString();
        xMLString.endElement(D[6], true);
        printWriter.println(xMLString);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block109: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block108: {
                char[] cArray3;
                Object var0;
                block107: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block106: {
                        char[] cArray5;
                        block105: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block104: {
                                char[] cArray7;
                                block103: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block102: {
                                        char[] cArray9;
                                        block101: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block100: {
                                                char[] cArray11;
                                                block99: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block98: {
                                                        char[] cArray13;
                                                        block97: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block96: {
                                                                char[] cArray15;
                                                                block95: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block94: {
                                                                        char[] cArray17;
                                                                        block93: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block92: {
                                                                                char[] cArray19;
                                                                                block91: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block90: {
                                                                                        stringArray = new String[9];
                                                                                        var0 = null;
                                                                                        char[] cArray21 = "|U+,zv]3!(7yru:/\nkuFvY0uLv^0:~lQ\"y(~V7uzv]3!{?H>&mmL>1".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n23 = cArray21.length;
                                                                                        cArray20 = cArray21;
                                                                                        n22 = n23;
                                                                                        if (n23 <= 1) break block90;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block91;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray22 = cArray20;
                                                                                        char[] cArray23 = cArray20;
                                                                                        int n24 = n4;
                                                                                        while (true) {
                                                                                            int n25;
                                                                                            char c2 = cArray22[n24];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n25 = 31;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n25 = 58;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n25 = 91;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n25 = 85;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n25 = 8;
                                                                                                }
                                                                                            }
                                                                                            cArray22[n24] = (char)(c2 ^ n25);
                                                                                            ++n4;
                                                                                            cArray20 = cArray23;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray23 = cArray20;
                                                                                            n21 = n22;
                                                                                            n24 = n22;
                                                                                            cArray22 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                copyright = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray24 = "3\u001a8:fk[2;{?".toCharArray();
                                                                                n4 = 0;
                                                                                int n26 = cArray24.length;
                                                                                cArray18 = cArray24;
                                                                                n20 = n26;
                                                                                if (n26 <= 1) break block92;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block93;
                                                                            }
                                                                            do {
                                                                                char[] cArray25 = cArray18;
                                                                                char[] cArray26 = cArray18;
                                                                                int n27 = n4;
                                                                                while (true) {
                                                                                    int n28;
                                                                                    char c3 = cArray25[n27];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n28 = 31;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n28 = 58;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n28 = 91;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n28 = 85;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n28 = 8;
                                                                                        }
                                                                                    }
                                                                                    cArray25[n27] = (char)(c3 ^ n28);
                                                                                    ++n4;
                                                                                    cArray18 = cArray26;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray26 = cArray18;
                                                                                    n19 = n20;
                                                                                    n27 = n20;
                                                                                    cArray25 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[0] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray27 = "3\u001a?<ny\u0007{".toCharArray();
                                                                        n4 = 0;
                                                                        int n29 = cArray27.length;
                                                                        cArray16 = cArray27;
                                                                        n18 = n29;
                                                                        if (n29 <= 1) break block94;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block95;
                                                                    }
                                                                    do {
                                                                        char[] cArray28 = cArray16;
                                                                        char[] cArray29 = cArray16;
                                                                        int n30 = n4;
                                                                        while (true) {
                                                                            int n31;
                                                                            char c4 = cArray28[n30];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n31 = 31;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n31 = 58;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n31 = 91;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n31 = 85;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n31 = 8;
                                                                                }
                                                                            }
                                                                            cArray28[n30] = (char)(c4 ^ n31);
                                                                            ++n4;
                                                                            cArray16 = cArray29;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray29 = cArray16;
                                                                            n17 = n18;
                                                                            n30 = n18;
                                                                            cArray28 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[1] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray30 = "?i/4ny\u001a".toCharArray();
                                                                n4 = 0;
                                                                int n32 = cArray30.length;
                                                                cArray14 = cArray30;
                                                                n16 = n32;
                                                                if (n32 <= 1) break block96;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block97;
                                                            }
                                                            do {
                                                                char[] cArray31 = cArray14;
                                                                char[] cArray32 = cArray14;
                                                                int n33 = n4;
                                                                while (true) {
                                                                    int n34;
                                                                    char c5 = cArray31[n33];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n34 = 31;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n34 = 58;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n34 = 91;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n34 = 85;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n34 = 8;
                                                                        }
                                                                    }
                                                                    cArray31[n33] = (char)(c5 ^ n34);
                                                                    ++n4;
                                                                    cArray14 = cArray32;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray32 = cArray14;
                                                                    n15 = n16;
                                                                    n33 = n16;
                                                                    cArray31 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[2] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray33 = "R_:&}m_{".toCharArray();
                                                        n4 = 0;
                                                        int n35 = cArray33.length;
                                                        cArray12 = cArray33;
                                                        n14 = n35;
                                                        if (n35 <= 1) break block98;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block99;
                                                    }
                                                    do {
                                                        char[] cArray34 = cArray12;
                                                        char[] cArray35 = cArray12;
                                                        int n36 = n4;
                                                        while (true) {
                                                            int n37;
                                                            char c6 = cArray34[n36];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n37 = 31;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n37 = 58;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n37 = 91;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n37 = 85;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n37 = 8;
                                                                }
                                                            }
                                                            cArray34[n36] = (char)(c6 ^ n37);
                                                            ++n4;
                                                            cArray12 = cArray35;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray35 = cArray12;
                                                            n13 = n14;
                                                            n36 = n14;
                                                            cArray34 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[3] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray36 = "?H>$}vH>&(".toCharArray();
                                                n4 = 0;
                                                int n38 = cArray36.length;
                                                cArray10 = cArray36;
                                                n12 = n38;
                                                if (n38 <= 1) break block100;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block101;
                                            }
                                            do {
                                                char[] cArray37 = cArray10;
                                                char[] cArray38 = cArray10;
                                                int n39 = n4;
                                                while (true) {
                                                    int n40;
                                                    char c7 = cArray37[n39];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n40 = 31;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n40 = 58;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n40 = 91;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n40 = 85;
                                                            break;
                                                        }
                                                        default: {
                                                            n40 = 8;
                                                        }
                                                    }
                                                    cArray37[n39] = (char)(c7 ^ n40);
                                                    ++n4;
                                                    cArray10 = cArray38;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray38 = cArray10;
                                                    n11 = n12;
                                                    n39 = n12;
                                                    cArray37 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[4] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray39 = "kH:6cJI>'Jz[5".toCharArray();
                                        n4 = 0;
                                        int n41 = cArray39.length;
                                        cArray8 = cArray39;
                                        n10 = n41;
                                        if (n41 <= 1) break block102;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block103;
                                    }
                                    do {
                                        char[] cArray40 = cArray8;
                                        char[] cArray41 = cArray8;
                                        int n42 = n4;
                                        while (true) {
                                            int n43;
                                            char c8 = cArray40[n42];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n43 = 31;
                                                    break;
                                                }
                                                case 1: {
                                                    n43 = 58;
                                                    break;
                                                }
                                                case 2: {
                                                    n43 = 91;
                                                    break;
                                                }
                                                case 3: {
                                                    n43 = 85;
                                                    break;
                                                }
                                                default: {
                                                    n43 = 8;
                                                }
                                            }
                                            cArray40[n42] = (char)(c8 ^ n43);
                                            ++n4;
                                            cArray8 = cArray41;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray41 = cArray8;
                                            n9 = n10;
                                            n42 = n10;
                                            cArray40 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[5] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray42 = "kH:6c".toCharArray();
                                n4 = 0;
                                int n44 = cArray42.length;
                                cArray6 = cArray42;
                                n8 = n44;
                                if (n44 <= 1) break block104;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block105;
                            }
                            do {
                                char[] cArray43 = cArray6;
                                char[] cArray44 = cArray6;
                                int n45 = n4;
                                while (true) {
                                    int n46;
                                    char c9 = cArray43[n45];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n46 = 31;
                                            break;
                                        }
                                        case 1: {
                                            n46 = 58;
                                            break;
                                        }
                                        case 2: {
                                            n46 = 91;
                                            break;
                                        }
                                        case 3: {
                                            n46 = 85;
                                            break;
                                        }
                                        default: {
                                            n46 = 8;
                                        }
                                    }
                                    cArray43[n45] = (char)(c9 ^ n46);
                                    ++n4;
                                    cArray6 = cArray44;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray44 = cArray6;
                                    n7 = n8;
                                    n45 = n8;
                                    cArray43 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[6] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray45 = "Vt\u001f\u0010P".toCharArray();
                        n4 = 0;
                        int n47 = cArray45.length;
                        cArray4 = cArray45;
                        n6 = n47;
                        if (n47 <= 1) break block106;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block107;
                    }
                    do {
                        char[] cArray46 = cArray4;
                        char[] cArray47 = cArray4;
                        int n48 = n4;
                        while (true) {
                            int n49;
                            char c10 = cArray46[n48];
                            switch (n4 % 5) {
                                case 0: {
                                    n49 = 31;
                                    break;
                                }
                                case 1: {
                                    n49 = 58;
                                    break;
                                }
                                case 2: {
                                    n49 = 91;
                                    break;
                                }
                                case 3: {
                                    n49 = 85;
                                    break;
                                }
                                default: {
                                    n49 = 8;
                                }
                            }
                            cArray46[n48] = (char)(c10 ^ n49);
                            ++n4;
                            cArray4 = cArray47;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray47 = cArray4;
                            n5 = n6;
                            n48 = n6;
                            cArray46 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[7] = new String(cArray3).intern();
                var0 = null;
                char[] cArray48 = "KH:6c\u0015".toCharArray();
                n4 = 0;
                int n50 = cArray48.length;
                cArray2 = cArray48;
                n3 = n50;
                if (n50 <= 1) break block108;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block109;
            }
            do {
                char[] cArray49 = cArray2;
                char[] cArray50 = cArray2;
                int n51 = n4;
                while (true) {
                    int n52;
                    char c11 = cArray49[n51];
                    switch (n4 % 5) {
                        case 0: {
                            n52 = 31;
                            break;
                        }
                        case 1: {
                            n52 = 58;
                            break;
                        }
                        case 2: {
                            n52 = 91;
                            break;
                        }
                        case 3: {
                            n52 = 85;
                            break;
                        }
                        default: {
                            n52 = 8;
                        }
                    }
                    cArray49[n51] = (char)(c11 ^ n52);
                    ++n4;
                    cArray2 = cArray50;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray50 = cArray2;
                    n2 = n3;
                    n51 = n3;
                    cArray49 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[8] = new String(cArray).intern();
        D = stringArray;
        TOLERABLE_ERROR = Note.coreDurations[8] / 5.0;
    }
}

