/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score.util;

import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentAdapter;
import com.softsynth.jmsl.JMSLRandom;
import com.softsynth.jmsl.score.Clef;
import com.softsynth.jmsl.score.KeySignature;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.NoteNamer;
import com.softsynth.jmsl.score.Orchestra;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Tempo;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.score.operators.DurationReporter;
import com.softsynth.jmsl.score.operators.UnbalancedRepeatsReporter;
import com.softsynth.jmsl.score.util.AutoBeamer;
import com.softsynth.jmsl.util.JMSLMath;
import com.softsynth.jmsl.util.TimeSignature;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class LilyPondWriter {
    public static final String LY_VERSION;
    private String a = B[176];
    private String b = null;
    private Score c;
    private PrintWriter d;
    private TimeSignature e = null;
    private KeySignature[] f;
    private Clef g = null;
    private int h = 0;
    private Tempo i = null;
    private String j = "";
    private boolean k = true;
    private boolean l = false;
    private boolean m = false;
    private boolean n = false;
    private int o = 0;
    private boolean p = false;
    private boolean q = false;
    private Vector r;
    private File s;
    private String t;
    private String u;
    private boolean v = false;
    private Vector w = new Vector();
    private static final String[] x;
    private boolean y = false;
    Color z = null;
    static String A;
    private static String[] B;

    public LilyPondWriter(Score score, File file) throws IOException {
        this.c = score;
        this.s = file;
        this.a = file.getName();
        if (this.a(this.a)) {
            throw new IOException(B[177] + this.a + "\"");
        }
        this.a();
        this.b();
        if (this.a.indexOf(".") != -1) {
            this.a = this.a.substring(0, this.a.indexOf("."));
        }
        this.b = file.getParentFile().getAbsolutePath();
        this.f = new KeySignature[score.getNumStaves()];
    }

    private void a() {
        DurationReporter durationReporter = new DurationReporter();
        durationReporter.operate(this.c);
        this.t = durationReporter.getResultString();
        if (this.durationErrorsInScore()) {
            this.t = B[52] + this.c.getName() + B[156] + B[157] + this.t;
        }
    }

    private void b() {
        UnbalancedRepeatsReporter unbalancedRepeatsReporter = new UnbalancedRepeatsReporter();
        unbalancedRepeatsReporter.operate(this.c);
        this.u = unbalancedRepeatsReporter.getResultString();
        if (this.unbalancedRepeatsErrorsInScore()) {
            this.u = B[52] + this.c.getName() + B[51] + B[50] + this.u;
        }
    }

    private boolean a(String string) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < x.length; ++i2) {
            if (this.a.indexOf(x[i2]) == -1) continue;
            bl2 = false;
            if (!bl) break;
            if (!bl) continue;
        }
        return !bl2;
    }

    boolean a(int n2) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            Measure measure = this.c.getMeasure(i2);
            Staff staff = measure.getStaff(n2);
            block1: for (int i3 = 0; i3 < staff.size(); ++i3) {
                Track track = staff.getTrack(i3);
                Enumeration enumeration = track.elements();
                while (enumeration.hasMoreElements()) {
                    Note note = (Note)enumeration.nextElement();
                    if (!note.isRest() && !note.getTiedIn()) {
                        boolean bl3 = bl2 = bl2 && note.getText() != null && note.getText().length() > 0;
                        if (!bl2 && !bl) continue block1;
                    }
                    if (!bl) continue;
                }
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        bl2 = false;
        System.out.println(B[14]);
        return bl2;
    }

    public void write() throws IOException {
        boolean bl = AutoBeamer.c;
        int n2 = this.c.getNumStaves();
        this.r = new Vector();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.v = this.a(i2);
            if (this.v) {
                this.w = new Vector();
                System.out.println(B[173] + i2 + B[175]);
            }
            this.b(i2);
            this.k();
            this.c();
            for (int i3 = 0; i3 < this.c.size(); ++i3) {
                Measure measure = this.c.getMeasure(i3);
                this.d.println(B[174] + (i3 + 1));
                if (this.h != 0) {
                    this.q();
                }
                this.h = 0;
                Staff staff = measure.getStaff(i2);
                if (i3 == 0 && staff.getInstrument() != null) {
                    this.a(staff);
                }
                this.c(staff);
                if (!bl) continue;
            }
            this.e();
            this.d();
            this.o();
            if (!bl) continue;
        }
        this.f();
        this.g();
    }

    private void c() {
        if (this.v) {
            this.d.println("{");
        }
    }

    private void d() {
        if (this.v) {
            this.d.println("}");
            this.d.println(B[13]);
            Enumeration enumeration = this.w.elements();
            while (enumeration.hasMoreElements()) {
                this.d.print((String)enumeration.nextElement() + " ");
                if (!AutoBeamer.c) continue;
            }
            this.d.println("}");
        }
    }

    private void a(Measure measure) {
        if (measure.getMeasureText() != null && measure.getMeasureText().length() > 0) {
            this.d.println(B[167]);
            this.d.println(B[168] + measure.getMeasureText() + "\"");
        }
    }

    private void e() {
        if (this.o != 0) {
            this.d.println(B[79]);
        }
        if (this.n) {
            this.d.print(B[36]);
        }
        if (this.m) {
            this.d.print(B[144]);
        }
        if (this.l && !this.p) {
            this.d.print(B[154]);
        }
    }

    public boolean durationErrorsInScore() {
        return this.t != null && this.t.indexOf(B[53]) == -1;
    }

    public String getDurationErrorReport() {
        return this.t;
    }

    public boolean unbalancedRepeatsErrorsInScore() {
        return this.u != null && this.u.toLowerCase().indexOf(B[166]) != -1;
    }

    public String getUnbalancedRepeatsErrorReport() {
        return this.u;
    }

    private void a(Staff staff) {
        String string;
        String string2 = string = staff.getInstrument().getName();
        String string3 = string;
        if (string.indexOf("_") != -1) {
            string2 = string.substring(0, string.indexOf("_"));
            string3 = string.substring(string.indexOf("_") + 1, string.length());
        }
        this.d.println("\n");
        this.d.println(B[63] + string2 + B[64]);
        this.d.println(B[62] + string3 + B[64]);
    }

    private void f() throws IOException {
        this.d = new PrintWriter(new FileWriter(this.s));
        this.s();
        this.r();
        this.n();
        this.d.println(B[18]);
        this.m();
        this.i();
        this.t();
        this.u();
        this.p();
        this.h();
        this.j();
        this.q();
        this.d.close();
    }

    private void g() throws IOException {
        int n2 = 0;
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            Staff staff = this.c.getMeasure(0).getStaff(n2);
            String string = B[49] + n2;
            Instrument instrument = staff.getInstrument();
            if (instrument != null && (string = staff.getInstrument().getName()).indexOf("_") != -1) {
                string = string.substring(0, string.indexOf("_"));
            }
            String string2 = (String)enumeration.nextElement();
            int n3 = string2.indexOf(".");
            String string3 = string2.substring(0, n3);
            String string4 = this.a;
            String string5 = this.b(string);
            string4 = string4 + "-" + string5 + B[48];
            System.out.println(B[45] + string4);
            File file = new File(this.b, string4);
            this.d = new PrintWriter(new FileWriter(file));
            this.s();
            this.r();
            this.m();
            this.i();
            this.d(string);
            this.u();
            this.p();
            this.h();
            this.d.println(B[44]);
            this.d.println(B[47]);
            this.d.println(B[46] + string3);
            this.d.println(B[43]);
            this.q();
            this.d.close();
            ++n2;
            if (!AutoBeamer.c) continue;
        }
    }

    private void h() {
        this.d.println(B[97]);
    }

    private String b(String string) {
        return string.replace(' ', '_');
    }

    private void i() {
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.d.println(B[0] + string + "\"");
            if (!AutoBeamer.c) continue;
        }
    }

    private void j() {
        this.d.println(B[47]);
        Enumeration enumeration = this.r.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf("."));
            this.d.println(B[46] + string2);
            if (!AutoBeamer.c) continue;
        }
        this.d.println(B[43]);
    }

    private void k() {
        this.e = null;
        this.g = null;
        this.h = 0;
        this.l = false;
        this.m = false;
        this.n = false;
        this.p = false;
        this.j = "";
        this.k = true;
        this.o = 0;
        this.q = false;
        this.i = null;
    }

    private void b(int n2) throws IOException {
        String string = this.h(n2);
        this.r.addElement(string);
        this.d = new PrintWriter(new FileWriter(new File(this.b, string)));
        this.s();
        this.r();
        this.d.println(B[12] + (n2 + 1) + "\n");
        this.c(string);
        this.p();
        this.l();
    }

    private void l() {
        this.d.println(B[4]);
        this.d.println(B[2]);
        this.d.println(B[5]);
        this.d.println(B[3]);
    }

    private void m() {
        this.d.println(B[112]);
        this.d.println(B[105]);
        this.d.println(B[106]);
        this.d.println(B[111]);
        this.d.println(B[108]);
        this.d.println(B[110]);
        this.d.println(B[107]);
        this.d.println(B[109]);
    }

    private void n() {
        this.d.println(B[15]);
    }

    private void c(String string) {
        String string2 = string.substring(0, string.indexOf("."));
        this.d.print("\"" + string2 + "\"" + B[34]);
    }

    private void o() {
        if (this.h != 0) {
            this.q();
        }
        this.q();
        this.d.close();
    }

    private boolean b(Staff staff) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = true;
        for (int i2 = 0; i2 < staff.size(); ++i2) {
            Track track = staff.getTrack(i2);
            boolean bl3 = bl2 = track.size() == 0;
            if (!bl2 && !bl) break;
            if (!bl) continue;
        }
        return bl2;
    }

    private void c(Staff staff) throws IOException {
        block10: {
            boolean bl;
            boolean bl2;
            block9: {
                bl2 = AutoBeamer.c;
                this.a(staff.getMeasure());
                this.e(staff);
                this.j(staff);
                this.d(staff);
                this.i(staff);
                this.h(staff);
                if (!this.b(staff)) break block9;
                this.g(staff);
                if (!bl2) break block10;
            }
            if (bl = staff.isMultiTrack()) {
                this.d.print(B[38]);
            }
            for (int i2 = staff.size() - 1; i2 >= 0; --i2) {
                Track track = staff.getTrack(i2);
                track.layoutChildren();
                if (bl) {
                    this.p();
                }
                for (int i3 = 0; i3 < track.size(); ++i3) {
                    Note note = track.getNote(i3);
                    this.d(note);
                    this.c(note);
                    this.b(note);
                    this.a(staff, note);
                    this.f(note);
                    this.g(note);
                    this.i(note);
                    if (!bl2) continue;
                }
                if (bl) {
                    this.q();
                }
                if (!bl || i2 == 0) continue;
                this.d.println(B[40]);
                if (!bl2) continue;
            }
            if (bl) {
                this.d.println(B[39]);
            }
        }
        this.f(staff);
    }

    private String a(int n2, String string) {
        String string2 = n2 % 2 == 1 ? B[153] : B[152];
        return "\\" + string + string2;
    }

    private void d(Staff staff) {
        String string;
        block7: {
            block6: {
                int n2 = staff.getKeySignature().getNumAccidentals();
                int n3 = staff.getKeySignature().getKeySignatureType();
                string = null;
                KeySignature keySignature = this.f[staff.getStaffIndex()];
                if (keySignature != null && keySignature.equals(staff.getKeySignature())) {
                    this.f[staff.getStaffIndex()] = staff.getKeySignature();
                    return;
                }
                this.f[staff.getStaffIndex()] = staff.getKeySignature();
                if (n2 == 0) {
                    this.d.println(B[161]);
                    return;
                }
                string = n3 == 0 ? KeySignature.KEYSIG_SHARP_NAMES[n2 - 1] : KeySignature.KEYSIG_FLAT_NAMES[n2 - 1];
                if (!(string = string.substring(0, string.indexOf(47))).endsWith("#")) break block6;
                string = string.substring(0, 1) + B[67];
                if (!AutoBeamer.c) break block7;
            }
            if (string.endsWith("b") && string.length() == 2) {
                string = string.substring(0, 1) + B[71];
            }
        }
        string = string.toLowerCase();
        this.d.println(B[163] + string + B[162]);
    }

    private boolean a(Note note) {
        boolean bl;
        block6: {
            int n2;
            block5: {
                bl = true;
                if (note.getTuplet() != 0) break block5;
                bl = false;
                if (!AutoBeamer.c) break block6;
            }
            int n3 = note.getTuplet();
            if (note.nextNote() != null && (n2 = note.nextNote().getTuplet()) == n3) {
                boolean bl2 = bl = !note.getBeamedOut();
            }
            if (note.prevNote() != null && (n2 = note.prevNote().getTuplet()) == n3) {
                bl = bl && !note.prevNote().getBeamedOut();
            }
        }
        return bl;
    }

    private void b(Note note) {
        if (this.o != 1 && note.is8va()) {
            this.d.println(B[80]);
            this.o = 1;
            return;
        }
        if (this.o != -1 && note.is8vb()) {
            this.d.println(B[81]);
            this.o = -1;
            return;
        }
        if (this.o != 0 && !note.is8va() && !note.is8vb()) {
            this.d.println(B[79]);
            this.o = 0;
            return;
        }
    }

    private void e(Staff staff) {
        if (staff.getMeasure().getRepeatStart()) {
            int n2 = this.b(staff.getMeasure());
            this.d.println(B[59] + n2);
            this.p();
            if (n2 > 1) {
                String string = B[58];
                if (this.y) {
                    string = B[61];
                }
                this.d.println(B[60] + (n2 + 1) + B[57] + string + ")");
            }
        }
    }

    private int b(Measure measure) {
        boolean bl = AutoBeamer.c;
        int n2 = 2;
        for (int i2 = measure.getMeasureIndex(); i2 < measure.getScore().size(); ++i2) {
            Measure measure2 = measure.getScore().getMeasure(i2);
            if (!measure2.getRepeatEnd()) continue;
            n2 = measure2.getNumRepeats();
            if (!bl) break;
            if (!bl) continue;
        }
        return n2;
    }

    private void f(Staff staff) {
        block6: {
            String string;
            block7: {
                boolean bl;
                block5: {
                    bl = AutoBeamer.c;
                    this.y = false;
                    if (!staff.getMeasure().getRepeatEnd()) break block5;
                    this.y = true;
                    if (staff.getMeasure().getNumRepeats() > 1) {
                        this.d.println(B[76]);
                        this.d.println(B[75]);
                    }
                    this.q();
                    if (!bl) break block6;
                }
                if (!staff.getMeasure().getDoubleBar()) break block7;
                string = B[78];
                this.d.print(B[74] + string + B[77]);
                if (!bl) break block6;
            }
            if (staff.getMeasure().getPeriodDoubleBar()) {
                string = B[73];
                this.d.print(B[74] + string + B[77]);
            }
        }
    }

    private void g(Staff staff) {
        int n2 = staff.getMeasure().getTimeSig().getNumerator();
        int n3 = staff.getMeasure().getTimeSig().getDenominator();
        String string = "R" + n3 + "*" + n2;
        this.d.print(" " + string + " ");
    }

    private void c(Note note) {
        String string = this.e(note);
        if (note.getNoteHeadType() > 1 && !string.equals(this.j)) {
            if (!string.equals(B[42])) {
                this.d.println(string);
                if (!note.isChord() && !note.isInterval()) {
                    this.k = false;
                }
            }
            if (!note.isChord() && !note.isInterval()) {
                this.j = string;
            }
        }
    }

    private void d(Note note) {
        if (!this.k && (note.isChord() || note.getNoteHeadType() <= 1 || this.e(note).equals(B[42]))) {
            this.d.println(B[41]);
            this.k = true;
            this.j = "";
        }
    }

    private String e(Note note) {
        boolean bl = AutoBeamer.c;
        String string = "";
        String string2 = B[103];
        if (note.isChord() || note.isInterval()) {
            string2 = B[98];
        }
        switch (note.getNoteHeadType()) {
            case 6: {
                string = string2 + B[101];
                if (!bl) break;
            }
            case 5: {
                if (!bl) break;
            }
            case 10: {
                string = B[42];
                if (!bl) break;
            }
            case 9: {
                string = B[42];
                if (!bl) break;
            }
            case 8: {
                string = string2 + B[100];
                if (!bl) break;
            }
            case 7: {
                string = string2 + B[100];
                if (!bl) break;
            }
            case 11: {
                string = B[42];
                if (!bl) break;
            }
            case 12: {
                string = string2 + B[99];
                if (!bl) break;
            }
            case 2: {
                string = string2 + B[104];
                if (!bl) break;
            }
            case 4: {
                string = string2 + B[101];
                if (!bl) break;
            }
            case 3: {
                string = string2 + B[102];
            }
        }
        return string;
    }

    private void f(Note note) {
        if (!this.n && note.getCrescOut()) {
            this.d.print(B[35]);
            this.n = true;
            return;
        }
        if (!this.n && note.getDecrescOut()) {
            this.d.print(B[37]);
            this.n = true;
            return;
        }
        if (this.n && !note.getDecrescOut() && !note.getCrescOut()) {
            this.d.print(B[36]);
            this.n = false;
            return;
        }
    }

    private void g(Note note) {
        if (!this.m && note.getSlurredOut()) {
            this.d.print(B[145]);
            this.m = true;
            return;
        }
        if (this.m && !note.getSlurredOut()) {
            this.d.print(B[144]);
            this.m = false;
            return;
        }
    }

    private boolean h(Note note) {
        boolean bl = AutoBeamer.c;
        boolean bl2 = false;
        int n2 = note.getTuplet();
        while (note != null && n2 == note.getTuplet() && n2 != 0 && note.getBeamedOut()) {
            boolean bl3 = bl2 = note.getCoreDuration() <= 2;
            if (bl2 && !bl) break;
            note = note.nextNote();
            if (!bl) continue;
        }
        if (!bl2 && n2 == note.getTuplet() && n2 != 0 && !note.getBeamedOut()) {
            bl2 = note.getCoreDuration() <= 2;
        }
        return bl2;
    }

    private void i(Note note) {
        if (!this.l && note.getBeamedOut()) {
            this.p = this.h(note);
            if (!this.p) {
                this.d.print(B[155]);
            }
            this.l = true;
            return;
        }
        if (this.l && !note.getBeamedOut()) {
            if (!this.p) {
                this.d.print(B[154]);
            }
            this.l = false;
            this.p = false;
            this.c(0);
            return;
        }
    }

    private void h(Staff staff) {
        boolean bl = AutoBeamer.c;
        Clef clef = staff.getClef();
        if (this.g == null || !this.g.equals(clef)) {
            String string = "";
            switch (clef.getClefType()) {
                case 0: {
                    string = B[6];
                    if (!bl) break;
                }
                case 1: {
                    string = B[7];
                    if (!bl) break;
                }
                case 2: {
                    string = B[11];
                    if (!bl) break;
                }
                case 3: {
                    string = B[9];
                    if (!bl) break;
                }
                case 4: {
                    string = B[10];
                }
            }
            this.d.println(B[8] + string);
            this.g = clef;
        }
    }

    private void p() {
        this.d.println("{");
    }

    private void q() {
        this.d.println(B[54]);
    }

    private String j(Note note) {
        boolean bl = AutoBeamer.c;
        String string = B[159];
        for (int i2 = 0; i2 < note.getMarks().size(); ++i2) {
            int n2 = (Integer)note.getMarks().elementAt(i2);
            if (n2 != 19) continue;
            string = B[158];
            if (!bl) break;
            if (!bl) continue;
        }
        return string;
    }

    int k(Note note) {
        boolean bl = AutoBeamer.c;
        int n2 = 0;
        for (int i2 = 0; i2 < note.getMarks().size(); ++i2) {
            int n3 = (Integer)note.getMarks().elementAt(i2);
            if (n3 == 16) {
                n2 = 2;
                if (!bl) break;
            }
            if (n3 == 17) {
                n2 = 3;
                if (!bl) break;
            }
            if (n3 != 18) continue;
            n2 = 4;
            if (!bl) break;
            if (!bl) continue;
        }
        return n2;
    }

    int l(Note note) {
        int n2 = note.getCoreDuration();
        return Math.max(1, n2 - 1);
    }

    private int m(Note note) {
        int n2 = this.k(note);
        int n3 = this.l(note);
        System.out.println(B[151] + note.getCoreDuration() + B[150] + n2 + B[149] + n3);
        int n4 = n2 + n3;
        int n5 = (int)Math.pow(2.0, n4);
        return n5;
    }

    private String n(Note note) {
        String string = "";
        if (this.k(note) != 0) {
            string = ":" + this.m(note);
        }
        return string;
    }

    private void a(Staff staff, Note note) {
        block37: {
            block36: {
                String string;
                boolean bl;
                block34: {
                    block35: {
                        String string2;
                        String string3;
                        Object object;
                        block33: {
                            String string4;
                            block30: {
                                block29: {
                                    block28: {
                                        bl = AutoBeamer.c;
                                        if (note.isVisible()) break block28;
                                        this.d.print(B[114]);
                                        if (!bl) break block29;
                                    }
                                    if (!note.isStemVisible()) {
                                        this.d.print(B[116]);
                                    }
                                }
                                string4 = this.b(staff, note);
                                if (note.getGraceNotes().size() <= 1) break block30;
                                boolean bl2 = false;
                                for (int i2 = 0; i2 < note.getGraceNotes().size(); ++i2) {
                                    block32: {
                                        block31: {
                                            object = (Note)note.getGraceNotes().elementAt(i2);
                                            string3 = this.c(staff, (Note)object);
                                            string2 = this.v((Note)object);
                                            if (i2 != 0) break block31;
                                            if (staff.isMultiTrack()) {
                                                this.d.print(this.a(note.getTrack().getTrackIndex(), B[122]) + " ");
                                            }
                                            this.d.print("\\" + this.j((Note)object) + B[127] + string3 + string2);
                                            bl2 = ((Note)object).getBeamedOut();
                                            if (!bl2) break block32;
                                            this.d.print(B[123]);
                                            if (!bl) break block32;
                                        }
                                        this.d.print(" " + string3 + string2);
                                    }
                                    if (i2 != note.getGraceNotes().size() - 1) continue;
                                    if (bl2) {
                                        this.d.print(B[119]);
                                    }
                                    this.d.println(B[124]);
                                    this.d.println(string4);
                                    if (!bl) continue;
                                }
                                if (!bl) break block33;
                            }
                            if (note.getGraceNotes().size() == 1) {
                                Note note2 = (Note)note.getGraceNotes().elementAt(0);
                                String string5 = this.c(staff, note2);
                                object = this.v(note2);
                                if (staff.isMultiTrack()) {
                                    this.d.print(this.a(note.getTrack().getTrackIndex(), B[122]) + " ");
                                }
                                this.d.print("\\" + this.j(note2) + " " + string5 + (String)object + " " + string4);
                            }
                        }
                        this.c(note.getTuplet());
                        string = this.c(staff, note);
                        this.d.println(this.o(note));
                        if (this.s(note) && staff.isMultiTrack()) {
                            this.d.print(this.a(note.getTrack().getTrackIndex(), B[118]) + " ");
                        }
                        if (note.isChord()) {
                            string = B[115] + string;
                            Enumeration enumeration = note.getIntervals().elements();
                            while (enumeration.hasMoreElements()) {
                                object = (Note)enumeration.nextElement();
                                string = string + this.o((Note)object);
                                string = string + " " + this.c(staff, (Note)object);
                                if (!bl) continue;
                            }
                            string = string + B[126];
                        }
                        String string6 = this.v(note);
                        object = this.w(note);
                        string3 = this.r(note);
                        string2 = this.q(note);
                        String string7 = this.u(note);
                        String string8 = this.n(note);
                        string = string + string6;
                        string = string + (String)object;
                        string = string + string8;
                        if (!note.isChord()) {
                            string = string + string3;
                        }
                        string = string + string2;
                        string = string + string7;
                        if (this.a(note)) {
                            string = string + B[117] + note.getTuplet() + B[125];
                        }
                        if (note.getText() == null || note.getText().length() <= 0) break block34;
                        if (!this.v) break block35;
                        this.w.addElement(note.getText());
                        if (!bl) break block34;
                    }
                    string = string + this.p(note);
                }
                if (note.prevNote() != null && !note.prevNote().getBeamedOut()) {
                    string = string + B[113];
                }
                this.d.print(string + " ");
                if (note.isVisible()) break block36;
                this.d.println(B[120]);
                if (!bl) break block37;
            }
            if (!note.isStemVisible()) {
                this.d.print(B[121]);
            }
        }
    }

    private String b(Staff staff, Note note) {
        String string = "";
        boolean bl = staff.isMultiTrack();
        if (bl) {
            string = note.getTrack().getTrackIndex() % 2 == 1 ? B[17] : B[16];
        }
        return string;
    }

    private String o(Note note) {
        String string;
        block4: {
            block6: {
                double d2;
                double d3;
                double d4;
                block5: {
                    string = "";
                    if (!(note.getNoteheadColor() == null && this.z != null || note.getNoteheadColor() != null && this.z == null) && (note.getNoteheadColor() == null || this.z == null || this.z.equals(note.getNoteheadColor()))) break block4;
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    if (note.getNoteheadColor() != null) {
                        d4 = (double)note.getNoteheadColor().getRed() / 255.0;
                        d3 = (double)note.getNoteheadColor().getGreen() / 255.0;
                        d2 = (double)note.getNoteheadColor().getBlue() / 255.0;
                    }
                    if (!note.isInterval()) break block5;
                    string = B[147] + d4 + " " + d3 + " " + d2 + B[146];
                    if (!AutoBeamer.c) break block6;
                }
                string = B[148] + d4 + " " + d3 + " " + d2 + ")";
            }
            this.z = note.getNoteheadColor();
        }
        return string;
    }

    private String p(Note note) {
        return B[96] + note.getText() + B[95];
    }

    private String q(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        String string = "";
        switch (note.getDynamic()) {
            case 0: {
                if (!bl) break;
            }
            case 1: {
                string = B[137];
                if (!bl) break;
            }
            case 2: {
                string = B[138];
                if (!bl) break;
            }
            case 3: {
                string = B[136];
                if (!bl) break;
            }
            case 4: {
                string = B[143];
                if (!bl) break;
            }
            case 5: {
                string = B[141];
                if (!bl) break;
            }
            case 6: {
                string = B[139];
                if (!bl) break;
            }
            case 7: {
                string = B[142];
                if (!bl) break;
            }
            case 8: {
                string = B[140];
            }
        }
        return string;
    }

    private String r(Note note) {
        return this.s(note) ? "~" : "";
    }

    private boolean s(Note note) {
        return note.getTiedOut() && !note.isRest();
    }

    private void c(int n2) {
        if (n2 != this.h) {
            if (this.h != 0) {
                this.q();
            }
            this.h = n2;
            if (n2 != 0) {
                this.d(n2);
                this.p();
                this.h = n2;
            }
        }
    }

    private void d(int n2) {
        this.d.println(B[160] + this.e(n2) + " ");
    }

    private String e(int n2) {
        int n3 = (int)Math.pow(2.0, JMSLMath.highestPowerOfTwoLessThan((int)n2));
        int n4 = n2;
        return n3 + "/" + n4;
    }

    private String c(Staff staff, Note note) {
        String string;
        String string2 = "";
        if ((note.isChord() || note.isInterval()) && (string = this.e(note)).indexOf(B[42]) == -1) {
            string2 = string2 + this.e(note) + " ";
        }
        string2 = string2 + this.a(note, staff).toLowerCase();
        int n2 = this.b(note, staff);
        if (!note.isRest() && note.is8va()) {
            ++n2;
        }
        if (!note.isRest() && note.is8vb()) {
            --n2;
        }
        String string3 = this.t(note);
        String string4 = this.r(note);
        String string5 = this.f(n2);
        string2 = string2 + string3;
        string2 = string2 + string5;
        if (note.isChord() || note.isInterval()) {
            string2 = string2 + string4;
        }
        return string2;
    }

    private String t(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        String string = "";
        switch (note.getAcc()) {
            case 0: {
                if (!bl) break;
            }
            case 1: {
                string = B[67];
                if (!bl) break;
            }
            case 5: {
                string = B[68];
                if (!bl) break;
            }
            case 2: {
                string = B[71];
                if (!bl) break;
            }
            case 4: {
                string = B[66];
                if (!bl) break;
            }
            case 6: {
                string = B[70];
                if (!bl) break;
            }
            case 8: {
                string = B[69];
                if (!bl) break;
            }
            case 7: {
                string = B[65];
                if (!bl) break;
            }
            case 9: {
                string = B[72];
                break;
            }
        }
        return string;
    }

    private String u(Note note) {
        boolean bl = AutoBeamer.c;
        if (note.isRest()) {
            return "";
        }
        String string = "";
        switch (note.getMark()) {
            case 1: {
                string = B[91];
                if (!bl) break;
            }
            case 5: {
                string = B[86];
                if (!bl) break;
            }
            case 6: {
                string = B[90];
                if (!bl) break;
            }
            case 8: {
                string = B[83];
                if (!bl) break;
            }
            case 9: {
                string = B[87];
                if (!bl) break;
            }
            case 15: {
                string = B[94];
                if (!bl) break;
            }
            case 14: {
                string = B[92];
                if (!bl) break;
            }
            case 2: {
                string = B[93];
                if (!bl) break;
            }
            case 3: {
                string = B[84];
                if (!bl) break;
            }
            case 10: {
                string = B[89];
                if (!bl) break;
            }
            case 11: {
                string = B[89];
                if (!bl) break;
            }
            case 13: {
                string = B[89];
                if (!bl) break;
            }
            case 12: {
                string = B[89];
                if (!bl) break;
            }
            case 4: {
                string = B[85];
                if (!bl) break;
            }
            case 7: {
                string = B[88];
            }
        }
        if (string.length() > 0) {
            string = "\\" + string;
        }
        return string;
    }

    private String v(Note note) {
        int n2 = note.getNoteDur();
        int n3 = (int)Math.pow(2.0, n2);
        return n3 + "";
    }

    private String w(Note note) {
        String string = "";
        for (int i2 = 0; i2 < note.getNumDots(); ++i2) {
            string = string + ".";
            if (!AutoBeamer.c) continue;
        }
        return string;
    }

    private String f(int n2) {
        if (n2 == 3 || n2 == -1) {
            return "";
        }
        String string = "'";
        String string2 = "'";
        int n3 = n2 - 4;
        if (n2 < 3) {
            string = ",";
            string2 = ",";
            n3 = 2 - n2;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + string2;
            if (!AutoBeamer.c) continue;
        }
        return string;
    }

    private void i(Staff staff) {
        TimeSignature timeSignature = staff.getMeasure().getTimeSig();
        if (this.e == null || !this.e.equals((Object)timeSignature)) {
            if (this.a(timeSignature)) {
                this.d.println(B[164]);
            }
            this.d.println(B[165] + timeSignature.getNumerator() + "/" + timeSignature.getDenominator());
            this.e = timeSignature;
        }
    }

    private boolean a(TimeSignature timeSignature) {
        return timeSignature.getNumerator() == 4 && timeSignature.getDenominator() == 4 || timeSignature.getNumerator() == 2 && timeSignature.getDenominator() == 2;
    }

    private void j(Staff staff) {
        if (this.i != null && this.i.equals(staff.getMeasure().getTempo())) {
            return;
        }
        Tempo tempo = staff.getMeasure().getTempo();
        String string = B[55] + (int)tempo.getBPM();
        if (!this.q) {
            this.d.println(B[56]);
            this.q = true;
        }
        this.d.println(string);
        this.i = tempo;
    }

    private void r() {
        this.d.println(B[170]);
        this.d.println(B[171] + new Date());
        this.d.println(B[169]);
        this.d.println(B[172]);
    }

    private String a(Note note, Staff staff) {
        if (note.isRest()) {
            return "r";
        }
        int n2 = this.k(staff);
        int n3 = note.getLevel();
        return NoteNamer.getPitchName(n3, n2);
    }

    private int k(Staff staff) {
        int n2 = staff.getClef().getClefLevelOffset();
        if (staff.getClef().getClefType() == Clef.PERCUSSION_CLEF.getClefType()) {
            n2 += 6;
        }
        return n2;
    }

    private int b(Note note, Staff staff) {
        if (note.isRest()) {
            return -1;
        }
        int n2 = this.k(staff);
        return NoteNamer.getOctaveName(note.getLevel(), n2);
    }

    private void s() {
        this.d.println(B[1]);
    }

    private void t() {
        this.d((String)null);
    }

    private void d(String string) {
        this.d.println(B[133]);
        this.d.println(B[132] + this.c.getName() + "\"");
        if (this.c.getSubtitle() != null && this.c.getSubtitle().length() > 0) {
            this.d.println(B[131] + this.c.getSubtitle() + "\"");
        }
        this.d.println(B[135] + this.c.getComposer() + "\"");
        if (this.c.getCopyright() != null && this.c.getCopyright().length() > 0) {
            this.d.println(B[129] + this.c.getCopyright() + "\"");
        }
        String string2 = this.c.getName();
        if (string != null) {
            string2 = string2 + B[128] + string + ")";
            this.d.println(B[134] + string + "\"");
        }
        this.d.println(B[130] + string2 + "\"");
        this.d.println("}");
    }

    private void u() {
        this.d.println(B[23]);
        this.d.println(B[19]);
        this.d.println(B[28]);
        this.d.println(B[30]);
        this.d.println(B[32]);
        this.d.println(B[24]);
        this.d.println(B[21]);
        this.d.println(B[33]);
        this.d.println(B[27]);
        this.d.println(B[29]);
        this.d.println(B[26]);
        this.d.println(B[33]);
        this.d.println(B[22]);
        this.d.println(B[31]);
        this.d.println(B[25]);
        this.d.println(B[26]);
        this.d.println(B[20]);
        this.d.println("}");
    }

    private static String g(int n2) {
        int n3 = n2 % 26;
        int n4 = n2 / 26;
        return A.substring(n4, n4 + 1) + A.substring(n3, n3 + 1);
    }

    private String h(int n2) {
        String string = LilyPondWriter.g(n2);
        return this.a + B[82] + string + B[48];
    }

    public static void main(String[] stringArray) {
        double d2;
        int n2;
        int n3;
        int n4;
        double d3;
        Object object;
        boolean bl = AutoBeamer.c;
        int n5 = 10;
        String[] stringArray2 = new String[]{B[196], B[179], B[192], B[191], B[189], B[190], B[195]};
        Orchestra orchestra = new Orchestra();
        for (int i2 = 0; i2 < n5; ++i2) {
            object = new InstrumentAdapter();
            object.setName(stringArray2[i2 % stringArray2.length]);
            orchestra.addInstrument((Instrument)object, object.getName());
            if (!bl) continue;
        }
        Score score = new Score(n5, 800, 600);
        score.setComposer(B[186]);
        score.setCopyright(B[198]);
        score.setName(B[188]);
        score.addMeasure(5, 4);
        score.setOrchestra(orchestra);
        score.getMeasure(0).getStaff(1).setClef(Clef.BASS_CLEF);
        score.getMeasure(0).getStaff(5).setClef(Clef.PERCUSSION_CLEF);
        object = score.addMeasure(4, 4);
        ((Measure)((Object)object)).setRepeatStart(true);
        ((Measure)((Object)object)).setTempo(90.0);
        object = score.addMeasure(4, 4);
        ((Measure)((Object)object)).setRepeatEnd(true);
        object.setRepeats(3);
        object = score.addMeasure();
        ((Measure)((Object)object)).setDoubleBar(true);
        object = score.addMeasure();
        ((Measure)((Object)object)).setDoubleBar(false);
        score.rewind();
        score.setCurrentStaffNumber(0);
        for (int i3 = 0; i3 < 24; ++i3) {
            boolean bl2 = i3 % 3 != 2;
            double d4 = 0.25;
            d3 = i3 + 60;
            Note note = score.addNote(d4, d3, 1.0, 0.4);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAccPref(1);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAltEnharmonicSpelling(true);
            note.setBeamedOut(true);
            note.setSlurredOut(bl2);
            note = score.addNote(d4, d3, 1.0, 0.4);
            note.setAccPref(1);
            note.setAltEnharmonicSpelling(true);
            note.setSlurredOut(bl2);
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(1);
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        double[] dArray = new double[]{0.75, 0.25};
        for (int i4 = 0; i4 < 48; ++i4) {
            n4 = i4 % 5 != 4 ? 1 : 0;
            d3 = dArray[i4 % dArray.length];
            int n6 = 60 + i4 - 24;
            Note note = score.addNote(d3, (double)n6, 0.5, 0.4);
            note.setSlurredOut(n4 != 0);
            note.setBeamedOut(i4 % 2 == 0);
            note.addInterval(n6 + 4);
            note.addInterval(n6 + 7);
            note.setDynamic(nArray[i4 % nArray.length]);
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(2);
        int[] nArray2 = new int[]{3, 3, 5, 5, 7, 9, 11, 13};
        for (n4 = 0; n4 < 24; ++n4) {
            int n7 = nArray2[n4 % nArray2.length];
            double d5 = 1.0;
            double d6 = d5 / (double)n7;
            for (int i5 = 0; i5 < n7; ++i5) {
                int n8 = 60 + n4;
                if (i5 == 1) {
                    n8 = 0;
                }
                boolean bl3 = i5 != n7 - 1;
                Note note = score.addNote(d6, (double)n8, 0.5, d6 * 0.8);
                note.setBeamedOut(i5 != n7 - 1);
                note.setTiedOut(i5 == 3 || i5 == 4);
                note.setCrescOut(bl3);
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        score.addNote(1.0, 0.0, 0.0, 1.0);
        score.rewind();
        score.setCurrentStaffNumber(3);
        Note note = score.addNote(0.6666, 72.0, 0.5, 0.5);
        note.setBeamedOut(true);
        note = score.addNote(0.3333, 72.0, 0.5, 0.5);
        note.setBeamedOut(false);
        for (n3 = 0; n3 < 3; ++n3) {
            note = score.addNote(0.3333, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 2);
            if (!bl) continue;
        }
        note = score.addNote(0.3333, 72.0, 0.5, 0.5);
        note.setBeamedOut(true);
        note = score.addNote(0.6666, 72.0, 0.5, 0.5);
        note.setBeamedOut(false);
        for (n3 = 0; n3 < 3; ++n3) {
            note = score.addNote(0.666, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 2);
            if (!bl) continue;
        }
        for (n3 = 0; n3 < 5; ++n3) {
            note = score.addNote(0.8, 72.0, 0.5, 0.5);
            note.setBeamedOut(n3 != 4);
            if (!bl) continue;
        }
        score.rewind();
        score.setCurrentStaffNumber(4);
        note = score.addNote(2.0, 60.0, 0.5, 0.8);
        note.addInterval(68.0).setTiedOut(true);
        note.addInterval(72.0);
        note = score.addNote(3.0, 60.0, 0.5, 0.8);
        note.addInterval(68.0);
        note.addInterval(72.0);
        score.rewind();
        score.setCurrentStaffNumber(5);
        score.addNote(3.0, 72.0, 0.5, 2.0).setTiedOut(true);
        score.addNote(2.0, 72.0, 0.5, 2.0);
        for (n3 = 0; n3 < 4; ++n3) {
            score.addNote(1.0, (double)(62 + n3 % 2 * 10), 0.5, 0.8);
            if (!bl) continue;
        }
        score.setCurrentTrackNumber(1);
        for (n3 = 0; n3 < 8; ++n3) {
            note = score.addNote(0.5, 79.0, 0.5, 0.4);
            note.setBeamedOut(n3 % 2 == 0);
            note.setNoteHeadType(2);
            if (!bl) continue;
        }
        score.setCurrentTrackNumber(0);
        score.addNote(4.0, 72.0, 0.5, 2.0);
        score.rewind();
        score.setCurrentStaffNumber(6);
        int[] nArray3 = new int[]{1, 5, 6, 8, 9, 15, 14, 2, 3, 10, 11, 13, 12, 4, 7};
        for (int i6 = 0; i6 < nArray3.length; ++i6) {
            score.addNote(1.0, 66.0, 0.5, 0.8).setMark(nArray3[i6]);
            if (!bl) continue;
        }
        score.addNote(2.0, 0.0, 0.0, 0.8);
        score.rewind();
        score.setCurrentStaffNumber(7);
        int[] nArray4 = new int[]{6, 5, 8, 7, 10, 9, 5, 6, 2, 4, 3, 12};
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[0]);
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[0]);
        score.addNote(1.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[nArray4.length - 1]);
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            note = score.addNote(0.25, 72.0, 0.5, 0.4);
            note.setNoteHeadType(nArray4[n2]);
            note.addInterval(76.0);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            note = score.addNote(0.25, 72.0, 0.5, 0.4);
            note.setNoteHeadType(nArray4[n2]);
            if (n2 > 1 && n2 < 8) {
                note.set8va(true);
                if (!bl) continue;
            }
            if (n2 <= 9 || n2 >= 13) continue;
            note.set8vb(true);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            score.addNote(2.0, 72.0, 0.5, 0.4).setNoteHeadType(nArray4[n2]);
            if (!bl) continue;
        }
        score.rewind();
        score.setCurrentStaffNumber(8);
        for (n2 = 0; n2 < 24; ++n2) {
            double d7 = 0.5;
            double d8 = 60.0 + (double)n2 * 0.5;
            double d9 = 0.5;
            d2 = d7 * 0.8;
            note = score.addNote(d7, d8, d9, d2);
            note.setBeamedOut(n2 % 2 == 0);
            if (!bl) continue;
        }
        for (n2 = 0; n2 < 24; ++n2) {
            double d10 = 0.5;
            double d11 = 72.0 - (double)n2 * 0.5;
            double d12 = 0.5;
            d2 = d10 * 0.8;
            note = score.addNote(d10, d11, d12, d2);
            note.setAccPref(1);
            note.setBeamedOut(n2 % 2 == 0);
            if (!bl) continue;
        }
        note = score.addNote(1.0, 0.0, 0.0, 1.0);
        String[] stringArray3 = new String[]{B[185], B[194], B[182], B[197], B[184], B[193], B[181], B[184], B[180]};
        score.rewind();
        score.setCurrentStaffNumber(9);
        for (int i7 = 0; i7 < 66; ++i7) {
            double d13 = 0.5;
            double d14 = 84 - i7;
            double d15 = 0.5;
            double d16 = d13 * 0.8;
            note = score.addNote(d13, d14, d15, d16);
            note.setAccPref(1);
            note.setBeamedOut(i7 % 4 == 0);
            note.setText(stringArray3[JMSLRandom.choose((int)stringArray3.length)]);
            if (!(d14 < 60.0)) continue;
            note.getTrack().getStaff().setClef(Clef.BASS_CLEF);
            if (!bl) continue;
        }
        score.getMeasure(score.size() - 1).setDoubleBar(true);
        File file = new File(B[178]);
        try {
            System.out.println(B[183]);
            LilyPondWriter lilyPondWriter = new LilyPondWriter(score, file);
            lilyPondWriter.write();
            if (lilyPondWriter.durationErrorsInScore()) {
                System.err.println(lilyPondWriter.getDurationErrorReport());
            }
            System.out.println(B[187]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        String[] stringArray = new String[199];
        Object var0 = null;
        LY_VERSION = LilyPondWriter.z(LilyPondWriter.z("TNH5NT"));
        var0 = null;
        stringArray[0] = LilyPondWriter.z(LilyPondWriter.z(":\t\u0017d\f\u0013\u0004\u001c'B"));
        var0 = null;
        stringArray[1] = LilyPondWriter.z(LilyPondWriter.z(":\u0016\u001cu\u0013\u000f\u000f\u0017'BTNH5NTB"));
        var0 = null;
        stringArray[2] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H6\u0016k\u0014\u0007\"\u000bf\u0003\r\u0005\r'CA\u0006\u0016i\u0014K\u000e\u0018j\u0005F]Y$B(\u0005\u000e'#\u0003\u000e\rr\u0012\u001f@*d\b\t\u000f\u0015e\u000f\t\u000b["));
        var0 = null;
        stringArray[3] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H6\u0016k\u0014\u0007\"\u000bf\u0003\r\u0005\r'CA\u0006\u0016i\u0014K\u0013\u0010}\u0005F]Y$KW"));
        var0 = null;
        stringArray[4] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H2\u001co\u0005\u0007\u0012\nf\f+\u0001\u000bl@EG\u001fh\u000e\u0012M\nn\u001a\u0003@D'CKQ"));
        var0 = null;
        stringArray[5] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H6\u0016k\u0014\u0007\"\u000bf\u0003\r\u0005\r'CA\u0006\u0016i\u0014K\u0013\u0011f\u0010\u0003@D'CA\u0002\u0016k\u0004"));
        var0 = null;
        stringArray[6] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0012\u001ce\f\u0003"));
        var0 = null;
        stringArray[7] = LilyPondWriter.z(LilyPondWriter.z("\u0007\f\rh"));
        var0 = null;
        stringArray[8] = LilyPondWriter.z(LilyPondWriter.z("l<\u001ak\u0005\u0000@"));
        var0 = null;
        stringArray[9] = LilyPondWriter.z(LilyPondWriter.z("\u0004\u0001\nt"));
        var0 = null;
        stringArray[10] = LilyPondWriter.z(LilyPondWriter.z("\u0016\u0005\u000bd\u0015\u0015\u0013\u0010h\u000e"));
        var0 = null;
        stringArray[11] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0005\u0017h\u0012"));
        var0 = null;
        stringArray[12] = LilyPondWriter.z(LilyPondWriter.z("lEYT\u0014\u0007\u0006\u001f'"));
        var0 = null;
        stringArray[13] = LilyPondWriter.z(LilyPondWriter.z(":\u0001\u001dc\f\u001f\u0012\u0010d\u0013F\u001b"));
        var0 = null;
        stringArray[14] = LilyPondWriter.z(LilyPondWriter.z("*\t\u0015~\u0010\u000f\u000e\u001dP\u0012\u000f\u0014\u001cu@\b\u000f\r'\u0017\u0014\t\rn\u000e\u0001@\u0015~\u0012\u000f\u0003\n+@\u0013\u0013\u0010i\u0007F\r\u0018u\u000b\u0013\u0010\n'\t\b\u0013\rb\u0001\u0002"));
        var0 = null;
        stringArray[15] = LilyPondWriter.z(LilyPondWriter.z("EH\nb\u0014K\u0004\u001ca\u0001\u0013\f\r*\u0010\u0007\u0010\u001cuM\u0015\t\u0003b@D\f\u001cs\u0014\u0003\u0012['G\n\u0001\u0017c\u0013\u0005\u0001\tbI"));
        var0 = null;
        stringArray[16] = LilyPondWriter.z(LilyPondWriter.z(":\u0016\u0016n\u0003\u00034\u000eh"));
        var0 = null;
        stringArray[17] = LilyPondWriter.z(LilyPondWriter.z(":\u0016\u0016n\u0003\u0003/\u0017b"));
        var0 = null;
        stringArray[18] = LilyPondWriter.z(LilyPondWriter.z("EH\nb\u0014K\u0007\u0015h\u0002\u0007\fTt\u0014\u0007\u0006\u001f*\u0013\u000f\u001a\u001c'QRI"));
        var0 = null;
        stringArray[19] = LilyPondWriter.z(LilyPondWriter.z("o\u0002\u001cs\u0017\u0003\u0005\u0017*\u0013\u001f\u0013\rb\rK\u0013\tf\u0003\u0003@D'QHU%d\r"));
        var0 = null;
        stringArray[20] = LilyPondWriter.z(LilyPondWriter.z("o\u001d"));
        var0 = null;
        stringArray[21] = LilyPondWriter.z(LilyPondWriter.z("oi%d\u000f\n\u0015\u0014i@\u001d"));
        var0 = null;
        stringArray[22] = LilyPondWriter.z(LilyPondWriter.z("oip\"EF\u0014\u0018`\f\u000f\u000e\u001c'\b\u0003\u0001\u001db\u0012F\u0006\u0010b\f\u0002@\u0016i@\u0007\f\u0015'\u0002\u0013\u0014Ya\t\u0014\u0013\r'\u0010\u0007\u0007\u001c)"));
        var0 = null;
        stringArray[23] = LilyPondWriter.z(LilyPondWriter.z(":\u0010\u0018w\u0005\u0014@\u0002"));
        var0 = null;
        stringArray[24] = LilyPondWriter.z(LilyPondWriter.z("o\u000f\u001dc&\t\u000f\rb\u0012+\u0001\u000bl\u0015\u0016@D'<\u000b\u0001\u000bl\u0015\u0016@\u0002"));
        var0 = null;
        stringArray[25] = LilyPondWriter.z(LilyPondWriter.z("oipz"));
        var0 = null;
        stringArray[26] = LilyPondWriter.z(LilyPondWriter.z("oi\u0004"));
        var0 = null;
        stringArray[27] = LilyPondWriter.z(LilyPondWriter.z("oip\"EF#\u0016w\u0019\u0014\t\u001eo\u0014F\b\u001cf\u0004\u0003\u0012Ya\t\u0003\f\u001d'\u000f\b\f\u0000'\u000f\b@\u001fn\u0012\u0015\u0014Yw\u0001\u0001\u0005W"));
        var0 = null;
        stringArray[28] = LilyPondWriter.z(LilyPondWriter.z("o\u0002\u001cs\u0017\u0003\u0005\u0017*\u0013\u001f\u0013\rb\rK\u0010\u0018c\u0004\u000f\u000e\u001e']FCH"));
        var0 = null;
        stringArray[29] = LilyPondWriter.z(LilyPondWriter.z("oip[\u000f\bM\ro\u0005K\u0006\u0015~@E\u0006\u0010u\u0013\u0012M\tf\u0007\u0003@%a\u0012\t\r\tu\u000f\u0016\u0005\u000bs\u0019FC^o\u0005\u0007\u0004\u001cuZ\u0005\u000f\t~\u0012\u000f\u0007\u0011s"));
        var0 = null;
        stringArray[30] = LilyPondWriter.z(LilyPondWriter.z("o\u0012\u0018`\u0007\u0003\u0004Te\u000f\u0012\u0014\u0016j]EC\u001f"));
        var0 = null;
        stringArray[31] = LilyPondWriter.z(LilyPondWriter.z("oip[\u000f\bM\ro\u0005K\u0006\u0015~@E\u000e\u0016sM\u0000\t\u000bt\u0014K\u0010\u0018`\u0005F<\u001fu\u000f\u000b\u0010\u000bh\u0010\u0003\u0012\r~@EG\u0011b\u0001\u0002\u0005\u000b=\u0014\u0007\u0007\u0015n\u000e\u0003"));
        var0 = null;
        stringArray[32] = LilyPondWriter.z(LilyPondWriter.z("o\u0012\u0018`\u0007\u0003\u0004Tk\u0001\u0015\u0014Te\u000f\u0012\u0014\u0016j]EC\u001f"));
        var0 = null;
        stringArray[33] = LilyPondWriter.z(LilyPondWriter.z("oi%a\t\n\fTk\t\b\u0005Y|"));
        var0 = null;
        stringArray[34] = LilyPondWriter.z(LilyPondWriter.z("F]Y"));
        var0 = null;
        stringArray[35] = LilyPondWriter.z(LilyPondWriter.z("F<\u001au@"));
        var0 = null;
        stringArray[36] = LilyPondWriter.z(LilyPondWriter.z("F<X'"));
        var0 = null;
        stringArray[37] = LilyPondWriter.z(LilyPondWriter.z("F<\u001db\u0003\u0014@"));
        var0 = null;
        stringArray[38] = LilyPondWriter.z(LilyPondWriter.z("F\\E'@"));
        var0 = null;
        stringArray[39] = LilyPondWriter.z(LilyPondWriter.z("F^G'"));
        var0 = null;
        stringArray[40] = LilyPondWriter.z(LilyPondWriter.z("F<%'"));
        var0 = null;
        stringArray[41] = LilyPondWriter.z(LilyPondWriter.z("l<\u000bb\u0016\u0003\u0012\r'.\t\u0014\u001cO\u0005\u0007\u0004Y$G\u0015\u0014\u0000k\u0005l"));
        var0 = null;
        stringArray[42] = LilyPondWriter.z(LilyPondWriter.z("3.*R06/+S%\""));
        var0 = null;
        stringArray[43] = LilyPondWriter.z(LilyPondWriter.z("X^"));
        var0 = null;
        stringArray[44] = LilyPondWriter.z(LilyPondWriter.z(":\u0012\u001cj\u000f\u0010\u0005.n\u0014\u000e4\u0018`@EG\nd\u000f\u0014\u0005"));
        var0 = null;
        stringArray[45] = LilyPondWriter.z(LilyPondWriter.z("1\u0012\u0010s\t\b\u0007Yw\u0001\u0014\u0014Ya\t\n\u0005Y"));
        var0 = null;
        stringArray[46] = LilyPondWriter.z(LilyPondWriter.z("o<\u0017b\u0017F3\rf\u0006\u0000@%"));
        var0 = null;
        stringArray[47] = LilyPondWriter.z(LilyPondWriter.z("Z\\"));
        var0 = null;
        stringArray[48] = LilyPondWriter.z(LilyPondWriter.z("H\f\u0000"));
        var0 = null;
        stringArray[49] = LilyPondWriter.z(LilyPondWriter.z("\u000f\u000e\n*"));
        var0 = null;
        stringArray[50] = LilyPondWriter.z(LilyPondWriter.z("2\b\u0010t@\u0011\t\u0015k@\u0014\u0005\nr\f\u0012@\u0010i@\u0015\u0005\u000fb\u0012\n\u0019Yd\u000f\u0014\u0012\fw\u0014\u0003\u0004YK\t\n\u0019)h\u000e\u0002@\u0015f\u0019\t\u0015\r)j"));
        var0 = null;
        stringArray[51] = LilyPondWriter.z(LilyPondWriter.z("D@\u001ah\u000e\u0012\u0001\u0010i\u0013F\u0015\u0017e\u0001\n\u0001\u0017d\u0005\u0002@\u000bb\u0010\u0003\u0001\r'\u0002\u0007\u0012\n'\u001c\u001aZY=\u001c\u001aj"));
        var0 = null;
        stringArray[52] = LilyPondWriter.z(LilyPondWriter.z(",-*K@5\u0003\u0016u\u0005FB"));
        var0 = null;
        stringArray[53] = LilyPondWriter.z(LilyPondWriter.z("(\u000fYc\u0015\u0014\u0001\rn\u000f\b@\u001cu\u0012\t\u0012\n'\u0012\u0003\u0010\u0016u\u0014\u0003\u0004"));
        var0 = null;
        stringArray[54] = LilyPondWriter.z(LilyPondWriter.z("l\u001d"));
        var0 = null;
        stringArray[55] = LilyPondWriter.z(LilyPondWriter.z(":\u0014\u001cj\u0010\t@M:"));
        var0 = null;
        stringArray[56] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H-\u001cs\u0012\t\u000e\u0016j\u0005+\u0001\u000bl@EG\tf\u0004\u0002\t\u0017`@[@Z3NS"));
        var0 = null;
        stringArray[57] = LilyPondWriter.z(LilyPondWriter.z("\u001eBP'"));
        var0 = null;
        stringArray[58] = LilyPondWriter.z(LilyPondWriter.z("F\u0013\rf\u0012\u0012M\u000bb\u0010\u0003\u0001\r"));
        var0 = null;
        stringArray[59] = LilyPondWriter.z(LilyPondWriter.z(":\u0012\u001cw\u0005\u0007\u0014Yq\u000f\n\u0014\u0018'"));
        var0 = null;
        stringArray[60] = LilyPondWriter.z(LilyPondWriter.z(":\u0013\u001cs@5\u0003\u0016u\u0005H\u0012\u001cw\u0005\u0007\u0014:h\r\u000b\u0001\u0017c\u0013F]Y$GN@Qq\u000f\n\u0014\u0018'B"));
        var0 = null;
        stringArray[61] = LilyPondWriter.z(LilyPondWriter.z("F\u0005\u0017cM\u0014\u0005\tb\u0001\u0012@\ns\u0001\u0014\u0014Tu\u0005\u0016\u0005\u0018s"));
        var0 = null;
        stringArray[62] = LilyPondWriter.z(LilyPondWriter.z(":\u0014\u0018`@EG\nd\u000f\u0014\u0005Y[\u0013\u0003\u0014YT\u0014\u0007\u0006\u001f)\u0013\u000e\u000f\u000bs)\b\u0013\ru\u0015\u000b\u0005\u0017s.\u0007\r\u001c']FB"));
        var0 = null;
        stringArray[63] = LilyPondWriter.z(LilyPondWriter.z(":\u0013\u001cs@5\u0014\u0018a\u0006H\t\u0017t\u0014\u0014\u0015\u0014b\u000e\u0012.\u0018j\u0005F]Y%"));
        var0 = null;
        stringArray[64] = LilyPondWriter.z(LilyPondWriter.z("FB"));
        var0 = null;
        stringArray[65] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0013\u001co"));
        var0 = null;
        stringArray[66] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0013\u001ct"));
        var0 = null;
        stringArray[67] = LilyPondWriter.z(LilyPondWriter.z("\u000f\u0013"));
        var0 = null;
        stringArray[68] = LilyPondWriter.z(LilyPondWriter.z("\u000f\u0013\u0010t"));
        var0 = null;
        stringArray[69] = LilyPondWriter.z(LilyPondWriter.z("\u000f\b"));
        var0 = null;
        stringArray[70] = LilyPondWriter.z(LilyPondWriter.z("\u0003\b"));
        var0 = null;
        stringArray[71] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0013"));
        var0 = null;
        stringArray[72] = LilyPondWriter.z(LilyPondWriter.z("\u000f\u0013\u0010o"));
        var0 = null;
        stringArray[73] = LilyPondWriter.z(LilyPondWriter.z("\u001aN"));
        var0 = null;
        stringArray[74] = LilyPondWriter.z(LilyPondWriter.z("F<\u001bf\u0012FB"));
        var0 = null;
        stringArray[75] = LilyPondWriter.z(LilyPondWriter.z(":\u0013\u001cs@5\u0003\u0016u\u0005H\u0012\u001cw\u0005\u0007\u0014:h\r\u000b\u0001\u0017c\u0013F]Y$GNH\u000fh\f\u0012\u0001Y$\u0006OI"));
        var0 = null;
        stringArray[76] = LilyPondWriter.z(LilyPondWriter.z(":\u0013\u001cs@5\u0003\u0016u\u0005H\u0012\u001cw\u0005\u0007\u0014:h\r\u000b\u0001\u0017c\u0013F]Y$GN@Qq\u000f\n\u0014\u0018'BFBP'\u0005\b\u0004Tu\u0005\u0016\u0005\u0018sI"));
        var0 = null;
        stringArray[77] = LilyPondWriter.z(LilyPondWriter.z("D@"));
        var0 = null;
        stringArray[78] = LilyPondWriter.z(LilyPondWriter.z("\u001a\u001c"));
        var0 = null;
        stringArray[79] = LilyPondWriter.z(LilyPondWriter.z("l<\u0016s\u0014\u0007\u0016\u0018'CV"));
        var0 = null;
        stringArray[80] = LilyPondWriter.z(LilyPondWriter.z("l<\u0016s\u0014\u0007\u0016\u0018'CW"));
        var0 = null;
        stringArray[81] = LilyPondWriter.z(LilyPondWriter.z("l<\u0016s\u0014\u0007\u0016\u0018'CKQ"));
        var0 = null;
        stringArray[82] = LilyPondWriter.z(LilyPondWriter.z("5\u0014\u0018a\u0006"));
        var0 = null;
        stringArray[83] = LilyPondWriter.z(LilyPondWriter.z("\u0000\u0005\u000bj\u0001\u0012\u0001"));
        var0 = null;
        stringArray[84] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0005\u0017r\u0014\t"));
        var0 = null;
        stringArray[85] = LilyPondWriter.z(LilyPondWriter.z("\u0014\u0014\u0016b"));
        var0 = null;
        stringArray[86] = LilyPondWriter.z(LilyPondWriter.z("\u0007\u0003\u001ab\u000e\u0012<\ns\u0001\u0005\u0003\u0018s\u000f"));
        var0 = null;
        stringArray[87] = LilyPondWriter.z(LilyPondWriter.z("\u0000\f\u0018`\u0005\t\f\u001cs"));
        var0 = null;
        stringArray[88] = LilyPondWriter.z(LilyPondWriter.z("\u0014\u0014\u0016b<\u0015\u0014\u0018d\u0003\u0007\u0014\u0016"));
        var0 = null;
        stringArray[89] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0012\u0010k\f"));
        var0 = null;
        stringArray[90] = LilyPondWriter.z(LilyPondWriter.z("\u0007\u0003\u001ab\u000e\u0012<\rb\u000e\u0013\u0014\u0016"));
        var0 = null;
        stringArray[91] = LilyPondWriter.z(LilyPondWriter.z("\u0007\u0003\u001ab\u000e\u0012"));
        var0 = null;
        stringArray[92] = LilyPondWriter.z(LilyPondWriter.z("\u000b\u000f\u000bc\u0005\b\u0014"));
        var0 = null;
        stringArray[93] = LilyPondWriter.z(LilyPondWriter.z("\u0015\u0014\u0018d\u0003\u0007\u0014\u0016"));
        var0 = null;
        stringArray[94] = LilyPondWriter.z(LilyPondWriter.z("\u0002\u000f\u000ei\r\t\u0012\u001db\u000e\u0012"));
        var0 = null;
        stringArray[95] = LilyPondWriter.z(LilyPondWriter.z("D\u001d"));
        var0 = null;
        stringArray[96] = LilyPondWriter.z(LilyPondWriter.z("9<\u0014f\u0012\r\u0015\t|@F<\u001fh\u000e\u0012\u0013\u0010}\u0005FCT3@D"));
        var0 = null;
        stringArray[97] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@5\u0003\u0016u\u0005H4\fw\f\u0003\u00147r\r\u0004\u0005\u000b'CA8Tb\u0018\u0012\u0005\u0017s@[@Z HV@W'PO@"));
        var0 = null;
        stringArray[98] = LilyPondWriter.z(LilyPondWriter.z(":\u0014\u000eb\u0001\r@Z \u0013\u0012\u0019\u0015b@EG"));
        var0 = null;
        stringArray[99] = LilyPondWriter.z(LilyPondWriter.z("\u0015\f\u0018t\b"));
        var0 = null;
        stringArray[100] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0012\u0010f\u000e\u0001\f\u001c"));
        var0 = null;
        stringArray[101] = LilyPondWriter.z(LilyPondWriter.z("\u0002\t\u0018j\u000f\b\u0004"));
        var0 = null;
        stringArray[102] = LilyPondWriter.z(LilyPondWriter.z("\u001e\u0003\u0010u\u0003\n\u0005"));
        var0 = null;
        stringArray[103] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u000fb\u0012\u0014\t\u001db@(\u000f\rb(\u0003\u0001\u001d'CA\u0013\r~\f\u0003@D'CA"));
        var0 = null;
        stringArray[104] = LilyPondWriter.z(LilyPondWriter.z("\u0005\u0012\u0016t\u0013"));
        var0 = null;
        stringArray[105] = LilyPondWriter.z(LilyPondWriter.z("F@Y'@:\u000f\u000fb\u0012\u0014\t\u001db@5\u0014\u001cj@FC^s\u0012\u0007\u000e\nw\u0001\u0014\u0005\u0017s@[@Z$\u0014F"));
        var0 = null;
        stringArray[106] = LilyPondWriter.z(LilyPondWriter.z("F@Y'@:\u000f\u000fb\u0012\u0014\t\u001db@4\u0005\ns@FC^s\u0012\u0007\u000e\nw\u0001\u0014\u0005\u0017s@[@Z$\u0014F\u001d"));
        var0 = null;
        stringArray[107] = LilyPondWriter.z(LilyPondWriter.z("\u0004\f\u0018i\u000b\u0015\u0014\u001cj\u0013F]Y|@:\u000f\u000fb\u0012\u0014\t\u001db@5\u0014\u001cj@FC^s\u0012\u0007\u000e\nw\u0001\u0014\u0005\u0017s@[@Z$\u0014F\u001d"));
        var0 = null;
        stringArray[108] = LilyPondWriter.z(LilyPondWriter.z("F@Y'@:\u0012\u001cq\u0005\u0014\u0014YT\u0014\u0003\rY$G\u0012\u0012\u0018i\u0013\u0016\u0001\u000bb\u000e\u0012@"));
        var0 = null;
        stringArray[109] = LilyPondWriter.z(LilyPondWriter.z("\u0013\u000e\u001bk\u0001\b\u000b\ns\u0005\u000b\u0013Y:@\u001d@%u\u0005\u0010\u0005\u000bs@5\u0014\u001cj@EG\ru\u0001\b\u0013\tf\u0012\u0003\u000e\r'\u001d"));
        var0 = null;
        stringArray[110] = LilyPondWriter.z(LilyPondWriter.z("F@Y'@:\u0012\u001cq\u0005\u0014\u0014YU\u0005\u0015\u0014Y$G\u0012\u0012\u0018i\u0013\u0016\u0001\u000bb\u000e\u0012@\u0004"));
        var0 = null;
        stringArray[111] = LilyPondWriter.z(LilyPondWriter.z("\u0013\u000e\u001bk\u0001\b\u000b\u0017h\u0014\u0003\u0013Y:@\u001d@%u\u0005\u0010\u0005\u000bs@(\u000f\rb(\u0003\u0001\u001d'CA\u0014\u000bf\u000e\u0015\u0010\u0018u\u0005\b\u0014"));
        var0 = null;
        stringArray[112] = LilyPondWriter.z(LilyPondWriter.z("\u0004\f\u0018i\u000b\b\u000f\rb\u0013F]Y|@:\u000f\u000fb\u0012\u0014\t\u001db@(\u000f\rb(\u0003\u0001\u001d'@EG\ru\u0001\b\u0013\tf\u0012\u0003\u000e\r']FCZs"));
        var0 = null;
        stringArray[113] = LilyPondWriter.z(LilyPondWriter.z(":\u000e\u0016E\u0005\u0007\r"));
        var0 = null;
        stringArray[114] = LilyPondWriter.z(LilyPondWriter.z("F<\u001bk\u0001\b\u000b\u0017h\u0014\u0003\u0013Y"));
        var0 = null;
        stringArray[115] = LilyPondWriter.z(LilyPondWriter.z("Z@"));
        var0 = null;
        stringArray[116] = LilyPondWriter.z(LilyPondWriter.z("F<\u001bk\u0001\b\u000b\ns\u0005\u000b\u0013Y"));
        var0 = null;
        stringArray[117] = LilyPondWriter.z(LilyPondWriter.z("8<\u0014f\u0012\r\u0015\t|<\u000f\u0014\u0018k\t\u0005<\rn\u000e\u001f@"));
        var0 = null;
        stringArray[118] = LilyPondWriter.z(LilyPondWriter.z("\u0012\t\u001c"));
        var0 = null;
        stringArray[119] = LilyPondWriter.z(LilyPondWriter.z("F=Y"));
        var0 = null;
        stringArray[120] = LilyPondWriter.z(LilyPondWriter.z("F<\fi\u0002\n\u0001\u0017l\u000e\t\u0014\u001ct@"));
        var0 = null;
        stringArray[121] = LilyPondWriter.z(LilyPondWriter.z("F<\fi\u0002\n\u0001\u0017l\u0013\u0012\u0005\u0014t@"));
        var0 = null;
        stringArray[122] = LilyPondWriter.z(LilyPondWriter.z("\u0015\f\fu"));
        var0 = null;
        stringArray[123] = LilyPondWriter.z(LilyPondWriter.z("F;Y"));
        var0 = null;
        stringArray[124] = LilyPondWriter.z(LilyPondWriter.z("F\u001dY"));
        var0 = null;
        stringArray[125] = LilyPondWriter.z(LilyPondWriter.z("F\u001d"));
        var0 = null;
        stringArray[126] = LilyPondWriter.z(LilyPondWriter.z("F^"));
        var0 = null;
        stringArray[127] = LilyPondWriter.z(LilyPondWriter.z("F\u001bY"));
        var0 = null;
        stringArray[128] = LilyPondWriter.z(LilyPondWriter.z("FH"));
        var0 = null;
        stringArray[129] = LilyPondWriter.z(LilyPondWriter.z("o\u0003\u0016w\u0019\u0014\t\u001eo\u0014F]Y%"));
        var0 = null;
        stringArray[130] = LilyPondWriter.z(LilyPondWriter.z("o\u0014\u0018`\f\u000f\u000e\u001c']FB"));
        var0 = null;
        stringArray[131] = LilyPondWriter.z(LilyPondWriter.z("o\u0013\fe\u0014\u000f\u0014\u0015b@[@["));
        var0 = null;
        stringArray[132] = LilyPondWriter.z(LilyPondWriter.z("o\u0014\u0010s\f\u0003@D'B"));
        var0 = null;
        stringArray[133] = LilyPondWriter.z(LilyPondWriter.z(":\b\u001cf\u0004\u0003\u0012Y|"));
        var0 = null;
        stringArray[134] = LilyPondWriter.z(LilyPondWriter.z("o\t\u0017t\u0014\u0014\u0015\u0014b\u000e\u0012@D'B"));
        var0 = null;
        stringArray[135] = LilyPondWriter.z(LilyPondWriter.z("o\u0003\u0016j\u0010\t\u0013\u001cu@[@["));
        var0 = null;
        stringArray[136] = LilyPondWriter.z(LilyPondWriter.z(":\u0010"));
        var0 = null;
        stringArray[137] = LilyPondWriter.z(LilyPondWriter.z(":\u0010\tw"));
        var0 = null;
        stringArray[138] = LilyPondWriter.z(LilyPondWriter.z(":\u0010\t"));
        var0 = null;
        stringArray[139] = LilyPondWriter.z(LilyPondWriter.z(":\u0006"));
        var0 = null;
        stringArray[140] = LilyPondWriter.z(LilyPondWriter.z(":\u0006\u001fa"));
        var0 = null;
        stringArray[141] = LilyPondWriter.z(LilyPondWriter.z(":\r\u001f"));
        var0 = null;
        stringArray[142] = LilyPondWriter.z(LilyPondWriter.z(":\u0006\u001f"));
        var0 = null;
        stringArray[143] = LilyPondWriter.z(LilyPondWriter.z(":\r\t"));
        var0 = null;
        stringArray[144] = LilyPondWriter.z(LilyPondWriter.z("FIY"));
        var0 = null;
        stringArray[145] = LilyPondWriter.z(LilyPondWriter.z("FHY"));
        var0 = null;
        stringArray[146] = LilyPondWriter.z(LilyPondWriter.z("O@"));
        var0 = null;
        stringArray[147] = LilyPondWriter.z(LilyPondWriter.z("F<\rp\u0005\u0007\u000bY$G\u0005\u000f\u0015h\u0012FC^/"));
        var0 = null;
        stringArray[148] = LilyPondWriter.z(LilyPondWriter.z("l<\u0016q\u0005\u0014\u0012\u0010c\u0005F.\u0016s\u0005.\u0005\u0018c@EG\u001ah\f\t\u0012Y:@EGQ"));
        var0 = null;
        stringArray[149] = LilyPondWriter.z(LilyPondWriter.z("J@\u0018c\u0004\u000f\u0014\u0010h\u000e\u0007\fC'"));
        var0 = null;
        stringArray[150] = LilyPondWriter.z(LilyPondWriter.z("J@\th\u0017\u0003\u0012Yh\u0006F\u0014\u000eh@\u0000\u0012\u0016j@\u0012\u0012\u001cj@[@"));
        var0 = null;
        stringArray[151] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0012\u001cj@\u0005\u000f\u001dbZF\u0003\u0016u\u0005F\u0004\fu@["));
        var0 = null;
        stringArray[152] = LilyPondWriter.z(LilyPondWriter.z("3\u0010"));
        var0 = null;
        stringArray[153] = LilyPondWriter.z(LilyPondWriter.z("\"\u000f\u000ei"));
        var0 = null;
        stringArray[154] = LilyPondWriter.z(LilyPondWriter.z("F="));
        var0 = null;
        stringArray[155] = LilyPondWriter.z(LilyPondWriter.z("=@"));
        var0 = null;
        stringArray[156] = LilyPondWriter.z(LilyPondWriter.z("D@\u001ah\u000e\u0012\u0001\u0010i\u0013F\r\u001cf\u0013\u0013\u0012\u001ct@\u0011\t\ro@\u0012\u000f\u0016'\r\u0007\u000e\u0000'\u000f\u0014@\rh\u000fF\u0006\u001cp@\u0012\u000f\rf\fF\u0004\fu\u0001\u0012\t\u0016i\u0013Hj"));
        var0 = null;
        stringArray[157] = LilyPondWriter.z(LilyPondWriter.z("2\b\u0010t@\u0011\t\u0015k@\u0014\u0005\nr\f\u0012@\u0010i@\u0013\u000e\u001c\u007f\u0010\u0003\u0003\rb\u0004F\r\u001cf\u0013\u0013\u0012\u001c'\u0003\t\u000e\rb\u000e\u0012\u0013Yn\u000eF,\u0010k\u00196\u000f\u0017cNl"));
        var0 = null;
        stringArray[158] = LilyPondWriter.z(LilyPondWriter.z("\u0007\u0003\u001an\u0001\u0005\u0003\u0018s\u0015\u0014\u0001"));
        var0 = null;
        stringArray[159] = LilyPondWriter.z(LilyPondWriter.z("\u0007\u0010\th\u0007\u0001\t\u0018s\u0015\u0014\u0001"));
        var0 = null;
        stringArray[160] = LilyPondWriter.z(LilyPondWriter.z("l<\rn\r\u0003\u0013Y"));
        var0 = null;
        stringArray[161] = LilyPondWriter.z(LilyPondWriter.z(":\u000b\u001c~@\u0005@%j\u0001\f\u000f\u000b"));
        var0 = null;
        stringArray[162] = LilyPondWriter.z(LilyPondWriter.z("F<\u0014f\n\t\u0012"));
        var0 = null;
        stringArray[163] = LilyPondWriter.z(LilyPondWriter.z(":\u000b\u001c~@"));
        var0 = null;
        stringArray[164] = LilyPondWriter.z(LilyPondWriter.z("l<\u0016q\u0005\u0014\u0012\u0010c\u0005F3\rf\u0006\u0000N-n\r\u00033\u0010`\u000e\u0007\u0014\fu\u0005FC^t\u0014\u001f\f\u001c']FC^/I"));
        var0 = null;
        stringArray[165] = LilyPondWriter.z(LilyPondWriter.z("l<\rn\r\u0003@"));
        var0 = null;
        stringArray[166] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0012\u000bh\u0012"));
        var0 = null;
        stringArray[167] = LilyPondWriter.z(LilyPondWriter.z(":\u000f\u0017d\u0005F<\u0016q\u0005\u0014\u0012\u0010c\u0005F3\u001ah\u0012\u0003N+b\b\u0003\u0001\u000bt\u0001\n-\u0018u\u000bFC^t\u0005\n\u0006Tf\f\u000f\u0007\u0017j\u0005\b\u0014T_@[@Zk\u0005\u0000\u0014"));
        var0 = null;
        stringArray[168] = LilyPondWriter.z(LilyPondWriter.z(":\r\u0018u\u000bFB"));
        var0 = null;
        stringArray[169] = LilyPondWriter.z(LilyPondWriter.z("C@3J3*@\rh@*\t\u0015~0\t\u000e\u001d'\u0003\t\u000e\u000fb\u0012\u0012\u0005\u000b'\u0002\u001f@7n\u0003\r@=n\u0004\r\u000f\u000ft\u000b\u001fLY/\u0003O@K7PP@7n\u0003\r@=n\u0004\r\u000f\u000ft\u000b\u001f"));
        var0 = null;
        stringArray[170] = LilyPondWriter.z(LilyPondWriter.z("C@:u\u0005\u0007\u0014\u001cc@\u0004\u0019C'*\u0007\u0016\u0018'-\u0013\u0013\u0010d@5\u0010\u001cd\t\u0000\t\u001af\u0014\u000f\u000f\u0017',\u0007\u000e\u001er\u0001\u0001\u0005U'\"3)5C@TPH6QTRH"));
        var0 = null;
        stringArray[171] = LilyPondWriter.z(LilyPondWriter.z("C@:u\u0005\u0007\u0014\u0010h\u000eF\u0004\u0018s\u0005\\@"));
        var0 = null;
        stringArray[172] = LilyPondWriter.z(LilyPondWriter.z("C@\u000fn\u0013\u000f\u0014Yp\u0017\u0011N\u0018k\u0007\t\r\ft\t\u0005N\u001ah\rF\u0001\u0017c@\u0011\u0017\u000e)\f\u000f\f\u0000w\u000f\b\u0004Wh\u0012\u0001"));
        var0 = null;
        stringArray[173] = LilyPondWriter.z(LilyPondWriter.z("5\u0014\u0018a\u0006F\t\u0017c\u0005\u001e@"));
        var0 = null;
        stringArray[174] = LilyPondWriter.z(LilyPondWriter.z("lEYJ\u0005\u0007\u0013\fu\u0005F"));
        var0 = null;
        stringArray[175] = LilyPondWriter.z(LilyPondWriter.z("F\u0006\u0016r\u000e\u0002@\rh@\u000e\u0001\u000fb@\u0007\f\u0015'\u000e\t\u0014\u001ct@\u0011\t\ro@\u0012\u0005\u0001sLF\u0013\u0016'\u0017\u0003@\u0018t\u0013\u0013\r\u001c'\u0014\u000e\u0005\u0000'\u0001\u0014\u0005Yk\u0019\u0014\t\u001at"));
        var0 = null;
        stringArray[176] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0005\ns"));
        var0 = null;
        stringArray[177] = LilyPondWriter.z(LilyPondWriter.z("(\u000fYc\t\u0001\t\rtLF\u0013\tf\u0003\u0003\u0013U'\u0015\b\u0004\u001cu\u0013\u0005\u000f\u000bb\u0013J@\u0016u@\u0002\u0001\no\u0005\u0015@\u0018k\f\t\u0017\u001cc@\u000f\u000eYK\t\n\u0019\th\u000e\u0002@\u001fn\f\u0003\u000e\u0018j\u0005\\@["));
        var0 = null;
        stringArray[178] = LilyPondWriter.z(LilyPondWriter.z("%ZVC\u000f\u0005\u0015\u0014b\u000e\u0012\u0013Yf\u000e\u0002@*b\u0014\u0012\t\u0017`\u0013I.\u0010d\u000bH0,I/5M?6R%&N3W_O=b\u0013\r\u0014\u0016wO\n\t\u0015~\u0010\t\u000e\u001d(\u0014\u0003\u0013\r)\f\u001f"));
        var0 = null;
        stringArray[179] = LilyPondWriter.z(LilyPondWriter.z("\u0016\u0006"));
        var0 = null;
        stringArray[180] = LilyPondWriter.z(LilyPondWriter.z("\u0001\u000f"));
        var0 = null;
        stringArray[181] = LilyPondWriter.z(LilyPondWriter.z("\n\u0005\r"));
        var0 = null;
        stringArray[182] = LilyPondWriter.z(LilyPondWriter.z("\u0016\f\u001cf\u0013\u0003"));
        var0 = null;
        stringArray[183] = LilyPondWriter.z(LilyPondWriter.z("1\u0012\u0010s\t\b\u0007YK\t\n\u0019)h\u000e\u0002@\u001fn\f\u0003"));
        var0 = null;
        stringArray[184] = LilyPondWriter.z(LilyPondWriter.z("\u000b\u0005"));
        var0 = null;
        stringArray[185] = LilyPondWriter.z(LilyPondWriter.z("\t\b"));
        var0 = null;
        stringArray[186] = LilyPondWriter.z(LilyPondWriter.z("(\t\u001al@\"\t\u001dl\u000f\u0010\u0013\u0012~"));
        var0 = null;
        stringArray[187] = LilyPondWriter.z(LilyPondWriter.z("\u0002\u000f\u0017b"));
        var0 = null;
        stringArray[188] = LilyPondWriter.z(LilyPondWriter.z("2\u0005\ns@,-*K@K^YK\t\n\u0019)h\u000e\u0002@\u001c\u007f\u0010\t\u0012\rb\u0012"));
        var0 = null;
        stringArray[189] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0007\ru"));
        var0 = null;
        stringArray[190] = LilyPondWriter.z(LilyPondWriter.z("\u0002\r\n"));
        var0 = null;
        stringArray[191] = LilyPondWriter.z(LilyPondWriter.z("\u0004\u0003\u0015"));
        var0 = null;
        stringArray[192] = LilyPondWriter.z(LilyPondWriter.z("\u0015\u0013\u0001"));
        var0 = null;
        stringArray[193] = LilyPondWriter.z(LilyPondWriter.z("\b\u0005\u000fb\u0012"));
        var0 = null;
        stringArray[194] = LilyPondWriter.z(LilyPondWriter.z("\u0004\u0001\u001b~"));
        var0 = null;
        stringArray[195] = LilyPondWriter.z(LilyPondWriter.z("\u0003\u0002"));
        var0 = null;
        stringArray[196] = LilyPondWriter.z(LilyPondWriter.z("\u0012\u0010\r"));
        var0 = null;
        stringArray[197] = LilyPondWriter.z(LilyPondWriter.z("\u0015\u0011\fb\u0005\u001c\u0005"));
        var0 = null;
        stringArray[198] = LilyPondWriter.z(LilyPondWriter.z("N\u0003P'RVPO'.\u000f\u0003\u0012'$\u000f\u0004\u0012h\u0016\u0015\u000b\u0000'OF0\fi\u000f\u0015@4r\u0013\u000f\u0003Y/\"+)P"));
        B = stringArray;
        x = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "_", " "};
        var0 = null;
        A = LilyPondWriter.z(LilyPondWriter.z("'\":C% '1N*-,4I/61+T436._9<"));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x60);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 102;
                            break;
                        }
                        case 1: {
                            n7 = 96;
                            break;
                        }
                        case 2: {
                            n7 = 121;
                            break;
                        }
                        case 3: {
                            n7 = 7;
                            break;
                        }
                        default: {
                            n7 = 96;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

