/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.MaxSystem;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class MXJPreferences {
    public static final String MXJPREFFILE = "mxjpreferences.xml";
    public static final String MXJ_COMPILER_COMMAND = "COMMAND";
    public static final String MXJ_COMPILER_OPTIONS = "OPTIONS";
    public static final String MXJ_COMPILER_BUILD_ROOT = "BUILD_ROOT";
    public static final String MXJ_EDITOR_FOREGROUND_COLOR = "FOREGROUND_COLOR";
    public static final String MXJ_EDITOR_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String MXJ_EDITOR_COMMENT1_COLOR = "COMMENT1_COLOR";
    public static final String MXJ_EDITOR_COMMENT2_COLOR = "COMMENT2_COLOR";
    public static final String MXJ_EDITOR_KEYWORD1_COLOR = "KEYWORD1_COLOR";
    public static final String MXJ_EDITOR_KEYWORD2_COLOR = "KEYWORD2_COLOR";
    public static final String MXJ_EDITOR_KEYWORD3_COLOR = "KEYWORD3_COLOR";
    public static final String MXJ_EDITOR_LITERAL1_COLOR = "LITERAL1_COLOR";
    public static final String MXJ_EDITOR_LITERAL2_COLOR = "LITERAL2_COLOR";
    public static final String MXJ_EDITOR_LABEL_COLOR = "LABEL_COLOR";
    public static final String MXJ_EDITOR_OPERATOR_COLOR = "OPERATOR_COLOR";
    public static final String MXJ_EDITOR_INVALID_COLOR = "INVALID_COLOR";
    public static final String MXJ_EDITOR_CARET_COLOR = "CARET_COLOR";
    public static final String MXJ_EDITOR_BLOCK_CARET = "BLOCK_CARET";
    public static final String MXJ_EDITOR_CARET_BLINKS = "CARET_BLINKS";
    public static final String MXJ_EDITOR_EOL_MARKER_COLOR = "EOL_MARKER_COLOR";
    public static final String MXJ_EDITOR_USE_EOL_MARKERS = "USE_EOL_MARKERS";
    public static final String MXJ_EDITOR_SELECTION_COLOR = "SELECTION_COLOR";
    public static final String MXJ_EDITOR_LINE_HILITE = "LINE_HILITE";
    public static final String MXJ_EDITOR_LINE_HILITE_COLOR = "LINE_HILITE_COLOR";
    public static final String MXJ_EDITOR_BRACKET_HILITE = "BRACKET_HILITE";
    public static final String MXJ_EDITOR_BRACKET_HILITE_COLOR = "BRACKET_HILITE_COLOR";
    private static Preferences _prefs = null;
    private static Preferences _mxj_prefs = null;
    private static Preferences _mxj_editor_prefs = null;
    private static Preferences _mxj_compiler_prefs = null;
    private static String _default_compiler = null;
    private static String _default_compiler_build_root = null;

    private MXJPreferences() {
    }

    public static void writeToDisk() {
        String filename = MaxSystem.maxPathToNativePath("c74:/java/mxjpreferences.xml");
        try {
            _mxj_prefs.exportSubtree(new BufferedOutputStream(new FileOutputStream(filename)));
        }
        catch (Exception e) {
            System.err.println("(mxj) Problem writing preferences to :" + filename);
            e.printStackTrace();
        }
    }

    public static void readFromDisk() {
        String filename = MaxSystem.maxPathToNativePath("c74:/java/mxjpreferences.xml");
        File f = new File(filename);
        if (f.exists()) {
            try {
                Preferences.importPreferences(new BufferedInputStream(new FileInputStream(f)));
            }
            catch (IOException e) {
                System.err.println("(mxj) IO Error importing preferences: " + filename);
                e.printStackTrace();
            }
            catch (InvalidPreferencesFormatException ipe) {
                System.err.println("(mxj) Invalid preference file format: " + filename);
                ipe.printStackTrace();
            }
        }
    }

    public static void flush() {
        try {
            _mxj_compiler_prefs.flush();
        }
        catch (Exception e) {
            System.err.println("(mxj) Problem flushing mxj preferences.");
            e.printStackTrace();
        }
    }

    public static void setMXJCompilerCommmand(String command) {
        _mxj_compiler_prefs.put(MXJ_COMPILER_COMMAND, command);
        MXJPreferences.flush();
        MXJPreferences.writeToDisk();
    }

    public static void setMXJCompilerBuildRoot(String root) {
        _mxj_compiler_prefs.put(MXJ_COMPILER_BUILD_ROOT, root);
        MXJPreferences.flush();
        MXJPreferences.writeToDisk();
    }

    public void setMXJCompilerOptions(String options) {
        _mxj_compiler_prefs.put(MXJ_COMPILER_OPTIONS, options);
        MXJPreferences.flush();
        MXJPreferences.writeToDisk();
    }

    public static String[] getMXJCompilerOptions() {
        String ret = _prefs.get(MXJ_COMPILER_OPTIONS, "");
        if (ret.equals("")) {
            return null;
        }
        return ret.split(" ");
    }

    private static String _get_default_compiler_build_root() {
        return MaxSystem.maxPathToNativePath("c74:/java/classes");
    }

    private static String _get_default_compiler() {
        String javahome = System.getProperty("java.home");
        StringBuffer ret = new StringBuffer(javahome + "/bin/javac");
        if (MaxSystem.isOsWindows()) {
            ret.append(".exe");
        }
        return ret.toString();
    }

    public static String getMXJCompilerCommmand() {
        return _mxj_compiler_prefs.get(MXJ_COMPILER_COMMAND, _default_compiler);
    }

    public static String getMXJCompilerBuildRoot() {
        return _mxj_compiler_prefs.get(MXJ_COMPILER_BUILD_ROOT, _default_compiler_build_root);
    }

    public static Color getMXJEditorFGColor() {
        String c = "000000";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_FOREGROUND_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public static void setMXJEditorFGColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_FOREGROUND_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorBGColor() {
        String c = "FFFFFF";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_BACKGROUND_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xFFFFFF);
        }
    }

    public static void setMXJEditorBGColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_BACKGROUND_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorComment1Color() {
        String c = "FF0000";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_COMMENT1_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xFF2288);
        }
    }

    public static void setMXJEditorComment1Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_COMMENT1_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorComment2Color() {
        String c = "ff0000";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_COMMENT2_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xFF0000);
        }
    }

    public static void setMXJEditorComment2Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_COMMENT2_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorKeyword1Color() {
        String c = MXJPreferences.RGBtoHex(Color.blue.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_KEYWORD1_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.blue;
        }
    }

    public static void setMXJEditorKeyword1Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_KEYWORD1_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorKeyword2Color() {
        String c = "339999";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_KEYWORD3_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0x339999);
        }
    }

    public static void setMXJEditorKeyword2Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_KEYWORD3_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorKeyword3Color() {
        String c = MXJPreferences.RGBtoHex(Color.magenta.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_KEYWORD2_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.magenta;
        }
    }

    public static void setMXJEditorKeyword3Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_KEYWORD2_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorLiteral1Color() {
        String c = "888888";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_LITERAL1_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0x888888);
        }
    }

    public static void setMXJEditorLiteral1Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_LITERAL1_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorLiteral2Color() {
        String c = MXJPreferences.RGBtoHex(Color.magenta.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_LITERAL2_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.magenta;
        }
    }

    public static void setMXJEditorLiteral2Color(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_LITERAL2_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorLabelColor() {
        String c = "0000ff";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_LABEL_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(255);
        }
    }

    public static void setMXJEditorLabelColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_LABEL_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorOperatorColor() {
        String c = MXJPreferences.RGBtoHex(Color.orange.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_OPERATOR_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.orange;
        }
    }

    public static void setMXJEditorOperatorColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_OPERATOR_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorInvalidColor() {
        String c = MXJPreferences.RGBtoHex(Color.black.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_INVALID_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public static void setMXJEditorInvalidColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_INVALID_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorCaretColor() {
        String c = "FF0000";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_CARET_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xFF0000);
        }
    }

    public static void setMXJEditorCaretColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_CARET_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static boolean getMXJEditorBlockCaret() {
        boolean val = true;
        String s = _mxj_editor_prefs.get(MXJ_EDITOR_BLOCK_CARET, "true");
        return s.equals("true");
    }

    public static void setMXJEditorBlockCaret(boolean b) {
        String s = b ? "true" : "false";
        _mxj_editor_prefs.put(MXJ_EDITOR_BLOCK_CARET, s);
    }

    public static boolean getMXJEditorCaretBlinks() {
        boolean val = false;
        String s = _mxj_editor_prefs.get(MXJ_EDITOR_CARET_BLINKS, "false");
        return s.equals("true");
    }

    public static void setMXJEditorCaretBlinks(boolean b) {
        String s = b ? "true" : "false";
        _mxj_editor_prefs.put(MXJ_EDITOR_CARET_BLINKS, s);
    }

    public static Color getMXJEditorEOLMarkerColor() {
        String c = "999966";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_EOL_MARKER_COLOR, c), 16));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return new Color(0x999966);
        }
    }

    public static void setMXJEditorEOLMarkerColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_EOL_MARKER_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static boolean getMXJEditorUseEOLMarkers() {
        boolean val = true;
        String s = _mxj_editor_prefs.get(MXJ_EDITOR_USE_EOL_MARKERS, "true");
        return s.equals("true");
    }

    public static void setMXJEditorUseEOLMarkers(boolean b) {
        String s = b ? "true" : "false";
        _mxj_editor_prefs.put(MXJ_EDITOR_USE_EOL_MARKERS, s);
    }

    public static Color getMXJEditorBracketHiliteColor() {
        String c = "FF66FF";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_BRACKET_HILITE_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xFF66FF);
        }
    }

    public static void setMXJEditorBracketHiliteColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_BRACKET_HILITE_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorLineHiliteColor() {
        String c = "e0e0e0";
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_LINE_HILITE_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return new Color(0xE0E0E0);
        }
    }

    public static void setMXJEditorLineHiliteColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_LINE_HILITE_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static Color getMXJEditorSelectionColor() {
        String c = MXJPreferences.RGBtoHex(Color.yellow.getRGB());
        try {
            return new Color(Integer.parseInt(_mxj_editor_prefs.get(MXJ_EDITOR_SELECTION_COLOR, c), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.yellow;
        }
    }

    public static void setMXJEditorSelectionColor(int c) {
        _mxj_editor_prefs.put(MXJ_EDITOR_SELECTION_COLOR, MXJPreferences.RGBtoHex(c));
    }

    public static boolean getMXJEditorLineHilite() {
        boolean val = false;
        String s = _mxj_editor_prefs.get(MXJ_EDITOR_LINE_HILITE, "false");
        return s.equals("true");
    }

    public static void setMXJEditorLineHilite(boolean b) {
        String s = b ? "true" : "false";
        _mxj_editor_prefs.put(MXJ_EDITOR_LINE_HILITE, s);
    }

    public static boolean getMXJEditorBracketHilite() {
        boolean val = true;
        String s = _mxj_editor_prefs.get(MXJ_EDITOR_BRACKET_HILITE, "true");
        return s.equals("true");
    }

    public static void setMXJEditorBracketHilite(boolean b) {
        String s = b ? "true" : "false";
        _mxj_editor_prefs.put(MXJ_EDITOR_BRACKET_HILITE, s);
    }

    public static void savePrefs() {
        MXJPreferences.flush();
        MXJPreferences.writeToDisk();
    }

    private static String RGBtoHex(int RGBcolor) {
        Color color = new Color(RGBcolor);
        StringBuffer webcolor = new StringBuffer();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (r < 16) {
            webcolor.append("0");
        }
        webcolor.append(Integer.toHexString(r));
        if (g < 16) {
            webcolor.append("0");
        }
        webcolor.append(Integer.toHexString(g));
        if (b < 16) {
            webcolor.append("0");
        }
        webcolor.append(Integer.toHexString(b));
        return webcolor.toString();
    }

    private static void write_compiler_prefs() {
        MXJPreferences.setMXJCompilerCommmand(MXJPreferences.getMXJCompilerCommmand());
        MXJPreferences.setMXJCompilerBuildRoot(MXJPreferences.getMXJCompilerBuildRoot());
    }

    private static void write_editor_prefs() {
        MXJPreferences.setMXJEditorFGColor(MXJPreferences.getMXJEditorFGColor().getRGB());
        MXJPreferences.setMXJEditorBGColor(MXJPreferences.getMXJEditorBGColor().getRGB());
        MXJPreferences.setMXJEditorComment1Color(MXJPreferences.getMXJEditorComment1Color().getRGB());
        MXJPreferences.setMXJEditorComment2Color(MXJPreferences.getMXJEditorComment2Color().getRGB());
        MXJPreferences.setMXJEditorKeyword1Color(MXJPreferences.getMXJEditorKeyword1Color().getRGB());
        MXJPreferences.setMXJEditorKeyword2Color(MXJPreferences.getMXJEditorKeyword2Color().getRGB());
        MXJPreferences.setMXJEditorKeyword3Color(MXJPreferences.getMXJEditorKeyword3Color().getRGB());
        MXJPreferences.setMXJEditorLiteral1Color(MXJPreferences.getMXJEditorLiteral1Color().getRGB());
        MXJPreferences.setMXJEditorLiteral2Color(MXJPreferences.getMXJEditorLiteral2Color().getRGB());
        MXJPreferences.setMXJEditorLabelColor(MXJPreferences.getMXJEditorLabelColor().getRGB());
        MXJPreferences.setMXJEditorOperatorColor(MXJPreferences.getMXJEditorOperatorColor().getRGB());
        MXJPreferences.setMXJEditorInvalidColor(MXJPreferences.getMXJEditorInvalidColor().getRGB());
        MXJPreferences.setMXJEditorBlockCaret(MXJPreferences.getMXJEditorBlockCaret());
        MXJPreferences.setMXJEditorCaretBlinks(MXJPreferences.getMXJEditorCaretBlinks());
        MXJPreferences.setMXJEditorEOLMarkerColor(MXJPreferences.getMXJEditorEOLMarkerColor().getRGB());
        MXJPreferences.setMXJEditorUseEOLMarkers(MXJPreferences.getMXJEditorUseEOLMarkers());
        MXJPreferences.setMXJEditorSelectionColor(MXJPreferences.getMXJEditorSelectionColor().getRGB());
        MXJPreferences.setMXJEditorLineHilite(MXJPreferences.getMXJEditorLineHilite());
        MXJPreferences.setMXJEditorLineHiliteColor(MXJPreferences.getMXJEditorLineHiliteColor().getRGB());
        MXJPreferences.setMXJEditorBracketHilite(MXJPreferences.getMXJEditorBracketHilite());
        MXJPreferences.setMXJEditorBracketHiliteColor(MXJPreferences.getMXJEditorBracketHiliteColor().getRGB());
    }

    static {
        String filename = MaxSystem.locateFile(MXJPREFFILE);
        if (filename == null) {
            filename = MaxSystem.maxPathToNativePath("c74:/java/mxjpreferences.xml");
        }
        File f = new File(filename);
        _prefs = Preferences.userRoot();
        _mxj_prefs = _prefs.node("MXJ_PREFS");
        _mxj_editor_prefs = _mxj_prefs.node("MXJ_EDITOR_PREFS");
        _mxj_compiler_prefs = _mxj_prefs.node("MXJ_COMPILER_PREFS");
        try {
            _mxj_editor_prefs.clear();
            _mxj_compiler_prefs.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        _default_compiler = MXJPreferences._get_default_compiler();
        _default_compiler_build_root = MXJPreferences._get_default_compiler_build_root();
        if (f.exists()) {
            try {
                Preferences.importPreferences(new BufferedInputStream(new FileInputStream(f)));
            }
            catch (IOException e) {
                System.err.println("(mxj) IO Error importing preferences: " + filename);
                e.printStackTrace();
            }
            catch (InvalidPreferencesFormatException ipe) {
                System.err.println("(mxj) Invalid preference file format: " + filename);
                ipe.printStackTrace();
            }
        } else {
            MXJPreferences.write_compiler_prefs();
            MXJPreferences.write_editor_prefs();
            MXJPreferences.savePrefs();
        }
    }
}

