/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.Atom;
import com.cycling74.max.Executable;
import com.cycling74.max.MXJClassLoader;
import java.io.IOException;

public class MaxSystem {
    private static final String[] _sys_classpath = MaxSystem.getSystemClassPath();
    public static final int PATH_STYLE_MAX = 0;
    public static final int PATH_STYLE_NATIVE = 1;
    public static final int PATH_STYLE_COLON = 2;
    public static final int PATH_STYLE_SLASH = 3;
    public static final int PATH_STYLE_NATIVE_WIN = 4;
    public static final int PATH_TYPE_IGNORE = 0;
    public static final int PATH_TYPE_ABSOLUTE = 1;
    public static final int PATH_TYPE_RELATIVE = 2;
    public static final int PATH_TYPE_BOOT = 3;
    public static final int PATH_TYPE_C74 = 4;

    public static native void defer(Executable var0);

    public static native void deferLow(Executable var0);

    public static native void deferMedium(Executable var0);

    public static native void deferFront(Executable var0);

    public static native void schedule(Executable var0, double var1);

    public static native void scheduleDelay(Executable var0, double var1);

    public static native void scheduleDefer(Executable var0, double var1);

    public static native boolean inMaxThread();

    public static native boolean inTimerThread();

    public static native boolean inMainThread();

    public static native void showCursor();

    public static native void hideCursor();

    public static native void nextWindowIsModal();

    public static native boolean sendMessageToBoundObject(String var0, String var1, Atom[] var2);

    public static String openDialog() {
        return MaxSystem.openDialog(null);
    }

    public static native String openDialog(String var0);

    public static native String saveAsDialog(String var0, String var1);

    public static native String locateFile(String var0);

    public static native String getDefaultPath();

    public static native String[] getSearchPath();

    public static native String nameConform(String var0, int var1, int var2);

    public static native String maxPathToNativePath(String var0);

    public static native double sysTimerGetTime();

    public static short getMaxVersion() {
        return MaxSystem.doGetMaxVersion();
    }

    public static boolean isRuntime() {
        return MaxSystem.doGetIsRuntime();
    }

    public static boolean isStandAlone() {
        return (0x2000 & MaxSystem.doGetMaxVersion()) != 0;
    }

    public static int[] getMaxVersionInts() {
        int[] i = new int[3];
        short v = MaxSystem.doGetMaxVersion();
        i[0] = (v & 0xF00) >>> 8;
        i[1] = (v & 0xF0) >>> 4;
        i[2] = v & 0xF;
        return i;
    }

    private static final native short doGetMaxVersion();

    public static native boolean doGetIsRuntime();

    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name", "");
        return osName.startsWith("Windows");
    }

    public static boolean isOsMacOsX() {
        String osName = System.getProperty("os.name", "");
        return osName.startsWith("Mac OS X");
    }

    public static String[] getSystemClassPath() {
        if (_sys_classpath != null) {
            return _sys_classpath;
        }
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static String[] getClassPath() {
        int syscplen = MaxSystem.getSystemClassPath().length;
        String[] tmp = MXJClassLoader.getInstance().getDynamicClassPath();
        String[] ret = new String[tmp.length + syscplen];
        int i = 0;
        for (i = 0; i < syscplen; ++i) {
            ret[i] = _sys_classpath[i];
        }
        for (i = syscplen; i < ret.length; ++i) {
            ret[i] = tmp[i - syscplen];
        }
        return ret;
    }

    public static void registerCommandAccelerators(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            MaxSystem.registerCommandAccelerator(c[i]);
        }
    }

    public static void registerCommandAccelerator(char c) {
        MaxSystem._register_command_accelerator(c);
    }

    private static native void _register_command_accelerator(char var0);

    public static void unregisterCommandAccelerators(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            MaxSystem.unregisterCommandAccelerator(c[i]);
        }
    }

    private static native void _unregister_command_accelerator(char var0);

    public static void unregisterCommandAccelerator(char c) {
        MaxSystem._unregister_command_accelerator(c);
    }

    public static void post(String message) {
        try {
            if (message != null) {
                if (message.length() > 1023) {
                    message = message.substring(0, 1023);
                }
                byte[] msgBytes = message.getBytes("UTF-8");
                MaxSystem.doPost(msgBytes);
            }
        }
        catch (IOException ioe) {
            MaxSystem.error("io error." + ioe);
        }
    }

    public static void loadObject(String objname) {
        try {
            if (objname != null) {
                if (objname.length() > 1023) {
                    objname = objname.substring(0, 1023);
                }
                byte[] msgBytes = objname.getBytes("UTF-8");
                MaxSystem.doLoadObject(msgBytes);
            }
        }
        catch (IOException ioe) {
            MaxSystem.error("io error." + ioe);
        }
    }

    public static void error(String message) {
        try {
            if (message != null) {
                if (message.length() > 1023) {
                    message = message.substring(0, 1023);
                }
                byte[] msgBytes = message.getBytes("UTF-8");
                MaxSystem.doError(msgBytes);
            }
        }
        catch (IOException ioe) {
            MaxSystem.error("io error." + ioe);
        }
    }

    public static void ouch(String message) {
        try {
            byte[] msgBytes = message.getBytes("UTF-8");
            MaxSystem.doOuch(msgBytes);
        }
        catch (IOException ioe) {
            MaxSystem.error("io error." + ioe);
        }
    }

    private static final native void doPost(byte[] var0);

    private static final native void doLoadObject(byte[] var0);

    private static final native void doError(byte[] var0);

    private static final native void doOuch(byte[] var0);
}

