/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.Tempo;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class AbsoluteDurationReporter
implements ScoreOperator {
    StringBuffer buf = new StringBuffer();

    static {
        System.out.println("JMSL plug-ins build 20080505");
    }

    public void operate(Score score) {
        this.buf = new StringBuffer();
        int i = 0;
        while (i < score.getSelectionBuffer().size()) {
            Note n = (Note)score.getSelectionBuffer().elementAt(i);
            this.reportAbsoluteDuration(n);
            ++i;
        }
    }

    private void reportAbsoluteDuration(Note n) {
        Tempo tempo = n.getScore().getMeasure(n.getMeasureIndex()).getTempo();
        double durationData = n.getDurationData();
        double absoluteDuration = durationData * 60.0 / tempo.getBPM();
        String tuplet = n.getTuplet() == 0 ? "-" : String.valueOf(n.getTuplet());
        this.buf.append("pitch = " + n.getPitchData() + "\tdur=" + durationData + "\ttuplet=" + tuplet + "\ttempo=" + tempo.getBPM() + "\tabsolute duration= " + absoluteDuration + " sec\n");
    }

    public String getName() {
        return "AbsoluteDurationReporter";
    }

    public String getResultString() {
        return this.buf.toString();
    }

    public static void main(String[] args) {
        Score score = new Score(1, 600, 200);
        score.addMeasure();
        ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addScoreOperator((ScoreOperator)new AbsoluteDurationReporter());
        scoreFrame.addScore(score);
        scoreFrame.pack();
        scoreFrame.setVisible(true);
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JMSL.closeMusicDevices();
                System.exit(0);
            }
        });
    }
}

