/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.NotePropertiesTransform;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.SelectionBuffer;
import com.softsynth.jmsl.util.BeanEditor;
import com.softsynth.jmsl.util.BooleanListener;
import com.softsynth.jmsl.util.LinearInterpolator;
import java.awt.Frame;
import java.util.Enumeration;

public class AmplitudeCrescendo
extends NotePropertiesTransform
implements BooleanListener {
    private double startAmp;
    private double endAmp;
    private Score score;
    private SelectionBuffer selectionBuffer;

    public AmplitudeCrescendo() {
        this.setName("AmplitudeCrescendo");
        this.setStartAmp(0.1);
        this.setEndAmp(0.7);
    }

    public void operate(Score score, SelectionBuffer selectionBuffer) {
        System.out.println("AmplitudeCrescendo transform by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        this.score = score;
        this.selectionBuffer = selectionBuffer;
        try {
            BeanEditor beanEditor = new BeanEditor(new Frame(), null, (Object)this, false, (BooleanListener)this);
            beanEditor.setVisible(true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void operate_impl() {
        int numNotes = 0;
        Enumeration e = this.selectionBuffer.elements();
        while (e.hasMoreElements()) {
            Note note = (Note)e.nextElement();
            if (note.isRest()) continue;
            ++numNotes;
        }
        LinearInterpolator interpolator = new LinearInterpolator(0.0, this.startAmp, (double)numNotes, this.endAmp);
        numNotes = 0;
        Enumeration e2 = this.selectionBuffer.elements();
        while (e2.hasMoreElements()) {
            Note note = (Note)e2.nextElement();
            if (note.isRest()) continue;
            double amp = interpolator.interp((double)numNotes);
            note.setVelData(amp);
            ++numNotes;
        }
    }

    public double getEndAmp() {
        return this.endAmp;
    }

    public double getStartAmp() {
        return this.startAmp;
    }

    public void setEndAmp(double d) {
        this.endAmp = d;
    }

    public void setStartAmp(double d) {
        this.startAmp = d;
    }

    public void booleanSelected(Object object, boolean flag) {
        if (flag) {
            this.operate_impl();
        }
    }
}

