/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.MusicShape;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.SelectionBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class DumpSelectedToMusicShape
implements ScoreOperator {
    StringBuffer srcbuf;
    int totalMusicShapes;

    public String getName() {
        return "Dump selected to MusicShape";
    }

    public void operate(Score score) {
        Integer staffIndex;
        Note note;
        System.out.println("DumpSelectedToMusicShape operator by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        Object nuthin = new Object();
        SelectionBuffer buf = score.getSelectionBuffer();
        Hashtable<Integer, Object> shapesHash = new Hashtable<Integer, Object>();
        Enumeration e = buf.elements();
        while (e.hasMoreElements()) {
            note = (Note)e.nextElement();
            staffIndex = new Integer(note.getStaffIndex());
            if (shapesHash.contains(staffIndex)) continue;
            shapesHash.put(staffIndex, nuthin);
        }
        e = buf.elements();
        while (e.hasMoreElements()) {
            note = (Note)e.nextElement();
            staffIndex = new Integer(note.getStaffIndex());
            if (shapesHash.get(staffIndex) == nuthin) {
                if (note.getDimensionNameSpace() != null) {
                    shapesHash.put(staffIndex, new MusicShape(note.getDimensionNameSpace()));
                } else {
                    shapesHash.put(staffIndex, new MusicShape(note.getData().length));
                }
            }
            MusicShape s = (MusicShape)shapesHash.get(staffIndex);
            if (note.isInterval()) continue;
            if (note.isChord()) {
                Enumeration intervals = note.getIntervals().elements();
                while (intervals.hasMoreElements()) {
                    Note interval = (Note)intervals.nextElement();
                    if (!interval.getSelected()) continue;
                    double[] dataCopy = interval.getPerformanceDataCopy();
                    if (interval.getTiedIn()) {
                        dataCopy[1] = 0.0;
                        dataCopy[2] = 0.0;
                    }
                    s.add(dataCopy);
                }
            }
            double[] performanceData = note.getPerformanceDataCopy();
            if (note.getTiedIn()) {
                performanceData[1] = 0.0;
                performanceData[2] = 0.0;
                s.add(performanceData);
                continue;
            }
            s.add(performanceData);
        }
        this.totalMusicShapes = shapesHash.size();
        this.srcbuf = new StringBuffer();
        e = shapesHash.keys();
        while (e.hasMoreElements()) {
            MusicShape s = (MusicShape)shapesHash.get(e.nextElement());
            this.srcbuf.append(String.valueOf(s.dumpSource()) + "\n\n");
        }
    }

    public String getResultString() {
        return "Total MusicShapes: " + this.totalMusicShapes + "\n\n" + this.srcbuf.toString();
    }
}

