/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Track;
import java.util.Vector;

public class ExtendOttavaRunsByOneNote
implements ScoreOperator {
    public String getName() {
        return "Extend Ottava runs by one note";
    }

    public void operate(Score score) {
        System.out.println("ExtendOttavaRunsByOneNote operator by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        Vector<Note> affectedNotes = new Vector<Note>();
        int m = 0;
        while (m < score.size()) {
            Measure measure = score.getMeasure(m);
            int s = 0;
            while (s < measure.size()) {
                Staff staff = measure.getStaff(s);
                int t = 0;
                while (t < staff.size()) {
                    Track track = staff.getTrack(t);
                    int n = 0;
                    while (n < track.size()) {
                        Note note = track.getNote(n);
                        if (!note.is8va() && note.get8vaIn() && note.prevNote() != null && !affectedNotes.contains(note.prevNote())) {
                            note.set8va(true);
                            affectedNotes.addElement(note);
                        } else if (!note.is8vb() && note.get8vbIn() && note.prevNote() != null && !affectedNotes.contains(note.prevNote())) {
                            note.set8vb(true);
                            affectedNotes.addElement(note);
                        }
                        ++n;
                    }
                    ++t;
                }
                ++s;
            }
            ++m;
        }
    }

    public String getResultString() {
        return "This score has been upgraded by extending ottava alta/bassa runs by one note";
    }
}

