/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.Composable;
import com.softsynth.jmsl.DimensionNameSpace;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.InstrumentAdapter;
import com.softsynth.jmsl.JMSL;
import com.softsynth.jmsl.MusicShape;
import com.softsynth.jmsl.SequentialCollection;
import com.softsynth.jmsl.score.Clef;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.transcribe.BeatDivisionScheme;
import com.softsynth.jmsl.score.transcribe.BeatDivisionSchemeList;
import com.softsynth.jmsl.score.transcribe.ElementMissedException;
import com.softsynth.jmsl.score.transcribe.SearchPathListExpansionException;
import com.softsynth.jmsl.score.transcribe.Transcriber;
import com.softsynth.jmsl.util.TimeSignature;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class GridEntry
implements ScoreOperator,
ActionListener,
ItemListener {
    int rows;
    int columns;
    int sixteenth;
    int basePitch;
    int repeats;
    String message = null;
    String[] gridLevels = new String[]{"1/2", "1/2 3", "1/4", "1/4 3", "1/8", "1/8 3", "1/16", "1/16 3", "1/32"};
    String[] octaves = new String[]{"1", "2", "3"};
    String[] notes = new String[]{"B  ", "A#", "A  ", "G#", "G  ", "F#", "F  ", "E  ", "D#", "D  ", "C#", "C  "};
    JFrame f;
    JPanel entryPanel;
    JPanel listPanel;
    JPanel buttonPanel;
    JPanel gridPanel;
    JPanel pitchPanel;
    JLabel label;
    JLabel divisionLabel;
    JLabel rangeLabel;
    JLabel repeatLabel;
    JComboBox division;
    JComboBox range;
    JButton accept;
    JButton clear;
    JButton cancel;
    JButton play;
    JButton stop;
    JTextField repeatField;
    Score s;
    TimeSignature ts;
    Staff staff;
    Measure measure;
    private String title = "GridEntry v1.1 plug-in by Daniel Ross, dross@themgmt.com, (c) 2005 Daniel Ross, All Rights Reserved, used with permission";
    Instrument instrument;
    SequentialCollection seqCol;

    static {
        System.out.println("JMSL plug-ins build 20080505");
    }

    public void operate(Score score) {
        System.out.println(this.title);
        this.s = score;
        this.message = null;
        this.measure = this.s.getSelectedMeasure();
        this.staff = this.s.getSelectedStaff();
        if (this.staff == null || this.measure == null) {
            this.message = "Click on a staff to select it before running this operator";
            return;
        }
        this.instrument = this.staff.getInstrument();
        this.s.setCurrentMeasureNumber(this.measure.getMeasureIndex());
        this.s.setCurrentStaffNumber(this.staff.getStaffIndex());
        this.ts = this.measure.getTimeSig();
        Clef clef = this.staff.getClef();
        this.rows = 24;
        this.sixteenth = this.columns = this.ts.getNumerator() * 16 / this.ts.getDenominator();
        this.repeats = 0;
        this.setRange(clef);
        this.buildFrame();
        this.buildSeqCol();
    }

    private void buildSeqCol() {
        this.seqCol = new SequentialCollection(){

            public double repeat(double time) {
                System.out.println("SeqCol repeating " + GridEntry.this.seqCol.getRepeatCount());
                MusicShape s = GridEntry.this.makeMusicShape();
                if (s.size() == 0) {
                    GridEntry.this.seqCol.setRepeatPause(1.0);
                } else {
                    GridEntry.this.seqCol.setRepeatPause(0.0);
                }
                MusicShape differentiatedMusicShape = (MusicShape)s.clone();
                differentiatedMusicShape.differentiate(GridEntry.this.ts.getTotalTime(), 0);
                this.instrument = GridEntry.this.staff.getInstrument();
                if (this.instrument != null) {
                    differentiatedMusicShape.setInstrument(this.instrument);
                } else {
                    differentiatedMusicShape.setInstrument((Instrument)new InstrumentAdapter());
                }
                differentiatedMusicShape.setTimeStretch(GridEntry.this.measure.getTempo().getTimeStretch());
                GridEntry.this.seqCol.removeAll();
                GridEntry.this.seqCol.add((Composable)differentiatedMusicShape);
                return time;
            }
        };
        this.seqCol.setRepeats(Integer.MAX_VALUE);
    }

    private void buildFrame() {
        this.f = new JFrame(this.title);
        this.label = new JLabel("Choose a grid setting and click to add notes and create patterns:");
        Container content = this.f.getContentPane();
        this.buildEntryPanel();
        this.buildListPanel();
        this.buildButtonPanel();
        content.setBackground(Color.WHITE);
        content.setLayout(new BorderLayout());
        content.add((Component)this.label, "North");
        content.add((Component)this.listPanel, "West");
        content.add((Component)this.entryPanel, "Center");
        content.add((Component)this.buttonPanel, "South");
        this.f.pack();
        this.f.setBounds(50, 50, 600, 450);
        this.f.setResizable(true);
        this.f.setVisible(true);
        this.f.setDefaultCloseOperation(2);
    }

    private void buildEntryPanel() {
        this.entryPanel = new JPanel();
        this.gridPanel = new JPanel();
        this.pitchPanel = new JPanel();
        this.pitchPanel.setBackground(Color.WHITE);
        this.gridPanel.setBackground(Color.WHITE);
        this.entryPanel.setBackground(Color.WHITE);
        this.updatePitchPanel();
        this.updateGridPanel();
        this.entryPanel.setLayout(new BorderLayout());
        this.entryPanel.add((Component)this.pitchPanel, "West");
        this.entryPanel.add((Component)this.gridPanel, "Center");
    }

    private void updatePitchPanel() {
        this.pitchPanel.removeAll();
        this.pitchPanel.setLayout(new GridLayout(this.rows, 1));
        this.pitchPanel.setVisible(false);
        int pitch = this.basePitch + this.rows - 1;
        int i = 0;
        while (i < this.rows) {
            this.pitchPanel.add(new JLabel(String.valueOf(this.notes[i % 12]) + pitch));
            --pitch;
            ++i;
        }
        Graphics g = this.pitchPanel.getGraphics();
        this.pitchPanel.update(g);
        this.pitchPanel.validate();
        this.pitchPanel.setVisible(true);
    }

    private void setRange(Clef c) {
        int clefType = c.getClefType();
        this.basePitch = clefType == 0 || clefType == 1 || clefType == 2 ? 60 : 36;
    }

    private void updateGridPanel() {
        this.gridPanel.removeAll();
        this.gridPanel.setLayout(new GridLayout(this.rows, this.columns));
        this.gridPanel.setVisible(false);
        int tileCount = 0;
        int colorCount = 64;
        int pitch = this.basePitch + this.rows - 1;
        double dur = this.ts.getTotalTime() / (double)this.columns;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                final Tile tile = new Tile(colorCount, dur, pitch);
                this.gridPanel.add((Component)tile, tileCount);
                tile.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        Instrument ins = GridEntry.this.staff.getInstrument();
                        if (ins != null) {
                            double[] dar = ins.getDimensionNameSpace() != null ? MusicShape.getDefaultArray((DimensionNameSpace)ins.getDimensionNameSpace()) : new double[4];
                            dar[0] = GridEntry.this.ts.getTotalTime() / (double)GridEntry.this.columns;
                            dar[1] = tile.isSelected() ? tile.getPitch() : 0;
                            dar[2] = 0.5;
                            dar[3] = GridEntry.this.ts.getTotalTime() / (double)GridEntry.this.columns * 0.8;
                            ins.play(JMSL.realTime(), 1.0, dar);
                        }
                    }
                });
                ++tileCount;
                ++j;
            }
            if ((colorCount += 16) > 240) {
                colorCount = 64;
            }
            --pitch;
            ++i;
        }
        Graphics g = this.gridPanel.getGraphics();
        this.gridPanel.update(g);
        this.gridPanel.validate();
        this.gridPanel.setVisible(true);
    }

    private void updateEntryPanel(int r, int c) {
        this.rows = r;
        this.columns = c;
        this.updatePitchPanel();
        this.updateGridPanel();
    }

    private void clearNotes() {
        Component[] tiles = this.gridPanel.getComponents();
        int i = 0;
        while (i < tiles.length) {
            if (((Tile)tiles[i]).isSelected()) {
                ((Tile)tiles[i]).setSelected(false);
            }
            ++i;
        }
    }

    private void buildListPanel() {
        this.listPanel = new JPanel();
        this.divisionLabel = new JLabel("Grid");
        this.rangeLabel = new JLabel("Range");
        this.repeatLabel = new JLabel("Repeat");
        this.division = new JComboBox<String>(this.gridLevels);
        this.range = new JComboBox<String>(this.octaves);
        this.repeatField = new JTextField("0");
        this.division.addItemListener(this);
        this.range.addItemListener(this);
        this.division.setSelectedItem("1/16");
        this.range.setSelectedItem("2");
        this.listPanel.setBackground(Color.WHITE);
        GridBagLayout listLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.listPanel.setLayout(listLayout);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        listLayout.setConstraints(this.divisionLabel, c);
        this.listPanel.add(this.divisionLabel);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        listLayout.setConstraints(this.division, c);
        this.listPanel.add(this.division);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        listLayout.setConstraints(this.rangeLabel, c);
        this.listPanel.add(this.rangeLabel);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 0;
        c.weightx = 1.0;
        listLayout.setConstraints(this.range, c);
        this.listPanel.add(this.range);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.weightx = 1.0;
        listLayout.setConstraints(this.repeatLabel, c);
        this.listPanel.add(this.repeatLabel);
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        listLayout.setConstraints(this.repeatField, c);
        this.listPanel.add(this.repeatField);
    }

    private void buildButtonPanel() {
        this.buttonPanel = new JPanel();
        this.accept = new JButton("accept");
        this.clear = new JButton("clear");
        this.cancel = new JButton("cancel");
        this.play = new JButton("play");
        this.stop = new JButton("stop");
        this.accept.addActionListener(this);
        this.clear.addActionListener(this);
        this.cancel.addActionListener(this);
        this.play.addActionListener(this);
        this.stop.addActionListener(this);
        this.buttonPanel.setBackground(Color.WHITE);
        this.buttonPanel.add(this.accept);
        this.buttonPanel.add(this.clear);
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.play);
        this.buttonPanel.add(this.stop);
    }

    public MusicShape makeMusicShape() {
        MusicShape musicShape;
        this.instrument = this.staff.getInstrument();
        if (this.instrument != null && this.instrument.getDimensionNameSpace() != null) {
            musicShape = new MusicShape(this.instrument.getDimensionNameSpace());
        } else {
            musicShape = new MusicShape(4);
            musicShape.useStandardDimensionNameSpace();
            musicShape.useStandardDimensionNameSpace();
        }
        int index = 0;
        double dur = this.ts.getTotalTime() / (double)this.columns;
        Component[] tiles = this.gridPanel.getComponents();
        double timeStamp = 0.0;
        int i = 0;
        while (i < this.columns) {
            index = i;
            int j = 0;
            while (j < this.rows) {
                Tile t = (Tile)tiles[index];
                if (t.isSelected()) {
                    double[] dar = MusicShape.getDefaultArray((DimensionNameSpace)musicShape);
                    dar[0] = timeStamp;
                    dar[1] = t.getPitch();
                    dar[2] = 0.5;
                    dar[3] = dur * 0.8;
                    musicShape.add(dar);
                }
                index += this.columns;
                ++j;
            }
            timeStamp += this.ts.getTotalTime() / (double)this.columns;
            ++i;
        }
        return musicShape;
    }

    public String getName() {
        return "GridEntry";
    }

    public String getResultString() {
        return this.message;
    }

    public static void main(String[] args) {
        Score score = new Score(1, 1000, 600);
        Measure m = score.addMeasure(5, 4);
        m.setTempo(110.0);
        score.addMeasure(4, 4);
        final ScoreFrame f = new ScoreFrame();
        f.addScoreOperator((ScoreOperator)new GridEntry());
        f.addScore(score);
        f.pack();
        f.setVisible(true);
        f.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.quit();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.accept) {
            try {
                this.repeats = new Integer(this.repeatField.getText());
                MusicShape musicShape = this.makeMusicShape();
                musicShape.print();
                this.repeatMusicShape(musicShape);
                musicShape.print();
                Transcriber transcriber = new Transcriber();
                transcriber.setScore(this.s);
                transcriber.setSourceMusicShape(musicShape);
                Vector<TimeSignature> tsVector = new Vector<TimeSignature>();
                TimeSignature ts = this.measure.getTimeSig();
                int measuresLeft = this.s.size() - this.measure.getMeasureIndex();
                int i = 0;
                while (i < measuresLeft) {
                    int measureIndex = this.measure.getMeasureIndex() + i;
                    if (measureIndex < this.s.size()) {
                        tsVector.addElement(this.s.getMeasure(measureIndex).getTimeSig());
                    }
                    ++i;
                }
                transcriber.setTimeSignatures(tsVector);
                try {
                    transcriber.transcribe();
                }
                catch (SearchPathListExpansionException e1) {
                    e1.printStackTrace();
                }
                catch (ElementMissedException e1) {
                    e1.printStackTrace();
                }
                this.s.render();
                this.f.dispose();
                this.seqCol.finishAll();
            }
            catch (NumberFormatException nfe) {
                this.message = "Please specify a valid number of repeats. (positive integer)";
                return;
            }
        }
        if (source == this.clear) {
            this.clearNotes();
        }
        if (source == this.cancel) {
            this.f.dispose();
            this.seqCol.finishAll();
        }
        if (source == this.play) {
            this.seqCol.launch(JMSL.now());
            this.play.setEnabled(false);
            this.stop.setEnabled(true);
        }
        if (source == this.stop) {
            this.seqCol.finishAll();
            this.play.setEnabled(true);
            this.stop.setEnabled(false);
        }
    }

    private void repeatMusicShape(MusicShape musicShape) {
        int size = musicShape.size();
        int i = 1;
        while (i < this.repeats) {
            double baseTimeStamp = (double)i * this.ts.getTotalTime();
            int j = 0;
            while (j < size) {
                double[] dar = musicShape.get(j);
                dar[0] = dar[0] + baseTimeStamp;
                musicShape.add(dar);
                ++j;
            }
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.division) {
            BeatDivisionScheme b;
            if ((String)this.division.getSelectedItem() == "1/2") {
                this.updateEntryPanel(this.rows, this.sixteenth / 8);
                BeatDivisionSchemeList.defaultSetup();
            }
            if ((String)this.division.getSelectedItem() == "1/2 3") {
                this.updateEntryPanel(this.rows, this.sixteenth / 16 * 3);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.25);
                b.setMinRequired(0);
                b.setNumberOfDivisions(4);
                b.setMinTimeSpan(0.25);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
                b = new BeatDivisionScheme();
                b.setTimeSpan(4.0);
                b.setMinTimeSpan(b.getTimeSpan() / 3.0);
                b.setMinRequired(1);
                b.setNumberOfDivisions(3);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
            if ((String)this.division.getSelectedItem() == "1/4") {
                this.updateEntryPanel(this.rows, this.sixteenth / 4);
                BeatDivisionSchemeList.defaultSetup();
            }
            if ((String)this.division.getSelectedItem() == "1/4 3") {
                this.updateEntryPanel(this.rows, this.sixteenth / 8 * 3);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.25);
                b.setMinRequired(0);
                b.setNumberOfDivisions(4);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
                b = new BeatDivisionScheme();
                b.setTimeSpan(2.0);
                b.setMinTimeSpan(b.getTimeSpan() / 3.0);
                b.setMinRequired(1);
                b.setNumberOfDivisions(3);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
            if ((String)this.division.getSelectedItem() == "1/8") {
                this.updateEntryPanel(this.rows, this.sixteenth / 2);
                BeatDivisionSchemeList.defaultSetup();
            }
            if ((String)this.division.getSelectedItem() == "1/8 3") {
                this.updateEntryPanel(this.rows, this.sixteenth / 4 * 3);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.25);
                b.setMinRequired(0);
                b.setNumberOfDivisions(4);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(b.getTimeSpan() / 3.0);
                b.setMinRequired(1);
                b.setNumberOfDivisions(3);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
            if ((String)this.division.getSelectedItem() == "1/16") {
                this.updateEntryPanel(this.rows, this.sixteenth);
                BeatDivisionSchemeList.defaultSetup();
            }
            if ((String)this.division.getSelectedItem() == "1/16 3") {
                this.updateEntryPanel(this.rows, this.sixteenth / 2 * 3);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.25);
                b.setMinRequired(0);
                b.setNumberOfDivisions(4);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
                b = new BeatDivisionScheme();
                b.setTimeSpan(0.5);
                b.setMinTimeSpan(b.getTimeSpan() / 3.0);
                b.setMinRequired(1);
                b.setNumberOfDivisions(3);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
            if ((String)this.division.getSelectedItem() == "1/32") {
                this.updateEntryPanel(this.rows, this.sixteenth * 2);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.125);
                b.setMinRequired(0);
                b.setNumberOfDivisions(8);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
            if ((String)this.division.getSelectedItem() == "1/32 3") {
                this.updateEntryPanel(this.rows, this.sixteenth * 3);
                BeatDivisionSchemeList.removeAllBeatDivisionSchemes();
                b = new BeatDivisionScheme();
                b.setTimeSpan(1.0);
                b.setMinTimeSpan(0.25);
                b.setMinRequired(0);
                b.setNumberOfDivisions(4);
                b.setConformToBeat(true);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
                b = new BeatDivisionScheme();
                b.setTimeSpan(0.25);
                b.setMinTimeSpan(b.getTimeSpan() / 3.0);
                b.setMinRequired(1);
                b.setNumberOfDivisions(3);
                BeatDivisionSchemeList.addBeatDivisionScheme((BeatDivisionScheme)b);
            }
        }
        if (source == this.range) {
            if ((String)this.range.getSelectedItem() == "1") {
                this.updateEntryPanel(12, this.columns);
            }
            if ((String)this.range.getSelectedItem() == "2") {
                this.updateEntryPanel(24, this.columns);
            }
            if ((String)this.range.getSelectedItem() == "3") {
                this.updateEntryPanel(36, this.columns);
            }
        }
    }

    private class Tile
    extends JToggleButton {
        double duration;
        int pitch;

        public Tile(int color, double dur, int p) {
            this.duration = dur;
            this.pitch = p;
            this.setBackground(new Color(color));
            this.setVisible(true);
        }

        public double getDur() {
            return this.duration;
        }

        public int getPitch() {
            return this.pitch;
        }
    }
}

