/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.score.CopyBuffer;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreFrame;
import com.softsynth.jmsl.score.UnaryCopyBufferTransform;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;

public class MelodyToChordTransform
extends UnaryCopyBufferTransform {
    public static final String copyright = "copyright (C) 2000 Nick Didkovsky, all rights reserved";

    public MelodyToChordTransform() {
        this.setName("MelodyToChord Transform");
    }

    public void operate(CopyBuffer copyBuffer) {
        System.out.println("MelodyToChordTransform by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        Note root = null;
        Enumeration e = copyBuffer.elements();
        while (e.hasMoreElements()) {
            Note note = (Note)e.nextElement();
            if (note.isRest()) continue;
            if (root == null) {
                root = note;
                continue;
            }
            root.addInterval(note.getPitchData());
        }
        copyBuffer.removeAllElements();
        copyBuffer.addElement(root);
        e = root.getIntervals().elements();
        while (e.hasMoreElements()) {
            Note interval = (Note)e.nextElement();
            copyBuffer.addElement((Object)interval);
        }
    }

    public static void main(String[] args) {
        final ScoreFrame scoreFrame = new ScoreFrame();
        scoreFrame.addUnaryCopyBufferTransform((UnaryCopyBufferTransform)new MelodyToChordTransform());
        Score score = new Score(1, 800, 600);
        score.addMeasure();
        Note n = score.addNote(1.0, 60.0, 0.5, 0.8);
        n = score.addNote(1.0, 72.0, 0.5, 0.8);
        scoreFrame.addScore(score);
        scoreFrame.setVisible(true);
        scoreFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                scoreFrame.quit();
            }
        });
    }
}

