/*
 * Decompiled with CFR 0.152.
 */
package com.punosmusic.jmsl.plugins;

import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.ScoreOperator;
import com.softsynth.jmsl.score.Staff;
import com.softsynth.jmsl.score.Track;
import java.util.Enumeration;

public class RestReporter
implements ScoreOperator {
    StringBuffer buf;

    public String getName() {
        return "Check for rest-filled Measures";
    }

    public void operate(Score score) {
        System.out.println("RestReporter operator by Nick Didkovsky, (c) 2006 Nick Didkovsky, all rights reserved");
        this.buf = new StringBuffer();
        this.buf.append("The following staves have ONLY rests in them.\n");
        this.buf.append("You might want to delete these rests so JMSL's exporters to San Andreas Press SCORE and Finale will substitute whole rest\n");
        boolean reportContainsStuff = false;
        int i = 0;
        while (i < score.size()) {
            Measure m = score.getMeasure(i);
            Enumeration e = m.elements();
            while (e.hasMoreElements()) {
                Staff staff = (Staff)e.nextElement();
                Enumeration t = staff.elements();
                while (t.hasMoreElements()) {
                    Track track = (Track)t.nextElement();
                    boolean restsOnly = this.checkForRests(track);
                    if (!restsOnly) continue;
                    reportContainsStuff = true;
                    this.buf.append("Measure " + (m.getMeasureIndex() + 1) + ", staff " + (track.getStaff().getStaffIndex() + 1) + "\n");
                }
            }
            ++i;
        }
        if (!reportContainsStuff) {
            this.buf.append("No Measures contain ONLY rests");
        }
    }

    private boolean checkForRests(Track track) {
        boolean restsOnly = true;
        if (track.size() == 0) {
            return false;
        }
        Enumeration e = track.elements();
        while (e.hasMoreElements()) {
            Note n = (Note)e.nextElement();
            if (n.isRest()) continue;
            restsOnly = false;
            break;
        }
        return restsOnly;
    }

    public String getResultString() {
        return this.buf.toString();
    }
}

