/*
 * Created on 23-Apr-2006
 * Martin Robinson
 * This software is released and may be distributed under the GNU GPL license
 * See: http://www.gnu.org/licenses/gpl.txt
 */
package uk.co.miajo.NN;
import java.io.*;

public class Node {
    private double  threshold, 
                    input, 
                    output, 
                    act;
    private double  weightVector[];
    private double  inputVector[];
    
    public Node(int numweights)
    {
        if(numweights < 1) numweights = 1;
        
        weightVector = new double[numweights];
        
        this.init(Utility.defaultWeight);
    }
    
    public void write(final String comment, BufferedWriter buffer, Listener callback)
    {
        try {
            buffer.write(""+threshold);
            if(comment != null) buffer.write("\t\t# "+comment+" Threshold");
            buffer.write("\n");
            
            for(int i = 0; i < weightVector.length; i++)
            {
                buffer.write(""+weightVector[i]);
                if(comment != null) buffer.write("\t\t# "+comment+" Weight "+i);
                buffer.write("\n");
            }
        }
        catch(Exception e)
        {
            if(callback != null) {
                callback.nnError("network write error");
            }
        }
    }
    
    public void read(BufferedReader buffer, Listener callback)
    {
        try {
            
            String line = buffer.readLine();
            int comm = line.indexOf("#");
            if(comm>=0) line = line.substring(0, comm);
            
            threshold = Double.parseDouble(line);
            
            for(int i = 0; i < weightVector.length; i++)
            {
                line = buffer.readLine();
                comm = line.indexOf("#");
                if(comm>0) line = line.substring(0, comm);
                
                weightVector[i] = Double.parseDouble(line);
            }
        }
        catch(Exception e)
        {
            if(callback != null) {
                callback.nnError("network read error");
            }
        }
    }
    
    public void init(double w)
    {
        threshold = Utility.randomWeight(w);
        
        for(int i = 0; i < weightVector.length; i++) 
        {
            weightVector[i] = Utility.randomWeight(w);
        }
    }
    
    public void rand(double w)
    {
        threshold += Utility.randomWeight(w);
        
        for(int i = 0; i < weightVector.length; i++) 
        {
            weightVector[i] += Utility.randomWeight(w);
        }
    }
    
    public int numWeights()
    {
        return weightVector.length;
    }
    
    public double propogate(double _inputVector[])
    {
        input       = 0.;
        inputVector = _inputVector;
        
        for(int i = 0; i < weightVector.length; i++)
        {
            input += inputVector[i] * weightVector[i];
        }
        
        act = input + threshold;
        output = 1./(1. + Math.pow(Math.E, -act));
        
        return output;
    }
    
    public double[] backProp(double error, double actfuncoff, double learnrate, double adjustVector[])
    {
        double adjust = error * (actfuncoff + (output * (1.-output)));
        double learn = adjust * learnrate;
        
        for(int i = 0; i < weightVector.length; i++)
        {
            weightVector[i] += inputVector[i] * learn;
            adjustVector[i] += weightVector[i] * adjust;
        }
        
        threshold += learn;
        
        return adjustVector;
    }
}
