/*
 * Created on 23-Apr-2006
 * Martin Robinson
 * This software is released and may be distributed under the GNU GPL license
 * See: http://www.gnu.org/licenses/gpl.txt
 */
package uk.co.miajo.NN;
import java.io.*;

public class TrainingPattern {
    private double inputs[];
    private double outputs[];
    
    public TrainingPattern(double _inputs[], double _outputs[])
    {
        inputs = _inputs;
        outputs = _outputs;
    }
    
    public TrainingPattern(BufferedReader buffer, int numinputs, int numoutputs, Listener callback)
    {
        try {   
            String line;
            int comm;
            
            inputs = new double[numinputs];
            for(int i = 0; i < inputs.length; i++)
            {
                line = buffer.readLine();
                comm = line.indexOf("#");
                if(comm>=0) line = line.substring(0, comm);
                inputs[i] = Double.parseDouble(line);
            }
            
            outputs = new double[numoutputs];
            for(int i = 0; i < outputs.length; i++)
            {
                line = buffer.readLine();
                comm = line.indexOf("#");
                if(comm>=0) line = line.substring(0, comm);
                outputs[i] = Double.parseDouble(line);
            }
        }
        catch(Exception e)
        {
            if(callback != null) {
                callback.nnError("pattern read error");
            }
        }
    }
    
    public void write(BufferedWriter buffer, boolean doComments, Listener callback)
    {
        try {   
            for(int i = 0; i < inputs.length; i++)
            {
                String line = new Double(inputs[i]).toString();
                
                if(line.charAt(0) == '-') {
                    for(int j = line.length(); j < 20; j++)
                    {
                        line = line + "0";
                    }
                } else {
                    for(int j = line.length(); j < 19; j++)
                    {
                        line = line + "0";
                    }
                }
                
                buffer.write(line);
                if(doComments) buffer.write("\t\t# input "+i);
                buffer.write("\n");
            }
            
            for(int i = 0; i < outputs.length; i++)
            {
                String line = new Double(outputs[i]).toString();
                
                if(line.charAt(0) == '-') {
                    for(int j = line.length(); j < 20; j++)
                    {
                        line = line + "0";
                    }
                } else {
                    for(int j = line.length(); j < 19; j++)
                    {
                        line = line + "0";
                    }
                }
                
                buffer.write(line);
                if(doComments) buffer.write("\t\t# output "+i);
                buffer.write("\n");
            }
        }
        catch(Exception e)
        {
            if(callback != null) {
                callback.nnError("pattern write error");
            }
        }
    }
    
    public void train(Network network)
    {
        network.backProp(inputs, outputs);
    }
    
    public int numInputs()
    {
        return inputs.length;
    }
    
    public int numOutputs()
    {
        return outputs.length;
    }
}
