/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Set;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.LocalStoreOperator;
import jode.expr.StoreInstruction;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.LoopBlock;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;
import jode.util.SimpleSet;

public class SequentialBlock
extends StructuredBlock {
    StructuredBlock[] subBlocks = new StructuredBlock[2];

    public void setFirst(StructuredBlock structuredBlock) {
        this.subBlocks[0] = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public void setSecond(StructuredBlock structuredBlock) {
        this.subBlocks[1] = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public void checkConsistent() {
        super.checkConsistent();
        if (this.subBlocks[0].jump != null || this.subBlocks[0] instanceof SequentialBlock || this.jump != null) {
            throw new AssertError("Inconsistency");
        }
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        if (variableStack == null) {
            GlobalOptions.err.println("map stack to local called with null: " + this + " in " + this.flowBlock);
        }
        if ((variableStack2 = this.subBlocks[0].mapStackToLocal(variableStack)) != null) {
            return this.subBlocks[1].mapStackToLocal(variableStack2);
        }
        GlobalOptions.err.println("Dead code after Block " + this.subBlocks[0]);
        return null;
    }

    public void removeOnetimeLocals() {
        StructuredBlock structuredBlock = this.subBlocks[1];
        if (structuredBlock instanceof SequentialBlock) {
            structuredBlock = ((SequentialBlock)structuredBlock).subBlocks[0];
        }
        if (this.subBlocks[0] instanceof InstructionBlock && structuredBlock instanceof InstructionContainer) {
            StoreInstruction storeInstruction;
            InstructionBlock instructionBlock = (InstructionBlock)this.subBlocks[0];
            InstructionContainer instructionContainer = (InstructionContainer)structuredBlock;
            if (instructionBlock.getInstruction() instanceof StoreInstruction && (storeInstruction = (StoreInstruction)instructionBlock.getInstruction()).getLValue() instanceof LocalStoreOperator && ((LocalStoreOperator)storeInstruction.getLValue()).getLocalInfo().getUseCount() == 2 && instructionContainer.getInstruction().canCombine(storeInstruction) > 0) {
                System.err.println("before: " + instructionBlock + instructionContainer);
                instructionContainer.setInstruction(instructionContainer.getInstruction().combine(storeInstruction));
                System.err.println("after: " + instructionContainer);
                StructuredBlock structuredBlock2 = this.subBlocks[1];
                structuredBlock2.moveDefinitions(this, structuredBlock2);
                structuredBlock2.replace(this);
                structuredBlock2.removeOnetimeLocals();
                return;
            }
        }
        super.removeOnetimeLocals();
    }

    public StructuredBlock getNextBlock(StructuredBlock structuredBlock) {
        if (structuredBlock == this.subBlocks[0]) {
            if (this.subBlocks[1].isEmpty()) {
                return this.subBlocks[1].getNextBlock();
            }
            return this.subBlocks[1];
        }
        return this.getNextBlock();
    }

    public FlowBlock getNextFlowBlock(StructuredBlock structuredBlock) {
        if (structuredBlock == this.subBlocks[0]) {
            if (this.subBlocks[1].isEmpty()) {
                return this.subBlocks[1].getNextFlowBlock();
            }
            return null;
        }
        return this.getNextFlowBlock();
    }

    public boolean isSingleExit(StructuredBlock structuredBlock) {
        return structuredBlock == this.subBlocks[1];
    }

    public Set propagateUsage() {
        this.used = new SimpleSet();
        SimpleSet simpleSet = new SimpleSet();
        Set set = this.subBlocks[0].propagateUsage();
        Set set2 = this.subBlocks[1].propagateUsage();
        this.used.addAll(this.subBlocks[0].used);
        if (this.subBlocks[0] instanceof LoopBlock) {
            ((LoopBlock)this.subBlocks[0]).removeLocallyDeclareable(this.used);
        }
        simpleSet.addAll(set);
        simpleSet.addAll(set2);
        set.retainAll(set2);
        this.used.addAll(set);
        return simpleSet;
    }

    public void makeDeclaration(Set set) {
        super.makeDeclaration(set);
        if (this.subBlocks[0] instanceof InstructionBlock) {
            ((InstructionBlock)this.subBlocks[0]).checkDeclaration(this.declare);
        }
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        this.subBlocks[0].dumpSource(tabbedPrintWriter);
        this.subBlocks[1].dumpSource(tabbedPrintWriter);
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        int n = 0;
        while (n < 2) {
            if (this.subBlocks[n] == structuredBlock) {
                this.subBlocks[n] = structuredBlock2;
                return true;
            }
            ++n;
        }
        return false;
    }

    public StructuredBlock[] getSubBlocks() {
        return this.subBlocks;
    }

    public boolean jumpMayBeChanged() {
        return this.subBlocks[1].jump != null || this.subBlocks[1].jumpMayBeChanged();
    }
}

