/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.MaxObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MaxContext {
    private static final String MXJ_VERSION = "mxj 1.0 for Java 1.4";
    private static final MaxContext sSingleton = new MaxContext();
    private final Map mAllInstances = new HashMap(10);

    private MaxContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Object o) {
        MaxContext maxContext = sSingleton;
        synchronized (maxContext) {
            MaxContext.sSingleton.mAllInstances.put(o, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(Object o) {
        MaxContext maxContext = sSingleton;
        synchronized (maxContext) {
            MaxContext.sSingleton.mAllInstances.remove(o);
        }
    }

    static MaxContext getSingleton() {
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaxObject getMaxObject(String name) {
        if (name == null) {
            return null;
        }
        MaxContext maxContext = this;
        synchronized (maxContext) {
            Iterator i = this.mAllInstances.keySet().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof MaxObject) || !name.equals(((MaxObject)o).getName())) continue;
                return (MaxObject)o;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllObjects() {
        MaxContext maxContext = this;
        synchronized (maxContext) {
            return Collections.unmodifiableSet(this.mAllInstances.entrySet());
        }
    }

    public String getMxjVersion() {
        return MXJ_VERSION;
    }
}

