/*
 * Decompiled with CFR 0.152.
 */
import de.sciss.net.OSCMessage;
import decider.core.Decider;
import decider.drawing.ControlPanel;
import decider.drawing.SoundEventSliders;
import decider.play.DeciderAgent;
import decider.play.Scene;
import decider.play.XScene;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import my_sound_events_1.BreathSoundEvent;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.gui.AudioInputGUI;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.AudioErrorHandler;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class DeciderMusebot
extends Application
implements MusebotAssistant.Responder {
    static final String name = "Decider Musebot";
    static final AudioContext ac = new AudioContext(new AudioServerIO.Jack("Decider Musebot"));
    MusebotAssistant musebot;
    Envelope masterGainEnvelope;
    Gain masterGain;
    Text text;
    float tickCount = 0.0f;
    float beatCount = 0.0f;
    DeciderAgent deciderAgent;

    static {
        ac.start();
    }

    public static void main(String[] args) {
        try {
            System.out.println("Waiting");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Launching");
        DeciderMusebot.launch((String[])args);
    }

    @Override
    public void incoming(OSCMessage msg) {
    }

    @Override
    public void time(final float tempo, final int _tickCount) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DeciderMusebot.this.text != null) {
                    DeciderMusebot.this.text.setText("Time: " + _tickCount + " (Tempo=" + tempo + ")");
                }
            }
        });
        int cfr_ignored_0 = _tickCount % 16;
        this.tickCount = _tickCount % 16 / 16;
        this.beatCount = _tickCount / 16 % 16 / 16;
        if (this.deciderAgent != null) {
            this.deciderAgent.timeSignal(this.tickCount, this.beatCount);
        }
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(level, time);
    }

    @Override
    public void kill() {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(0.0f, 5000.0f, new Bead(){

            @Override
            public void messageReceived(Bead m) {
                System.exit(0);
            }
        });
        this.masterGainEnvelope.lock(true);
    }

    public void start(Stage stage) throws Exception {
        boolean audioError = AudioErrorHandler.handleAudioError(ac);
        this.musebot = new MusebotAssistant();
        this.masterGainEnvelope = new Envelope(ac, 1.0f);
        this.masterGain = new Gain(ac, 2, this.masterGainEnvelope);
        DeciderMusebot.ac.out.addInput(this.masterGain);
        this.musebot.respondWith(this);
        System.out.println(".....");
        this.startDecider();
        this.text = new Text("Starting");
        System.out.println("Keys agent is running.");
        StackPane root = new StackPane();
        root.getChildren().add((Object)this.text);
        javafx.scene.Scene scene = new javafx.scene.Scene((Parent)root, 300.0, 250.0);
        stage.setTitle("Musebot Keys Agent!");
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                System.exit(0);
            }
        });
        if (audioError) {
            AudioErrorHandler.runAudioErrorAlert(name);
        }
    }

    void startDecider() {
        BreathSoundEvent event = new BreathSoundEvent();
        XScene s = new XScene();
        Decider d = event.getPreferredDecider();
        d.setNumInputs(8);
        System.out.println("NUM LEAVES: " + d.getNumLeaves());
        s.setDecider(d);
        s.getDecider().centerState();
        ArrayList extractors = new ArrayList();
        extractors.add(SpectralCentroid.class);
        extractors.add(Frequency.class);
        extractors.add(Power.class);
        extractors.add(MFCC.class);
        AudioInputGUI newGoo = AudioInputGUI.createAndShow(ac, extractors);
        this.deciderAgent = new DeciderAgent(s, DeciderMusebot.ac.out, newGoo.getAnalyzer());
        ControlPanel.draw(this.deciderAgent);
        SoundEventSliders.createAndShow(ac);
        new Thread(){

            @Override
            public void run() {
                try {
                    File f = new File("scenes/__A_Winner");
                    FileInputStream fis = new FileInputStream(f);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    Scene newS = (Scene)ois.readObject();
                    newS.setName(f.getName());
                    DeciderMusebot.this.deciderAgent.setCurrentScene(newS);
                    ois.close();
                    fis.close();
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

