/*
 * Decompiled with CFR 0.152.
 */
import de.sciss.net.OSCMessage;
import decider.play.DeciderAgent;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class Test
extends Application
implements MusebotAssistant.Responder {
    static final String name = "Decider Musebot";
    static final AudioContext ac = new AudioContext(new AudioServerIO.Jack("Decider Musebot"));
    MusebotAssistant musebot;
    Envelope masterGainEnvelope;
    Gain masterGain;
    Text text;
    float tickCount = 0.0f;
    float beatCount = 0.0f;
    DeciderAgent deciderAgent;

    static {
        ac.start();
    }

    public static void main(String[] args) {
        System.out.println(name);
        try {
            System.out.println("Waiting");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Launching");
        Test.launch((String[])args);
    }

    @Override
    public void incoming(OSCMessage msg) {
    }

    @Override
    public void time(final float tempo, final int _tickCount) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Test.this.text != null) {
                    Test.this.text.setText("Time: " + _tickCount + " (Tempo=" + tempo + ")");
                }
            }
        });
        int cfr_ignored_0 = _tickCount % 16;
        this.tickCount = _tickCount % 16 / 16;
        this.beatCount = _tickCount / 16 % 16 / 16;
        this.deciderAgent.timeSignal(this.tickCount, this.beatCount);
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(level, time);
    }

    @Override
    public void kill() {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(0.0f, 5000.0f, new Bead(){

            @Override
            public void messageReceived(Bead m) {
                System.exit(0);
            }
        });
        this.masterGainEnvelope.lock(true);
    }

    public void start(Stage primaryStage) throws Exception {
    }
}

