/*
 * Decompiled with CFR 0.152.
 */
package decider.analytics;

import decider.core.Decider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DeciderSimulationStats {
    Map<Integer, ArrayList<Integer>> nodeVisitTimes;
    ArrayList<Integer> nodeAtTime;
    Map<Integer, Integer> holdLengthHistogram;
    public List<float[]> stateHistory = new ArrayList<float[]>();
    Decider decider;
    DeciderSimulationStatsData data = new DeciderSimulationStatsData();

    public DeciderSimulationStats(Decider d) {
        this.decider = d;
        this.nodeVisitTimes = new Hashtable<Integer, ArrayList<Integer>>();
        this.nodeAtTime = new ArrayList();
        this.data.timeStepsRun = 0;
    }

    protected void notifyNodeEvent(int node) {
        ArrayList<Integer> visitTimes = this.nodeVisitTimes.get(node);
        if (visitTimes == null) {
            visitTimes = new ArrayList();
            this.nodeVisitTimes.put(node, visitTimes);
        }
        visitTimes.add(this.data.timeStepsRun);
        this.nodeAtTime.add(node);
        float[] state = new float[this.decider.getNumHiddenElements()];
        int i = 0;
        while (i < this.decider.getNumHiddenElements()) {
            state[i] = this.decider.getStateFract(i);
            ++i;
        }
        this.stateHistory.add(state);
        ++this.data.timeStepsRun;
    }

    public void doStats() {
        this.data.nodesVisited = this.nodeVisitTimes.size();
        this.data.timeAtZeroNode = 0.0f;
        if (this.nodeVisitTimes.containsKey(0)) {
            this.data.timeAtZeroNode = (float)this.nodeVisitTimes.get(0).size() / (float)this.data.timeStepsRun;
        }
        int[] visitCounts = new int[(int)this.data.nodesVisited];
        int index = 0;
        for (ArrayList<Integer> visitCount : this.nodeVisitTimes.values()) {
            visitCounts[index++] = visitCount.size();
        }
        Arrays.sort(visitCounts);
        this.data.medianNumVisits = visitCounts[visitCounts.length / 2];
        this.data.maxNumVisits = visitCounts[visitCounts.length - 1];
        int lastNode = 0;
        int changeCount = 0;
        int currentStateLength = 0;
        this.holdLengthHistogram = new TreeMap<Integer, Integer>();
        for (int i : this.nodeAtTime) {
            if (i != lastNode) {
                ++changeCount;
                lastNode = i;
                if (currentStateLength != 0) {
                    int currentCount = 0;
                    if (this.holdLengthHistogram.containsKey(currentStateLength)) {
                        currentCount = this.holdLengthHistogram.get(currentStateLength);
                    }
                    this.holdLengthHistogram.put(currentStateLength, currentCount + 1);
                }
                currentStateLength = 1;
                continue;
            }
            ++currentStateLength;
        }
        int currentCount = 0;
        if (this.holdLengthHistogram.containsKey(currentStateLength)) {
            currentCount = this.holdLengthHistogram.get(currentStateLength);
        }
        this.holdLengthHistogram.put(currentStateLength, currentCount + 1);
        this.data.changeRatio = (float)changeCount / (float)this.data.timeStepsRun;
        this.data.numMinimallyShortHolds = 0.0f;
        if (this.holdLengthHistogram.containsKey(1)) {
            this.data.numMinimallyShortHolds = this.holdLengthHistogram.get(1).intValue();
        }
        Hashtable<Integer, ArrayList<Integer>> gapsBetweenVisits = new Hashtable<Integer, ArrayList<Integer>>();
        Hashtable<Integer, Integer> lastTimeVisited = new Hashtable<Integer, Integer>();
        int time = 0;
        this.data.traversalLinearity = 0.0f;
        for (int i : this.nodeAtTime) {
            int gapLength = time;
            if (lastTimeVisited.containsKey(i)) {
                gapLength = time - (Integer)lastTimeVisited.get(i);
            }
            if (gapLength > 1) {
                ArrayList<Integer> gapsForIndex = (ArrayList<Integer>)gapsBetweenVisits.get(i);
                if (gapsForIndex == null) {
                    gapsForIndex = new ArrayList<Integer>();
                    gapsBetweenVisits.put(i, gapsForIndex);
                }
                gapsForIndex.add(gapLength);
            }
            lastTimeVisited.put(i, time);
            float nodeAsFract = (float)i / (float)this.decider.getNumLeaves();
            float timeAsFract = (float)time / (float)this.data.timeStepsRun;
            this.data.traversalLinearity = (float)((double)this.data.traversalLinearity + Math.pow(1.0f - Math.abs(nodeAsFract - timeAsFract) / 2.0f, 2.0));
            ++time;
        }
        this.data.traversalLinearity /= (float)this.nodeAtTime.size();
        if (gapsBetweenVisits.size() == 0) {
            this.data.medianMaxGapLength = 0.0f;
        } else {
            int[] maxGapLengths = new int[gapsBetweenVisits.size()];
            int next = 0;
            for (ArrayList gapList : gapsBetweenVisits.values()) {
                int max = 0;
                Iterator iterator = gapList.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i <= max) continue;
                    max = i;
                }
                maxGapLengths[next++] = max;
            }
            Arrays.sort(maxGapLengths);
            this.data.medianMaxGapLength = maxGapLengths[maxGapLengths.length / 2];
        }
        int states = 10;
        double[][] prob = new double[states][states];
        int count = this.nodeAtTime.size() - 1;
        int i = 0;
        while (i < count) {
            int n1 = this.nodeAtTime.get(i) % states;
            int n2 = this.nodeAtTime.get(i + 1) % states;
            double[] dArray = prob[n1];
            int n = n2;
            dArray[n] = dArray[n] + 1.0 / (double)count;
            ++i;
        }
        this.data.entropy = 0.0f;
        i = 0;
        while (i < states) {
            int j = 0;
            while (j < states) {
                if (prob[i][j] != 0.0) {
                    this.data.entropy = (float)((double)this.data.entropy - prob[i][j] * Math.log(prob[i][j]));
                }
                ++j;
            }
            ++i;
        }
    }

    public void printStats() {
        System.out.println("Time Steps          : " + this.data.timeStepsRun);
        System.out.println("Num nodes           : " + this.decider.getNumLeaves());
        System.out.println("Time at zero        : " + this.data.timeAtZeroNode);
        System.out.println("Nodes visited       : " + this.data.nodesVisited + " (" + this.data.nodesVisited / (float)this.decider.getNumLeaves() + ")");
        System.out.println("Median num visits   : " + this.data.medianNumVisits);
        System.out.println("Maximum num visits  : " + this.data.maxNumVisits + " (" + this.data.maxNumVisits / (float)this.data.timeStepsRun + ")");
        System.out.println("Change ratio        : " + this.data.changeRatio);
        System.out.println("Num short holds     : " + this.data.numMinimallyShortHolds + " (" + this.data.numMinimallyShortHolds / (float)this.data.timeStepsRun + ")");
        System.out.println("Median max gap      : " + this.data.medianMaxGapLength + " (" + this.data.medianMaxGapLength / (float)this.data.timeStepsRun + ")");
        System.out.println("Traversal linearity : " + this.data.medianMaxGapLength + " (" + this.data.medianMaxGapLength / (float)this.data.timeStepsRun + ")");
        System.out.println("Entropy             : " + this.data.entropy);
    }

    public String stateHistoryToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        int t = 0;
        for (float[] state : this.stateHistory) {
            int i = 0;
            while (i < state.length) {
                buff.append(String.valueOf(state[i]) + " ");
                ++i;
            }
            ++t;
            buff.append("\n");
        }
        return buff.toString();
    }

    public String decisionHistoryToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        boolean t = false;
        for (int x : this.nodeAtTime) {
            buff.append(String.valueOf(x) + " \n");
        }
        return buff.toString();
    }

    public String statsToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(this.data.timeStepsRun) + " ");
        buff.append(String.valueOf(this.decider.getNumLeaves()) + " ");
        buff.append(String.valueOf(this.data.timeAtZeroNode) + " ");
        buff.append(String.valueOf(this.data.nodesVisited) + " ");
        buff.append(String.valueOf(this.data.medianNumVisits) + " ");
        buff.append(String.valueOf(this.data.maxNumVisits) + " ");
        buff.append(String.valueOf(this.data.changeRatio) + " ");
        buff.append(String.valueOf(this.data.numMinimallyShortHolds) + " ");
        buff.append(String.valueOf(this.data.medianMaxGapLength) + " ");
        buff.append(this.data.traversalLinearity);
        buff.append("\n");
        return buff.toString();
    }

    public String holdLengthHistogramToGNUPlotString() {
        StringBuffer buff = new StringBuffer();
        for (int key : this.holdLengthHistogram.keySet()) {
            int val = this.holdLengthHistogram.get(key);
            buff.append(String.valueOf(key) + " " + val + "\n");
        }
        return buff.toString();
    }

    public void printHoldLengthHistogram() {
        System.out.println("--- hold lengths -----");
        int sum = 0;
        for (int holdLength : this.holdLengthHistogram.keySet()) {
            int count = this.holdLengthHistogram.get(holdLength);
            System.out.println(String.valueOf(holdLength) + " " + count);
            sum += holdLength * count;
        }
        System.out.println("Sum: " + sum);
        System.out.println("----------------------");
    }

    public static DeciderSimulationStatsData average(List<DeciderSimulationStatsData> list) {
        DeciderSimulationStatsData average = new DeciderSimulationStatsData();
        for (DeciderSimulationStatsData dss : list) {
            average.changeRatio += dss.changeRatio;
            average.maxNumVisits += dss.maxNumVisits;
            average.medianNumVisits += dss.medianNumVisits;
            average.nodesVisited += dss.nodesVisited;
            average.numMinimallyShortHolds += dss.numMinimallyShortHolds;
            average.timeAtZeroNode += dss.timeAtZeroNode;
            average.timeStepsRun += dss.timeStepsRun;
        }
        int size = list.size();
        average.changeRatio /= (float)size;
        average.maxNumVisits /= (float)size;
        average.medianNumVisits /= (float)size;
        average.nodesVisited /= (float)size;
        average.numMinimallyShortHolds /= (float)size;
        average.timeAtZeroNode /= (float)size;
        average.timeStepsRun /= size;
        return average;
    }

    public DeciderSimulationStatsData getData() {
        return this.data;
    }

    public int getTimeStepsRun() {
        return this.data.timeStepsRun;
    }

    public float getTimeAtZeroNode() {
        return this.data.timeAtZeroNode;
    }

    public float getNodesVisited() {
        return this.data.nodesVisited;
    }

    public float getMedianNumVisits() {
        return this.data.medianNumVisits;
    }

    public float getMaxNumVisits() {
        return this.data.maxNumVisits;
    }

    public float getNumMinimallyShortHolds() {
        return this.data.numMinimallyShortHolds;
    }

    public float getChangeRatio() {
        return this.data.changeRatio;
    }

    public float getMedianMaxGapLength() {
        return this.data.medianMaxGapLength;
    }

    public float getTraversalLinearity() {
        return this.data.traversalLinearity;
    }

    public static class DeciderSimulationStatsData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int timeStepsRun;
        public float timeAtZeroNode;
        public float nodesVisited;
        public float medianNumVisits;
        public float maxNumVisits;
        public float numMinimallyShortHolds;
        public float changeRatio;
        public float medianMaxGapLength;
        public float traversalLinearity;
        public float entropy;
    }
}

